# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class Cesium3DTilesWriter(Writer):
    r"""
    Cesium3DTilesWriter - Writes a dataset into 3D Tiles format.
    
    Superclass: Writer
    
    Valid inputs include the MultiBlockDataSet (as created by
    CityGMLReader) storing 3D buidlings, PointSet storing a point
    cloud or PolyData for storing a mesh.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCesium3DTilesWriter, obj, update, **traits)
    
    content_gltf = tvtk_base.false_bool_trait(desc=\
        r"""
        What is the file type used to save tiles. If content_gltf is false
        (the default) we use b3dm for Buildings or Mesh and PNTS for
        point_cloud otherwise  we use GLB (3DTILES_content_gltf
        extension).  If the file type is b3dm or GLB, external programs
        are needed to convert GLTF -> GLB -> b3dm.
        """
    )

    def _content_gltf_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetContentGLTF,
                        self.content_gltf_)

    merge_tile_poly_data = tvtk_base.false_bool_trait(desc=\
        r"""
        Merge all meshes in each tile to end up with one mesh per tile.
        Default is false which means that we expect an external program
        to merge the meshes in each tile to improve performance (such as
        meshoptimizer). otherwise we merge the polydata in VTK.@see
        https://meshoptimizer.org/
        """
    )

    def _merge_tile_poly_data_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergeTilePolyData,
                        self.merge_tile_poly_data_)

    save_textures = tvtk_base.true_bool_trait(desc=\
        r"""
        Save textures as part of the 3D Tiles dataset. Default true.
        Otherwise save only the mesh.
        """
    )

    def _save_textures_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveTextures,
                        self.save_textures_)

    save_tiles = tvtk_base.true_bool_trait(desc=\
        r"""
        Save the tiles (b3d_ms) as part of the 3D Tiles dataset. Default
        true. Otherwise save only the tileset (JSON) file. This is mainly
        used for debugging. Default true.
        """
    )

    def _save_tiles_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSaveTiles,
                        self.save_tiles_)

    crs = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the coordinate reference system (CRS) also known as spatial
        reference system (SRC), such as EPSG:2263. This string can also
        be a proj string such as "+proj=utm +zone=17 +datum=WGS84"
        """
    )

    def _crs_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCRS,
                        self.crs)

    directory_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Accessor for name of the directory where cesium3d_tiles data is
        written
        """
    )

    def _directory_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDirectoryName,
                        self.directory_name)

    input_type = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Input is Buildings, Points or Mesh.
        """
    )

    def _input_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputType,
                        self.input_type)

    number_of_features_per_tile = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Maximum number of buildings per tile in case of buildings input
        or the number of points per tile in case of point cloud input.
        Default is 100.
        """
    )

    def _number_of_features_per_tile_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfFeaturesPerTile,
                        self.number_of_features_per_tile)

    offset = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Data coordinates are relative to this origin. To get the actuall
        coordinates data has to be translated with the Offset.
        """
    )

    def _offset_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOffset,
                        self.offset)

    texture_base_directory = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Path used to prefix all texture paths stored as fields in the
        input data.@see CityGMLReader
        """
    )

    def _texture_base_directory_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTextureBaseDirectory,
                        self.texture_base_directory)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('content_gltf', 'GetContentGLTF'), ('merge_tile_poly_data',
    'GetMergeTilePolyData'), ('save_textures', 'GetSaveTextures'),
    ('save_tiles', 'GetSaveTiles'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('crs',
    'GetCRS'), ('directory_name', 'GetDirectoryName'), ('input_type',
    'GetInputType'), ('number_of_features_per_tile',
    'GetNumberOfFeaturesPerTile'), ('offset', 'GetOffset'),
    ('texture_base_directory', 'GetTextureBaseDirectory'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'content_gltf', 'debug', 'global_warning_display',
    'merge_tile_poly_data', 'release_data_flag', 'save_textures',
    'save_tiles', 'crs', 'directory_name', 'input_type',
    'number_of_features_per_tile', 'object_name', 'offset',
    'progress_text', 'texture_base_directory'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Cesium3DTilesWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Cesium3DTilesWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['content_gltf', 'merge_tile_poly_data', 'save_textures',
            'save_tiles'], [], ['crs', 'directory_name', 'input_type',
            'number_of_features_per_tile', 'object_name', 'offset',
            'texture_base_directory']),
            title='Edit Cesium3DTilesWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Cesium3DTilesWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

