#serial 1

# Control SSL support:
# --enable-ssl=yes/no
# --with-ssl-library=openssl

AC_DEFUN([DCLIB_CHECK_SSL],
[
  AC_ARG_ENABLE([ssl],
    [AS_HELP_STRING([--disable-ssl],[disable support for Secure Sockets Layer (default=enabled)])],
    [ ENABLE_SSL=$enableval ],
    [ ENABLE_SSL="yes"]
  )
  
  AC_ARG_WITH([ssl-library],
    [AS_HELP_STRING([--with-ssl-library=openssl],[Which SSL library to use. Currently only "openssl" is supported. (default=openssl)])],
    [ SSL_TOOLKIT=$withval ],
    [ SSL_TOOLKIT="openssl" ]
  )
  
  AC_MSG_CHECKING([if SSL support should be enabled])
  if test "x${ENABLE_SSL}" = "xyes"
  then
    AC_MSG_RESULT([yes])
    HAVE_SSL=1
    if test "x${SSL_TOOLKIT}" = "xopenssl"
    then
      AC_MSG_NOTICE([OpenSSL is currently the only supported SSL library.])
      USING_OPENSSL=1
      
      AC_MSG_NOTICE([Looking for OpenSSL libraries via pkg-config...])
      PKG_CHECK_MODULES([OPENSSL],[openssl >= 0.9.7],
	[SSL_LDFLAGS="${OPENSSL_LIBS}"
	 SSL_CPPFLAGS="${OPENSSL_CFLAGS}"
        ],
	[AC_MSG_RESULT([$OPENSSL_PKG_ERRORS])
	 AC_MSG_NOTICE([using openssl in default directories])
	 SSL_LDFLAGS="-lssl -lcrypto"
	 SSL_CPPFLAGS=""
	])
      
      AC_MSG_CHECKING([if the OpenSSL flags work])
      
      ac_save_LIBS="$LIBS"
      ac_save_CPPFLAGS="$CPPFLAGS"
      LIBS="$LIBS $SSL_LDFLAGS"
      CPPFLAGS="$CPPFLAGS $SSL_CPPFLAGS"
      
      AC_LINK_IFELSE([AC_LANG_SOURCE(
[[
#include <openssl/err.h>
#include <openssl/ssl.h>

int main()
{
	SSL_load_error_strings();
	SSL_library_init();
	return 0;
}
]]
	)],
	[ AC_MSG_RESULT([yes]) ],
	[ AC_MSG_ERROR([no - the test OpenSSL program failed to link, check config.log for details]) ]
      )
      
      LIBS="$ac_save_LIBS"
      CPPFLAGS="$ac_save_CPPFLAGS"
      
    else
      AC_MSG_ERROR([OpenSSL is currently the only supported SSL library.])
    fi
  else
    AC_MSG_RESULT([no])
    HAVE_SSL=0
    USING_OPENSSL=0
    SSL_LDFLAGS=""
    SSL_CPPFLAGS=""
  fi
  
  AC_SUBST(HAVE_SSL)
  AC_SUBST(USING_OPENSSL)
  AC_SUBST(SSL_LDFLAGS)
  AC_SUBST(SSL_CPPFLAGS)
])
