#!/usr/bin/env python

from lbagent import *

def splitHostPort(s):
    h,p = s.split(':')
    p = int(p)
    if h == '*':
        h = ''
    return h,p

class ConfigError(Exception): pass

class LBAgentFactory:
    def __init__(self, filename=None, xml=None):
        dom = self._loadDOM(filename, xml)
        if dom.nodeName != 'lbaconfig':
            raise ConfigError, "expected top level 'lbaconfig', got '%s'"%(dom.nodeName)
    def _loadDOM(self, filename, xml):
        from xml.dom.minidom import parseString
        if filename is not None:
            xml = open(filename).read()
        elif xml is None:
            raise ConfigError, "need filename or xml"
        self.dom = parseString(xml)
        return self.dom.childNodes[0]
    def _createLBAgent(self):
        return LBAgent()
    def _loadLBAgent(self, elem):
        lbAgent = self._createLBAgent()
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'lbaservice':
                if item.hasAttribute('listen'):
                    lbAgent.listen = splitHostPort(item.getAttribute('listen'))
            elif item.nodeName == u'specs':
                lbAgent.constants=self._loadConstants(lbAgent,item)
            elif item.nodeName == u'status':
                lbAgent.variables=self._loadVariables(lbAgent,item)
            else: raise ConfigError, "expected 'lbaservice', 'specs' or 'status', got '%s'"%item.nodeName
        return lbAgent
    def _loadConstants(self,lbAgent,elem):
        constants = []
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'constant':
                constants.append(self._loadConstant(lbAgent,item))
            else: raise ConfigError, "expected 'constant' got '%s'"%item.nodeName
        return constants
    def _loadConstant(self,lbAgent,elem):
        constant = LBConstant(lbAgent)
        if elem.hasAttribute('name'):
            constant.name = elem.getAttribute('name')
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'value':
                constant.value = self._loadText(item)
            elif item.nodeName == u'command':
                constant.command = self._loadText(item)
            elif item.nodeName == u'eval':
                constant.eval = self._loadText(item)
            else: raise ConfigError, "expected 'value', 'command' or 'eval' got '%s'"%item.nodeName
        return constant
    def _loadVariables(self,lbAgent,elem):
        variables = []
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'variable':
                variables.append(self._loadVariable(lbAgent,item))
            else: raise ConfigError, "expected 'variable' got '%s'"%item.nodeName
        return variables
    def _loadVariable(self,lbAgent,elem):
        variable = LBVariable(lbAgent)
        if elem.hasAttribute('name'):
            variable.name = elem.getAttribute('name')
        if elem.hasAttribute('refresh-delay'):
            variable.refresh = int(elem.getAttribute('refresh-delay'))
        if elem.hasAttribute('capacity'):
            variable.capacity = elem.getAttribute('capacity')
        if elem.hasAttribute('critical'):
            variable.critical = elem.getAttribute('critical')
        for item in elem.childNodes:
            if item.nodeName in ("#text", "#comment"): continue
            if item.nodeName == u'command':
                variable.command = self._loadText(item)
            elif item.nodeName == u'eval':
                variable.eval = self._loadText(item)
            else: raise ConfigError, "expected 'command' or 'eval' got '%s'"%item.nodeName
        return variable
    def _loadText(self,elem):
        text = ''
        for item in elem.childNodes:
            if item.nodeName == "#text":
                text=text+item.nodeValue
        return text
    def newLBAgent(self):
        lbAgent = self._loadLBAgent(self.dom.childNodes[0])
        return lbAgent
    
    
def main():
    pass

if __name__ == "__main__":
    main()
