package tests::LrCountUniqTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::SQLExt::LrCountUniq;

sub set_up {
    my $self = shift()->SUPER::set_up();

    $self->{'lr_count_uniq'} = new Lire::SQLExt::LrCountUniq();

    return;
}

sub tear_down {
    my $self = $_[0];

    $self->SUPER::tear_down();

    return;
}

sub test_lr_count_uniq {
    my $self = $_[0];

    my $cu = $self->{'lr_count_uniq'};
    $self->assert_deep_equals( {}, $cu->{'_keys'} );

    $cu->step( undef, undef );
    $self->assert_deep_equals( {}, $cu->{'_keys'} );

    $cu->step( undef, 'host1' );
    $self->assert_deep_equals( {}, $cu->{'_keys'} );

    $cu->step( 'user1', undef );
    $self->assert_deep_equals( {}, $cu->{'_keys'} );

    $cu->step( 'user1', 'host1' );
    $self->assert_equals( 1, scalar keys %{$cu->{'_keys'}} );

    $cu->step( 'user1', 'host1' );
    $self->assert_equals( 1, scalar keys %{$cu->{'_keys'}} );

    $cu->step( 'user2', 'host1' );
    $self->assert_equals( 2, scalar keys %{$cu->{'_keys'}} );

    $cu->step( 'user2h', 'ost1' );
    $self->assert_equals( 3, scalar keys %{$cu->{'_keys'}} );

    $self->assert_equals( 3, $cu->finalize() );
    $self->assert_deep_equals( {}, $cu->{'_keys'} );
}

1;
