package junit.test.svg;

import latexDraw.parsers.svg.MalformedSVGDocument;
import latexDraw.parsers.svg.SVGAttributes;
import latexDraw.parsers.svg.SVGElements;
import latexDraw.parsers.svg.elements.SVGRectElement;

import org.junit.Test;

/** 
 * This class contains tests for the SVGRectElement class.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/10/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestSVGRectElement extends AbstractTestSVGElement
{
	@Test
	public void testContructor()
	{
		try
		{ 
			new SVGRectElement(null, null);
			fail();
		}
		catch(Exception e){/**/}
		
		try
		{ 
			new SVGRectElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}

		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "dsd");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "dsd");
			new SVGRectElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "1");
			new SVGRectElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "-1");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			new SVGRectElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{ 
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "-1");
			new SVGRectElement(node, null);
			fail();
		}
		catch(MalformedSVGDocument e){/**/}
		
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			new SVGRectElement(node, null);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testEnableRendering()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "0");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "0");
			SVGRectElement e = new SVGRectElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "0");
			e = new SVGRectElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "0");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			e = new SVGRectElement(node, null);
			assertFalse(e.enableRendering());
			
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "10");
			e = new SVGRectElement(node, null);
			assertTrue(e.enableRendering());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetHeight()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGRectElement r = new SVGRectElement(node, null);
			assertEquals(r.getHeight(), 20.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetWidth()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGRectElement r = new SVGRectElement(node, null);
			assertEquals(r.getWidth(), 10.);
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetRy()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGRectElement r = new SVGRectElement(node, null);
			assertEquals(r.getRy(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_RY, "1");
			r = new SVGRectElement(node, null);
			assertEquals(1., r.getRy());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetRx()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGRectElement r = new SVGRectElement(node, null);
			assertEquals(r.getRx(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_RX, "1");
			r = new SVGRectElement(node, null);
			assertEquals(1., r.getRx());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	
	@Test
	public void testGetY()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGRectElement r = new SVGRectElement(node, null);
			assertEquals(r.getY(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_Y, "1");
			r = new SVGRectElement(node, null);
			assertEquals(1., r.getY());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Test
	public void testGetX()
	{
		try
		{
			node.setAttribute(SVGAttributes.SVG_WIDTH, "10");
			node.setAttribute(SVGAttributes.SVG_HEIGHT, "20");
			SVGRectElement r = new SVGRectElement(node, null);
			assertEquals(r.getX(), 0.);
			
			node.setAttribute(SVGAttributes.SVG_X, "1");
			r = new SVGRectElement(node, null);
			assertEquals(1., r.getX());
		}
		catch(MalformedSVGDocument e) { fail(); }
	}
	
	
	@Override
	public String getNameNode()
	{
		return SVGElements.SVG_RECT;
	}
}
