package junit.test;

import junit.framework.TestCase;
import latexDraw.lang.LaTeXDrawLang;
import static latexDraw.lang.LaTeXDrawLang.*;

import org.junit.Test;

/** 
 * This class contains tests for the LLang class.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 12/18/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class TestLLang extends TestCase
{
	@Test
	public void testGetOthersString()
	{
		assertEquals(getOthersString(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getOthersString("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getOthersString(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	@Test
	public void testGetStringLaTeXDrawFrame()
	{
		assertEquals(getStringLaTeXDrawFrame(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getStringLaTeXDrawFrame("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getStringLaTeXDrawFrame(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	@Test
	public void testGetString1_6()
	{
		assertEquals(getString1_6(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getString1_6("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getString1_6(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	@Test
	public void testGetString1_7()
	{
		assertEquals(getString1_7(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getString1_7("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getString1_7(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	@Test
	public void testGetString1_8()
	{
		assertEquals(getString1_8(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getString1_8("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getString1_8(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	@Test
	public void testGetString1_9()
	{
		assertEquals(getString1_9(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getString1_9("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getString1_9(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	@Test
	public void testGetDialogFrameString()
	{
		assertEquals(getDialogFrameString(null), '!' + LaTeXDrawLang.MISSING_KEY + '!');
		assertEquals(getDialogFrameString("thisisnotavalidkey;)"), "!thisisnotavalidkey;)!"); //$NON-NLS-1$ //$NON-NLS-2$
		assertEquals(getDialogFrameString(""), "!!"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	
	@Test
	public void testLang()
	{
		readLang();
		getlangCurrent();
		getTokenLang();
	}
	
	
	@Test
	public void testSetLangCurrent()
	{
		String former = getlangCurrent();
		
		setlangCurrent(null);
		assertEquals(former, getlangCurrent());
		setlangCurrent(""); //$NON-NLS-1$
		assertEquals(former, getlangCurrent());
		setlangCurrent("dsqdsq"); //$NON-NLS-1$
		assertEquals(former, getlangCurrent());
		setlangCurrent(LANG_DE);
		assertEquals(getlangCurrent(), LANG_DE);
		setlangCurrent(LANG_ES);
		assertEquals(getlangCurrent(), LANG_ES);
		setlangCurrent(LANG_FR);
		assertEquals(getlangCurrent(), LANG_FR);
		setlangCurrent(LANG_EN);
		assertEquals(getlangCurrent(), LANG_EN);
		setlangCurrent(LANG_EN_US);
		assertEquals(getlangCurrent(), LANG_EN_US);
	}
}
