/*
 * Copyright 2010-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.idea.conversion.copy;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("idea/testData/copyPaste/plainTextConversion")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class TextJavaToKotlinCopyPasteConversionTestGenerated extends AbstractTextJavaToKotlinCopyPasteConversionTest {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInPlainTextConversion() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("idea/testData/copyPaste/plainTextConversion"), Pattern.compile("^([^\\.]+)\\.txt$"), TargetBackend.ANY, true);
    }

    @TestMetadata("AsExpression.txt")
    public void testAsExpression() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/AsExpression.txt");
    }

    @TestMetadata("AsExpressionBody.txt")
    public void testAsExpressionBody() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/AsExpressionBody.txt");
    }

    @TestMetadata("ImportFromTarget.txt")
    public void testImportFromTarget() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/ImportFromTarget.txt");
    }

    @TestMetadata("ImportResolve.txt")
    public void testImportResolve() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/ImportResolve.txt");
    }

    @TestMetadata("InsideIdentifier.txt")
    public void testInsideIdentifier() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/InsideIdentifier.txt");
    }

    @TestMetadata("IntoComment.txt")
    public void testIntoComment() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/IntoComment.txt");
    }

    @TestMetadata("IntoRawStringLiteral.txt")
    public void testIntoRawStringLiteral() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/IntoRawStringLiteral.txt");
    }

    @TestMetadata("IntoStringLiteral.txt")
    public void testIntoStringLiteral() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/IntoStringLiteral.txt");
    }

    @TestMetadata("KT13529.txt")
    public void testKT13529() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/KT13529.txt");
    }

    @TestMetadata("KT13529_1.txt")
    public void testKT13529_1() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/KT13529_1.txt");
    }

    @TestMetadata("MembersIntoClass.txt")
    public void testMembersIntoClass() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/MembersIntoClass.txt");
    }

    @TestMetadata("MembersToTopLevel.txt")
    public void testMembersToTopLevel() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/MembersToTopLevel.txt");
    }

    @TestMetadata("Override.txt")
    public void testOverride() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/Override.txt");
    }

    @TestMetadata("OverrideInterface.txt")
    public void testOverrideInterface() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/OverrideInterface.txt");
    }

    @TestMetadata("PostProcessing.txt")
    public void testPostProcessing() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/PostProcessing.txt");
    }

    @TestMetadata("StatementsIntoFunction.txt")
    public void testStatementsIntoFunction() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/StatementsIntoFunction.txt");
    }

    @TestMetadata("WholeFile.txt")
    public void testWholeFile() throws Exception {
        runTest("idea/testData/copyPaste/plainTextConversion/WholeFile.txt");
    }
}
