/*
  Copyright (c) 2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef GRAVATARCREATEWIDGET_H
#define GRAVATARCREATEWIDGET_H

#include <QWidget>
class QLabel;
class QPushButton;
namespace PimCommon {
class GravatarResolvUrlJob;
}
namespace KABGravatar {
class GravatarCreateWidget : public QWidget
{
    Q_OBJECT
public:
    explicit GravatarCreateWidget(QWidget *parent = 0);
    ~GravatarCreateWidget();
    void setEmail(const QString &email);

private Q_SLOTS:
    void slotSearchGravatar();
    void slotSearchGravatarFinished(PimCommon::GravatarResolvUrlJob *);
private:
    QString mEmail;
    QLabel *mEmailLab;
    QPushButton *mSearchGravatar;
    QLabel *mResultGravatar;
};
}

#endif // GRAVATARCREATEWIDGET_H
