/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.Intercepts;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.util.CollectionUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Intercepts(value={LifecycleStage.RequestInit, LifecycleStage.ActionBeanResolution, LifecycleStage.HandlerResolution, LifecycleStage.BindingAndValidation, LifecycleStage.CustomValidation, LifecycleStage.EventHandling, LifecycleStage.ResolutionExecution, LifecycleStage.RequestComplete})
public class BeforeAfterMethodInterceptor
implements Interceptor {
    private static final Log log = Log.getInstance(BeforeAfterMethodInterceptor.class);
    private Map<Class<? extends ActionBean>, FilterMethods> filterMethodsCache = new ConcurrentHashMap<Class<? extends ActionBean>, FilterMethods>();

    @Override
    public Resolution intercept(ExecutionContext context) throws Exception {
        FilterMethods filterMethods;
        ActionBean bean;
        LifecycleStage stage = context.getLifecycleStage();
        ActionBeanContext abc = context.getActionBeanContext();
        String event = abc == null ? null : abc.getEventName();
        Resolution resolution = null;
        if (context.getActionBean() != null) {
            bean = context.getActionBean();
            filterMethods = this.getFilterMethods(bean.getClass());
            List<Method> beforeMethods = filterMethods.getBeforeMethods(stage);
            for (Method method : beforeMethods) {
                String[] on = method.getAnnotation(Before.class).on();
                if (event != null && !CollectionUtil.applies(on, event) || (resolution = this.invoke(bean, method, stage, Before.class)) == null) continue;
                return resolution;
            }
        }
        resolution = context.proceed();
        if (context.getActionBean() != null) {
            bean = context.getActionBean();
            filterMethods = this.getFilterMethods(bean.getClass());
            List<Method> afterMethods = filterMethods.getAfterMethods(stage);
            event = abc == null ? null : abc.getEventName();
            Resolution overrideResolution = null;
            for (Method method : afterMethods) {
                String[] on = method.getAnnotation(After.class).on();
                if (event != null && !CollectionUtil.applies(on, event) || (overrideResolution = this.invoke(bean, method, stage, After.class)) == null) continue;
                return overrideResolution;
            }
        }
        return resolution;
    }

    protected Resolution invoke(ActionBean bean, Method m, LifecycleStage stage, Class<? extends Annotation> when) throws Exception {
        Class<?> beanClass = bean.getClass();
        Object retval = null;
        log.debug(new Object[]{"Calling @Before method '", m.getName(), "' at LifecycleStage '", stage, "' on ActionBean '", beanClass.getSimpleName(), "'"});
        try {
            retval = m.invoke((Object)bean, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            log.error(e, new Object[]{"An InvalidArgumentException was raised when calling @", when.getSimpleName(), " method '", m.getName(), "' at LifecycleStage '", stage, "' on ActionBean '", beanClass.getSimpleName(), "'. See java.lang.reflect.Method.invoke() for possible reasons."});
        }
        catch (IllegalAccessException e) {
            log.error(e, new Object[]{"An IllegalAccessException was raised when calling @", when.getSimpleName(), " method '", m.getName(), "' at LifecycleStage '", stage, "' on ActionBean '", beanClass.getSimpleName(), "'"});
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        if (retval != null && retval instanceof Resolution) {
            return (Resolution)retval;
        }
        return null;
    }

    protected FilterMethods getFilterMethods(Class<? extends ActionBean> beanClass) {
        FilterMethods filterMethods = this.filterMethodsCache.get(beanClass);
        if (filterMethods == null) {
            filterMethods = new FilterMethods();
            this.filterMethodsCache.put(beanClass, filterMethods);
            Collection<Method> methods = ReflectUtil.getMethods(beanClass);
            for (Method method : methods) {
                Annotation annotation;
                if (!method.isAnnotationPresent(Before.class) && !method.isAnnotationPresent(After.class)) continue;
                int mods = method.getModifiers();
                if (method.getParameterTypes().length != 0 || Modifier.isAbstract(mods)) {
                    log.warn("Method '", beanClass.getName(), ".", method.getName(), "' is ", "annotated with @Before or @After but has an incompatible ", "signature. @Before/@After methods must be non-abstract ", "zero-argument methods.");
                    continue;
                }
                if (!method.isAccessible()) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        log.warn("Method '", beanClass.getName(), ".", method.getName(), "' is ", "annotated with @Before or @After but is not public and  ", "calling setAccessible(true) on it threw a SecurityException. ", "Please either declare the method as public, or change your ", "JVM security policy to allow Stripes code to call ", "Method.setAccessible() on your code base.");
                        continue;
                    }
                }
                if (method.isAnnotationPresent(Before.class)) {
                    annotation = method.getAnnotation(Before.class);
                    filterMethods.addBeforeMethod(annotation.stages(), method);
                }
                if (!method.isAnnotationPresent(After.class)) continue;
                annotation = method.getAnnotation(After.class);
                filterMethods.addAfterMethod(annotation.stages(), method);
            }
        }
        return filterMethods;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilterMethods {
        private Map<LifecycleStage, List<Method>> beforeMethods = new HashMap<LifecycleStage, List<Method>>();
        private Map<LifecycleStage, List<Method>> afterMethods = new HashMap<LifecycleStage, List<Method>>();

        protected FilterMethods() {
        }

        public void addBeforeMethod(LifecycleStage[] stages, Method method) {
            for (LifecycleStage stage : stages) {
                if (stage == LifecycleStage.ActionBeanResolution) {
                    log.warn("LifecycleStage.ActionBeanResolution is unsupported for @Before ", "methods. Method '", method.getDeclaringClass().getName(), ".", method.getName(), "' will not be invoked for this stage.");
                    continue;
                }
                this.addFilterMethod(this.beforeMethods, stage, method);
            }
        }

        public void addAfterMethod(LifecycleStage[] stages, Method method) {
            for (LifecycleStage stage : stages) {
                this.addFilterMethod(this.afterMethods, stage, method);
            }
        }

        private void addFilterMethod(Map<LifecycleStage, List<Method>> methodMap, LifecycleStage stage, Method method) {
            List<Method> methods = methodMap.get((Object)stage);
            if (methods == null) {
                methods = new ArrayList<Method>();
                methodMap.put(stage, methods);
            }
            methods.add(method);
        }

        public List<Method> getBeforeMethods(LifecycleStage stage) {
            List<Method> methods = this.beforeMethods.get((Object)stage);
            if (methods == null) {
                methods = Collections.emptyList();
            }
            return methods;
        }

        public List<Method> getAfterMethods(LifecycleStage stage) {
            List<Method> methods = this.afterMethods.get((Object)stage);
            if (methods == null) {
                methods = Collections.emptyList();
            }
            return methods;
        }
    }
}

