/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.elements.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.intabulas.sandler.elements.AtomElement;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Generator;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.elements.impl.AbstractEntryElement;
import org.intabulas.sandler.elements.impl.ContentImpl;
import org.intabulas.sandler.elements.impl.EntryImpl;
import org.intabulas.sandler.elements.impl.GeneratorImpl;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.elements.impl.PersonImpl;
import org.intabulas.sandler.util.SandlerUtilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FeedImpl
extends AbstractEntryElement
implements Feed,
AtomElement {
    private String _version = "0.2";
    private String _language = "en";
    private Content _tagline;
    private Content _copyright;
    private Content _info;
    private Generator _generator;
    private List _entryList = new ArrayList(1);

    public void clear() {
        this._entryList.clear();
        this._contributorList.clear();
        this._version = "0.2";
        this._language = "en";
        this._title = null;
        this._linksList.clear();
        this._modified = null;
        this._tagline = null;
        this._id = null;
        this._copyright = null;
        this._author = null;
        this._generator = null;
    }

    public void addEntry(int index, Entry entry) {
        this._entryList.add(index, entry);
    }

    public boolean addEntry(Entry entry) {
        return this._entryList.add(entry);
    }

    public int getEntryCount() {
        return this._entryList.size();
    }

    public void removeEntry(int index) {
        if (index >= 0 && index < this._entryList.size()) {
            this._entryList.remove(index);
        }
    }

    public boolean removeEntry(Entry entry) {
        boolean result = false;
        if (this._entryList.contains(entry)) {
            result = this._entryList.remove(entry);
        }
        return result;
    }

    public Entry getEntry(int index) {
        Entry result = null;
        if (index >= 0 && index < this._entryList.size()) {
            result = (Entry)this._entryList.get(index);
        }
        return result;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public String getVersion() {
        return this._version;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setInfo(Content info) {
        this._info = info;
    }

    public void setInfo(String info) {
        this._info = new ContentImpl("info");
        this._info.setBody(info);
    }

    public Content getInfo() {
        return this._info;
    }

    public Content getTagline() {
        return this._tagline;
    }

    public void setTagline(Content tagline) {
        this._tagline = tagline;
    }

    public void setTagline(String tagline) {
        this._tagline = new ContentImpl("tagline");
        this._tagline.setBody(tagline);
    }

    public Content getCopyright() {
        return this._copyright;
    }

    public void setCopyright(Content copyright) {
        this._copyright = copyright;
    }

    public void setGenerator(Generator generator) {
        this._generator = generator;
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public String toString() {
        int x;
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
        String feedAttributes = MessageFormat.format(" version=\"{0}\" xml:lang=\"{1}\" xmlns=\"http://purl.org/atom/ns#\"", this._version, this._language);
        buffer.append(MessageFormat.format("<{0}{1}>", "feed", feedAttributes));
        buffer.append(this._title.toString());
        if (this._linksList.size() > 0) {
            for (x = 0; x < this._linksList.size(); ++x) {
                Link link = (Link)this._linksList.get(x);
                buffer.append(link.toString());
            }
        }
        buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "modified", "", SandlerUtilities.getUTCDate(this._modified)));
        if (this._summary != null) {
            buffer.append(this._summary.toString());
        }
        if (this._tagline != null) {
            buffer.append(this._tagline.toString());
        }
        if (this._info != null) {
            buffer.append(this._info.toString());
        }
        if (this._id != null) {
            buffer.append(MessageFormat.format("<{0}{1}>{2}</{0}>", "id", "", this._id));
        }
        if (this._copyright != null) {
            buffer.append(this._copyright.toString());
        }
        if (this._generator != null) {
            buffer.append(this._generator.toString());
        }
        if (this._author != null) {
            buffer.append("<").append("author").append(">");
            buffer.append(this._author.toString());
            buffer.append("</").append("author").append(">");
        }
        if (this._entryList.size() > 0) {
            for (x = 0; x < this._entryList.size(); ++x) {
                Entry entry = (Entry)this._entryList.get(x);
                buffer.append(entry.toString());
            }
        }
        if (this._contributorList.size() > 0) {
            for (x = 0; x < this._contributorList.size(); ++x) {
                Person contributor = (Person)this._contributorList.get(x);
                buffer.append("<").append("contributor").append(">");
                buffer.append(contributor.toString());
                buffer.append("</").append("contributor").append(">");
            }
        }
        buffer.append("</").append("feed").append(">");
        return buffer.toString();
    }

    public void loadDocument(XmlPullParser parser) throws XmlPullParserException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2 && parser.getName().equalsIgnoreCase("feed")) {
                this.processDocumentAttributes(parser);
                try {
                    this.processDocumenteElements(parser);
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (eventType != 1);
    }

    private void processDocumenteElements(XmlPullParser parser) throws XmlPullParserException, IOException {
        String boundingTag = parser.getName();
        String childTag = null;
        int eventType = parser.nextTag();
        do {
            if (eventType == 2) {
                childTag = parser.getName();
                if (parser.getName().equalsIgnoreCase("title")) {
                    this.processTitleTag(parser);
                } else if (parser.getName().equalsIgnoreCase("link")) {
                    LinkImpl link = new LinkImpl();
                    link.loadDocument(parser);
                    this._linksList.add(link);
                } else if (parser.getName().equalsIgnoreCase("id")) {
                    this.processIdTag(parser);
                } else if (parser.getName().equalsIgnoreCase("modified")) {
                    this.processModifiedTag(parser);
                } else if (parser.getName().equalsIgnoreCase("tagline")) {
                    this.processTaglineTag(parser);
                } else if (parser.getName().equalsIgnoreCase("info")) {
                    this.processInfoTag(parser);
                } else if (parser.getName().equalsIgnoreCase("copyright")) {
                    this.processCopyrightTag(parser);
                } else if (parser.getName().equalsIgnoreCase("generator")) {
                    this._generator = new GeneratorImpl();
                    this._generator.loadDocument(parser);
                } else if (parser.getName().equalsIgnoreCase("entry")) {
                    EntryImpl entry = new EntryImpl();
                    entry.loadDocument(parser);
                    this.addEntry(entry);
                } else if (parser.getName().equalsIgnoreCase("author")) {
                    this._author = new PersonImpl();
                    this._author.loadDocument(parser);
                } else if (parser.getName().equalsIgnoreCase("contributor")) {
                    PersonImpl contrib = new PersonImpl();
                    contrib.loadDocument(parser);
                    this._contributorList.add(contrib);
                }
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (eventType != 3 || !"feed".equals(parser.getName()));
    }

    private void processDocumentAttributes(XmlPullParser parser) {
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("version")) {
                this._version = parser.getAttributeValue(x);
            }
            if (!parser.getAttributeName(x).equals("lang")) continue;
            this._language = parser.getAttributeValue(x);
        }
    }

    private void processTitleTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl("title");
        content.loadDocument(parser);
        this.setTitle(content);
    }

    private void processCopyrightTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl("copyright");
        content.loadDocument(parser);
        this.setCopyright(content);
    }

    private void processIdTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        this._id = parser.nextText();
    }

    private void processTaglineTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl("tagline");
        content.loadDocument(parser);
        this.setTagline(content);
    }

    private void processInfoTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        ContentImpl content = new ContentImpl("info");
        content.loadDocument(parser);
        this.setInfo(content);
    }

    private void processModifiedTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        try {
            this._modified = SandlerUtilities.getDateFromUTCDate(parser.nextText());
        }
        catch (ParseException e) {
            this._modified = new Date();
        }
    }
}

