<?xml version="1.0"?>
<!--
Copyright (C) 2002 Ross Gardler <ross@saafe.org>.

This file is part of JavaNCSS2Ant
(http://www.kclee.com/clemens/java/javancss/).

JavaNCSS is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

JavaNCSS is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with JavaNCSS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
-->
<!--
This stylesheet converts JavaNCSS XML output to a document format
which is very close to HTML and which can be used to generate
custom HTML pages for your project.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="xml" indent="yes"/>

  <xsl:template match="javancss">
    <document>
      <header>
        <title>Java Non Commenting Source Statements - Analysis</title>
      </header>
      <body>
        <xsl:call-template name="packages"/>
        <xsl:call-template name="classes"/>
        <xsl:call-template name="methods"/>
        <section title="Explanation">
          <p>The metrics on this page are calculated by counting the comment lines and Non Commenting Source Statements (NCSS). Statements are not statements as specified in the Java Language Specification but include all kinds of declarations too. Roughly spoken, NCSS is approximately equivalent to counting ';' and '{' characters in Java source files.</p>
          <p>SLCs and MLCs correspond to Sinle Line and Multi Line comments, whilst CCN is the Cyclomatic Complexity Number.</p>
          <p>For more information about these metrics see the <link href="http://www.kclee.com/clemens/java/javancss/">JavaNCSS</link> home page.</p>
        </section>
        <section title="credits">
          <p>Generated by <link href="http://www.kclee.com/clemens/java/javancss/">JavaNCSS</link>,<link href="http://sourceforge.net/projects/javancss2ant/">javaNCSS2Ant</link> and <link href="http://jakarta.apache.org/ant">Ant</link></p>
        </section>
      </body>
    </document>
  </xsl:template>

  <xsl:template name="packages">
    <section title="Packages">
      <table width="100%">
        <tr>
          <th width="25%">Name</th>
          <th width="15%">Classes</th>
          <th width="15%">Methods</th>
          <th width="15%">Methods/Class</th>
          <th width="15%">NCSS</th>
          <th width="15%">Comm/NCSS</th>
        </tr>
        <xsl:for-each select="packages/package">
          <xsl:sort select="functions" data-type="number"/>
          <xsl:variable name="classes">
            <xsl:value-of select="classes"/>
          </xsl:variable>
          <xsl:variable name="methods">
            <xsl:value-of select="functions"/>
          </xsl:variable>
          <xsl:variable name="ncss">
            <xsl:value-of select="ncss"/>
          </xsl:variable>
          <xsl:variable name="slc">
            <xsl:value-of select="single_comment_lines"/>
          </xsl:variable>
          <xsl:variable name="mlc">
            <xsl:value-of select="multi_comment_lines"/>
          </xsl:variable>
          <xsl:variable name="comments">
            <xsl:value-of select="$slc + $mlc"/>
          </xsl:variable>
          <tr>
            <td><xsl:value-of select="name"/></td>
            <td><xsl:value-of select="$classes"/></td>
            <td><xsl:value-of select="$methods"/></td>
            <td><xsl:value-of select="format-number($methods div $classes, '#.#')"/></td>
            <td><xsl:value-of select="$ncss"/></td>
            <td><xsl:value-of select="format-number($ncss div $comments, '#.#')"/></td>
          </tr>
        </xsl:for-each>
      </table>
    </section>
  </xsl:template>
  
  <xsl:template name="classes">
    <section title="Classes">
      <table width="100%">
        <tr>
          <th width="40%">Name</th>
          <th width="20%">Methods</th>
          <th width="20%">NCSS</th>
          <th width="20%">NCSS/Method</th>
        </tr>
        <xsl:for-each select="objects/object">
          <tr>
            <xsl:variable name="ncss">
              <xsl:value-of select="ncss"/>
            </xsl:variable>
            <xsl:variable name="methods">
              <xsl:value-of select="functions"/>
            </xsl:variable>
            <td><xsl:value-of select="name"/></td>
            <td><xsl:value-of select="$methods"/></td>
            <td><xsl:value-of select="$ncss"/></td>
            <td><xsl:value-of select="format-number($ncss div $methods, '#.#')"/></td>
          </tr>
        </xsl:for-each>
      </table>
    </section>    
  </xsl:template>

  <xsl:template name="methods">
    <section title="Methods">
      <table width="100%">
        <tr>
          <th width="40%">Name</th>
          <th width="20%">NCSS</th>
          <th width="20%">CCN</th>
          <th width="20%">NCSS/CCN</th>
        </tr>
        <xsl:for-each select="functions/function">
          <tr>
            <xsl:variable name="ncss">
              <xsl:value-of select="ncss"/>
            </xsl:variable>
            <xsl:variable name="ccn">
              <xsl:value-of select="ccn"/>
            </xsl:variable>
            <td><xsl:value-of select="name"/></td>
            <td><xsl:value-of select="$ncss"/></td>
            <td><xsl:value-of select="$ccn"/></td>
            <td><xsl:value-of select="format-number($ncss div $ccn, '#.#')"/></td>
          </tr>
        </xsl:for-each>
      </table>
    </section>
  </xsl:template>

</xsl:stylesheet>
