#!/usr/bin/env python

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

#  This Day in History Screenlet (c) Jack Kerouac 2007 <jackkerouac@rogers.com>
#
# INFO:
# - a VERY simple screenlet that gives you info on 'This Day in History' from World Book
# - heavily borrowed from the MacKeiv version for Mac OS
# - I have no idea what I am doing in Python, so there are very likely MANY mistakes!
# 
# TODO:
# - clean up code
# - figure out a way to get this to update daily

import screenlets
from screenlets.options import BoolOption
from screenlets.options import IntOption
from screenlets.options import StringOption
from screenlets.options import create_option_from_node
import cairo
import gtk
import pango
from xml.dom.minidom import parseString
from os import system
import gobject
import datetime
import os.path
import sys
import re
import traceback
import linecache

# Get the ScreenletPath
ScreenletPath = sys.path[0]

max_lines = 0
#use gettext for translation
import gettext

_ = screenlets.utils.get_translator(__file__)

def tdoc(obj):
	obj.__doc__ = _(obj.__doc__)
	return obj

@tdoc

class DayinHistoryScreenlet (screenlets.Screenlet):
	"""A VERY SIMPLE This Day in History screenlet, modelled after the MacKeiv screenlet for Mac OS."""
	
	# default meta-info for Screenlets (should be removed and put into metainfo)
	__name__	= 'DayinHistoryScreenlet'
	__version__	= '0.2+++'
	__author__	= 'Jack Kerouac'
	__desc__	= __doc__	# set description to docstring of class
	
	# editable options (options that are editable through the UI)
	test_text = ''
	demo_text = ''
	demo_number = ''

	# settings
	show_text	= True
	text_prefix 	= '<b>'
	text_suffix 	= '</b>'
	text_x		= 45
	text_y		= 62
	width 		= 100
	height		= 213
	max_lines	= 0

	# editable options and defaults
	update_interval = 86400 # every 24 hours
	p_layout = None
	# constructor
	def __init__ (self, **keyword_args):
		#call super (width/height MUST match the size of graphics in the theme)
		screenlets.Screenlet.__init__(self, width=196, height=213, 
			uses_theme=True, **keyword_args)
		# set theme
		self.theme_name = "default"
		self.update_interval = self.update_interval
		# add default menu items
		self.add_default_menuitems()
	
	def on_draw (self, ctx):
		# if theme is loaded
		if self.theme:
			when = datetime.datetime.now().strftime("%B %d")
			month = datetime.datetime.now().strftime("%B")
			# set scale rel. to scale-attribute
			ctx.scale(self.scale, self.scale)
			# TEST: render example-bg into context (either PNG or SVG)
			self.theme.render(ctx, 'example-bg')

			# Print out the month on the screenlet
			ctx.save()
			ctx.translate(self.text_x, self.text_y)
			if self.p_layout == None : 
				self.p_layout = ctx.create_layout() 
			else: 
				ctx.update_layout(self.p_layout)
			p_fdesc = pango.FontDescription("Free Sans 12")
			self.p_layout.set_font_description(p_fdesc)
			self.p_layout.set_width((self.width) * pango.SCALE)
			self.p_layout.set_markup(self.text_prefix + str(when) + self.text_suffix)
			ctx.set_source_rgba(1, 1, 1, 1)
			ctx.show_layout(self.p_layout)
			ctx.fill()
			ctx.restore()
			
			# Take the month, lower case it and use that as the text file name to open
			myFile = ScreenletPath+'/Months/' + month.lower() + ".txt"
			
			when = int(datetime.datetime.now().strftime("%d"))

			# The first of the month is a special case - hack: fix!
			if when == 1:
				line1 = linecache.getline(myFile, 1)
				line2 = linecache.getline(myFile, 2)
				line3 = linecache.getline(myFile, 3)
			else:
				when -= 1
				when *= 3
				line1 = linecache.getline(myFile, when+1)
				line2 = linecache.getline(myFile, when+2)
				line3 = linecache.getline(myFile, when+3)					
			
			line = line1 + "\n" + line2 + "\n" + line3
			
			# Print out the file contents on the screenlet
			ctx.save()
			ctx.translate(self.text_x-30, self.text_y+25)
			if self.p_layout == None : 
				self.p_layout = ctx.create_layout() 
			else: 
				ctx.update_layout(self.p_layout)
			p_fdesc = pango.FontDescription("Free Sans 8")
			self.p_layout.set_font_description(p_fdesc)
			self.p_layout.set_width(((self.width-50) * pango.SCALE))
			self.p_layout.set_markup(str(line))
			ctx.set_source_rgba(0, 0, 0, 1)
			ctx.show_layout(self.p_layout)
			ctx.fill()
			ctx.restore()
	
	def on_draw_shape (self, ctx):
		self.on_draw(ctx)
	
# If the program is run directly or passed as an argument to the python
# interpreter then create a Screenlet instance and show it
if __name__ == "__main__":
	# create new session
	import screenlets.session
	screenlets.session.create_session(DayinHistoryScreenlet)

