/* testsmsstorage.c generated by valac 0.16.1, the Vala compiler
 * generated from testsmsstorage.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <fsogsm.h>
#include <stdlib.h>
#include <string.h>
#include <smsutil.h>
#include <conversions.h>
#include <util.h>
#include <gee.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sms_free0(var) ((var == NULL) ? NULL : (var = (sms_free (var), NULL)))
#define _wrap_hex_pdu_unref0(var) ((var == NULL) ? NULL : (var = (wrap_hex_pdu_unref (var), NULL)))



void test_fso_sms_storage_new (void);
#define IMSI "26203123456789"
void test_fso_sms_storage_add_single (void);
#define pdu3 "0791947106004034040C9194713900303341009001910002108059D6B75B076A86D36C" \
"F11BEF024DD365103A2C2EBB413290BB5C2F839CE1315A9E1EA3E96537C805D2D6DBA0" \
"A0585E3797DDA0FB1ECD2EBB41D37419244ED3E965906845CBC56EB9190C069BCD6622"
#define pdulength3 97
void test_fso_sms_storage_add_concatenated (void);
void test_fso_sms_storage_store_transaction_index (void);
#define PHONE_NUMBER "+49123456789"
#define LONG_TEXT "freesmartphone.org is a collaboration platform for open source and ope" \
"n discussion software projects working on interoperability and shared " \
"technology for Linux-based SmartPhones. freesmartphone.org works on a " \
"service layer (middleware) that allows developers to concentrate on th" \
"eir application business logic rather than dealing with device specifi" \
"cs. freesmartphone.org honours and bases on specifications and softwar" \
"e created by the freedesktop.org community."
void test_fso_sms_storage_confirm_ack (void);
void _vala_main (gchar** args, int args_length1);
static void _test_fso_sms_storage_new_gcallback (void);
static void _test_fso_sms_storage_add_single_gcallback (void);
static void _test_fso_sms_storage_add_concatenated_gcallback (void);
static void _test_fso_sms_storage_store_transaction_index_gcallback (void);
static void _test_fso_sms_storage_confirm_ack_gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const gint pdulengths1[11];
extern const gchar* pdus1[11];

void test_fso_sms_storage_new (void) {
	FsoGsmISmsStorage* _tmp0_ = NULL;
	FsoGsmISmsStorage* storage;
#line 27 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp0_ = fso_gsm_sms_storage_factory_create ("default", IMSI);
#line 27 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	storage = _tmp0_;
#line 24 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (storage);
#line 72 "testsmsstorage.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1455 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1456 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	result = self;
#line 1456 "/usr/share/vala-0.16/vapi/glib-2.0.vapi"
	return result;
#line 84 "testsmsstorage.c"
}


static struct sms* sms_newFromHexPdu (const gchar* hexpdu, gint tpdulen) {
	struct sms* result = NULL;
	glong items_written;
	gchar* _tmp0_ = NULL;
	gchar* binpdu;
	gint binpdu_length1;
	gint _binpdu_size_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp2__length1;
	glong _tmp3_ = 0L;
	glong _tmp4_;
	struct sms* _tmp5_;
	struct sms* sms;
	gchar* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	struct sms* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean res;
	gboolean _tmp10_;
#line 590 "../src/lib/fsogsm3rdparty.vapi"
	g_return_val_if_fail (hexpdu != NULL, NULL);
#line 592 "../src/lib/fsogsm3rdparty.vapi"
	items_written = (glong) (-1);
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	_tmp0_ = g_new0 (gchar, 1024);
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	binpdu = _tmp0_;
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	binpdu_length1 = 1024;
#line 593 "../src/lib/fsogsm3rdparty.vapi"
	_binpdu_size_ = binpdu_length1;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	_tmp1_ = hexpdu;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	_tmp2_ = binpdu;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	_tmp2__length1 = binpdu_length1;
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	decode_hex_own_buf (_tmp1_, (glong) (-1), &_tmp3_, (gchar) 0, _tmp2_);
#line 594 "../src/lib/fsogsm3rdparty.vapi"
	items_written = _tmp3_;
#line 595 "../src/lib/fsogsm3rdparty.vapi"
	_tmp4_ = items_written;
#line 595 "../src/lib/fsogsm3rdparty.vapi"
	g_assert (_tmp4_ != ((glong) (-1)));
#line 597 "../src/lib/fsogsm3rdparty.vapi"
	_tmp5_ = sms_new ();
#line 597 "../src/lib/fsogsm3rdparty.vapi"
	sms = _tmp5_;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp6_ = binpdu;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp6__length1 = binpdu_length1;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp7_ = tpdulen;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp8_ = sms;
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	_tmp9_ = sms_decode (_tmp6_, _tmp6__length1, FALSE, _tmp7_, _tmp8_);
#line 598 "../src/lib/fsogsm3rdparty.vapi"
	res = _tmp9_;
#line 600 "../src/lib/fsogsm3rdparty.vapi"
	_tmp10_ = res;
#line 600 "../src/lib/fsogsm3rdparty.vapi"
	if (!_tmp10_) {
#line 155 "testsmsstorage.c"
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp11_ = tpdulen;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp13_ = _tmp12_;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp14_ = hexpdu;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp15_ = string_to_string (_tmp14_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp16_ = g_strconcat ("Sms.Message::newFromHexPdu: could not decode message w/ tpdulen ", _tmp13_, " and hexpdu ", _tmp15_, NULL);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_tmp17_ = _tmp16_;
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		g_warning ("fsogsm3rdparty.vapi:602: %s", _tmp17_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_g_free0 (_tmp17_);
#line 602 "../src/lib/fsogsm3rdparty.vapi"
		_g_free0 (_tmp13_);
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		result = NULL;
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		_sms_free0 (sms);
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		binpdu = (g_free (binpdu), NULL);
#line 603 "../src/lib/fsogsm3rdparty.vapi"
		return result;
#line 191 "testsmsstorage.c"
	} else {
#line 607 "../src/lib/fsogsm3rdparty.vapi"
		result = sms;
#line 607 "../src/lib/fsogsm3rdparty.vapi"
		binpdu = (g_free (binpdu), NULL);
#line 607 "../src/lib/fsogsm3rdparty.vapi"
		return result;
#line 199 "testsmsstorage.c"
	}
#line 590 "../src/lib/fsogsm3rdparty.vapi"
	_sms_free0 (sms);
#line 590 "../src/lib/fsogsm3rdparty.vapi"
	binpdu = (g_free (binpdu), NULL);
#line 205 "testsmsstorage.c"
}


void test_fso_sms_storage_add_single (void) {
	FsoGsmISmsStorage* _tmp0_ = NULL;
	FsoGsmISmsStorage* storage;
	struct sms* _tmp1_ = NULL;
	struct sms* sms;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 32 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp0_ = fso_gsm_sms_storage_factory_create ("default", IMSI);
#line 32 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	storage = _tmp0_;
#line 33 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	fso_gsm_isms_storage_clean (storage);
#line 35 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp1_ = sms_newFromHexPdu (pdu3, pdulength3);
#line 35 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	sms = _tmp1_;
#line 36 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (sms != NULL);
#line 39 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp2_ = fso_gsm_isms_storage_addSms (storage, sms);
#line 39 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp2_ == FSO_GSM_SMS_STORAGE_SMS_SINGLE_COMPLETE);
#line 42 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp3_ = fso_gsm_isms_storage_addSms (storage, sms);
#line 42 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp3_ == FSO_GSM_SMS_STORAGE_SMS_ALREADY_SEEN);
#line 30 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_sms_free0 (sms);
#line 30 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (storage);
#line 240 "testsmsstorage.c"
}


void test_fso_sms_storage_add_concatenated (void) {
	FsoGsmISmsStorage* _tmp0_ = NULL;
	FsoGsmISmsStorage* storage;
	FsoGsmISmsStorage* _tmp1_;
	struct sms** _tmp2_ = NULL;
	struct sms** smses;
	gint smses_length1;
	gint _smses_size_;
	FsoGsmISmsStorage* _tmp24_;
	struct sms** _tmp25_;
	gint _tmp25__length1;
	struct sms* _tmp26_;
	gint _tmp27_ = 0;
#line 49 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp0_ = fso_gsm_sms_storage_factory_create ("default", IMSI);
#line 49 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	storage = _tmp0_;
#line 50 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp1_ = storage;
#line 50 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	fso_gsm_isms_storage_clean (_tmp1_);
#line 52 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp2_ = g_new0 (struct sms*, G_N_ELEMENTS (pdulengths1) + 1);
#line 52 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	smses = _tmp2_;
#line 52 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	smses_length1 = G_N_ELEMENTS (pdulengths1);
#line 52 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_smses_size_ = smses_length1;
#line 273 "testsmsstorage.c"
	{
		gint i;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		i = 0;
#line 278 "testsmsstorage.c"
		{
			gboolean _tmp3_;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp3_ = TRUE;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			while (TRUE) {
#line 285 "testsmsstorage.c"
				gboolean _tmp4_;
				gint _tmp6_;
				struct sms** _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				struct sms* _tmp13_ = NULL;
				struct sms* _tmp14_;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp4_ = _tmp3_;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				if (!_tmp4_) {
#line 301 "testsmsstorage.c"
					gint _tmp5_;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
					_tmp5_ = i;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
					i = _tmp5_ + 1;
#line 307 "testsmsstorage.c"
				}
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp3_ = FALSE;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp6_ = i;
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				if (!(_tmp6_ < G_N_ELEMENTS (pdulengths1))) {
#line 54 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
					break;
#line 317 "testsmsstorage.c"
				}
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp7_ = smses;
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp7__length1 = smses_length1;
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp8_ = i;
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp9_ = i;
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp10_ = pdus1[_tmp9_];
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp11_ = i;
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp12_ = pdulengths1[_tmp11_];
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp13_ = sms_newFromHexPdu (_tmp10_, _tmp12_);
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_sms_free0 (_tmp7_[_tmp8_]);
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp7_[_tmp8_] = _tmp13_;
#line 56 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp14_ = _tmp7_[_tmp8_];
#line 341 "testsmsstorage.c"
			}
		}
	}
	{
		gint i;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		i = 0;
#line 349 "testsmsstorage.c"
		{
			gboolean _tmp15_;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp15_ = TRUE;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			while (TRUE) {
#line 356 "testsmsstorage.c"
				gboolean _tmp16_;
				gint _tmp18_;
				FsoGsmISmsStorage* _tmp19_;
				struct sms** _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				struct sms* _tmp22_;
				gint _tmp23_ = 0;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp16_ = _tmp15_;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				if (!_tmp16_) {
#line 369 "testsmsstorage.c"
					gint _tmp17_;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
					_tmp17_ = i;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
					i = _tmp17_ + 1;
#line 375 "testsmsstorage.c"
				}
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp15_ = FALSE;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp18_ = i;
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				if (!(_tmp18_ < (G_N_ELEMENTS (pdulengths1) - 1))) {
#line 59 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
					break;
#line 385 "testsmsstorage.c"
				}
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp19_ = storage;
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp20_ = smses;
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp20__length1 = smses_length1;
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp21_ = i;
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp22_ = _tmp20_[_tmp21_];
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				_tmp23_ = fso_gsm_isms_storage_addSms (_tmp19_, _tmp22_);
#line 61 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				g_assert (_tmp23_ == FSO_GSM_SMS_STORAGE_SMS_MULTI_INCOMPLETE);
#line 401 "testsmsstorage.c"
			}
		}
	}
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp24_ = storage;
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp25_ = smses;
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp25__length1 = smses_length1;
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp26_ = _tmp25_[G_N_ELEMENTS (pdulengths1) - 1];
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp27_ = fso_gsm_isms_storage_addSms (_tmp24_, _tmp26_);
#line 63 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp27_ == G_N_ELEMENTS (pdulengths1));
#line 46 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	smses = (_vala_array_free (smses, smses_length1, (GDestroyNotify) sms_free), NULL);
#line 46 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (storage);
#line 421 "testsmsstorage.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	return self ? g_object_ref (self) : NULL;
#line 428 "testsmsstorage.c"
}


void test_fso_sms_storage_store_transaction_index (void) {
	FsoGsmNullModem* _tmp0_;
	FsoGsmNullModem* _tmp1_;
	FsoGsmAtSmsHandler* _tmp2_;
	FsoGsmAtSmsHandler* _tmp3_;
	FsoGsmAtSmsHandler* handler;
	FsoGsmAtSmsHandler* _tmp4_;
	FsoGsmISmsStorage* _tmp5_ = NULL;
	FsoGsmISmsStorage* _tmp6_;
	FsoGsmAtSmsHandler* _tmp7_;
	GeeArrayList* _tmp8_ = NULL;
	GeeArrayList* pdus;
	gint i;
	FsoGsmAtSmsHandler* _tmp23_;
	GeeArrayList* _tmp24_;
#line 70 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp0_ = fso_gsm_null_modem_new ();
#line 70 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp1_ = _tmp0_;
#line 70 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp2_ = fso_gsm_at_sms_handler_new ((FsoGsmModem*) _tmp1_);
#line 70 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp3_ = _tmp2_;
#line 70 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (_tmp1_);
#line 70 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	handler = _tmp3_;
#line 71 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp4_ = handler;
#line 71 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp5_ = fso_gsm_sms_storage_factory_create ("default", IMSI);
#line 71 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp6_ = _tmp5_;
#line 71 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	fso_gsm_sms_handler_set_storage ((FsoGsmSmsHandler*) _tmp4_, _tmp6_);
#line 71 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (_tmp6_);
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp7_ = handler;
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp8_ = fso_gsm_sms_handler_formatTextMessage ((FsoGsmSmsHandler*) _tmp7_, PHONE_NUMBER, LONG_TEXT, TRUE);
#line 73 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	pdus = _tmp8_;
#line 74 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	i = 0;
#line 477 "testsmsstorage.c"
	{
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _pdu_list;
		GeeArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _pdu_size;
		gint _pdu_index;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_tmp9_ = pdus;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_pdu_list = _tmp10_;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_tmp11_ = _pdu_list;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_tmp12_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp11_);
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_tmp13_ = _tmp12_;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_pdu_size = _tmp13_;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_pdu_index = -1;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		while (TRUE) {
#line 505 "testsmsstorage.c"
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			GeeArrayList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_ = NULL;
			WrapHexPdu* pdu;
			WrapHexPdu* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp14_ = _pdu_index;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_pdu_index = _tmp14_ + 1;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp15_ = _pdu_index;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp16_ = _pdu_size;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			if (!(_tmp15_ < _tmp16_)) {
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
				break;
#line 528 "testsmsstorage.c"
			}
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp17_ = _pdu_list;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp18_ = _pdu_index;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			pdu = (WrapHexPdu*) _tmp19_;
#line 77 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp20_ = pdu;
#line 77 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp21_ = i;
#line 77 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			i = _tmp21_ + 1;
#line 77 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp22_ = i;
#line 77 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_tmp20_->transaction_index = _tmp22_;
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
			_wrap_hex_pdu_unref0 (pdu);
#line 550 "testsmsstorage.c"
		}
#line 75 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
		_g_object_unref0 (_pdu_list);
#line 554 "testsmsstorage.c"
	}
#line 79 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp23_ = handler;
#line 79 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp24_ = pdus;
#line 79 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	fso_gsm_sms_handler_storeTransactionIndizesForSentMessage ((FsoGsmSmsHandler*) _tmp23_, _tmp24_);
#line 67 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (pdus);
#line 67 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (handler);
#line 566 "testsmsstorage.c"
}


void test_fso_sms_storage_confirm_ack (void) {
	FsoGsmNullModem* _tmp0_;
	FsoGsmNullModem* _tmp1_;
	FsoGsmAtSmsHandler* _tmp2_;
	FsoGsmAtSmsHandler* _tmp3_;
	FsoGsmAtSmsHandler* handler;
	FsoGsmISmsStorage* _tmp4_ = NULL;
	FsoGsmISmsStorage* _tmp5_;
	FsoGsmISmsStorage* _tmp6_;
	FsoGsmISmsStorage* _tmp7_;
	gint _tmp8_ = 0;
	FsoGsmISmsStorage* _tmp9_;
	FsoGsmISmsStorage* _tmp10_;
	gint _tmp11_ = 0;
	FsoGsmISmsStorage* _tmp12_;
	FsoGsmISmsStorage* _tmp13_;
	gint _tmp14_ = 0;
	FsoGsmISmsStorage* _tmp15_;
	FsoGsmISmsStorage* _tmp16_;
	gint _tmp17_ = 0;
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp0_ = fso_gsm_null_modem_new ();
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp1_ = _tmp0_;
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp2_ = fso_gsm_at_sms_handler_new ((FsoGsmModem*) _tmp1_);
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp3_ = _tmp2_;
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (_tmp1_);
#line 86 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	handler = _tmp3_;
#line 87 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp4_ = fso_gsm_sms_storage_factory_create ("default", IMSI);
#line 87 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp5_ = _tmp4_;
#line 87 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	fso_gsm_sms_handler_set_storage ((FsoGsmSmsHandler*) handler, _tmp5_);
#line 87 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (_tmp5_);
#line 89 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp6_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) handler);
#line 89 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp7_ = _tmp6_;
#line 89 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp8_ = fso_gsm_isms_storage_confirmReceivedMessage (_tmp7_, 2);
#line 89 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp8_ == (-1));
#line 90 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp9_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) handler);
#line 90 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp10_ = _tmp9_;
#line 90 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp11_ = fso_gsm_isms_storage_confirmReceivedMessage (_tmp10_, 3);
#line 90 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp11_ == (-1));
#line 91 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp12_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) handler);
#line 91 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp13_ = _tmp12_;
#line 91 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp14_ = fso_gsm_isms_storage_confirmReceivedMessage (_tmp13_, 4);
#line 91 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp14_ == (-1));
#line 92 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp15_ = fso_gsm_sms_handler_get_storage ((FsoGsmSmsHandler*) handler);
#line 92 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp16_ = _tmp15_;
#line 92 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_tmp17_ = fso_gsm_isms_storage_confirmReceivedMessage (_tmp16_, 1);
#line 92 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_assert (_tmp17_ != (-1));
#line 83 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_g_object_unref0 (handler);
#line 644 "testsmsstorage.c"
}


static void _test_fso_sms_storage_new_gcallback (void) {
#line 101 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	test_fso_sms_storage_new ();
#line 651 "testsmsstorage.c"
}


static void _test_fso_sms_storage_add_single_gcallback (void) {
#line 103 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	test_fso_sms_storage_add_single ();
#line 658 "testsmsstorage.c"
}


static void _test_fso_sms_storage_add_concatenated_gcallback (void) {
#line 104 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	test_fso_sms_storage_add_concatenated ();
#line 665 "testsmsstorage.c"
}


static void _test_fso_sms_storage_store_transaction_index_gcallback (void) {
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	test_fso_sms_storage_store_transaction_index ();
#line 672 "testsmsstorage.c"
}


static void _test_fso_sms_storage_confirm_ack_gcallback (void) {
#line 106 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	test_fso_sms_storage_confirm_ack ();
#line 679 "testsmsstorage.c"
}


void _vala_main (gchar** args, int args_length1) {
#line 99 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_init (&args_length1, &args, NULL);
#line 101 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_add_func ("/Fso/Sms/Storage/New", _test_fso_sms_storage_new_gcallback);
#line 103 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_add_func ("/Fso/Sms/Storage/Add/Single", _test_fso_sms_storage_add_single_gcallback);
#line 104 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_add_func ("/Fso/Sms/Storage/Add/Concatenated", _test_fso_sms_storage_add_concatenated_gcallback);
#line 105 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_add_func ("/Fso/Sms/Storage/StoreTransactionIndex", _test_fso_sms_storage_store_transaction_index_gcallback);
#line 106 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_add_func ("/Fso/Sms/Storage/ConfirmReceivedMessage", _test_fso_sms_storage_confirm_ack_gcallback);
#line 108 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_test_run ();
#line 698 "testsmsstorage.c"
}


int main (int argc, char ** argv) {
#line 96 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	g_type_init ();
#line 96 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	_vala_main (argv, argc);
#line 96 "/home/morphis/data/Workspace/fso-new/buildroot/cornucopia/fsogsmd/tests/testsmsstorage.vala"
	return 0;
#line 709 "testsmsstorage.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



