import QtQuick 2.0
import Ubuntu.Components 0.1

// Show location information of a status update (if any)
// Should only be used by StatusUpdateContent
UbuntuShape {
    height: locationName.height + units.gu(1)
    width: locationName.width + units.gu(2)
    visible: location.length > 0
    Label {
        id: locationName
        anchors.centerIn: parent
        text: location
        wrapMode: Text.WrapAtWordBoundaryOrAnywhere
    }
    MouseArea {
        anchors.fill: parent
        onClicked: {
            if (url.length > 0)
            {
                Qt.openUrlExternally(url);
            }
        }
    }
}
