/* Freebirth
 * Copyright (C) 1999 topher lafata <topher@topher.com>,
 *		      Jake Donham <jake@bitmechanic.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#define __MIX_H

#ifndef __SAMPLE_PRODUCER_H
  #include "sample_producer.h"
#endif

#define MIX_MAX_AMP 32768
#define MIX_MIN_AMP 0
#define MUTE_SWITCH -1

typedef struct mixer{
  sample *(* get_buffer)(struct mixer *);
  void (*next_buffer)(struct mixer *);
  sample_producer **(*get_children)(struct mixer *);
  char **(*get_header)(struct mixer *);
  char **(*get_code)(struct mixer *);
  char **(*get_footer)(struct mixer *);
  char **header;
  char **code;
  sample_producer **source;
  sample *buffer;
  sample **bufs;
  int *amplitude;
  int *mute_map;
  int length;
  int next;
}mixer;


mixer *mixer_new(sample_producer **sources);
sample *mixer_get_buffer(mixer *this);
void mixer_next_buffer(mixer *this);
void mixer_set_amplitude(mixer *this,int amp,int index);

/*
  Local Variables:
  mode: font-lock
  End:
*/
