Feature: Check for boilerplate metadata

  In order to ensure that recipe metadata is accurate
  As a developer
  I want to identify metadata that has not been changed from the generated defaults

  Scenario: Unmodified knife generated metadata
    Given a cookbook that has the default boilerplate metadata generated by knife
    When I check the cookbook
    Then the boilerplate metadata warning 008 should be displayed against the metadata file

  Scenario Outline: Boilerplate maintainer metadata
    Given a cookbook that has maintainer metadata set to <maintainer> and <maintainer_email>
    When I check the cookbook
    Then the boilerplate metadata warning 008 should warn on lines <lines>

    Examples:
      | maintainer        | maintainer_email | lines         |
      | unspecified       | unspecified      |               |
      | YOUR_COMPANY_NAME | unspecified      | 1             |
      | unspecified       | YOUR_EMAIL       | 1             |
      | YOUR_COMPANY_NAME | foo@example.com  | 1             |
      | Example Ltd       | YOUR_EMAIL       | 2             |
      | YOUR_COMPANY_NAME | YOUR_EMAIL       | 1,2           |
      | Example Ltd       | foo@example.com  |               |
