/*
 *	PROGRAM:	JRD Access Method
 *	MODULE:		lck_proto.h
 *	DESCRIPTION:	Prototype header file for lck.cpp
 *
 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): ______________________________________.
 */

#ifndef JRD_LCK_PROTO_H
#define JRD_LCK_PROTO_H

#include "../jrd/lck.h"
#include "../lock/lock_proto.h"

namespace Jrd {
	enum lck_t;
}

void	LCK_assert(Jrd::thread_db*, Jrd::Lock*);
bool	LCK_cancel_wait(Jrd::Attachment*);
bool	LCK_convert(Jrd::thread_db*, Jrd::Lock*, USHORT, SSHORT);
bool	LCK_convert_opt(Jrd::thread_db*, Jrd::Lock*, USHORT);
void	LCK_downgrade(Jrd::thread_db*, Jrd::Lock*);
void	LCK_fini(Jrd::thread_db*, Jrd::lck_owner_t);
void	LCK_init(Jrd::thread_db*, Jrd::lck_owner_t);
bool	LCK_lock(Jrd::thread_db*, Jrd::Lock*, USHORT, SSHORT);
bool	LCK_lock_opt(Jrd::thread_db*, Jrd::Lock*, USHORT, SSHORT);
SINT64	LCK_query_data(Jrd::thread_db*, Jrd::lck_t, USHORT);
SINT64	LCK_read_data(Jrd::thread_db*, Jrd::Lock*);
void	LCK_release(Jrd::thread_db*, Jrd::Lock*);
void	LCK_re_post(Jrd::thread_db*, Jrd::Lock*);
void	LCK_write_data(Jrd::thread_db*, Jrd::Lock*, SINT64);


class AutoLock
{
public:
	explicit AutoLock(Jrd::thread_db* tdbb, Jrd::Lock* lck = NULL)
		: m_tdbb(tdbb),
		  m_lock(lck)
	{
	}

	~AutoLock()
	{
		release();
	}

	void release()
	{
		if (m_lock)
		{
			if (m_lock->lck_id)
				LCK_release(m_tdbb, m_lock);
			delete m_lock;
			m_lock = NULL;
		}
	}

	Jrd::Lock* operator-> ()
	{
		return m_lock;
	}

	operator Jrd::Lock* ()
	{
		return m_lock;
	}

	Jrd::Lock* operator= (Jrd::Lock* lck)
	{
		release();
		m_lock = lck;
		return m_lock;
	}

private:
	Jrd::thread_db* m_tdbb;
	Jrd::Lock* m_lock;
};


#endif // JRD_LCK_PROTO_H
