/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.TextType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinaryString;

public class BinaryTextType
implements BinaryObject {
    public static final int computeBytes(TextType tt) {
        return 5 + BinaryString.computeBytes(tt.getName()) + 1;
    }

    public static final TextType read(BinaryReader reader, int index) throws IOException, VisADException {
        String name = BinaryString.read(reader);
        DataInput file = reader.getInput();
        byte endByte = file.readByte();
        if (endByte != 80) {
            throw new IOException("Corrupted file (no TextType end-marker)");
        }
        TextType tt = TextType.getTextType(name);
        BinaryObjectCache cache = reader.getTypeCache();
        cache.add(index, tt);
        return tt;
    }

    public static final int write(BinaryWriter writer, TextType tt, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        int index = cache.getIndex(tt);
        if (index < 0) {
            index = cache.add(tt);
            if (index < 0) {
                throw new IOException("Couldn't cache TextType " + tt);
            }
            if (!(tt.getClass().equals(TextType.class) || tt instanceof TextType && tt instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, tt, token);
                return index;
            }
            String name = tt.getName();
            int objLen = BinaryTextType.computeBytes(tt);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(5);
            BinaryString.write(writer, name, token);
            file.writeByte(80);
        }
        return index;
    }
}

