/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import ucar.netcdf.Attribute;
import ucar.netcdf.Variable;
import visad.data.in.OffsetUnpacker;
import visad.data.in.ScaleAndOffsetUnpacker;
import visad.data.in.ScaleUnpacker;
import visad.data.in.ValueRanger;
import visad.data.in.ValueUnpacker;
import visad.data.in.ValueVetter;

final class Vetter {
    private ValueVetter vetter;
    private ValueUnpacker unpacker;
    private ValueRanger ranger;
    private Class type;
    private double minValid;
    private double maxValid;
    private double fill;

    protected Vetter() {
    }

    Vetter(Class type) {
        this.type = type;
        if (type.equals(Byte.TYPE)) {
            this.fill = Double.NaN;
            this.minValid = -128.0;
            this.maxValid = 127.0;
        } else if (type.equals(Short.TYPE)) {
            this.fill = -32767.0;
            this.minValid = -32768.0;
            this.maxValid = 32767.0;
        } else if (type.equals(Integer.TYPE)) {
            this.fill = -2.147483647E9;
            this.minValid = -2.147483648E9;
            this.maxValid = 2.147483647E9;
        } else if (type.equals(Float.TYPE)) {
            this.fill = 9.96921E36f;
            this.minValid = Double.NEGATIVE_INFINITY;
            this.maxValid = Double.POSITIVE_INFINITY;
        } else if (type.equals(Double.TYPE)) {
            this.fill = 9.96921E36f;
            this.minValid = Double.NEGATIVE_INFINITY;
            this.maxValid = Double.POSITIVE_INFINITY;
        } else {
            this.fill = 0.0;
            this.minValid = 0.0;
            this.maxValid = 0.0;
        }
    }

    Vetter(Variable var) {
        this(var.getComponentType());
        double offset;
        double missing = Double.NaN;
        double lower = Double.NEGATIVE_INFINITY;
        double upper = Double.POSITIVE_INFINITY;
        Attribute attr = var.getAttribute("_FillValue");
        if (attr != null) {
            this.fill = attr.getNumericValue().doubleValue();
            if (this.fill < 0.0) {
                lower = this.type.equals(Float.TYPE) || this.type.equals(Double.TYPE) ? this.fill / 2.0 : this.fill + 1.0;
            } else if (this.fill > 0.0) {
                double d = upper = this.type.equals(Float.TYPE) || this.type.equals(Double.TYPE) ? this.fill / 2.0 : this.fill - 1.0;
            }
        }
        if ((attr = var.getAttribute("missing_value")) != null) {
            missing = attr.getNumericValue().doubleValue();
        }
        this.vetter = ValueVetter.valueVetter(new double[]{this.fill, missing});
        attr = var.getAttribute("scale_factor");
        double scale = attr == null ? 1.0 : attr.getNumericValue().doubleValue();
        attr = var.getAttribute("add_offset");
        double d = offset = attr == null ? 0.0 : attr.getNumericValue().doubleValue();
        this.unpacker = scale == scale && scale != 1.0 && offset == offset && offset != 0.0 ? ScaleAndOffsetUnpacker.scaleAndOffsetUnpacker(scale, offset) : (scale == scale && scale != 1.0 ? ScaleUnpacker.scaleUnpacker(scale) : (offset == offset && offset != 0.0 ? OffsetUnpacker.offsetUnpacker(offset) : ValueUnpacker.valueUnpacker()));
        attr = var.getAttribute("valid_range");
        if (attr != null) {
            lower = attr.getNumericValue(0).doubleValue();
            upper = attr.getNumericValue(1).doubleValue();
        }
        if ((attr = var.getAttribute("valid_min")) != null) {
            lower = attr.getNumericValue().doubleValue();
        }
        if ((attr = var.getAttribute("valid_max")) != null) {
            upper = attr.getNumericValue().doubleValue();
        }
        this.ranger = ValueRanger.valueRanger(lower, upper);
        if (this.minValid < lower) {
            this.minValid = lower;
        }
        if (this.maxValid > upper) {
            this.maxValid = upper;
        }
    }

    double minValid() {
        return this.minValid;
    }

    double maxValid() {
        return this.maxValid;
    }

    public void vet(float[] values) {
        this.ranger.process(this.unpacker.process(this.vetter.process(values)));
    }

    public void vet(double[] values) {
        this.ranger.process(this.unpacker.process(this.vetter.process(values)));
    }
}

