/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.ui.BAMutil;
import thredds.ui.FileManager;
import thredds.ui.IndependentWindow;
import thredds.ui.PopupMenu;
import thredds.ui.TextHistoryPane;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2PDSVariables;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.nc2.ui.StructureTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

public class Grib2Table
extends JPanel {
    private PreferencesExt prefs;
    private BeanTableSorted recordTable;
    private BeanTableSorted gdsTable;
    private BeanTableSorted productTable;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane infoTA;
    private TextHistoryPane infoPopup;
    private IndependentWindow infoWindow;
    private StructureTable dataTable;
    private IndependentWindow dataWindow;
    private FileManager fileChooser;
    private String location;

    public Grib2Table(PreferencesExt prefs) {
        this.prefs = prefs;
        this.recordTable = new BeanTableSorted(RecordBean.class, (PreferencesExt)prefs.node("GridRecordBean"), false);
        this.recordTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RecordBean mb = (RecordBean)Grib2Table.this.recordTable.getSelectedBean();
                Grib2Table.this.infoTA.setText(mb.gr.toString());
            }
        });
        PopupMenu varPopup = new PopupMenu(this.recordTable.getJTable(), "Options");
        this.gdsTable = new BeanTableSorted(GdsBean.class, (PreferencesExt)prefs.node("GdsBean"), false);
        this.gdsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GdsBean bean = (GdsBean)Grib2Table.this.gdsTable.getSelectedBean();
                Grib2Table.this.infoPopup.setText(bean.gds.toString());
                Grib2Table.this.infoWindow.setVisible(true);
                Grib2Table.this.gdsTable.clearSelection();
            }
        });
        this.productTable = new BeanTableSorted(ProductBean.class, (PreferencesExt)prefs.node("ProductBean"), false);
        this.productTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ProductBean pb = (ProductBean)Grib2Table.this.productTable.getSelectedBean();
                Grib2Table.this.infoPopup.setText(pb.toString());
                Grib2Table.this.infoWindow.setVisible(true);
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoPopup = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage("netcdfUI"), this.infoPopup);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        this.split2 = new JSplitPane(0, false, this.recordTable, this.productTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 800));
        this.split = new JSplitPane(0, false, this.split2, this.gdsTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    private void makeDataTable() {
        this.dataTable = new StructureTable((PreferencesExt)this.prefs.node("structTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage("netcdfUI"), this.dataTable);
        this.dataWindow.setBounds((Rectangle)this.prefs.getBean("dataWindow", new Rectangle(50, 300, 1000, 600)));
    }

    public void save() {
        this.recordTable.saveState(false);
        this.gdsTable.saveState(false);
        this.productTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
    }

    public void setGribFile(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
        if (this.location.endsWith(".gbx")) {
            this.setGribFileIndex(raf);
        }
        HashMap<Integer, Grib2GridDefinitionSection> gdsSet = new HashMap<Integer, Grib2GridDefinitionSection>();
        Grib2Input reader = new Grib2Input(raf);
        raf.seek(0L);
        reader.scan(false, false);
        ArrayList<RecordBean> recordList = new ArrayList<RecordBean>();
        for (Grib2Record gr : reader.getRecords()) {
            recordList.add(new RecordBean(gr));
            Grib2GridDefinitionSection grib2GridDefinitionSection = gr.getGDS();
            gdsSet.put(grib2GridDefinitionSection.getGdsKey(), grib2GridDefinitionSection);
        }
        this.recordTable.setBeans(recordList);
        System.out.printf("num records = %d%n", recordList.size());
        ArrayList<ProductBean> productList = new ArrayList<ProductBean>();
        for (Grib2Product grib2Product : reader.getProducts()) {
            productList.add(new ProductBean(grib2Product));
        }
        System.out.printf("num products = %d%n", productList.size());
        if (productList.size() == 0) {
            for (Grib2Record grib2Record : reader.getRecords()) {
                productList.add(new ProductBean(grib2Record));
            }
        }
        this.productTable.setBeans(productList);
        ArrayList<GdsBean> gdsList = new ArrayList<GdsBean>();
        for (Grib2GridDefinitionSection gds : gdsSet.values()) {
            gdsList.add(new GdsBean(gds.getGdsKey(), gds));
        }
        this.gdsTable.setBeans(gdsList);
    }

    private void setGribFileIndex(RandomAccessFile raf) throws IOException {
        this.location = raf.getLocation();
    }

    public class GdsBean {
        Grib2GridDefinitionSection gds;
        int key;

        public GdsBean() {
        }

        public GdsBean(int key, Grib2GridDefinitionSection m) {
            this.key = key;
            this.gds = m;
        }

        public int getKey() {
            return this.key;
        }

        public int getHashCode() {
            return this.gds.hashCode();
        }

        public int getGridNo() {
            return this.gds.getGdtn();
        }

        public String getGridName() {
            return Grib2GridDefinitionSection.getGridName(this.gds.getGdtn());
        }

        public String getScanMode() {
            return Long.toBinaryString(this.gds.getScanMode());
        }

        public String getResolution() {
            return Long.toBinaryString(this.gds.getResolution());
        }
    }

    public class ProductBean {
        Grib2PDSVariables pdsv;

        public ProductBean() {
        }

        public ProductBean(Grib2Product prod) {
            Grib2ProductDefinitionSection pds = prod.getPDS();
            this.pdsv = pds.getPdsVars();
        }

        public ProductBean(Grib2Record r) {
            Grib2ProductDefinitionSection pds = r.getPDS();
            this.pdsv = pds.getPdsVars();
        }

        public String toString() {
            byte[] bytes = this.pdsv.getPDSBytes();
            Formatter f = new Formatter();
            int count = 1;
            for (byte b : bytes) {
                f.format(" %d : %d%n", count++, b);
            }
            return f.toString();
        }

        public final int getTemplate() {
            return this.pdsv.getProductDefinition();
        }

        public final int getVCoords() {
            return this.pdsv.getCoordinates();
        }

        public final String getProdId() {
            return this.pdsv.getParameterCategory() + "-" + this.pdsv.getProductDefinition() + "-" + this.pdsv.getParameterNumber();
        }

        public final int getGenProc() {
            return this.pdsv.getTypeGenProcess();
        }

        public final int getChem() {
            return this.pdsv.getChemicalType();
        }

        public final int getBackProc() {
            return this.pdsv.getBackGenProcess();
        }

        public final int getObsProc() {
            return this.pdsv.getObservationProcess();
        }

        public final int getBands() {
            return this.pdsv.getNB();
        }

        public final int getAnalProc() {
            return this.pdsv.getAnalysisGenProcess();
        }

        public final String getCutoff() {
            return this.pdsv.getHoursAfter() + ":" + this.pdsv.getMinutesAfter();
        }

        public final int getTimeUnit() {
            return this.pdsv.getTimeRangeUnit();
        }

        public final int getForecastTime() {
            return this.pdsv.getForecastTime();
        }

        public final String getSurfaceType() {
            return this.pdsv.getTypeFirstFixedSurface() + "-" + this.pdsv.getTypeSecondFixedSurface();
        }

        public String getSurfaceValue() {
            return this.pdsv.getValueFirstFixedSurface() + "-" + this.pdsv.getValueSecondFixedSurface();
        }

        public final boolean isEnsemble() {
            return this.pdsv.isEnsemble();
        }

        public final int getType() {
            return this.pdsv.getType();
        }

        public final int getEnsN() {
            return this.pdsv.getPerturbation();
        }

        public final int getNForecasts() {
            return this.pdsv.getNumberForecasts();
        }

        public final String getLimit() {
            return this.pdsv.getValueLowerLimit() + "-" + this.pdsv.getValueUpperLimit();
        }
    }

    public class RecordBean {
        Grib2Record gr;
        Grib2IdentificationSection id;

        public RecordBean() {
        }

        public RecordBean(Grib2Record m) {
            this.gr = m;
            this.id = this.gr.getId();
        }

        public final long getGdsOffset() {
            return this.gr.getGdsOffset();
        }

        public final long getPdsOffset() {
            return this.gr.getPdsOffset();
        }

        public final int getDiscipline() {
            return this.gr.getIs().getDiscipline();
        }

        public final String getCenter() {
            return this.id.getCenter_id() + "/" + this.id.getSubcenter_id();
        }

        public final String getCenterName() {
            return this.id.getCenter_idName();
        }

        public final String getTable() {
            return this.id.getMaster_table_version() + "-" + this.id.getLocal_table_version();
        }

        public final String getSignificance() {
            return this.id.getSignificanceOfRTName();
        }

        public Date getRefTime() {
            return new Date(this.id.getRefTime());
        }

        public final Date getBaseTime() {
            return this.id.getBaseTime();
        }

        public final String getProductStatus() {
            return this.id.getProductStatusName();
        }

        public final String getProductType() {
            return this.id.getProductTypeName();
        }
    }
}

