/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public class GEOSnav
extends AREAnav {
    private static final long serialVersionUID = 1L;
    final int loff;
    final int coff;
    final int lfac;
    final int cfac;
    final int plon;
    final double PI = 3.1415926535;
    final double radpol = 6356.5838;
    final double radeq = 6378.169;
    final double X42 = 42164.0;
    private boolean isEastPositive = true;

    public GEOSnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1195724627) {
            throw new IllegalArgumentException("Invald navigation type " + iparms[0]);
        }
        this.loff = iparms[1];
        this.coff = iparms[2];
        this.lfac = iparms[3];
        this.cfac = iparms[4];
        this.plon = iparms[5];
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xlin;
            double xele;
            double xlat = latlon[0][point];
            double xlon = latlon[1][point];
            if (!this.isEastPositive) {
                xlon = -xlon;
            }
            double lat = xlat * 3.1415926535 / 180.0;
            double lon = xlon * 3.1415926535 / 180.0;
            double splon = (double)this.plon / 10.0 * 3.1415926535 / 180.0;
            double c_lat = Math.atan(0.993243 * Math.tan(lat));
            double cosc_lat = Math.cos(c_lat);
            double r_pol2 = 4.040615760642245E7;
            double r_eq2 = 4.0681039792560995E7;
            double rl = 6356.5838 / Math.sqrt(1.0 - (r_eq2 - r_pol2) / r_eq2 * cosc_lat * cosc_lat);
            double r1 = 42164.0 - rl * cosc_lat * Math.cos(lon - splon);
            double r2 = -rl * cosc_lat * Math.sin(lon - splon);
            double r3 = rl * Math.sin(c_lat);
            double rn = Math.sqrt(r1 * r1 + r2 * r2 + r3 * r3);
            double ad2 = r1 * r1 + r2 * r2 + r3 * r3 * r_eq2 / r_pol2;
            double bd = 42164.0 * r1;
            double cd = 1.777802896E9 - r_eq2;
            double delta2 = bd * bd - ad2 * cd;
            double halfsom = bd * rn / ad2;
            if (delta2 >= 0.0 && rn <= halfsom) {
                double x = Math.atan(-r2 / r1);
                double y = Math.asin(-r3 / rn);
                x = x * 180.0 / 3.1415926535;
                y = y * 180.0 / 3.1415926535;
                xele = (double)this.coff / 10.0 + x / Math.pow(2.0, 16.0) * (double)this.cfac / 10.0;
                xlin = (double)this.loff / 10.0 + y / Math.pow(2.0, 16.0) * (double)this.lfac / 10.0;
            } else {
                xlin = Double.NaN;
                xele = Double.NaN;
            }
            linele[1][point] = xlin;
            linele[0][point] = xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double x = (xele - (double)this.coff / 10.0) * Math.pow(2.0, 16.0) / ((double)this.cfac / 10.0);
            double y = (xlin - (double)this.loff / 10.0) * Math.pow(2.0, 16.0) / ((double)this.lfac / 10.0);
            x = x * 3.1415926535 / 180.0;
            y = y * 3.1415926535 / 180.0;
            double cosx = Math.cos(x);
            double cosy = Math.cos(y);
            double sinx = Math.sin(x);
            double aux = 42164.0 * cosx * cosy;
            double siny = Math.sin(y);
            double aux2 = cosy * cosy + 1.006803 * siny * siny;
            double sdd = aux * aux - aux2 * 1.737121856E9;
            if (sdd < 0.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double sd = Math.sqrt(sdd);
                double sn = (aux - sd) / aux2;
                double s1 = 42164.0 - sn * cosx * cosy;
                double s2 = sn * sinx * cosy;
                double s3 = -sn * siny;
                double sxy = Math.sqrt(s1 * s1 + s2 * s2);
                xlon = Math.atan(s2 / s1);
                xlon = xlon * 180.0 / 3.1415926535 + (double)this.plon / 10.0;
                xlat = Math.atan(1.006803 * s3 / sxy) * 180.0 / 3.1415926535;
                if (xlon > 180.0) {
                    xlon -= 360.0;
                }
                if (xlon < -180.0) {
                    xlon += 360.0;
                }
            }
            if (!this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = xlat;
            latlon[1][point] = xlon;
        }
        return latlon;
    }
}

