#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core import commandData
from fenrirscreenreader.core import debug
from fenrirscreenreader.core.generalData import general_data
from fenrirscreenreader.core.inputData import input_data
from fenrirscreenreader.core.outputData import output_data
from fenrirscreenreader.core.punctuationData import punctuation_data
from fenrirscreenreader.core.runtimeData import runtime_data
from fenrirscreenreader.core.screenData import screen_data
from fenrirscreenreader.core.settingsData import settings_data

environment = {
    "screen": screen_data,
    "runtime": runtime_data,
    "general": general_data,
    "settings": settings_data,
    "commandInfo": commandData.command_info,
    "commandBuffer": commandData.command_buffer,
    "input": input_data,
    "punctuation": punctuation_data,
    "output": output_data,
    "soundIcons": {},
    "bindings": {},
    "rawBindings": {},
}
