/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

#include "chrono.h"

chrono::chrono () {
  secs = delta_secs = 0;
  ticks = delta_ticks = 0;
}

chrono& chrono::operator++ () {
  ticks += delta_ticks;
  secs += delta_secs;
  return *this;
}

void nano_chrono::reset () {
  clock_gettime (CLOCK_MONOTONIC, &start);
}

void nano_chrono::tick () {
  clock_gettime (CLOCK_MONOTONIC, &now);
  find_elapsed ();
}

void nano_chrono::find_elapsed () {
  if (( now.tv_nsec - start.tv_nsec ) < 0) {
    delta.tv_sec = now.tv_sec - start.tv_sec - 1;
    delta.tv_nsec = now.tv_nsec + 1000000000 - start.tv_nsec;
  } else {
    delta.tv_sec = now.tv_sec - start.tv_sec;
    delta.tv_nsec = now.tv_nsec - start.tv_nsec;
  }
  secs = delta.tv_sec + delta.tv_nsec / 1000000000.0;
}
