#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "transformation.hpp"

#include "control_file.hpp"

#include "transformations.hpp"

namespace {

class cross_compiling_transformation :
	public transformation
{
public:
	virtual ~cross_compiling_transformation(void) throw() { }
	virtual void operator()(control_file &) const;
};

void cross_compiling_transformation::operator()(control_file &control) const
{
	control.source().cross_compiling = false;
	for(control_file::binary_iterator i = control.binaries_begin();
			i != control.binaries_end(); ++i)
		i->cross_compiling = false;
	return;
}

}

transformation const &transform_cross_compiling = cross_compiling_transformation();
