#ifndef TRANSFER_MANAGER_H__
#define TRANSFER_MANAGER_H__
#include "../dcpp/stdinc.h"
#include "../dcpp/DCPlusPlus.h"
#include <dcpp/UploadManager.h>
#include <dcpp/DownloadManager.h>
#include <dcpp/QueueManagerListener.h>
#include <dcpp/QueueItem.h>
#include <dcpp/FinishedManager.h>
#include <map>
#include "IdAssigner.h"

namespace dcqt_backend {

class TransferManager : 
  public UploadManagerListener,
  public DownloadManagerListener,
  public QueueManagerListener,
  public FinishedManagerListener,
  public Singleton<TransferManager>
{
public:
  void on(UploadManagerListener::Starting, Upload*) throw();
  void on(UploadManagerListener::Tick, const Upload::List&) throw();
  void on(UploadManagerListener::Complete, Upload*) throw();
  void on(UploadManagerListener::Failed, Upload*, const string&) throw();
  void on(DownloadManagerListener::Starting, Download*) throw();
  void on(DownloadManagerListener::Tick, const Download::List&) throw();
  void on(DownloadManagerListener::Complete, Download*) throw();
  void on(DownloadManagerListener::Failed, Download*, const string&) throw();

  void on(QueueManagerListener::Added, QueueItem*) throw();
  void on(QueueManagerListener::Finished, QueueItem*) throw();
  void on(QueueManagerListener::Removed, QueueItem*) throw(); 
  void on(QueueManagerListener::Moved, QueueItem*) throw();
  void on(QueueManagerListener::SourcesUpdated, QueueItem*) throw();
  void on(QueueManagerListener::StatusUpdated, QueueItem*) throw(); 
  void on(QueueManagerListener::SearchStringUpdated, QueueItem*) throw();
  void on(QueueManagerListener::PartialList, const ::User::Ptr&, const string&) throw();

  void on(FinishedManagerListener::AddedDl, FinishedItem*) throw();
  void on(FinishedManagerListener::RemovedDl, FinishedItem*) throw();
  void on(FinishedManagerListener::RemovedAllDl) throw();
  void on(FinishedManagerListener::AddedUl, FinishedItem*) throw();
  void on(FinishedManagerListener::RemovedUl, FinishedItem*) throw();
  void on(FinishedManagerListener::RemovedAllUl) throw();


  TransferManager(); 
  ~TransferManager();
  
  void downloadFile(const string& file,int64_t size,int userid, const string& dir, const string& tth );
  void getUserFileList( int userId );
  void removeQueueItem( int id );
  void forceConnect( int userId );
  void removeSource(int qid, int uid);

  typedef map<Upload*,int> UploadStatusMap;
  enum {UPLOAD_STARTING=1,UPLOAD_COMPLETE=2};
  IdAssigner<QueueItem::Ptr> queueItemIds;
  IdAssigner<FinishedItem*> finishedItemIds;
  
  bool isFileListRequested( int uId );
  void removeFileListRequest( int uId );

protected:
  UploadStatusMap uploadStatus;
  
  // Needed to keep track of which users we have requested file lists for,
  // so we know if we should send the list to clients or not when we get notified that a 
  // file list has been downloaded
  vector<int> fileListRequests;
};
}
#endif
