/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import java.util.List;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceDeclarations;
import net.sf.saxon.om.NamespaceDeclarationsImpl;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.tinytree.TinyAttributeCollection;
import net.sf.saxon.tinytree.TinyElementImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;
import net.sf.saxon.tinytree.TinyParentNodeImpl;
import net.sf.saxon.tinytree.TinyTextImpl;
import net.sf.saxon.tinytree.TinyTree;
import net.sf.saxon.tinytree.WhitespaceTextImpl;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class TinyTreeWalker
implements PullProvider,
SourceLocator {
    private int startNode;
    private int currentNode;
    private int currentEvent;
    private TinyTree tree;
    private PipelineConfiguration pipe;
    private NamespaceDeclarationsImpl nsDeclarations;
    private int[] nsBuffer = new int[10];

    public TinyTreeWalker(TinyNodeImpl tinyNodeImpl) {
        int n = tinyNodeImpl.getNodeKind();
        if (n == 2 || n == 13) {
            throw new IllegalArgumentException("TinyTreeWalker cannot start at an attribute or namespace node");
        }
        this.startNode = tinyNodeImpl.nodeNr;
        this.tree = tinyNodeImpl.tree;
        this.nsDeclarations = new NamespaceDeclarationsImpl();
        this.nsDeclarations.setNamePool(tinyNodeImpl.getNamePool());
    }

    public void setPipelineConfiguration(PipelineConfiguration pipelineConfiguration) {
        this.pipe = pipelineConfiguration;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public int next() throws XPathException {
        switch (this.currentEvent) {
            case 0: {
                this.currentNode = this.startNode;
                switch (this.tree.nodeKind[this.currentNode]) {
                    case 9: {
                        this.currentEvent = 2;
                        break;
                    }
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                        break;
                    }
                    case 12: {
                        throw new IllegalStateException("Current node is a parent-pointer pseudo-node");
                    }
                }
                return this.currentEvent;
            }
            case 2: 
            case 4: {
                if (this.tree.depth[this.currentNode + 1] > this.tree.depth[this.currentNode]) {
                    switch (this.tree.nodeKind[++this.currentNode]) {
                        case 1: {
                            this.currentEvent = 4;
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.currentEvent = 8;
                            break;
                        }
                        case 8: {
                            this.currentEvent = 9;
                            break;
                        }
                        case 7: {
                            this.currentEvent = 10;
                            break;
                        }
                        case 12: {
                            throw new IllegalStateException("First child node must not be a parent-pointer pseudo-node");
                        }
                    }
                    return this.currentEvent;
                }
                this.currentEvent = this.currentEvent == 2 ? 3 : 5;
                return this.currentEvent;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.currentNode == this.startNode) {
                    this.currentEvent = -1;
                    return this.currentEvent;
                }
                int n = this.tree.next[this.currentNode];
                if (n > this.currentNode) {
                    this.currentNode = this.tree.next[this.currentNode];
                    do {
                        switch (this.tree.nodeKind[this.currentNode]) {
                            case 1: {
                                this.currentEvent = 4;
                                break;
                            }
                            case 3: 
                            case 4: {
                                this.currentEvent = 8;
                                break;
                            }
                            case 8: {
                                this.currentEvent = 9;
                                break;
                            }
                            case 7: {
                                this.currentEvent = 10;
                                break;
                            }
                            case 12: {
                                this.currentEvent = -1;
                                ++this.currentNode;
                            }
                        }
                    } while (this.currentEvent == -1);
                    return this.currentEvent;
                }
                this.currentNode = n;
                if (this.currentNode == -1) {
                    this.currentEvent = -1;
                    return this.currentEvent;
                }
                switch (this.tree.nodeKind[this.currentNode]) {
                    case 1: {
                        this.currentEvent = 5;
                        break;
                    }
                    case 9: {
                        this.currentEvent = 3;
                    }
                }
                return this.currentEvent;
            }
            case 3: 
            case 6: 
            case 7: {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            case -1: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        if (this.tree.nodeKind[this.currentNode] == 1) {
            if (this.tree.alpha[this.currentNode] == -1) {
                return AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION;
            }
            return new TinyAttributeCollection(this.tree, this.currentNode);
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    public NamespaceDeclarations getNamespaceDeclarations() throws XPathException {
        if (this.tree.nodeKind[this.currentNode] == 1) {
            int[] nArray = this.currentNode == this.startNode ? TinyElementImpl.getInScopeNamespaces(this.tree, this.currentNode, this.nsBuffer) : TinyElementImpl.getDeclaredNamespaces(this.tree, this.currentNode, this.nsBuffer);
            this.nsDeclarations.setNamespaceCodes(nArray);
            return this.nsDeclarations;
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not START_ELEMENT");
    }

    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                this.currentEvent = 5;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int getNameCode() {
        switch (this.currentEvent) {
            case 4: 
            case 5: 
            case 10: {
                return this.tree.nameCode[this.currentNode];
            }
        }
        throw new IllegalStateException("getNameCode() called when its value is undefined");
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public CharSequence getStringValue() throws XPathException {
        switch (this.tree.nodeKind[this.currentNode]) {
            case 3: {
                return TinyTextImpl.getStringValue(this.tree, this.currentNode);
            }
            case 4: {
                return WhitespaceTextImpl.getStringValue(this.tree, this.currentNode);
            }
            case 7: 
            case 8: {
                return this.tree.getNode(this.currentNode).getStringValue();
            }
            case 1: {
                this.currentEvent = 5;
                return TinyParentNodeImpl.getStringValue(this.tree, this.currentNode);
            }
            case 12: {
                throw new IllegalStateException("Trying to get string value of a parent-pointer pseudo node");
            }
        }
        return null;
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public int getTypeAnnotation() {
        if (this.tree.nodeKind[this.currentNode] != 1) {
            throw new IllegalStateException("getTypeAnnotation() called when current event is not ELEMENT_START or ");
        }
        if (this.tree.typeCodeArray == null) {
            return 641;
        }
        return this.tree.typeCodeArray[this.currentNode] & 0xFFFFF;
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.tree.getSystemId(this.currentNode);
    }

    public int getLineNumber() {
        return this.tree.getLineNumber(this.currentNode);
    }

    public int getColumnNumber() {
        return -1;
    }

    public List getUnparsedEntities() {
        return null;
    }
}

