/*
 * TagLib C# bindings
 * by Clemens Koppensteiner
 *
 * This work is hereby released into the Public Domain. To view a copy of the
 * public domain dedication, visit
 * http://creativecommons.org/licenses/publicdomain/ or send a letter to
 * Creative Commons, 543 Howard Street, 5th Floor, San Francisco, California,
 * 94105, USA.
 */

using System;
using System.Runtime.InteropServices;

namespace TagLib
{
	public class Object
	{
		protected IntPtr ptr;
		
		protected Object(IntPtr ptr) {
			this.ptr = ptr;
		}
		
		static bool unicodeStrings = true; // There is no getter so we must hardcode
						   // the default value from tag_c.cpp 
		public static bool UnicodeStrings {
			get { return unicodeStrings; }
			set {
				taglib_set_strings_unicode(value);
				unicodeStrings = value;
			}
		}
		
		[DllImport("libtag_c")]
		static extern void taglib_set_strings_unicode(bool unicode);
	}
}
