/*
 * Copyright (C) 2003  Robert Collins  <robertc@squid-cache.org>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * DO NOT ALTER THE NEXT LINE
 * arch-tag: 269e7a3b-b9be-4d54-ad65-c9d38b4569c3
 * 
 */

#ifndef   _CM_CONFIG_H_
#define   _CM_CONFIG_H_

#include <iostream>
#include <stdexcept>
#include <vector>

class ConfigSource;
class ConfigEntry;
class Config
{

public:
    Config (std::istream &source);
    void build (std::string const &where) throw(std::exception *);
    void cat () throw (std::exception *);
    void update (std::string const &where) throw (std::exception *);
    int changes (std::string const &where) throw (std::exception *);
    int missing (std::string const &where) throw (std::exception *);
    void examine (std::string const &where) throw (std::exception *);
    void makeReleaseId(std::string const &where) throw (std::exception *);
    void name(std::string const &newName) throw (std::exception *);
    void setConfigSource(ConfigSource *) throw (std::exception *);
    void verbose(bool const &);
    bool verbose() const;
    
    friend class Examiner;

private:
    std::string normalise(std::string const &aPath);
    void parse (std::istream &source) throw (std::exception *);
    std::string getToken(bool const &) throw(std::exception *);
    std::istream &source;
    std::vector<ConfigEntry> entries;
    std::string theName;
    ConfigSource *theSource;
    bool _verbose;
};

#endif /* _CM_CONFIG_H_ */
