/****************************************************************************
 *    lib/c/Statement.h - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef STATEMENT_H
#define STATEMENT_H

#include <string>
#include "Types.h"
#include "Identifier.h"
#include "FluentAction.h"
#include "Constraint.h"

namespace C {

class Statement
{
public:
	Statement(int line=0, Types* types=NULL);
	virtual ~Statement ( );

	void print ( );

protected:
	template <typename T> void printIdentifiers(Printer* p, T* I, set<Variable*>* vars);
	string createTempArgs(int);

	Types types_;
	int line_;

};
}; // end of package namespace

#endif // STATEMENT_H
