!define PRODUCT_NAME "Clementine"
!define PRODUCT_PUBLISHER "Clementine"
!define PRODUCT_VERSION_MAJOR 1
!define PRODUCT_VERSION_MINOR 2
!define PRODUCT_DISPLAY_VERSION "1.2"
!define PRODUCT_DISPLAY_VERSION_SHORT "1.2"
!define PRODUCT_WEB_SITE "http://www.clementine-player.org/"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define PRODUCT_INSTALL_DIR "$PROGRAMFILES\Clementine"

; Set Application Capabilities info
!define CAPABILITIES_NAME "Clementine"
!define CAPABILITIES_LOCAL_NAME "Clementine"
!define CAPABILITIES_PROGID "Clementine music player"
!define CAPABILITIES_PATH "Software\Clients\Media\Clementine"
!define CAPABILITIES_DESCRIPTION "Clementine music player"
!define CAPABILITIES_ICON "$INSTDIR\clementine.ico"
!define CAPABILITIES_REINSTALL "Command to reinstall"
!define CAPABILITIES_HIDE_ICONS "Command to hide icons"
!define CAPABILITIES_SHOW_ICONS "Command to show icons"

SetCompressor /SOLID lzma
!addplugindir nsisplugins
!include "MUI2.nsh"
!include "FileAssociation.nsh"
!include "Capabilities.nsh"

!define MUI_ICON "clementine.ico"

!define MUI_COMPONENTSPAGE_SMALLDESC
!define MUI_FINISHPAGE_RUN
!define MUI_FINISHPAGE_RUN_TEXT "Run Clementine"
!define MUI_FINISHPAGE_RUN_FUNCTION "RunClementine"

; Installer pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES  
!insertmacro MUI_UNPAGE_FINISH

!insertmacro MUI_LANGUAGE "English"

Name "${PRODUCT_NAME}"
OutFile "${PRODUCT_NAME}Setup-1.2.0.exe"
InstallDir "${PRODUCT_INSTALL_DIR}"
ShowInstDetails show
ShowUnInstDetails show
RequestExecutionLevel admin

Function RunClementine
  ShellExecAsUser::ShellExecAsUser "" "$INSTDIR/clementine.exe" ""
FunctionEnd

Section "Delete old files" oldfiles
  ; Delete files from older versions
  ; 0.3
  Delete "$INSTDIR\lastfm.lib"
  Delete "$INSTDIR\gstreamer-plugins\libgstdecodebin.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstdirectsound.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstwaveform.dll"

  ; 0.4
  Delete "$INSTDIR\avcodec-gpl-52.dll"
  Delete "$INSTDIR\avformat-gpl-52.dll"
  Delete "$INSTDIR\avutil-gpl-50.dll"
  Delete "$INSTDIR\iconv.dll"
  Delete "$INSTDIR\libbz2.dll"
  Delete "$INSTDIR\libdl.dll"
  Delete "$INSTDIR\libfaac-0.dll"
  Delete "$INSTDIR\libfaad-2.dll"
  Delete "$INSTDIR\libFLAC-8.dll"
  Delete "$INSTDIR\libgcc_s_sjlj-1.dll"
  Delete "$INSTDIR\libgstaudio-0.10.dll"
  Delete "$INSTDIR\libgstbase-0.10.dll"
  Delete "$INSTDIR\libgstcontroller-0.10.dll"
  Delete "$INSTDIR\libgstdshow-0.10.dll"
  Delete "$INSTDIR\libgstinterfaces-0.10.dll"
  Delete "$INSTDIR\libgstnet-0.10.dll"
  Delete "$INSTDIR\libgstnetbuffer-0.10.dll"
  Delete "$INSTDIR\libgstpbutils-0.10.dll"
  Delete "$INSTDIR\libgstreamer-0.10.dll"
  Delete "$INSTDIR\libgstriff-0.10.dll"
  Delete "$INSTDIR\libgstrtp-0.10.dll"
  Delete "$INSTDIR\libgstrtsp-0.10.dll"
  Delete "$INSTDIR\libgstsdp-0.10.dll"
  Delete "$INSTDIR\libgsttag-0.10.dll"
  Delete "$INSTDIR\libxml2.dll"
  Delete "$INSTDIR\z.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstasfdemux.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstffmpeg-gpl.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstqueue2.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstsoup.dll"

  ; 1.0 prerelease
  Delete "$INSTDIR\spotify.dll"

  ; 1.0
  Delete "$INSTDIR\libofa.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstofa.dll"

  ; 1.1
  Delete "$INSTDIR\libprotobuf-lite-7.dll"

  ; mingw-w64
  Delete "$INSTDIR\avcodec-52.dll"
  Delete "$INSTDIR\avformat-52.dll"
  Delete "$INSTDIR\avutil-50.dll"
  Delete "$INSTDIR\libcdio-12.dll"
  Delete "$INSTDIR\libgcc_s_dw2-1.dll"

  ; libimobiledevice removal
  Delete "$INSTDIR\libimobiledevice-1.dll"
  Delete "$INSTDIR\libplist.dll"
  Delete "$INSTDIR\libusbmuxd.dll"
SectionEnd

Section "Clementine" Clementine
  SetOutPath "$INSTDIR"

  File "avcodec-53.dll"
  File "avformat-53.dll"
  File "avutil-51.dll"
  File "clementine.exe"
  File "clementine-tagreader.exe"
  File "clementine-spotifyblob.exe"
  File "clementine.ico"
  File "glew32.dll"
  File "intl.dll"
  File "libcdio-14.dll"
  File "libeay32.dll"
  File "libexpat-1.dll"
  File "libfaac.dll"
  File "libfaad.dll"
  File "libfftw3-3.dll"
  File "libFLAC.dll"
  File "libgcc_s_sjlj-1.dll"
  File "libgcrypt-11.dll"
  File "libgdk_pixbuf-2.0-0.dll"
  File "libgio-2.0-0.dll"
  File "libglib-2.0-0.dll"
  File "libgmodule-2.0-0.dll"
  File "libgnutls-26.dll"
  File "libgobject-2.0-0.dll"
  File "libgpg-error-0.dll"
  File "libgstapp-0.10-0.dll"
  File "libgstaudio-0.10-0.dll"
  File "libgstbase-0.10-0.dll"
  File "libgstcdda-0.10-0.dll"
  File "libgstcontroller-0.10-0.dll"
  File "libgstdataprotocol-0.10-0.dll"
  File "libgstfft-0.10-0.dll"
  File "libgstinterfaces-0.10-0.dll"
  File "libgstnet-0.10-0.dll"
  File "libgstnetbuffer-0.10-0.dll"
  File "libgstpbutils-0.10-0.dll"
  File "libgstreamer-0.10-0.dll"
  File "libgstriff-0.10-0.dll"
  File "libgstrtp-0.10-0.dll"
  File "libgstrtsp-0.10-0.dll"
  File "libgstsdp-0.10-0.dll"
  File "libgsttag-0.10-0.dll"
  File "libgthread-2.0-0.dll"
  File "libid3tag.dll"
  File "liblastfm.dll"
  File "libmad.dll"
  File "libmms-0.dll"
  File "libmp3lame-0.dll"
  File "libogg-0.dll"
  File "liboil-0.3-0.dll"
  File "liborc-0.4-0.dll"
  File "liborc-test-0.4-0.dll"
  File "libplist.dll"
  File "libpng14-14.dll"
  File "libprotobuf-7.dll"
  File "libqjson.dll"
  File "libsoup-2.4-1.dll"
  File "libspeex-1.dll"
  File "libspotify.dll"
  File "libstdc++-6.dll"
  File "libtag.dll"
  File "libtasn1-3.dll"
  File "libvorbis-0.dll"
  File "libvorbisenc-2.dll"
  File "libxml2-2.dll"
  File "mingwm10.dll"
  File "pthreadGC2.dll"
  File "QtCore4.dll"
  File "QtGui4.dll"
  File "QtNetwork4.dll"
  File "QtOpenGL4.dll"
  File "QtSql4.dll"
  File "QtSvg4.dll"
  File "QtXml4.dll"
  File "ssleay32.dll"
  File "zlib1.dll"

  ; Check the OS.  If Vista or newer, use Default Programs
  nsisos::osversion
  StrCpy $R0 $0
  IntCmp $R0 6 HasDefaultPrograms NoDefaultPrograms HasDefaultPrograms

  HasDefaultPrograms:
    ; Register Clementine with Default Programs
    Var /GLOBAL AppIcon
    Var /GLOBAL AppExe
    StrCpy $AppExe "$INSTDIR\clementine.exe"
    StrCpy $AppIcon "$INSTDIR\clementine.ico"

    ${RegisterCapabilities}

    ${RegisterMediaType} ".mp3" $AppExe $AppIcon "MP3 Audio File"
    ${RegisterMediaType} ".flac" $AppExe $AppIcon "FLAC Audio File"
    ${RegisterMediaType} ".ogg" $AppExe $AppIcon "OGG Audio File"
    ${RegisterMediaType} ".spx" $AppExe $AppIcon "OGG Speex Audio File"
    ${RegisterMediaType} ".m4a" $AppExe $AppIcon "MP4 Audio File"
    ${RegisterMediaType} ".aac" $AppExe $AppIcon "AAC Audio File"
    ${RegisterMediaType} ".wma" $AppExe $AppIcon "WMA Audio File"
    ${RegisterMediaType} ".wav" $AppExe $AppIcon "WAV Audio File"
    
    ${RegisterMediaType} ".pls" $AppExe $AppIcon "PLS Audio File"
    ${RegisterMediaType} ".m3u" $AppExe $AppIcon "M3U Audio File"
    ${RegisterMediaType} ".xspf" $AppExe $AppIcon "XSPF Audio File"
    ${RegisterMediaType} ".asx" $AppExe $AppIcon "Windows Media Audio/Video playlist"
    
    ${RegisterMimeType} "audio/mp3" "mp3" "{cd3afa76-b84f-48f0-9393-7edc34128127}"
    ${RegisterMimeType} "audio/mp4" "m4a" "{cd3afa7c-b84f-48f0-9393-7edc34128127}"
    ${RegisterMimeType} "audio/x-ms-wma" "wma" "{cd3afa84-b84f-48f0-9393-7edc34128127}"
    ${RegisterMimeType} "audio/wav" "wav" "{cd3afa7b-b84f-48f0-9393-7edc34128127}"

    ${RegisterMimeType} "audio/mpegurl" "m3u" "{cd3afa78-b84f-48f0-9393-7edc34128127}"
    ${RegisterMimeType} "application/x-wmplayer" "asx" "{cd3afa96-b84f-48f0-9393-7edc34128127}"
    Goto done
  NoDefaultPrograms:
    ${registerExtension} "$INSTDIR\clementine.exe" ".mp3" "MP3 Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".flac" "FLAC Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".ogg" "OGG Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".spx" "OGG Speex Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".m4a" "MP4 Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".aac" "AAC Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".wma" "WMA Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".wav" "WAV Audio File"

    ${registerExtension} "$INSTDIR\clementine.exe" ".pls" "PLS Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".m3u" "M3U Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".xspf" "XSPF Audio File"
    ${registerExtension} "$INSTDIR\clementine.exe" ".asx" "Windows Media Audio/Video playlist"
  done:
SectionEnd

Section "Qt image format plugins" imageformats
  SetOutPath "$INSTDIR\imageformats"

  File "/oname=qgif4.dll" "imageformats\qgif4.dll"
  File "/oname=qjpeg4.dll" "imageformats\qjpeg4.dll"
SectionEnd

Section "GIO modules" gio-modules
  SetOutPath "$INSTDIR\gio-modules"

  File "/oname=libgiognutls.dll" "gio-modules\libgiognutls.dll"
SectionEnd

Section "Gstreamer plugins" gstreamer-plugins
  SetOutPath "$INSTDIR\gstreamer-plugins"
  
  File "/oname=libgstapetag.dll" "gstreamer-plugins\libgstapetag.dll"
  File "/oname=libgstapp.dll" "gstreamer-plugins\libgstapp.dll"
  File "/oname=libgstasf.dll" "gstreamer-plugins\libgstasf.dll"
  File "/oname=libgstaudioconvert.dll" "gstreamer-plugins\libgstaudioconvert.dll"
  File "/oname=libgstaudiofx.dll" "gstreamer-plugins\libgstaudiofx.dll"
  File "/oname=libgstaudioresample.dll" "gstreamer-plugins\libgstaudioresample.dll"
  File "/oname=libgstaudiotestsrc.dll" "gstreamer-plugins\libgstaudiotestsrc.dll"
  File "/oname=libgstautodetect.dll" "gstreamer-plugins\libgstautodetect.dll"
  File "/oname=libgstcdio.dll" "gstreamer-plugins\libgstcdio.dll"
  File "/oname=libgstcoreelements.dll" "gstreamer-plugins\libgstcoreelements.dll"
  File "/oname=libgstdecodebin2.dll" "gstreamer-plugins\libgstdecodebin2.dll"
  File "/oname=libgstdirectsoundsink.dll" "gstreamer-plugins\libgstdirectsoundsink.dll"
  File "/oname=libgstequalizer.dll" "gstreamer-plugins\libgstequalizer.dll"
  File "/oname=libgstfaac.dll" "gstreamer-plugins\libgstfaac.dll"
  File "/oname=libgstfaad.dll" "gstreamer-plugins\libgstfaad.dll"
  File "/oname=libgstffmpeg.dll" "gstreamer-plugins\libgstffmpeg.dll"
  File "/oname=libgstflac.dll" "gstreamer-plugins\libgstflac.dll"
  File "/oname=libgstgdp.dll" "gstreamer-plugins\libgstgdp.dll"
  File "/oname=libgstgio.dll" "gstreamer-plugins\libgstgio.dll"
  File "/oname=libgsticydemux.dll" "gstreamer-plugins\libgsticydemux.dll"
  File "/oname=libgstid3demux.dll" "gstreamer-plugins\libgstid3demux.dll"
  File "/oname=libgstlame.dll" "gstreamer-plugins\libgstlame.dll"
  File "/oname=libgstmad.dll" "gstreamer-plugins\libgstmad.dll"
  File "/oname=libgstmms.dll" "gstreamer-plugins\libgstmms.dll"
  File "/oname=libgstmpegaudioparse.dll" "gstreamer-plugins\libgstmpegaudioparse.dll"
  File "/oname=libgstogg.dll" "gstreamer-plugins\libgstogg.dll"
  File "/oname=libgstqtdemux.dll" "gstreamer-plugins\libgstqtdemux.dll"
  File "/oname=libgstreplaygain.dll" "gstreamer-plugins\libgstreplaygain.dll"
  File "/oname=libgstsouphttpsrc.dll" "gstreamer-plugins\libgstsouphttpsrc.dll"
  File "/oname=libgstspectrum.dll" "gstreamer-plugins\libgstspectrum.dll"
  File "/oname=libgstspeex.dll" "gstreamer-plugins\libgstspeex.dll"
  File "/oname=libgsttaglib.dll" "gstreamer-plugins\libgsttaglib.dll"
  File "/oname=libgsttcp.dll" "gstreamer-plugins\libgsttcp.dll"
  File "/oname=libgsttypefindfunctions.dll" "gstreamer-plugins\libgsttypefindfunctions.dll"
  File "/oname=libgstudp.dll" "gstreamer-plugins\libgstudp.dll"
  File "/oname=libgstvolume.dll" "gstreamer-plugins\libgstvolume.dll"
  File "/oname=libgstvorbis.dll" "gstreamer-plugins\libgstvorbis.dll"
  File "/oname=libgstwavparse.dll" "gstreamer-plugins\libgstwavparse.dll"
SectionEnd

Section "projectM presets" projectm-presets
  SetOutPath "$INSTDIR\projectm-presets"

  File "/oname=Aderrasi - Agitator.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Agitator.milk"
  File "/oname=Aderrasi - Aimless (Gravity Directive Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Aimless (Gravity Directive Mix).milk"
  File "/oname=Aderrasi - Aimless (Spirogravity Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Aimless (Spirogravity Mix).milk"
  File "/oname=Aderrasi - Airhandler (Menagerie Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Airhandler (Menagerie Mix).milk"
  File "/oname=Aderrasi - Airs (Windy Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Airs (Windy Mix).milk"
  File "/oname=Aderrasi - Anchorpulse (Pulse Of A Ghast II Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Anchorpulse (Pulse Of A Ghast II Mix).milk"
  File "/oname=Aderrasi - Anchorpulse (Verified Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Anchorpulse (Verified Mix).milk"
  File "/oname=Aderrasi - Anomalous Material Science (Pure Splinter Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Anomalous Material Science (Pure Splinter Mix).milk"
  File "/oname=Aderrasi - Antidote (Aqualung Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Antidote (Aqualung Mix).milk"
  File "/oname=Aderrasi - Antidote.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Antidote.milk"
  File "/oname=Aderrasi - Antidote (Side Effects Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Antidote (Side Effects Mix).milk"
  File "/oname=Aderrasi - Antique Abyss.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Antique Abyss.milk"
  File "/oname=Aderrasi - Arise! (Padded Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Arise! (Padded Mix).milk"
  File "/oname=Aderrasi - Ashes Of Air (Remix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Ashes Of Air (Remix).milk"
  File "/oname=Aderrasi - Bitterfeld (Crystal Border Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Bitterfeld (Crystal Border Mix).milk"
  File "/oname=Aderrasi - Blender.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Blender.milk"
  File "/oname=Aderrasi - Bow To Gravity.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Bow To Gravity.milk"
  File "/oname=Aderrasi - Brakefreak.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Brakefreak.milk"
  File "/oname=Aderrasi - Candy Avian.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Candy Avian.milk"
  File "/oname=Aderrasi - Causeway Of Dreams.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Causeway Of Dreams.milk"
  File "/oname=Aderrasi - Causeway Of Dreams (Nightmare Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Causeway Of Dreams (Nightmare Mix).milk"
  File "/oname=Aderrasi - Causeway Of Dreams (REMix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Causeway Of Dreams (REMix).milk"
  File "/oname=Aderrasi - Chromatic Abyss (The Other Side).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Chromatic Abyss (The Other Side).milk"
  File "/oname=Aderrasi - Circlefacade.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Circlefacade.milk"
  File "/oname=Aderrasi - Contortion.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Contortion.milk"
  File "/oname=Aderrasi - Contortion (Xenomorph Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Contortion (Xenomorph Mix).milk"
  File "/oname=Aderrasi - Crystal Storm.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Crystal Storm.milk"
  File "/oname=Aderrasi - Dark Matter (Converse Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Dark Matter (Converse Mix).milk"
  File "/oname=Aderrasi - Elastoid.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Elastoid.milk"
  File "/oname=Aderrasi - Floater Society.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Floater Society.milk"
  File "/oname=Aderrasi - Flowing Form.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Flowing Form.milk"
  File "/oname=Aderrasi - Making Time (Swamp Mix).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Making Time (Swamp Mix).milk"
  File "/oname=Aderrasi - Potion of Spirits.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Potion of Spirits.milk"
  File "/oname=Aderrasi - Songflower (Moss Posy).milk" "../../3rdparty/libprojectm/presets/Aderrasi - Songflower (Moss Posy).milk"
  File "/oname=Aderrasi - Spillswirl.milk" "../../3rdparty/libprojectm/presets/Aderrasi - Spillswirl.milk"
  File "/oname=Aderrasi - What cannot be.milk" "../../3rdparty/libprojectm/presets/Aderrasi - What cannot be.milk"
  File "/oname=Aderrasi - What Cannot Be Undone.milk" "../../3rdparty/libprojectm/presets/Aderrasi - What Cannot Be Undone.milk"
  File "/oname=baked - mushroom rainbows[2].milk" "../../3rdparty/libprojectm/presets/baked - mushroom rainbows[2].milk"
  File "/oname=Bmelgren - Godhead.milk" "../../3rdparty/libprojectm/presets/Bmelgren - Godhead.milk"
  File "/oname=Bmelgren & Krash - Rainbow Orb Peacock (Centred Journey Mix.milk" "../../3rdparty/libprojectm/presets/Bmelgren & Krash - Rainbow Orb Peacock (Centred Journey Mix.milk"
  File "/oname=Bmelgren & Krash - Rainbow Orb Peacock (Lonely Signal Gone .milk" "../../3rdparty/libprojectm/presets/Bmelgren & Krash - Rainbow Orb Peacock (Lonely Signal Gone .milk"
  File "/oname=Bmelgren - Pentultimate Nerual Slipstream (Tweak 2).milk" "../../3rdparty/libprojectm/presets/Bmelgren - Pentultimate Nerual Slipstream (Tweak 2).milk"
  File "/oname=Bmelgren - Take This Highway.milk" "../../3rdparty/libprojectm/presets/Bmelgren - Take This Highway.milk"
  File "/oname=che - adela the flower.milk" "../../3rdparty/libprojectm/presets/che - adela the flower.milk"
  File "/oname=Che - Burning Hus.milk" "../../3rdparty/libprojectm/presets/Che - Burning Hus.milk"
  File "/oname=che - burning hus (oil mix).milk" "../../3rdparty/libprojectm/presets/che - burning hus (oil mix).milk"
  File "/oname=Che - Escape.milk" "../../3rdparty/libprojectm/presets/Che - Escape.milk"
  File "/oname=che - terracarbon stream.milk" "../../3rdparty/libprojectm/presets/che - terracarbon stream.milk"
  File "/oname=Che - Watch & Fly.milk" "../../3rdparty/libprojectm/presets/Che - Watch & Fly.milk"
  File "/oname=CrystalHigh - mad ravetriping.milk" "../../3rdparty/libprojectm/presets/CrystalHigh - mad ravetriping.milk"
  File "/oname=DaNOnE - Highway to Heaven (rotating).milk" "../../3rdparty/libprojectm/presets/DaNOnE - Highway to Heaven (rotating).milk"
  File "/oname=EMPR - Random - Changing Polyevolution.milk" "../../3rdparty/libprojectm/presets/EMPR - Random - Changing Polyevolution.milk"
  File "/oname=EMPR - Random - Look mama I'm on TV! 2.milk" "../../3rdparty/libprojectm/presets/EMPR - Random - Look mama I'm on TV! 2.milk"
  File "/oname=EMPR - Random - They're so cute Dad can I keep one!.milk" "../../3rdparty/libprojectm/presets/EMPR - Random - They're so cute Dad can I keep one!.milk"
  File "/oname=EMPR - Random - Turbulence Sandwich.milk" "../../3rdparty/libprojectm/presets/EMPR - Random - Turbulence Sandwich.milk"
  File "/oname=Eo.S. - glowsticks v2 03 music.milk" "../../3rdparty/libprojectm/presets/Eo.S. - glowsticks v2 03 music.milk"
  File "/oname=Eo.S. - glowsticks v2 04 music minimal.milk" "../../3rdparty/libprojectm/presets/Eo.S. - glowsticks v2 04 music minimal.milk"
  File "/oname=Eo.S. - glowsticks v2 05 and proton lights (+Krash's beat code) _Phat_remix02b.milk" "../../3rdparty/libprojectm/presets/Eo.S. - glowsticks v2 05 and proton lights (+Krash's beat code) _Phat_remix02b.milk"
  File "/oname=Eo.S. - glowsticks v2 05 and proton lights (+Krash's beat code) _Phat_remix07 recursive demons.milk" "../../3rdparty/libprojectm/presets/Eo.S. - glowsticks v2 05 and proton lights (+Krash's beat code) _Phat_remix07 recursive demons.milk"
  File "/oname=Eo.S. - heater core C_Phat's_class + sparks_mix.milk" "../../3rdparty/libprojectm/presets/Eo.S. - heater core C_Phat's_class + sparks_mix.milk"
  File "/oname=Eo.S. - heater core C_Phat's_on route_mix+beam.milk" "../../3rdparty/libprojectm/presets/Eo.S. - heater core C_Phat's_on route_mix+beam.milk"
  File "/oname=Eo.S.+Phat - Arm_upgrades - transformer.milk" "../../3rdparty/libprojectm/presets/Eo.S.+Phat - Arm_upgrades - transformer.milk"
  File "/oname=Eo.S. + Phat - chasers 18 hallway.milk" "../../3rdparty/libprojectm/presets/Eo.S. + Phat - chasers 18 hallway.milk"
  File "/oname=Eo.S.+Phat Cool Bug v2 + (Krash's beat detection).milk" "../../3rdparty/libprojectm/presets/Eo.S.+Phat Cool Bug v2 + (Krash's beat detection).milk"
  File "/oname=Eo.S. - repeater 05 - rave on acid.milk" "../../3rdparty/libprojectm/presets/Eo.S. - repeater 05 - rave on acid.milk"
  File "/oname=Eo.S. - repeater 15 - kaleidoscope b.milk" "../../3rdparty/libprojectm/presets/Eo.S. - repeater 15 - kaleidoscope b.milk"
  File "/oname=EvilJim - Follow the ball.milk" "../../3rdparty/libprojectm/presets/EvilJim - Follow the ball.milk"
  File "/oname=EvilJim - Ice Drops.milk" "../../3rdparty/libprojectm/presets/EvilJim - Ice Drops.milk"
  File "/oname=fiShbRaiN - blueprint.milk" "../../3rdparty/libprojectm/presets/fiShbRaiN - blueprint.milk"
  File "/oname=Fvese - 0 To 60.milk" "../../3rdparty/libprojectm/presets/Fvese - 0 To 60.milk"
  File "/oname=Fvese - A Blur.milk" "../../3rdparty/libprojectm/presets/Fvese - A Blur.milk"
  File "/oname=Fvese & Idiot24-7 - Rearview Mirror.milk" "../../3rdparty/libprojectm/presets/Fvese & Idiot24-7 - Rearview Mirror.milk"
  File "/oname=Fvese - Lifesavor Anyone.milk" "../../3rdparty/libprojectm/presets/Fvese - Lifesavor Anyone.milk"
  File "/oname=Fvese - New meetings.milk" "../../3rdparty/libprojectm/presets/Fvese - New meetings.milk"
  File "/oname=Fvese - Quicksand.milk" "../../3rdparty/libprojectm/presets/Fvese - Quicksand.milk"
  File "/oname=Fvese - Round and Round (geiss gamma mix).milk" "../../3rdparty/libprojectm/presets/Fvese - Round and Round (geiss gamma mix).milk"
  File "/oname=Fvese - simple.milk" "../../3rdparty/libprojectm/presets/Fvese - simple.milk"
  File "/oname=Fvese - Stand Still!.milk" "../../3rdparty/libprojectm/presets/Fvese - Stand Still!.milk"
  File "/oname=Fvese - The Tunnel (Final Stage Mix).milk" "../../3rdparty/libprojectm/presets/Fvese - The Tunnel (Final Stage Mix).milk"
  File "/oname=Fvese - Window Reflection 6.milk" "../../3rdparty/libprojectm/presets/Fvese - Window Reflection 6.milk"
  File "/oname=Fvese - Zoom Effects (Remix 2).milk" "../../3rdparty/libprojectm/presets/Fvese - Zoom Effects (Remix 2).milk"
  File "/oname=Geiss - Aieeeeee!!!.milk" "../../3rdparty/libprojectm/presets/Geiss - Aieeeeee!!!.milk"
  File "/oname=Geiss and Rovastar - The Chaos Of Colours (sprouting diment.milk" "../../3rdparty/libprojectm/presets/Geiss and Rovastar - The Chaos Of Colours (sprouting diment.milk"
  File "/oname=Geiss - Anomaly 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Anomaly 1.milk"
  File "/oname=Geiss - Anomaly 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Anomaly 2.milk"
  File "/oname=Geiss - Approach.milk" "../../3rdparty/libprojectm/presets/Geiss - Approach.milk"
  File "/oname=Geiss - Asymptote.milk" "../../3rdparty/libprojectm/presets/Geiss - Asymptote.milk"
  File "/oname=Geiss - Bass Kaleidosphere.milk" "../../3rdparty/libprojectm/presets/Geiss - Bass Kaleidosphere.milk"
  File "/oname=Geiss - Bass Zoom.milk" "../../3rdparty/libprojectm/presets/Geiss - Bass Zoom.milk"
  File "/oname=Geiss - Bipolar 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Bipolar 1.milk"
  File "/oname=Geiss - Bipolar 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Bipolar 2.milk"
  File "/oname=Geiss - Bipolar 3.milk" "../../3rdparty/libprojectm/presets/Geiss - Bipolar 3.milk"
  File "/oname=Geiss - Bipolar 4.milk" "../../3rdparty/libprojectm/presets/Geiss - Bipolar 4.milk"
  File "/oname=Geiss - Bipolar 5.milk" "../../3rdparty/libprojectm/presets/Geiss - Bipolar 5.milk"
  File "/oname=Geiss - Blasto.milk" "../../3rdparty/libprojectm/presets/Geiss - Blasto.milk"
  File "/oname=Geiss - Bonfire.milk" "../../3rdparty/libprojectm/presets/Geiss - Bonfire.milk"
  File "/oname=Geiss - Bright Fiber Matrix 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Bright Fiber Matrix 1.milk"
  File "/oname=Geiss - Bright Fiber Matrix 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Bright Fiber Matrix 2.milk"
  File "/oname=Geiss - Calligraphy.milk" "../../3rdparty/libprojectm/presets/Geiss - Calligraphy.milk"
  File "/oname=Geiss - Casino.milk" "../../3rdparty/libprojectm/presets/Geiss - Casino.milk"
  File "/oname=Geiss - Cepiasound.milk" "../../3rdparty/libprojectm/presets/Geiss - Cepiasound.milk"
  File "/oname=Geiss - Churn.milk" "../../3rdparty/libprojectm/presets/Geiss - Churn.milk"
  File "/oname=Geiss - Constant Velocity.milk" "../../3rdparty/libprojectm/presets/Geiss - Constant Velocity.milk"
  File "/oname=Geiss - Coral.milk" "../../3rdparty/libprojectm/presets/Geiss - Coral.milk"
  File "/oname=Geiss - Corpus Callosum.milk" "../../3rdparty/libprojectm/presets/Geiss - Corpus Callosum.milk"
  File "/oname=Geiss - Cosmic Dust 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Cosmic Dust 1.milk"
  File "/oname=Geiss - Cosmic Dust 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Cosmic Dust 2.milk"
  File "/oname=Geiss - Cruzin'.milk" "../../3rdparty/libprojectm/presets/Geiss - Cruzin'.milk"
  File "/oname=Geiss - Cycloid 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Cycloid 1.milk"
  File "/oname=Geiss - Cycloid 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Cycloid 2.milk"
  File "/oname=Geiss - Davod The Pod.milk" "../../3rdparty/libprojectm/presets/Geiss - Davod The Pod.milk"
  File "/oname=Geiss - De La Moutard 1.milk" "../../3rdparty/libprojectm/presets/Geiss - De La Moutard 1.milk"
  File "/oname=Geiss - De La Moutard 2.milk" "../../3rdparty/libprojectm/presets/Geiss - De La Moutard 2.milk"
  File "/oname=Geiss - Demonic Distortion.milk" "../../3rdparty/libprojectm/presets/Geiss - Demonic Distortion.milk"
  File "/oname=Geiss - Descent.milk" "../../3rdparty/libprojectm/presets/Geiss - Descent.milk"
  File "/oname=Geiss - Destruction.milk" "../../3rdparty/libprojectm/presets/Geiss - Destruction.milk"
  File "/oname=Geiss - Diffraction.milk" "../../3rdparty/libprojectm/presets/Geiss - Diffraction.milk"
  File "/oname=Geiss - Digital Smoke.milk" "../../3rdparty/libprojectm/presets/Geiss - Digital Smoke.milk"
  File "/oname=Geiss - Downward Spiral.milk" "../../3rdparty/libprojectm/presets/Geiss - Downward Spiral.milk"
  File "/oname=Geiss - Drift.milk" "../../3rdparty/libprojectm/presets/Geiss - Drift.milk"
  File "/oname=Geiss - Dynamic Swirls 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Dynamic Swirls 1.milk"
  File "/oname=Geiss - Dynamic Swirls 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Dynamic Swirls 2.milk"
  File "/oname=Geiss - Eddies 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Eddies 1.milk"
  File "/oname=Geiss - Eddies 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Eddies 2.milk"
  File "/oname=Geiss - Eggs.milk" "../../3rdparty/libprojectm/presets/Geiss - Eggs.milk"
  File "/oname=Geiss - El Cubismo.milk" "../../3rdparty/libprojectm/presets/Geiss - El Cubismo.milk"
  File "/oname=Geiss - Feedback 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Feedback 2.milk"
  File "/oname=Geiss - Feedback.milk" "../../3rdparty/libprojectm/presets/Geiss - Feedback.milk"
  File "/oname=Geiss - Festive.milk" "../../3rdparty/libprojectm/presets/Geiss - Festive.milk"
  File "/oname=Geiss - Fiberglass.milk" "../../3rdparty/libprojectm/presets/Geiss - Fiberglass.milk"
  File "/oname=Geiss - Flotsam.milk" "../../3rdparty/libprojectm/presets/Geiss - Flotsam.milk"
  File "/oname=Geiss - Flower Blossom.milk" "../../3rdparty/libprojectm/presets/Geiss - Flower Blossom.milk"
  File "/oname=Geiss - Flower.milk" "../../3rdparty/libprojectm/presets/Geiss - Flower.milk"
  File "/oname=Geiss - Four Kinds of Amphetamines.milk" "../../3rdparty/libprojectm/presets/Geiss - Four Kinds of Amphetamines.milk"
  File "/oname=Geiss - Galaxy 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Galaxy 1.milk"
  File "/oname=Geiss - Galaxy 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Galaxy 2.milk"
  File "/oname=Geiss - Greenland.milk" "../../3rdparty/libprojectm/presets/Geiss - Greenland.milk"
  File "/oname=Geiss - Heavenly 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Heavenly 1.milk"
  File "/oname=Geiss - Heavenly 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Heavenly 2.milk"
  File "/oname=Geiss - Heavenly 3.milk" "../../3rdparty/libprojectm/presets/Geiss - Heavenly 3.milk"
  File "/oname=Geiss - High Dynamic Range.milk" "../../3rdparty/libprojectm/presets/Geiss - High Dynamic Range.milk"
  File "/oname=Geiss - Hovering.milk" "../../3rdparty/libprojectm/presets/Geiss - Hovering.milk"
  File "/oname=Geiss - Hyperion.milk" "../../3rdparty/libprojectm/presets/Geiss - Hyperion.milk"
  File "/oname=Geiss - Inkblot.milk" "../../3rdparty/libprojectm/presets/Geiss - Inkblot.milk"
  File "/oname=Geiss - Iris.milk" "../../3rdparty/libprojectm/presets/Geiss - Iris.milk"
  File "/oname=Geiss - Journey.milk" "../../3rdparty/libprojectm/presets/Geiss - Journey.milk"
  File "/oname=Geiss - Julia Fractal 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Julia Fractal 1.milk"
  File "/oname=Geiss - Julia Fractal 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Julia Fractal 2.milk"
  File "/oname=Geiss - Luz.milk" "../../3rdparty/libprojectm/presets/Geiss - Luz.milk"
  File "/oname=Geiss - Mega Swirl 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Mega Swirl 1.milk"
  File "/oname=Geiss - Mega Swirl 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Mega Swirl 2.milk"
  File "/oname=Geiss - Mega Swirl 3.milk" "../../3rdparty/libprojectm/presets/Geiss - Mega Swirl 3.milk"
  File "/oname=Geiss - Microcosm.milk" "../../3rdparty/libprojectm/presets/Geiss - Microcosm.milk"
  File "/oname=Geiss - Monotone Ripples.milk" "../../3rdparty/libprojectm/presets/Geiss - Monotone Ripples.milk"
  File "/oname=Geiss - Music Box.milk" "../../3rdparty/libprojectm/presets/Geiss - Music Box.milk"
  File "/oname=Geiss - Nautilus.milk" "../../3rdparty/libprojectm/presets/Geiss - Nautilus.milk"
  File "/oname=Geiss - Octopus Blue.milk" "../../3rdparty/libprojectm/presets/Geiss - Octopus Blue.milk"
  File "/oname=Geiss - Octopus Ever Changing.milk" "../../3rdparty/libprojectm/presets/Geiss - Octopus Ever Changing.milk"
  File "/oname=Geiss - Octopus Fat and Ever Changing.milk" "../../3rdparty/libprojectm/presets/Geiss - Octopus Fat and Ever Changing.milk"
  File "/oname=Geiss - Octopus Gold.milk" "../../3rdparty/libprojectm/presets/Geiss - Octopus Gold.milk"
  File "/oname=Geiss - Octopus Gold with Dots.milk" "../../3rdparty/libprojectm/presets/Geiss - Octopus Gold with Dots.milk"
  File "/oname=Geiss - Octopus.milk" "../../3rdparty/libprojectm/presets/Geiss - Octopus.milk"
  File "/oname=Geiss - Oldskool Mellowstyle.milk" "../../3rdparty/libprojectm/presets/Geiss - Oldskool Mellowstyle.milk"
  File "/oname=Geiss - Pelota De Fuego.milk" "../../3rdparty/libprojectm/presets/Geiss - Pelota De Fuego.milk"
  File "/oname=Geiss - Pinch.milk" "../../3rdparty/libprojectm/presets/Geiss - Pinch.milk"
  File "/oname=Geiss - Pistons.milk" "../../3rdparty/libprojectm/presets/Geiss - Pistons.milk"
  File "/oname=Geiss - Planet 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Planet 1.milk"
  File "/oname=Geiss - Planet 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Planet 2.milk"
  File "/oname=Geiss - Quasilinear Submanifolds.milk" "../../3rdparty/libprojectm/presets/Geiss - Quasilinear Submanifolds.milk"
  File "/oname=Geiss - Reducto Absurdum.milk" "../../3rdparty/libprojectm/presets/Geiss - Reducto Absurdum.milk"
  File "/oname=Geiss - Reducto Ad Nauseum.milk" "../../3rdparty/libprojectm/presets/Geiss - Reducto Ad Nauseum.milk"
  File "/oname=Geiss - Rocket.milk" "../../3rdparty/libprojectm/presets/Geiss - Rocket.milk"
  File "/oname=Geiss & Rovastar - Julia Fractal (Vectrip Mix).milk" "../../3rdparty/libprojectm/presets/Geiss & Rovastar - Julia Fractal (Vectrip Mix).milk"
  File "/oname=Geiss & Rovastar - Notions Of Tonality 2.milk" "../../3rdparty/libprojectm/presets/Geiss & Rovastar - Notions Of Tonality 2.milk"
  File "/oname=Geiss & Rovastar - The Chaos Of Colours (sprouting dimentia mix).milk" "../../3rdparty/libprojectm/presets/Geiss & Rovastar - The Chaos Of Colours (sprouting dimentia mix).milk"
  File "/oname=Geiss & Rovastar - Tokamak (Naked Intrusion Mix).milk" "../../3rdparty/libprojectm/presets/Geiss & Rovastar - Tokamak (Naked Intrusion Mix).milk"
  File "/oname=Geiss - Runoff.milk" "../../3rdparty/libprojectm/presets/Geiss - Runoff.milk"
  File "/oname=Geiss - Scary.milk" "../../3rdparty/libprojectm/presets/Geiss - Scary.milk"
  File "/oname=Geiss - Script.milk" "../../3rdparty/libprojectm/presets/Geiss - Script.milk"
  File "/oname=Geiss - Serpent.milk" "../../3rdparty/libprojectm/presets/Geiss - Serpent.milk"
  File "/oname=Geiss - Shake.milk" "../../3rdparty/libprojectm/presets/Geiss - Shake.milk"
  File "/oname=Geiss - Shift.milk" "../../3rdparty/libprojectm/presets/Geiss - Shift.milk"
  File "/oname=Geiss - Sinews 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Sinews 1.milk"
  File "/oname=Geiss - Sinews 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Sinews 2.milk"
  File "/oname=Geiss - Smoke.milk" "../../3rdparty/libprojectm/presets/Geiss - Smoke.milk"
  File "/oname=Geiss - Solar Flare (Blue).milk" "../../3rdparty/libprojectm/presets/Geiss - Solar Flare (Blue).milk"
  File "/oname=Geiss - Solar Flare.milk" "../../3rdparty/libprojectm/presets/Geiss - Solar Flare.milk"
  File "/oname=Geiss - Solar Flare (Reptile).milk" "../../3rdparty/libprojectm/presets/Geiss - Solar Flare (Reptile).milk"
  File "/oname=Geiss - Sound And The Fury.milk" "../../3rdparty/libprojectm/presets/Geiss - Sound And The Fury.milk"
  File "/oname=Geiss - Spacedust.milk" "../../3rdparty/libprojectm/presets/Geiss - Spacedust.milk"
  File "/oname=Geiss - Space Voyage Bright.milk" "../../3rdparty/libprojectm/presets/Geiss - Space Voyage Bright.milk"
  File "/oname=Geiss - Space Voyage (High-Warp).milk" "../../3rdparty/libprojectm/presets/Geiss - Space Voyage (High-Warp).milk"
  File "/oname=Geiss - Space Voyage.milk" "../../3rdparty/libprojectm/presets/Geiss - Space Voyage.milk"
  File "/oname=Geiss & Sperl - Feedback (projectM idle HDR mix).prjm" "../../3rdparty/libprojectm/presets/Geiss & Sperl - Feedback (projectM idle HDR mix).prjm"
  File "/oname=Geiss - Starfish 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Starfish 1.milk"
  File "/oname=Geiss - Starfish 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Starfish 2.milk"
  File "/oname=Geiss - Sunsets.milk" "../../3rdparty/libprojectm/presets/Geiss - Sunsets.milk"
  File "/oname=Geiss - Supernova 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Supernova 1.milk"
  File "/oname=Geiss - Supernova 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Supernova 2.milk"
  File "/oname=Geiss - Surface.milk" "../../3rdparty/libprojectm/presets/Geiss - Surface.milk"
  File "/oname=Geiss - Swirl 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirl 1.milk"
  File "/oname=Geiss - Swirl 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirl 2.milk"
  File "/oname=Geiss - Swirlie 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirlie 1.milk"
  File "/oname=Geiss - Swirlie 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirlie 2.milk"
  File "/oname=Geiss - Swirlie 3.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirlie 3.milk"
  File "/oname=Geiss - Swirlie 4.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirlie 4.milk"
  File "/oname=Geiss - Swirlie 5.milk" "../../3rdparty/libprojectm/presets/Geiss - Swirlie 5.milk"
  File "/oname=Geiss - Symmetry.milk" "../../3rdparty/libprojectm/presets/Geiss - Symmetry.milk"
  File "/oname=Geiss - The Fatty Lumpkin Sunkle Tweaker.milk" "../../3rdparty/libprojectm/presets/Geiss - The Fatty Lumpkin Sunkle Tweaker.milk"
  File "/oname=Geiss - Three And A Half Kinds Of Amphetamines.milk" "../../3rdparty/libprojectm/presets/Geiss - Three And A Half Kinds Of Amphetamines.milk"
  File "/oname=Geiss - Three Kinds Of Amphetamines.milk" "../../3rdparty/libprojectm/presets/Geiss - Three Kinds Of Amphetamines.milk"
  File "/oname=Geiss - Tokamak.milk" "../../3rdparty/libprojectm/presets/Geiss - Tokamak.milk"
  File "/oname=Geiss - Tornado.milk" "../../3rdparty/libprojectm/presets/Geiss - Tornado.milk"
  File "/oname=Geiss - Toy.milk" "../../3rdparty/libprojectm/presets/Geiss - Toy.milk"
  File "/oname=Geiss - Trampoline.milk" "../../3rdparty/libprojectm/presets/Geiss - Trampoline.milk"
  File "/oname=Geiss - Tube.milk" "../../3rdparty/libprojectm/presets/Geiss - Tube.milk"
  File "/oname=Geiss - Two-Pointed Pulsagon.milk" "../../3rdparty/libprojectm/presets/Geiss - Two-Pointed Pulsagon.milk"
  File "/oname=Geiss - Ultrafast.milk" "../../3rdparty/libprojectm/presets/Geiss - Ultrafast.milk"
  File "/oname=Geiss - Volume Zoom.milk" "../../3rdparty/libprojectm/presets/Geiss - Volume Zoom.milk"
  File "/oname=Geiss - Vortex 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Vortex 1.milk"
  File "/oname=Geiss - Vortex 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Vortex 2.milk"
  File "/oname=Geiss - Warp Of Dali 1.milk" "../../3rdparty/libprojectm/presets/Geiss - Warp Of Dali 1.milk"
  File "/oname=Geiss - Warp Of Dali 2.milk" "../../3rdparty/libprojectm/presets/Geiss - Warp Of Dali 2.milk"
  File "/oname=Geiss - Warp Of Dali Bright.milk" "../../3rdparty/libprojectm/presets/Geiss - Warp Of Dali Bright.milk"
  File "/oname=Geiss - Waterfall.milk" "../../3rdparty/libprojectm/presets/Geiss - Waterfall.milk"
  File "/oname=headphones.tga" "../../3rdparty/libprojectm/presets/headphones.tga"
  File "/oname=Idiot24-7 - Ascending to heaven 2.milk" "../../3rdparty/libprojectm/presets/Idiot24-7 - Ascending to heaven 2.milk"
  File "/oname=Idiot24-7 - Meeting place.milk" "../../3rdparty/libprojectm/presets/Idiot24-7 - Meeting place.milk"
  File "/oname=Idiot - 9-7-02 (Remix) (sustain fixed).milk" "../../3rdparty/libprojectm/presets/Idiot - 9-7-02 (Remix) (sustain fixed).milk"
  File "/oname=Idiot & Che - Various Abstract Effects.milk" "../../3rdparty/libprojectm/presets/Idiot & Che - Various Abstract Effects.milk"
  File "/oname=Idiot - Cortex (Spiritual Visions Mix).milk" "../../3rdparty/libprojectm/presets/Idiot - Cortex (Spiritual Visions Mix).milk"
  File "/oname=Idiot - Madness Within The Void (Remix).milk" "../../3rdparty/libprojectm/presets/Idiot - Madness Within The Void (Remix).milk"
  File "/oname=Idiot - MOTIVATION!.milk" "../../3rdparty/libprojectm/presets/Idiot - MOTIVATION!.milk"
  File "/oname=idiot - Nothing Yet - 03 - The worst of the pack.milk" "../../3rdparty/libprojectm/presets/idiot - Nothing Yet - 03 - The worst of the pack.milk"
  File "/oname=idiot - Nucleus.milk" "../../3rdparty/libprojectm/presets/idiot - Nucleus.milk"
  File "/oname=Idiot & Rovastar - Altars Of Madness 2 (X.42 Mix).milk" "../../3rdparty/libprojectm/presets/Idiot & Rovastar - Altars Of Madness 2 (X.42 Mix).milk"
  File "/oname=idiot - Sinful Code (unchained style).milk" "../../3rdparty/libprojectm/presets/idiot - Sinful Code (unchained style).milk"
  File "/oname=idiot - Some big word I learned.milk" "../../3rdparty/libprojectm/presets/idiot - Some big word I learned.milk"
  File "/oname=idiot - Spectrum.milk" "../../3rdparty/libprojectm/presets/idiot - Spectrum.milk"
  File "/oname=Idiot - Tentacle Dreams (Remix).milk" "../../3rdparty/libprojectm/presets/Idiot - Tentacle Dreams (Remix).milk"
  File "/oname=Idiot - Texture Boxes (Remix 2).milk" "../../3rdparty/libprojectm/presets/Idiot - Texture Boxes (Remix 2).milk"
  File "/oname=Idiot - Texture Boxes (Remix).milk" "../../3rdparty/libprojectm/presets/Idiot - Texture Boxes (Remix).milk"
  File "/oname=Idiot - Typomatic (Remix 2).milk" "../../3rdparty/libprojectm/presets/Idiot - Typomatic (Remix 2).milk"
  File "/oname=Idiot - What Is.milk" "../../3rdparty/libprojectm/presets/Idiot - What Is.milk"
  File "/oname=Idiot - What Shall Come.milk" "../../3rdparty/libprojectm/presets/Idiot - What Shall Come.milk"
  File "/oname=Idiot & Zylot - Unhealthy Love (Idiot's STDs Mix).milk" "../../3rdparty/libprojectm/presets/Idiot & Zylot - Unhealthy Love (Idiot's STDs Mix).milk"
  File "/oname=Illusion & Che - Return Of The King.milk" "../../3rdparty/libprojectm/presets/Illusion & Che - Return Of The King.milk"
  File "/oname=Illusion & Che - The Piper.milk" "../../3rdparty/libprojectm/presets/Illusion & Che - The Piper.milk"
  File "/oname=Illusion - Figure Eight.milk" "../../3rdparty/libprojectm/presets/Illusion - Figure Eight.milk"
  File "/oname=Illusion - Heavenly Eye.milk" "../../3rdparty/libprojectm/presets/Illusion - Heavenly Eye.milk"
  File "/oname=Illusion & Rovastar - Clouded Bottle.milk" "../../3rdparty/libprojectm/presets/Illusion & Rovastar - Clouded Bottle.milk"
  File "/oname=Illusion & Rovastar - Snowflake Delight.milk" "../../3rdparty/libprojectm/presets/Illusion & Rovastar - Snowflake Delight.milk"
  File "/oname=Illusion & Rovastar - Snowflake Return.milk" "../../3rdparty/libprojectm/presets/Illusion & Rovastar - Snowflake Return.milk"
  File "/oname=illusion & studio music - charged bliss.milk" "../../3rdparty/libprojectm/presets/illusion & studio music - charged bliss.milk"
  File "/oname=Illusion & Unchained - Frozen Eye 1.milk" "../../3rdparty/libprojectm/presets/Illusion & Unchained - Frozen Eye 1.milk"
  File "/oname=Illusion & Unchained - Invade My Mind.milk" "../../3rdparty/libprojectm/presets/Illusion & Unchained - Invade My Mind.milk"
  File "/oname=Illusion & Unchained - Re-Enter Homeworld.milk" "../../3rdparty/libprojectm/presets/Illusion & Unchained - Re-Enter Homeworld.milk"
  File "/oname=[Ishan] - Life in the drains.milk" "../../3rdparty/libprojectm/presets/[Ishan] - Life in the drains.milk"
  File "/oname=Jess - Trying To Trap A Twister.milk" "../../3rdparty/libprojectm/presets/Jess - Trying To Trap A Twister.milk"
  File "/oname=Krash - 3D Shapes Demo 2.milk" "../../3rdparty/libprojectm/presets/Krash - 3D Shapes Demo 2.milk"
  File "/oname=Krash - 3D Shapes Demo.milk" "../../3rdparty/libprojectm/presets/Krash - 3D Shapes Demo.milk"
  File "/oname=Krash and Fvese - Molten Indecision (Fvese Remix).milk" "../../3rdparty/libprojectm/presets/Krash and Fvese - Molten Indecision (Fvese Remix).milk"
  File "/oname=Krash and Rovastar - Rainbow Orb.milk" "../../3rdparty/libprojectm/presets/Krash and Rovastar - Rainbow Orb.milk"
  File "/oname=Krash - Digital Flame.milk" "../../3rdparty/libprojectm/presets/Krash - Digital Flame.milk"
  File "/oname=Krash - Dynamic Borders 1.milk" "../../3rdparty/libprojectm/presets/Krash - Dynamic Borders 1.milk"
  File "/oname=Krash - Framed Geometry.milk" "../../3rdparty/libprojectm/presets/Krash - Framed Geometry.milk"
  File "/oname=Krash & Idiot - Memories Of The Castle.milk" "../../3rdparty/libprojectm/presets/Krash & Idiot - Memories Of The Castle.milk"
  File "/oname=Krash & Illusion - Indecisive Mosaic.milk" "../../3rdparty/libprojectm/presets/Krash & Illusion - Indecisive Mosaic.milk"
  File "/oname=Krash & Illusion - Spiral Movement.milk" "../../3rdparty/libprojectm/presets/Krash & Illusion - Spiral Movement.milk"
  File "/oname=Krash - Pulse.milk" "../../3rdparty/libprojectm/presets/Krash - Pulse.milk"
  File "/oname=Krash & Rovastar - Altars Of Madness (Mad Ocean Mix).milk" "../../3rdparty/libprojectm/presets/Krash & Rovastar - Altars Of Madness (Mad Ocean Mix).milk"
  File "/oname=Krash & Rovastar - A Million Miles from Earth (Ripple Mix).milk" "../../3rdparty/libprojectm/presets/Krash & Rovastar - A Million Miles from Earth (Ripple Mix).milk"
  File "/oname=Krash & Rovastar - Cerebral Demons (Distant Memory Mix).milk" "../../3rdparty/libprojectm/presets/Krash & Rovastar - Cerebral Demons (Distant Memory Mix).milk"
  File "/oname=Krash & Rovastar - Cerebral Demons - Phat + Eo.S. hall of ghouls Remix.milk" "../../3rdparty/libprojectm/presets/Krash & Rovastar - Cerebral Demons - Phat + Eo.S. hall of ghouls Remix.milk"
  File "/oname=Krash & Rovastar - Switching Polygons.milk" "../../3rdparty/libprojectm/presets/Krash & Rovastar - Switching Polygons.milk"
  File "/oname=Krash & Rovastar - The Devil Is In The Details.milk" "../../3rdparty/libprojectm/presets/Krash & Rovastar - The Devil Is In The Details.milk"
  File "/oname=Krash - Season's Greetings 2.milk" "../../3rdparty/libprojectm/presets/Krash - Season's Greetings 2.milk"
  File "/oname=Krash & TEcHNO - Rhythmic Mantas.milk" "../../3rdparty/libprojectm/presets/Krash & TEcHNO - Rhythmic Mantas.milk"
  File "/oname=Krash - Twisting Indecision.milk" "../../3rdparty/libprojectm/presets/Krash - Twisting Indecision.milk"
  File "/oname=Krash - War Machine (Shifting Complexity Mix).milk" "../../3rdparty/libprojectm/presets/Krash - War Machine (Shifting Complexity Mix).milk"
  File "/oname=Krash - Windowframe To Mega Swirl 2.milk" "../../3rdparty/libprojectm/presets/Krash - Windowframe To Mega Swirl 2.milk"
  File "/oname=Krash & Zylot - Inside The Planar Portal (Indecision Mix).milk" "../../3rdparty/libprojectm/presets/Krash & Zylot - Inside The Planar Portal (Indecision Mix).milk"
  File "/oname=Mstress - Acoustic Nerve Impulses (Under Drug Effetcs (Hypn.milk" "../../3rdparty/libprojectm/presets/Mstress - Acoustic Nerve Impulses (Under Drug Effetcs (Hypn.milk"
  File "/oname=Mstress & Juppy - Dancer.milk" "../../3rdparty/libprojectm/presets/Mstress & Juppy - Dancer.milk"
  File "/oname=Mstress & Juppy - Dancers In The Dark.milk" "../../3rdparty/libprojectm/presets/Mstress & Juppy - Dancers In The Dark.milk"
  File "/oname=Mstress - Snowing Fiber City.milk" "../../3rdparty/libprojectm/presets/Mstress - Snowing Fiber City.milk"
  File "/oname=M.tga" "../../3rdparty/libprojectm/presets/M.tga"
  File "/oname=nil - Can't Stop the Blithering.milk" "../../3rdparty/libprojectm/presets/nil - Can't Stop the Blithering.milk"
  File "/oname=nil - Can't Stop the Cramming.milk" "../../3rdparty/libprojectm/presets/nil - Can't Stop the Cramming.milk"
  File "/oname=nil - Cid and Lucy.milk" "../../3rdparty/libprojectm/presets/nil - Cid and Lucy.milk"
  File "/oname=nil - Disco Comet.milk" "../../3rdparty/libprojectm/presets/nil - Disco Comet.milk"
  File "/oname=nil - Singularity in My Oscilloscope.milk" "../../3rdparty/libprojectm/presets/nil - Singularity in My Oscilloscope.milk"
  File "/oname=nil - Vortex of Vortices.milk" "../../3rdparty/libprojectm/presets/nil - Vortex of Vortices.milk"
  File "/oname=Phat+fiShbRaiN+Eo.S_Mandala_Chasers_remix.milk" "../../3rdparty/libprojectm/presets/Phat+fiShbRaiN+Eo.S_Mandala_Chasers_remix.milk"
  File "/oname=Phat+fiShbRaiN+Eo.S_Mandala_Chasers_remix - www.eos4life.com.milk" "../../3rdparty/libprojectm/presets/Phat+fiShbRaiN+Eo.S_Mandala_Chasers_remix - www.eos4life.com.milk"
  File "/oname=PieturP - triptrap_(getting_concrete_visions_through_a_diafragma_version).milk" "../../3rdparty/libprojectm/presets/PieturP - triptrap_(getting_concrete_visions_through_a_diafragma_version).milk"
  File "/oname=PieturP - triptrap_(ultimate-trip-mix).milk" "../../3rdparty/libprojectm/presets/PieturP - triptrap_(ultimate-trip-mix).milk"
  File "/oname=project.tga" "../../3rdparty/libprojectm/presets/project.tga"
  File "/oname=Redi Jedi - acid in your brain.milk" "../../3rdparty/libprojectm/presets/Redi Jedi - acid in your brain.milk"
  File "/oname=Redi Jedi - multiple points of origin, one destination.milk" "../../3rdparty/libprojectm/presets/Redi Jedi - multiple points of origin, one destination.milk"
  File "/oname=Reenen - phoenix.milk" "../../3rdparty/libprojectm/presets/Reenen - phoenix.milk"
  File "/oname=Rocke - Cold Love (Tei Zwaa).milk" "../../3rdparty/libprojectm/presets/Rocke - Cold Love (Tei Zwaa).milk"
  File "/oname=Rocke - Personal Comet.milk" "../../3rdparty/libprojectm/presets/Rocke - Personal Comet.milk"
  File "/oname=Rovastar & Aderrasi - Oceanic Bassograph (Underwater Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Aderrasi - Oceanic Bassograph (Underwater Mix).milk"
  File "/oname=Rovastar - Altars Of Harlequin's Maddess.milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Harlequin's Maddess.milk"
  File "/oname=Rovastar - Altars Of Harlequin's Madness (Dark Disorder Mix.milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Harlequin's Madness (Dark Disorder Mix.milk"
  File "/oname=Rovastar - Altars Of Madness 2 (Frozen Time Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness 2 (Frozen Time Mix).milk"
  File "/oname=Rovastar - Altars Of Madness 4 (Spirit Of Twisted Madness M.milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness 4 (Spirit Of Twisted Madness M.milk"
  File "/oname=Rovastar - Altars Of Madness (A Million Miles From Earth Mi.milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness (A Million Miles From Earth Mi.milk"
  File "/oname=Rovastar - Altars Of Madness (Boxfresh Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness (Boxfresh Mix).milk"
  File "/oname=Rovastar - Altars Of Madness (Duel Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness (Duel Mix).milk"
  File "/oname=Rovastar - Altars Of Madness.milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness.milk"
  File "/oname=Rovastar - Altars Of Madness (Surealist Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Altars Of Madness (Surealist Mix).milk"
  File "/oname=Rovastar - A Million Miles from Earth.milk" "../../3rdparty/libprojectm/presets/Rovastar - A Million Miles from Earth.milk"
  File "/oname=Rovastar - A Million Miles from Earth (Pathfinder Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - A Million Miles from Earth (Pathfinder Mix).milk"
  File "/oname=Rovastar - A Million Miles From Earth (Wormhole Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - A Million Miles From Earth (Wormhole Mix).milk"
  File "/oname=Rovastar and Krash - Hallucinogenic Pyramids (Extra Beat Ti.milk" "../../3rdparty/libprojectm/presets/Rovastar and Krash - Hallucinogenic Pyramids (Extra Beat Ti.milk"
  File "/oname=Rovastar and Unchained - Braindance Visions.milk" "../../3rdparty/libprojectm/presets/Rovastar and Unchained - Braindance Visions.milk"
  File "/oname=Rovastar and Unchained - Life After Pie (Remix).milk" "../../3rdparty/libprojectm/presets/Rovastar and Unchained - Life After Pie (Remix).milk"
  File "/oname=Rovastar - Attacking Freedom.milk" "../../3rdparty/libprojectm/presets/Rovastar - Attacking Freedom.milk"
  File "/oname=Rovastar - Bellanova (New Wave Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Bellanova (New Wave Mix).milk"
  File "/oname=Rovastar - Biohazard Warning.milk" "../../3rdparty/libprojectm/presets/Rovastar - Biohazard Warning.milk"
  File "/oname=Rovastar - Chapel Of Ghouls.milk" "../../3rdparty/libprojectm/presets/Rovastar - Chapel Of Ghouls.milk"
  File "/oname=Rovastar & Che - Adela The Flower (Altars Of Madness Mix 2).milk" "../../3rdparty/libprojectm/presets/Rovastar & Che - Adela The Flower (Altars Of Madness Mix 2).milk"
  File "/oname=Rovastar & Che - Asylum Animations.milk" "../../3rdparty/libprojectm/presets/Rovastar & Che - Asylum Animations.milk"
  File "/oname=Rovastar - Chemical Spirituality.milk" "../../3rdparty/libprojectm/presets/Rovastar - Chemical Spirituality.milk"
  File "/oname=Rovastar - Clouded Judgement 3.milk" "../../3rdparty/libprojectm/presets/Rovastar - Clouded Judgement 3.milk"
  File "/oname=Rovastar - Cosmic Echoes 1.milk" "../../3rdparty/libprojectm/presets/Rovastar - Cosmic Echoes 1.milk"
  File "/oname=Rovastar - Cosmic Echoes 2.milk" "../../3rdparty/libprojectm/presets/Rovastar - Cosmic Echoes 2.milk"
  File "/oname=Rovastar - Cosmic Havoc.milk" "../../3rdparty/libprojectm/presets/Rovastar - Cosmic Havoc.milk"
  File "/oname=Rovastar - Cosmic Mosaic (Active Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Cosmic Mosaic (Active Mix).milk"
  File "/oname=Rovastar - Dark Ritual (Star Of Destiny Denied Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Dark Ritual (Star Of Destiny Denied Mix).milk"
  File "/oname=Rovastar - Dark Ritual (Star Of Destiny Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Dark Ritual (Star Of Destiny Mix).milk"
  File "/oname=Rovastar - Decreasing Dreams (Extended Movement Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Decreasing Dreams (Extended Movement Mix).milk"
  File "/oname=Rovastar - Dreamcatcher.milk" "../../3rdparty/libprojectm/presets/Rovastar - Dreamcatcher.milk"
  File "/oname=Rovastar - Explosive Minds.milk" "../../3rdparty/libprojectm/presets/Rovastar - Explosive Minds.milk"
  File "/oname=Rovastar - Forgotten Moon.milk" "../../3rdparty/libprojectm/presets/Rovastar - Forgotten Moon.milk"
  File "/oname=Rovastar - Fractopia (Fantic Dancing Lights Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Fractopia (Fantic Dancing Lights Mix).milk"
  File "/oname=Rovastar - Fractopia (Galaxy Swirl Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Fractopia (Galaxy Swirl Mix).milk"
  File "/oname=Rovastar - Fractopia (Upspoken Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Fractopia (Upspoken Mix).milk"
  File "/oname=Rovastar - Fractopia (Upspoken Mix)_Phat_Speak_When_Spoken_2.milk" "../../3rdparty/libprojectm/presets/Rovastar - Fractopia (Upspoken Mix)_Phat_Speak_When_Spoken_2.milk"
  File "/oname=Rovastar - Frozen Rapture .milk" "../../3rdparty/libprojectm/presets/Rovastar - Frozen Rapture .milk"
  File "/oname=Rovastar - Future Speakers.milk" "../../3rdparty/libprojectm/presets/Rovastar - Future Speakers.milk"
  File "/oname=Rovastar & Fvese - Dark Subconscious.milk" "../../3rdparty/libprojectm/presets/Rovastar & Fvese - Dark Subconscious.milk"
  File "/oname=Rovastar & Fvese - Deadly Flower.milk" "../../3rdparty/libprojectm/presets/Rovastar & Fvese - Deadly Flower.milk"
  File "/oname=Rovastar & Fvese - Mosaic Waves.milk" "../../3rdparty/libprojectm/presets/Rovastar & Fvese - Mosaic Waves.milk"
  File "/oname=Rovastar & Fvese - Paranormal Static.milk" "../../3rdparty/libprojectm/presets/Rovastar & Fvese - Paranormal Static.milk"
  File "/oname=Rovastar & Fvese - Stranger Minds (Astral Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Fvese - Stranger Minds (Astral Mix).milk"
  File "/oname=Rovastar & Fvese - Stranger Minds.milk" "../../3rdparty/libprojectm/presets/Rovastar & Fvese - Stranger Minds.milk"
  File "/oname=Rovastar & Geiss - Approach (Vectrip Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Approach (Vectrip Mix).milk"
  File "/oname=Rovastar & Geiss - Bipolar 2 (Vectrip Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Bipolar 2 (Vectrip Mix).milk"
  File "/oname=Rovastar & Geiss - Dynamic Swirls 3 (Broken Destiny Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Dynamic Swirls 3 (Broken Destiny Mix).milk"
  File "/oname=Rovastar & Geiss - Dynamic Swirls 3 (Mysticial Awakening Mi.milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Dynamic Swirls 3 (Mysticial Awakening Mi.milk"
  File "/oname=Rovastar & Geiss - Dynamic Swirls 3 (Poltergiest Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Dynamic Swirls 3 (Poltergiest Mix).milk"
  File "/oname=Rovastar & Geiss - Dynamic Swirls 3 (Smoke Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Dynamic Swirls 3 (Smoke Mix).milk"
  File "/oname=Rovastar & Geiss - Dynamic Swirls 3 (Smoking Delusion Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Dynamic Swirls 3 (Smoking Delusion Mix).milk"
  File "/oname=Rovastar & Geiss - Dynamic Swirls 3 (Voyage Of Twisted Soul.milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Dynamic Swirls 3 (Voyage Of Twisted Soul.milk"
  File "/oname=Rovastar & Geiss - Ice Planet.milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Ice Planet.milk"
  File "/oname=Rovastar & Geiss - Octoplasm.milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Octoplasm.milk"
  File "/oname=Rovastar & Geiss - Octotrip.milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Octotrip.milk"
  File "/oname=Rovastar & Geiss - Octotrip (MultiTrip Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Geiss - Octotrip (MultiTrip Mix).milk"
  File "/oname=Rovastar - Halcyon Dreams 3.milk" "../../3rdparty/libprojectm/presets/Rovastar - Halcyon Dreams 3.milk"
  File "/oname=Rovastar - Hallucinogenic Pyramids (Beat Time Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Hallucinogenic Pyramids (Beat Time Mix).milk"
  File "/oname=Rovastar - Harlequin's Delight (Endless Tunnel Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Delight (Endless Tunnel Mix).milk"
  File "/oname=Rovastar - Harlequin's Dynamic Fractal 1.milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Dynamic Fractal 1.milk"
  File "/oname=Rovastar - Harlequin's Dynamic Fractal 2.milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Dynamic Fractal 2.milk"
  File "/oname=Rovastar - Harlequin's Dynamic Fractal 3.milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Dynamic Fractal 3.milk"
  File "/oname=Rovastar - Harlequin's Dynamic Fractal (Crazed Spiral Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Dynamic Fractal (Crazed Spiral Mix).milk"
  File "/oname=Rovastar - Harlequin's Dynamic Fractal (Dual Spiral Mix ).milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Dynamic Fractal (Dual Spiral Mix ).milk"
  File "/oname=Rovastar - Harlequin's Fractal Encounter 2.milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Fractal Encounter 2.milk"
  File "/oname=Rovastar - Harlequin's Fractal Encounter.milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Fractal Encounter.milk"
  File "/oname=Rovastar - Harlequin's Spirit.milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Spirit.milk"
  File "/oname=Rovastar - Harlequin's Spirit (Twisted Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Harlequin's Spirit (Twisted Mix).milk"
  File "/oname=Rovastar - Hyperspace (Frozen Rapture Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Hyperspace (Frozen Rapture Mix).milk"
  File "/oname=Rovastar - Hyperspace (Hyper Speed Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Hyperspace (Hyper Speed Mix).milk"
  File "/oname=Rovastar - Hyperspace.milk" "../../3rdparty/libprojectm/presets/Rovastar - Hyperspace.milk"
  File "/oname=Rovastar & Idiot24-7 - Balk Acid.milk" "../../3rdparty/libprojectm/presets/Rovastar & Idiot24-7 - Balk Acid.milk"
  File "/oname=Rovastar & Idiot24-7 - Mixed Emotions (Harlequin's Shame Mi.milk" "../../3rdparty/libprojectm/presets/Rovastar & Idiot24-7 - Mixed Emotions (Harlequin's Shame Mi.milk"
  File "/oname=Rovastar & Idiot24-7 - Mixed Emotions (Harlequin's Shame Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Idiot24-7 - Mixed Emotions (Harlequin's Shame Mix).milk"
  File "/oname=Rovastar & Illusion - Shifting Sphere.milk" "../../3rdparty/libprojectm/presets/Rovastar & Illusion - Shifting Sphere.milk"
  File "/oname=Rovastar - Inner Thoughts (Clouded Judgement Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Inner Thoughts (Clouded Judgement Mix).milk"
  File "/oname=Rovastar - Inner Thoughts (Dark Secret Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Inner Thoughts (Dark Secret Mix).milk"
  File "/oname=Rovastar - Inner Thoughts (Distant Memories Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Inner Thoughts (Distant Memories Mix).milk"
  File "/oname=Rovastar - Inner Thoughts (Frantic Thoughts Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Inner Thoughts (Frantic Thoughts Mix).milk"
  File "/oname=Rovastar - Inner Thoughts (Strange Cargo Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Inner Thoughts (Strange Cargo Mix).milk"
  File "/oname=Rovastar - Kalideostars (Altars Of Madness MIx).milk" "../../3rdparty/libprojectm/presets/Rovastar - Kalideostars (Altars Of Madness MIx).milk"
  File "/oname=Rovastar - Kalideostars.milk" "../../3rdparty/libprojectm/presets/Rovastar - Kalideostars.milk"
  File "/oname=Rovastar - Kalideostars (Round  Round Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Kalideostars (Round  Round Mix).milk"
  File "/oname=Rovastar & Krash - Cerebral Demons.milk" "../../3rdparty/libprojectm/presets/Rovastar & Krash - Cerebral Demons.milk"
  File "/oname=Rovastar & Krash - Flowing Synergy.milk" "../../3rdparty/libprojectm/presets/Rovastar & Krash - Flowing Synergy.milk"
  File "/oname=Rovastar & Krash - Interwoven (Contra Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Krash - Interwoven (Contra Mix).milk"
  File "/oname=Rovastar - LabFunk.milk" "../../3rdparty/libprojectm/presets/Rovastar - LabFunk.milk"
  File "/oname=Rovastar - Lost Souls of the Bermuda Triangle (Darkest Soul.milk" "../../3rdparty/libprojectm/presets/Rovastar - Lost Souls of the Bermuda Triangle (Darkest Soul.milk"
  File "/oname=Rovastar - Magic Carpet.milk" "../../3rdparty/libprojectm/presets/Rovastar - Magic Carpet.milk"
  File "/oname=Rovastar - Mosaics Of Ages.milk" "../../3rdparty/libprojectm/presets/Rovastar - Mosaics Of Ages.milk"
  File "/oname=Rovastar - Multiverse Starfield 1.milk" "../../3rdparty/libprojectm/presets/Rovastar - Multiverse Starfield 1.milk"
  File "/oname=Rovastar - Multiverse Starfield 3.milk" "../../3rdparty/libprojectm/presets/Rovastar - Multiverse Starfield 3.milk"
  File "/oname=Rovastar - Omnipresence Resurrection.milk" "../../3rdparty/libprojectm/presets/Rovastar - Omnipresence Resurrection.milk"
  File "/oname=Rovastar - Omnipresence Resurrection (Raw Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Omnipresence Resurrection (Raw Mix).milk"
  File "/oname=Rovastar - Oozing Resistance.milk" "../../3rdparty/libprojectm/presets/Rovastar - Oozing Resistance.milk"
  File "/oname=Rovastar - Pandora's Volcano.milk" "../../3rdparty/libprojectm/presets/Rovastar - Pandora's Volcano.milk"
  File "/oname=Rovastar - Parallel Universe.milk" "../../3rdparty/libprojectm/presets/Rovastar - Parallel Universe.milk"
  File "/oname=Rovastar & Rocke - Answer.42 (Trippy S. Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Rocke - Answer.42 (Trippy S. Mix).milk"
  File "/oname=Rovastar & Rocke - Headspin.milk" "../../3rdparty/libprojectm/presets/Rovastar & Rocke - Headspin.milk"
  File "/oname=Rovastar & Rocke - Sugar Spun Sister.milk" "../../3rdparty/libprojectm/presets/Rovastar & Rocke - Sugar Spun Sister.milk"
  File "/oname=Rovastar - Sea Shells.milk" "../../3rdparty/libprojectm/presets/Rovastar - Sea Shells.milk"
  File "/oname=Rovastar - Snapshot Of Space.milk" "../../3rdparty/libprojectm/presets/Rovastar - Snapshot Of Space.milk"
  File "/oname=Rovastar - Solarized Space.milk" "../../3rdparty/libprojectm/presets/Rovastar - Solarized Space.milk"
  File "/oname=Rovastar - Solarized Space (Space DNA Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Solarized Space (Space DNA Mix).milk"
  File "/oname=Rovastar - Space.milk" "../../3rdparty/libprojectm/presets/Rovastar - Space.milk"
  File "/oname=Rovastar - Space (Twisted Dimension Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Space (Twisted Dimension Mix).milk"
  File "/oname=Rovastar & Sperl - Tuxflower.prjm" "../../3rdparty/libprojectm/presets/Rovastar & Sperl - Tuxflower.prjm"
  File "/oname=Rovastar - Starquake (Sunquake Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Starquake (Sunquake Mix).milk"
  File "/oname=Rovastar & StudioMusic - More Cherished Desires.milk" "../../3rdparty/libprojectm/presets/Rovastar & StudioMusic - More Cherished Desires.milk"
  File "/oname=Rovastar & StudioMusic - Twisted Spider Web.milk" "../../3rdparty/libprojectm/presets/Rovastar & StudioMusic - Twisted Spider Web.milk"
  File "/oname=Rovastar & Telek - Altars of Madness (Rolling Oceans Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Telek - Altars of Madness (Rolling Oceans Mix).milk"
  File "/oname=Rovastar & Telek - Cosmic Fireworks.milk" "../../3rdparty/libprojectm/presets/Rovastar & Telek - Cosmic Fireworks.milk"
  File "/oname=Rovastar - The Awakening.milk" "../../3rdparty/libprojectm/presets/Rovastar - The Awakening.milk"
  File "/oname=Rovastar - The Chaos Of Colours (Drifting Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - The Chaos Of Colours (Drifting Mix).milk"
  File "/oname=Rovastar - The Chaos Of Colours.milk" "../../3rdparty/libprojectm/presets/Rovastar - The Chaos Of Colours.milk"
  File "/oname=Rovastar - The Shroomery.milk" "../../3rdparty/libprojectm/presets/Rovastar - The Shroomery.milk"
  File "/oname=Rovastar - Timeless Voyage.milk" "../../3rdparty/libprojectm/presets/Rovastar - Timeless Voyage.milk"
  File "/oname=Rovastar - Touchdown on Mars (Detailed Pictures Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - Touchdown on Mars (Detailed Pictures Mix).milk"
  File "/oname=Rovastar - Tripmaker.milk" "../../3rdparty/libprojectm/presets/Rovastar - Tripmaker.milk"
  File "/oname=Rovastar - twisted bytes.milk" "../../3rdparty/libprojectm/presets/Rovastar - twisted bytes.milk"
  File "/oname=Rovastar & Unchained - Ambrosia Mystic (Dark Heart Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Unchained - Ambrosia Mystic (Dark Heart Mix).milk"
  File "/oname=Rovastar & Unchained - Centre Of Gravity.milk" "../../3rdparty/libprojectm/presets/Rovastar & Unchained - Centre Of Gravity.milk"
  File "/oname=Rovastar & Unchained - Demonology (Vampire Soul Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Unchained - Demonology (Vampire Soul Mix).milk"
  File "/oname=Rovastar & Unchained - Oddball World.milk" "../../3rdparty/libprojectm/presets/Rovastar & Unchained - Oddball World.milk"
  File "/oname=Rovastar & Unchained - Voodoo Chess Magnet (Everglow Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Unchained - Voodoo Chess Magnet (Everglow Mix).milk"
  File "/oname=Rovastar & Unchained - Xen Traffic.milk" "../../3rdparty/libprojectm/presets/Rovastar & Unchained - Xen Traffic.milk"
  File "/oname=Rovastar - VooV's Movement (After Dark Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar - VooV's Movement (After Dark Mix).milk"
  File "/oname=Rovastar - VooV's Movement.milk" "../../3rdparty/libprojectm/presets/Rovastar - VooV's Movement.milk"
  File "/oname=Rovastar & Zylot - Azirphaeli's Plan (Multiplan Mix).milk" "../../3rdparty/libprojectm/presets/Rovastar & Zylot - Azirphaeli's Plan (Multiplan Mix).milk"
  File "/oname=Rovastar & Zylot - Narell's Fever.milk" "../../3rdparty/libprojectm/presets/Rovastar & Zylot - Narell's Fever.milk"
  File "/oname=Rovastar & Zylot - Passion Flower.milk" "../../3rdparty/libprojectm/presets/Rovastar & Zylot - Passion Flower.milk"
  File "/oname=Rovastar & Zylot - Sea Of Zigrot.milk" "../../3rdparty/libprojectm/presets/Rovastar & Zylot - Sea Of Zigrot.milk"
  File "/oname=Rozzer & Zylot - Force Field Generator (Slowtime Tweak).milk" "../../3rdparty/libprojectm/presets/Rozzer & Zylot - Force Field Generator (Slowtime Tweak).milk"
  File "/oname=Rozzor & Aderrasi - Canon.milk" "../../3rdparty/libprojectm/presets/Rozzor & Aderrasi - Canon.milk"
  File "/oname=Rozzor and che - Inside the House of nil.milk" "../../3rdparty/libprojectm/presets/Rozzor and che - Inside the House of nil.milk"
  File "/oname=Rozzor and Idiot - Any Other Deep Rising.milk" "../../3rdparty/libprojectm/presets/Rozzor and Idiot - Any Other Deep Rising.milk"
  File "/oname=Rozzor and Rovastar - Altars Of Madness 3 (ooze tweak).milk" "../../3rdparty/libprojectm/presets/Rozzor and Rovastar - Altars Of Madness 3 (ooze tweak).milk"
  File "/oname=Rozzor and Rovastar - Altars Of Madness 3 (ooze tweak with .milk" "../../3rdparty/libprojectm/presets/Rozzor and Rovastar - Altars Of Madness 3 (ooze tweak with .milk"
  File "/oname=Rozzor and StudioMusic - Vertigyny (Geiss shape mod).milk" "../../3rdparty/libprojectm/presets/Rozzor and StudioMusic - Vertigyny (Geiss shape mod).milk"
  File "/oname=Rozzor and Zylot - Associative Order.milk" "../../3rdparty/libprojectm/presets/Rozzor and Zylot - Associative Order.milk"
  File "/oname=Rozzor & Che - Inside The House Of Nil.milk" "../../3rdparty/libprojectm/presets/Rozzor & Che - Inside The House Of Nil.milk"
  File "/oname=Rozzor - Learning Curve (Invert tweak).milk" "../../3rdparty/libprojectm/presets/Rozzor - Learning Curve (Invert tweak).milk"
  File "/oname=Rozzor & Rovastar - Oozing Resistance (Waveform Mod).milk" "../../3rdparty/libprojectm/presets/Rozzor & Rovastar - Oozing Resistance (Waveform Mod).milk"
  File "/oname=shifter - escape the worm - Eo.S. + Phat 5362.milk" "../../3rdparty/libprojectm/presets/shifter - escape the worm - Eo.S. + Phat 5362.milk"
  File "/oname=shifter - escape the worm - Eo.S. + Phat - Before_It_Eats_Your_Brain_Mix_v2.milk" "../../3rdparty/libprojectm/presets/shifter - escape the worm - Eo.S. + Phat - Before_It_Eats_Your_Brain_Mix_v2.milk"
  File "/oname=StudioMusic Aderrasi & nil - LA movement (Intellectual Sens.milk" "../../3rdparty/libprojectm/presets/StudioMusic Aderrasi & nil - LA movement (Intellectual Sens.milk"
  File "/oname=Studio Music and Unchained - Rapid Alteration.milk" "../../3rdparty/libprojectm/presets/Studio Music and Unchained - Rapid Alteration.milk"
  File "/oname=Studio Music - Cherished Desires.milk" "../../3rdparty/libprojectm/presets/Studio Music - Cherished Desires.milk"
  File "/oname=StudioMusic - Harmonic Bliss (elated mix).milk" "../../3rdparty/libprojectm/presets/StudioMusic - Harmonic Bliss (elated mix).milk"
  File "/oname=StudioMusic - It's Only Make Believe.milk" "../../3rdparty/libprojectm/presets/StudioMusic - It's Only Make Believe.milk"
  File "/oname=StudioMusic - Numerosity.milk" "../../3rdparty/libprojectm/presets/StudioMusic - Numerosity.milk"
  File "/oname=StudioMusic - Twisted Galaxy.milk" "../../3rdparty/libprojectm/presets/StudioMusic - Twisted Galaxy.milk"
  File "/oname=StudioMusic & Unchained - Entity.milk" "../../3rdparty/libprojectm/presets/StudioMusic & Unchained - Entity.milk"
  File "/oname=StudioMusic & Unchained - Minor Alteration.milk" "../../3rdparty/libprojectm/presets/StudioMusic & Unchained - Minor Alteration.milk"
  File "/oname=StudioMusic & Unchained - So Much Love.milk" "../../3rdparty/libprojectm/presets/StudioMusic & Unchained - So Much Love.milk"
  File "/oname=StudioMusic & Unchained - State Of Discretion.milk" "../../3rdparty/libprojectm/presets/StudioMusic & Unchained - State Of Discretion.milk"
  File "/oname=StudioMusic & Unchained - Wrenched Fate.milk" "../../3rdparty/libprojectm/presets/StudioMusic & Unchained - Wrenched Fate.milk"
  File "/oname=TEcHNO and SandStorm - Psychodelic Highway.milk" "../../3rdparty/libprojectm/presets/TEcHNO and SandStorm - Psychodelic Highway.milk"
  File "/oname=Telek - City Helix Lattice.milk" "../../3rdparty/libprojectm/presets/Telek - City Helix Lattice.milk"
  File "/oname=Telek - Directive Swagger (Spectral Inferno) (fix...) maybe.milk" "../../3rdparty/libprojectm/presets/Telek - Directive Swagger (Spectral Inferno) (fix...) maybe.milk"
  File "/oname=Telek EMPR - Scanner - Trust me I've got a Melways.milk" "../../3rdparty/libprojectm/presets/Telek EMPR - Scanner - Trust me I've got a Melways.milk"
  File "/oname=Telek - Flicker.milk" "../../3rdparty/libprojectm/presets/Telek - Flicker.milk"
  File "/oname=Telek - Flicker (xis).milk" "../../3rdparty/libprojectm/presets/Telek - Flicker (xis).milk"
  File "/oname=Telek - Lost Star (Flash).milk" "../../3rdparty/libprojectm/presets/Telek - Lost Star (Flash).milk"
  File "/oname=Telek - Recirculate (Cool).milk" "../../3rdparty/libprojectm/presets/Telek - Recirculate (Cool).milk"
  File "/oname=Telek - Sine Wave.milk" "../../3rdparty/libprojectm/presets/Telek - Sine Wave.milk"
  File "/oname=Telek - Slow Shift Matrix (bb4.5).milk" "../../3rdparty/libprojectm/presets/Telek - Slow Shift Matrix (bb4.5).milk"
  File "/oname=Telek - Slow Shift Matrix (Ethereal Drift).milk" "../../3rdparty/libprojectm/presets/Telek - Slow Shift Matrix (Ethereal Drift).milk"
  File "/oname=Telek - Slow Shift Matrix.milk" "../../3rdparty/libprojectm/presets/Telek - Slow Shift Matrix.milk"
  File "/oname=Telek - Slow Thing (Spiderman Mix).milk" "../../3rdparty/libprojectm/presets/Telek - Slow Thing (Spiderman Mix).milk"
  File "/oname=Telek - Spiral Tabletop (New and Improved!).milk" "../../3rdparty/libprojectm/presets/Telek - Spiral Tabletop (New and Improved!).milk"
  File "/oname=Telek - Spokes (More Dynamic).milk" "../../3rdparty/libprojectm/presets/Telek - Spokes (More Dynamic).milk"
  File "/oname=Telek - Target Practice (tracking retreat slide).milk" "../../3rdparty/libprojectm/presets/Telek - Target Practice (tracking retreat slide).milk"
  File "/oname=TobiasWolfBoi - Cataract.milk" "../../3rdparty/libprojectm/presets/TobiasWolfBoi - Cataract.milk"
  File "/oname=TobiasWolfBoi - The Pit.milk" "../../3rdparty/libprojectm/presets/TobiasWolfBoi - The Pit.milk"
  File "/oname=Tschoey - Music Flower.milk" "../../3rdparty/libprojectm/presets/Tschoey - Music Flower.milk"
  File "/oname=Tux.tga" "../../3rdparty/libprojectm/presets/Tux.tga"
  File "/oname=Unchained - All You Can Eat.milk" "../../3rdparty/libprojectm/presets/Unchained - All You Can Eat.milk"
  File "/oname=Unchained - A Matter Of Taste (Remix).milk" "../../3rdparty/libprojectm/presets/Unchained - A Matter Of Taste (Remix).milk"
  File "/oname=Unchained - Bad Karma Oddnezz Style.milk" "../../3rdparty/libprojectm/presets/Unchained - Bad Karma Oddnezz Style.milk"
  File "/oname=Unchained - Beat Demo 1.0.milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo 1.0.milk"
  File "/oname=Unchained - Beat Demo 10.milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo 10.milk"
  File "/oname=Unchained - Beat Demo 2.0.milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo 2.0.milk"
  File "/oname=Unchained - Beat Demo 2.1.milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo 2.1.milk"
  File "/oname=Unchained - Beat Demo 2.2.milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo 2.2.milk"
  File "/oname=Unchained - Beat Demo 2.3.milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo 2.3.milk"
  File "/oname=Unchained - Beat Demo (Demonology Mix).milk" "../../3rdparty/libprojectm/presets/Unchained - Beat Demo (Demonology Mix).milk"
  File "/oname=Unchained - Cartoon Factory.milk" "../../3rdparty/libprojectm/presets/Unchained - Cartoon Factory.milk"
  File "/oname=Unchained & Che - Oddnezz 3.milk" "../../3rdparty/libprojectm/presets/Unchained & Che - Oddnezz 3.milk"
  File "/oname=Unchained & Che - Oddnezz 4 (Done it again).milk" "../../3rdparty/libprojectm/presets/Unchained & Che - Oddnezz 4 (Done it again).milk"
  File "/oname=Unchained - Cranked On Failure.milk" "../../3rdparty/libprojectm/presets/Unchained - Cranked On Failure.milk"
  File "/oname=Unchained & CTho - Bad Vibes.milk" "../../3rdparty/libprojectm/presets/Unchained & CTho - Bad Vibes.milk"
  File "/oname=Unchained - Custom Gramatix (Remix).milk" "../../3rdparty/libprojectm/presets/Unchained - Custom Gramatix (Remix).milk"
  File "/oname=Unchained - Deeper Logic.milk" "../../3rdparty/libprojectm/presets/Unchained - Deeper Logic.milk"
  File "/oname=Unchained - Free to Feel (Valium Remix).milk" "../../3rdparty/libprojectm/presets/Unchained - Free to Feel (Valium Remix).milk"
  File "/oname=Unchained - French Clothing.milk" "../../3rdparty/libprojectm/presets/Unchained - French Clothing.milk"
  File "/oname=Unchained - Games With Light & Sound.milk" "../../3rdparty/libprojectm/presets/Unchained - Games With Light & Sound.milk"
  File "/oname=Unchained - Ghostlight Whisper.milk" "../../3rdparty/libprojectm/presets/Unchained - Ghostlight Whisper.milk"
  File "/oname=Unchained - God Of The Game (Remix).milk" "../../3rdparty/libprojectm/presets/Unchained - God Of The Game (Remix).milk"
  File "/oname=Unchained - Goofy Beat Detection.milk" "../../3rdparty/libprojectm/presets/Unchained - Goofy Beat Detection.milk"
  File "/oname=Unchained - Goo Kung Fu.milk" "../../3rdparty/libprojectm/presets/Unchained - Goo Kung Fu.milk"
  File "/oname=Unchained - Housed In A Childish Mind.milk" "../../3rdparty/libprojectm/presets/Unchained - Housed In A Childish Mind.milk"
  File "/oname=Unchained & Illusion - Dual Wave 3.milk" "../../3rdparty/libprojectm/presets/Unchained & Illusion - Dual Wave 3.milk"
  File "/oname=Unchained & Illusion - Logic Morph.milk" "../../3rdparty/libprojectm/presets/Unchained & Illusion - Logic Morph.milk"
  File "/oname=Unchained & Illusion - Spirit Morph.milk" "../../3rdparty/libprojectm/presets/Unchained & Illusion - Spirit Morph.milk"
  File "/oname=Unchained - In Memory Of Peg.milk" "../../3rdparty/libprojectm/presets/Unchained - In Memory Of Peg.milk"
  File "/oname=Unchained - Invariant Under Rigorous Motions.milk" "../../3rdparty/libprojectm/presets/Unchained - Invariant Under Rigorous Motions.milk"
  File "/oname=Unchained - Jaded Emotion.milk" "../../3rdparty/libprojectm/presets/Unchained - Jaded Emotion.milk"
  File "/oname=Unchained - Jaundice.milk" "../../3rdparty/libprojectm/presets/Unchained - Jaundice.milk"
  File "/oname=Unchained - Making a Science of It 4.milk" "../../3rdparty/libprojectm/presets/Unchained - Making a Science of It 4.milk"
  File "/oname=Unchained - Morat's Final Voyage.milk" "../../3rdparty/libprojectm/presets/Unchained - Morat's Final Voyage.milk"
  File "/oname=Unchained - Non-Professional Music Analyzer.milk" "../../3rdparty/libprojectm/presets/Unchained - Non-Professional Music Analyzer.milk"
  File "/oname=Unchained - Painful Plasma (Multi-Wave Mirrored Rage) -- Ro.milk" "../../3rdparty/libprojectm/presets/Unchained - Painful Plasma (Multi-Wave Mirrored Rage) -- Ro.milk"
  File "/oname=Unchained - Perverted Dialect.milk" "../../3rdparty/libprojectm/presets/Unchained - Perverted Dialect.milk"
  File "/oname=Unchained - Picture Of Exile.milk" "../../3rdparty/libprojectm/presets/Unchained - Picture Of Exile.milk"
  File "/oname=Unchained - Picture Of Nectar.milk" "../../3rdparty/libprojectm/presets/Unchained - Picture Of Nectar.milk"
  File "/oname=Unchained - Picture Of Poison.milk" "../../3rdparty/libprojectm/presets/Unchained - Picture Of Poison.milk"
  File "/oname=Unchained - ReAwoke.milk" "../../3rdparty/libprojectm/presets/Unchained - ReAwoke.milk"
  File "/oname=Unchained - Resistance.milk" "../../3rdparty/libprojectm/presets/Unchained - Resistance.milk"
  File "/oname=Unchained - Ribald Ballad.milk" "../../3rdparty/libprojectm/presets/Unchained - Ribald Ballad.milk"
  File "/oname=Unchained & Rovastar - For The Seagull.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - For The Seagull.milk"
  File "/oname=Unchained & Rovastar - Luckless.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Luckless.milk"
  File "/oname=Unchained & Rovastar - Rainbow Obscura.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Rainbow Obscura.milk"
  File "/oname=Unchained & Rovastar - Slow Solstice.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Slow Solstice.milk"
  File "/oname=Unchained & Rovastar - Triptionary.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Triptionary.milk"
  File "/oname=Unchained & Rovastar - Wormhole Pillars (Hall of Shadows mi.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Wormhole Pillars (Hall of Shadows mi.milk"
  File "/oname=Unchained & Rovastar - Wormhole Pillars.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Wormhole Pillars.milk"
  File "/oname=Unchained & Rovastar - Xen Traffic.milk" "../../3rdparty/libprojectm/presets/Unchained & Rovastar - Xen Traffic.milk"
  File "/oname=Unchained - Shaping The Grid.milk" "../../3rdparty/libprojectm/presets/Unchained - Shaping The Grid.milk"
  File "/oname=Unchained - Subjective Experience Of The Manifold.milk" "../../3rdparty/libprojectm/presets/Unchained - Subjective Experience Of The Manifold.milk"
  File "/oname=Unchained - Unclaimed Wreckage 2 (Shamanic).milk" "../../3rdparty/libprojectm/presets/Unchained - Unclaimed Wreckage 2 (Shamanic).milk"
  File "/oname=Unchained - Unclaimed Wreckage.milk" "../../3rdparty/libprojectm/presets/Unchained - Unclaimed Wreckage.milk"
  File "/oname=Unchained - Unified Drag 2.milk" "../../3rdparty/libprojectm/presets/Unchained - Unified Drag 2.milk"
  File "/oname=Unchained - ventilation.milk" "../../3rdparty/libprojectm/presets/Unchained - ventilation.milk"
  File "/oname=Unchained - Working the Grid.milk" "../../3rdparty/libprojectm/presets/Unchained - Working the Grid.milk"
  File "/oname=Zylot & Aderrasi - Oceanic Bassograph (New Jersey Shore Mix.milk" "../../3rdparty/libprojectm/presets/Zylot & Aderrasi - Oceanic Bassograph (New Jersey Shore Mix.milk"
  File "/oname=Zylot and Rovastar - Iouo Stone Morphic Fusion.milk" "../../3rdparty/libprojectm/presets/Zylot and Rovastar - Iouo Stone Morphic Fusion.milk"
  File "/oname=Zylot - Azirphaeli's Mirror.milk" "../../3rdparty/libprojectm/presets/Zylot - Azirphaeli's Mirror.milk"
  File "/oname=Zylot - Block Of Sound (Abstract Architecture Mix).milk" "../../3rdparty/libprojectm/presets/Zylot - Block Of Sound (Abstract Architecture Mix).milk"
  File "/oname=Zylot - Block Of Sound (Fractal Construction Mix).milk" "../../3rdparty/libprojectm/presets/Zylot - Block Of Sound (Fractal Construction Mix).milk"
  File "/oname=Zylot - Color Of Music.milk" "../../3rdparty/libprojectm/presets/Zylot - Color Of Music.milk"
  File "/oname=Zylot - Crystal Ball (Magical Reaction Mix).milk" "../../3rdparty/libprojectm/presets/Zylot - Crystal Ball (Magical Reaction Mix).milk"
  File "/oname=Zylot - De(-a)range(d)(ment) complex.milk" "../../3rdparty/libprojectm/presets/Zylot - De(-a)range(d)(ment) complex.milk"
  File "/oname=Zylot - De(-a)range(d)(ment) strain.milk" "../../3rdparty/libprojectm/presets/Zylot - De(-a)range(d)(ment) strain.milk"
  File "/oname=Zylot - Digiscape Advanced Processor.milk" "../../3rdparty/libprojectm/presets/Zylot - Digiscape Advanced Processor.milk"
  File "/oname=Zylot - Ether Storm.milk" "../../3rdparty/libprojectm/presets/Zylot - Ether Storm.milk"
  File "/oname=Zylot - Global Earthquake.milk" "../../3rdparty/libprojectm/presets/Zylot - Global Earthquake.milk"
  File "/oname=Zylot & Idiot - ATan2 Demo (Spiraling Mad Mix).milk" "../../3rdparty/libprojectm/presets/Zylot & Idiot - ATan2 Demo (Spiraling Mad Mix).milk"
  File "/oname=Zylot - Inside The Planar Portal.milk" "../../3rdparty/libprojectm/presets/Zylot - Inside The Planar Portal.milk"
  File "/oname=Zylot & Krash - Extremophile.milk" "../../3rdparty/libprojectm/presets/Zylot & Krash - Extremophile.milk"
  File "/oname=Zylot - light of the path.milk" "../../3rdparty/libprojectm/presets/Zylot - light of the path.milk"
  File "/oname=Zylot - Mixing Pot.milk" "../../3rdparty/libprojectm/presets/Zylot - Mixing Pot.milk"
  File "/oname=Zylot & Mstress - Celebrate.milk" "../../3rdparty/libprojectm/presets/Zylot & Mstress - Celebrate.milk"
  File "/oname=Zylot & Mstress - Toxic Storm On Acid Sea (The End Of The W.milk" "../../3rdparty/libprojectm/presets/Zylot & Mstress - Toxic Storm On Acid Sea (The End Of The W.milk"
  File "/oname=Zylot - Puddle Of Music.milk" "../../3rdparty/libprojectm/presets/Zylot - Puddle Of Music.milk"
  File "/oname=Zylot - Rainbow Planet Under Attack.milk" "../../3rdparty/libprojectm/presets/Zylot - Rainbow Planet Under Attack.milk"
  File "/oname=Zylot & Rovastar - Crystal Ball (Cerimonial Decor Mix).milk" "../../3rdparty/libprojectm/presets/Zylot & Rovastar - Crystal Ball (Cerimonial Decor Mix).milk"
  File "/oname=Zylot - Rush.milk" "../../3rdparty/libprojectm/presets/Zylot - Rush.milk"
  File "/oname=Zylot - S Pulse Virus.milk" "../../3rdparty/libprojectm/presets/Zylot - S Pulse Virus.milk"
  File "/oname=Zylot - String.milk" "../../3rdparty/libprojectm/presets/Zylot - String.milk"
  File "/oname=Zylot - Tangent Universe (Collapsed With Artifact Mix).milk" "../../3rdparty/libprojectm/presets/Zylot - Tangent Universe (Collapsed With Artifact Mix).milk"
  File "/oname=Zylot - The Deeper.milk" "../../3rdparty/libprojectm/presets/Zylot - The Deeper.milk"
  File "/oname=Zylot - The Inner Workings of my New Computer.milk" "../../3rdparty/libprojectm/presets/Zylot - The Inner Workings of my New Computer.milk"
  File "/oname=Zylot - Visionarie (geiss aspect ratio fix).milk" "../../3rdparty/libprojectm/presets/Zylot - Visionarie (geiss aspect ratio fix).milk"
  File "/oname=Zylot - Waves Of Blood.milk" "../../3rdparty/libprojectm/presets/Zylot - Waves Of Blood.milk"
  File "/oname=Zylot - Wisps.milk" "../../3rdparty/libprojectm/presets/Zylot - Wisps.milk"
SectionEnd

Section "Start menu items" startmenu
  ; Create Start Menu folders and shortcuts.
  SetShellVarContext all

  CreateDirectory "$SMPROGRAMS\${PRODUCT_NAME}"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk" "$INSTDIR\clementine.exe"
  CreateShortCut "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk" "$INSTDIR\Uninstall.exe"
SectionEnd

Section "Uninstaller"
  ; Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "${PRODUCT_NAME}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\Uninstall.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\clementine.ico"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_DISPLAY_VERSION}"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionMajor" "${PRODUCT_VERSION_MAJOR}"
  WriteRegDWORD ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "VersionMinor" "${PRODUCT_VERSION_MINOR}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Section "Uninstall"
  ; Kill clementine.exe if it's running
  ; This calling convention is retarded...
  StrCpy $0 "clementine.exe"
  KillProc::FindProcesses
  StrCmp $1 "-1" wooops

  StrCmp $0 "0" completed
  
  DetailPrint "Killing running clementine.exe..."

  StrCpy $0 "clementine.exe"
  KillProc::KillProcesses
  StrCmp $1 "-1" wooops

  Sleep 2000
  Goto completed

  wooops:
  DetailPrint "-> Error: Something went wrong while killing running clementine.exe"
  Abort

  completed:
  
  ; Delete all the files
  Delete "$INSTDIR\avcodec-53.dll"
  Delete "$INSTDIR\avformat-53.dll"
  Delete "$INSTDIR\avutil-51.dll"
  Delete "$INSTDIR\clementine.ico"
  Delete "$INSTDIR\clementine.exe"
  Delete "$INSTDIR\clementine-tagreader.exe"
  Delete "$INSTDIR\clementine-spotifyblob.exe"
  Delete "$INSTDIR\glew32.dll"
  Delete "$INSTDIR\intl.dll"
  Delete "$INSTDIR\libcdio-14.dll"
  Delete "$INSTDIR\libeay32.dll"
  Delete "$INSTDIR\libexpat-1.dll"
  Delete "$INSTDIR\libfaac.dll"
  Delete "$INSTDIR\libfaad.dll"
  Delete "$INSTDIR\libfftw3-3.dll"
  Delete "$INSTDIR\libFLAC.dll"
  Delete "$INSTDIR\libgcc_s_sjlj-1.dll"
  Delete "$INSTDIR\libgcrypt-11.dll"
  Delete "$INSTDIR\libgdk_pixbuf-2.0-0.dll"
  Delete "$INSTDIR\libgio-2.0-0.dll"
  Delete "$INSTDIR\libglib-2.0-0.dll"
  Delete "$INSTDIR\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\libgnutls-26.dll"
  Delete "$INSTDIR\libgobject-2.0-0.dll"
  Delete "$INSTDIR\libgpg-error-0.dll"
  Delete "$INSTDIR\libgstapp-0.10-0.dll"
  Delete "$INSTDIR\libgstaudio-0.10-0.dll"
  Delete "$INSTDIR\libgstbase-0.10-0.dll"
  Delete "$INSTDIR\libgstcdda-0.10-0.dll"
  Delete "$INSTDIR\libgstcontroller-0.10-0.dll"
  Delete "$INSTDIR\libgstdataprotocol-0.10-0.dll"
  Delete "$INSTDIR\libgstfft-0.10-0.dll"
  Delete "$INSTDIR\libgstinterfaces-0.10-0.dll"
  Delete "$INSTDIR\libgstnet-0.10-0.dll"
  Delete "$INSTDIR\libgstnetbuffer-0.10-0.dll"
  Delete "$INSTDIR\libgstpbutils-0.10-0.dll"
  Delete "$INSTDIR\libgstreamer-0.10-0.dll"
  Delete "$INSTDIR\libgstriff-0.10-0.dll"
  Delete "$INSTDIR\libgstrtp-0.10-0.dll"
  Delete "$INSTDIR\libgstrtsp-0.10-0.dll"
  Delete "$INSTDIR\libgstsdp-0.10-0.dll"
  Delete "$INSTDIR\libgsttag-0.10-0.dll"
  Delete "$INSTDIR\libgthread-2.0-0.dll"
  Delete "$INSTDIR\libid3tag.dll"
  Delete "$INSTDIR\libimobiledevice-1.dll"
  Delete "$INSTDIR\liblastfm.dll"
  Delete "$INSTDIR\libmad.dll"
  Delete "$INSTDIR\libmms-0.dll"
  Delete "$INSTDIR\libmp3lame-0.dll"
  Delete "$INSTDIR\libogg-0.dll"
  Delete "$INSTDIR\liboil-0.3-0.dll"
  Delete "$INSTDIR\liborc-0.4-0.dll"
  Delete "$INSTDIR\liborc-test-0.4-0.dll"
  Delete "$INSTDIR\libplist.dll"
  Delete "$INSTDIR\libpng14-14.dll"
  Delete "$INSTDIR\libprotobuf-7.dll"
  Delete "$INSTDIR\libqjson.dll"
  Delete "$INSTDIR\libsoup-2.4-1.dll"
  Delete "$INSTDIR\libspeex-1.dll"
  Delete "$INSTDIR\libspotify.dll"
  Delete "$INSTDIR\libstdc++-6.dll"
  Delete "$INSTDIR\libtag.dll"
  Delete "$INSTDIR\libtasn1-3.dll"
  Delete "$INSTDIR\libusbmuxd.dll"
  Delete "$INSTDIR\libvorbis-0.dll"
  Delete "$INSTDIR\libvorbisenc-2.dll"
  Delete "$INSTDIR\libxml2-2.dll"
  Delete "$INSTDIR\mingwm10.dll"
  Delete "$INSTDIR\pthreadGC2.dll"
  Delete "$INSTDIR\QtCore4.dll"
  Delete "$INSTDIR\QtGui4.dll"
  Delete "$INSTDIR\QtNetwork4.dll"
  Delete "$INSTDIR\QtOpenGL4.dll"
  Delete "$INSTDIR\QtSql4.dll"
  Delete "$INSTDIR\QtSvg4.dll"
  Delete "$INSTDIR\QtXml4.dll"
  Delete "$INSTDIR\ssleay32.dll"
  Delete "$INSTDIR\zlib1.dll"

  Delete "$INSTDIR\imageformats\qgif4.dll"
  Delete "$INSTDIR\imageformats\qjpeg4.dll"

  Delete "$INSTDIR\gstreamer-plugins\libgstapetag.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstapp.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstasf.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstaudioconvert.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstaudiofx.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstaudioresample.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstaudiotestsrc.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstautodetect.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstcdio.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstcoreelements.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstdecodebin2.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstdirectsoundsink.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstequalizer.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstfaac.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstfaad.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstffmpeg.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstflac.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstgdp.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstgio.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgsticydemux.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstid3demux.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstlame.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstmad.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstmms.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstmpegaudioparse.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstogg.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstqtdemux.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstreplaygain.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstspectrum.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstspeex.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstsouphttpsrc.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgsttaglib.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgsttcp.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgsttypefindfunctions.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstudp.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstvolume.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstvorbis.dll"
  Delete "$INSTDIR\gstreamer-plugins\libgstwavparse.dll"

  Delete "$INSTDIR\projectm-presets\Aderrasi - Agitator.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Aimless (Gravity Directive Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Aimless (Spirogravity Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Airhandler (Menagerie Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Airs (Windy Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Anchorpulse (Pulse Of A Ghast II Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Anchorpulse (Verified Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Anomalous Material Science (Pure Splinter Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Antidote (Aqualung Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Antidote.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Antidote (Side Effects Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Antique Abyss.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Arise! (Padded Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Ashes Of Air (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Bitterfeld (Crystal Border Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Blender.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Bow To Gravity.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Brakefreak.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Candy Avian.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Causeway Of Dreams.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Causeway Of Dreams (Nightmare Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Causeway Of Dreams (REMix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Chromatic Abyss (The Other Side).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Circlefacade.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Contortion.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Contortion (Xenomorph Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Crystal Storm.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Dark Matter (Converse Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Elastoid.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Floater Society.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Flowing Form.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Making Time (Swamp Mix).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Potion of Spirits.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Songflower (Moss Posy).milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - Spillswirl.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - What cannot be.milk"
  Delete "$INSTDIR\projectm-presets\Aderrasi - What Cannot Be Undone.milk"
  Delete "$INSTDIR\projectm-presets\baked - mushroom rainbows[2].milk"
  Delete "$INSTDIR\projectm-presets\Bmelgren - Godhead.milk"
  Delete "$INSTDIR\projectm-presets\Bmelgren & Krash - Rainbow Orb Peacock (Centred Journey Mix.milk"
  Delete "$INSTDIR\projectm-presets\Bmelgren & Krash - Rainbow Orb Peacock (Lonely Signal Gone .milk"
  Delete "$INSTDIR\projectm-presets\Bmelgren - Pentultimate Nerual Slipstream (Tweak 2).milk"
  Delete "$INSTDIR\projectm-presets\Bmelgren - Take This Highway.milk"
  Delete "$INSTDIR\projectm-presets\che - adela the flower.milk"
  Delete "$INSTDIR\projectm-presets\Che - Burning Hus.milk"
  Delete "$INSTDIR\projectm-presets\che - burning hus (oil mix).milk"
  Delete "$INSTDIR\projectm-presets\Che - Escape.milk"
  Delete "$INSTDIR\projectm-presets\che - terracarbon stream.milk"
  Delete "$INSTDIR\projectm-presets\Che - Watch & Fly.milk"
  Delete "$INSTDIR\projectm-presets\CrystalHigh - mad ravetriping.milk"
  Delete "$INSTDIR\projectm-presets\DaNOnE - Highway to Heaven (rotating).milk"
  Delete "$INSTDIR\projectm-presets\EMPR - Random - Changing Polyevolution.milk"
  Delete "$INSTDIR\projectm-presets\EMPR - Random - Look mama I'm on TV! 2.milk"
  Delete "$INSTDIR\projectm-presets\EMPR - Random - They're so cute Dad can I keep one!.milk"
  Delete "$INSTDIR\projectm-presets\EMPR - Random - Turbulence Sandwich.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - glowsticks v2 03 music.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - glowsticks v2 04 music minimal.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - glowsticks v2 05 and proton lights (+Krash's beat code) _Phat_remix02b.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - glowsticks v2 05 and proton lights (+Krash's beat code) _Phat_remix07 recursive demons.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - heater core C_Phat's_class + sparks_mix.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - heater core C_Phat's_on route_mix+beam.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S.+Phat - Arm_upgrades - transformer.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. + Phat - chasers 18 hallway.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S.+Phat Cool Bug v2 + (Krash's beat detection).milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - repeater 05 - rave on acid.milk"
  Delete "$INSTDIR\projectm-presets\Eo.S. - repeater 15 - kaleidoscope b.milk"
  Delete "$INSTDIR\projectm-presets\EvilJim - Follow the ball.milk"
  Delete "$INSTDIR\projectm-presets\EvilJim - Ice Drops.milk"
  Delete "$INSTDIR\projectm-presets\fiShbRaiN - blueprint.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - 0 To 60.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - A Blur.milk"
  Delete "$INSTDIR\projectm-presets\Fvese & Idiot24-7 - Rearview Mirror.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - Lifesavor Anyone.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - New meetings.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - Quicksand.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - Round and Round (geiss gamma mix).milk"
  Delete "$INSTDIR\projectm-presets\Fvese - simple.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - Stand Still!.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - The Tunnel (Final Stage Mix).milk"
  Delete "$INSTDIR\projectm-presets\Fvese - Window Reflection 6.milk"
  Delete "$INSTDIR\projectm-presets\Fvese - Zoom Effects (Remix 2).milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Aieeeeee!!!.milk"
  Delete "$INSTDIR\projectm-presets\Geiss and Rovastar - The Chaos Of Colours (sprouting diment.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Anomaly 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Anomaly 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Approach.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Asymptote.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bass Kaleidosphere.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bass Zoom.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bipolar 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bipolar 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bipolar 3.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bipolar 4.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bipolar 5.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Blasto.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bonfire.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bright Fiber Matrix 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Bright Fiber Matrix 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Calligraphy.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Casino.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Cepiasound.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Churn.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Constant Velocity.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Coral.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Corpus Callosum.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Cosmic Dust 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Cosmic Dust 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Cruzin'.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Cycloid 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Cycloid 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Davod The Pod.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - De La Moutard 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - De La Moutard 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Demonic Distortion.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Descent.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Destruction.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Diffraction.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Digital Smoke.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Downward Spiral.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Drift.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Dynamic Swirls 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Dynamic Swirls 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Eddies 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Eddies 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Eggs.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - El Cubismo.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Feedback 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Feedback.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Festive.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Fiberglass.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Flotsam.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Flower Blossom.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Flower.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Four Kinds of Amphetamines.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Galaxy 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Galaxy 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Greenland.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Heavenly 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Heavenly 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Heavenly 3.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - High Dynamic Range.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Hovering.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Hyperion.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Inkblot.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Iris.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Journey.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Julia Fractal 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Julia Fractal 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Luz.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Mega Swirl 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Mega Swirl 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Mega Swirl 3.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Microcosm.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Monotone Ripples.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Music Box.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Nautilus.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Octopus Blue.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Octopus Ever Changing.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Octopus Fat and Ever Changing.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Octopus Gold.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Octopus Gold with Dots.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Octopus.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Oldskool Mellowstyle.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Pelota De Fuego.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Pinch.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Pistons.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Planet 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Planet 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Quasilinear Submanifolds.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Reducto Absurdum.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Reducto Ad Nauseum.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Rocket.milk"
  Delete "$INSTDIR\projectm-presets\Geiss & Rovastar - Julia Fractal (Vectrip Mix).milk"
  Delete "$INSTDIR\projectm-presets\Geiss & Rovastar - Notions Of Tonality 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss & Rovastar - The Chaos Of Colours (sprouting dimentia mix).milk"
  Delete "$INSTDIR\projectm-presets\Geiss & Rovastar - Tokamak (Naked Intrusion Mix).milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Runoff.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Scary.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Script.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Serpent.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Shake.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Shift.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Sinews 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Sinews 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Smoke.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Solar Flare (Blue).milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Solar Flare.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Solar Flare (Reptile).milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Sound And The Fury.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Spacedust.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Space Voyage Bright.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Space Voyage (High-Warp).milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Space Voyage.milk"
  Delete "$INSTDIR\projectm-presets\Geiss & Sperl - Feedback (projectM idle HDR mix).prjm"
  Delete "$INSTDIR\projectm-presets\Geiss - Starfish 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Starfish 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Sunsets.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Supernova 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Supernova 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Surface.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirl 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirl 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirlie 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirlie 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirlie 3.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirlie 4.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Swirlie 5.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Symmetry.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - The Fatty Lumpkin Sunkle Tweaker.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Three And A Half Kinds Of Amphetamines.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Three Kinds Of Amphetamines.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Tokamak.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Tornado.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Toy.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Trampoline.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Tube.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Two-Pointed Pulsagon.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Ultrafast.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Volume Zoom.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Vortex 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Vortex 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Warp Of Dali 1.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Warp Of Dali 2.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Warp Of Dali Bright.milk"
  Delete "$INSTDIR\projectm-presets\Geiss - Waterfall.milk"
  Delete "$INSTDIR\projectm-presets\headphones.tga"
  Delete "$INSTDIR\projectm-presets\Idiot24-7 - Ascending to heaven 2.milk"
  Delete "$INSTDIR\projectm-presets\Idiot24-7 - Meeting place.milk"
  Delete "$INSTDIR\projectm-presets\Idiot - 9-7-02 (Remix) (sustain fixed).milk"
  Delete "$INSTDIR\projectm-presets\Idiot & Che - Various Abstract Effects.milk"
  Delete "$INSTDIR\projectm-presets\Idiot - Cortex (Spiritual Visions Mix).milk"
  Delete "$INSTDIR\projectm-presets\Idiot - Madness Within The Void (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Idiot - MOTIVATION!.milk"
  Delete "$INSTDIR\projectm-presets\idiot - Nothing Yet - 03 - The worst of the pack.milk"
  Delete "$INSTDIR\projectm-presets\idiot - Nucleus.milk"
  Delete "$INSTDIR\projectm-presets\Idiot & Rovastar - Altars Of Madness 2 (X.42 Mix).milk"
  Delete "$INSTDIR\projectm-presets\idiot - Sinful Code (unchained style).milk"
  Delete "$INSTDIR\projectm-presets\idiot - Some big word I learned.milk"
  Delete "$INSTDIR\projectm-presets\idiot - Spectrum.milk"
  Delete "$INSTDIR\projectm-presets\Idiot - Tentacle Dreams (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Idiot - Texture Boxes (Remix 2).milk"
  Delete "$INSTDIR\projectm-presets\Idiot - Texture Boxes (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Idiot - Typomatic (Remix 2).milk"
  Delete "$INSTDIR\projectm-presets\Idiot - What Is.milk"
  Delete "$INSTDIR\projectm-presets\Idiot - What Shall Come.milk"
  Delete "$INSTDIR\projectm-presets\Idiot & Zylot - Unhealthy Love (Idiot's STDs Mix).milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Che - Return Of The King.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Che - The Piper.milk"
  Delete "$INSTDIR\projectm-presets\Illusion - Figure Eight.milk"
  Delete "$INSTDIR\projectm-presets\Illusion - Heavenly Eye.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Rovastar - Clouded Bottle.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Rovastar - Snowflake Delight.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Rovastar - Snowflake Return.milk"
  Delete "$INSTDIR\projectm-presets\illusion & studio music - charged bliss.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Unchained - Frozen Eye 1.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Unchained - Invade My Mind.milk"
  Delete "$INSTDIR\projectm-presets\Illusion & Unchained - Re-Enter Homeworld.milk"
  Delete "$INSTDIR\projectm-presets\[Ishan] - Life in the drains.milk"
  Delete "$INSTDIR\projectm-presets\Jess - Trying To Trap A Twister.milk"
  Delete "$INSTDIR\projectm-presets\Krash - 3D Shapes Demo 2.milk"
  Delete "$INSTDIR\projectm-presets\Krash - 3D Shapes Demo.milk"
  Delete "$INSTDIR\projectm-presets\Krash and Fvese - Molten Indecision (Fvese Remix).milk"
  Delete "$INSTDIR\projectm-presets\Krash and Rovastar - Rainbow Orb.milk"
  Delete "$INSTDIR\projectm-presets\Krash - Digital Flame.milk"
  Delete "$INSTDIR\projectm-presets\Krash - Dynamic Borders 1.milk"
  Delete "$INSTDIR\projectm-presets\Krash - Framed Geometry.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Idiot - Memories Of The Castle.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Illusion - Indecisive Mosaic.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Illusion - Spiral Movement.milk"
  Delete "$INSTDIR\projectm-presets\Krash - Pulse.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Rovastar - Altars Of Madness (Mad Ocean Mix).milk"
  Delete "$INSTDIR\projectm-presets\Krash & Rovastar - A Million Miles from Earth (Ripple Mix).milk"
  Delete "$INSTDIR\projectm-presets\Krash & Rovastar - Cerebral Demons (Distant Memory Mix).milk"
  Delete "$INSTDIR\projectm-presets\Krash & Rovastar - Cerebral Demons - Phat + Eo.S. hall of ghouls Remix.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Rovastar - Switching Polygons.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Rovastar - The Devil Is In The Details.milk"
  Delete "$INSTDIR\projectm-presets\Krash - Season's Greetings 2.milk"
  Delete "$INSTDIR\projectm-presets\Krash & TEcHNO - Rhythmic Mantas.milk"
  Delete "$INSTDIR\projectm-presets\Krash - Twisting Indecision.milk"
  Delete "$INSTDIR\projectm-presets\Krash - War Machine (Shifting Complexity Mix).milk"
  Delete "$INSTDIR\projectm-presets\Krash - Windowframe To Mega Swirl 2.milk"
  Delete "$INSTDIR\projectm-presets\Krash & Zylot - Inside The Planar Portal (Indecision Mix).milk"
  Delete "$INSTDIR\projectm-presets\Mstress - Acoustic Nerve Impulses (Under Drug Effetcs (Hypn.milk"
  Delete "$INSTDIR\projectm-presets\Mstress & Juppy - Dancer.milk"
  Delete "$INSTDIR\projectm-presets\Mstress & Juppy - Dancers In The Dark.milk"
  Delete "$INSTDIR\projectm-presets\Mstress - Snowing Fiber City.milk"
  Delete "$INSTDIR\projectm-presets\M.tga"
  Delete "$INSTDIR\projectm-presets\nil - Can't Stop the Blithering.milk"
  Delete "$INSTDIR\projectm-presets\nil - Can't Stop the Cramming.milk"
  Delete "$INSTDIR\projectm-presets\nil - Cid and Lucy.milk"
  Delete "$INSTDIR\projectm-presets\nil - Disco Comet.milk"
  Delete "$INSTDIR\projectm-presets\nil - Singularity in My Oscilloscope.milk"
  Delete "$INSTDIR\projectm-presets\nil - Vortex of Vortices.milk"
  Delete "$INSTDIR\projectm-presets\Phat+fiShbRaiN+Eo.S_Mandala_Chasers_remix.milk"
  Delete "$INSTDIR\projectm-presets\Phat+fiShbRaiN+Eo.S_Mandala_Chasers_remix - www.eos4life.com.milk"
  Delete "$INSTDIR\projectm-presets\PieturP - triptrap_(getting_concrete_visions_through_a_diafragma_version).milk"
  Delete "$INSTDIR\projectm-presets\PieturP - triptrap_(ultimate-trip-mix).milk"
  Delete "$INSTDIR\projectm-presets\project.tga"
  Delete "$INSTDIR\projectm-presets\Redi Jedi - acid in your brain.milk"
  Delete "$INSTDIR\projectm-presets\Redi Jedi - multiple points of origin, one destination.milk"
  Delete "$INSTDIR\projectm-presets\Reenen - phoenix.milk"
  Delete "$INSTDIR\projectm-presets\Rocke - Cold Love (Tei Zwaa).milk"
  Delete "$INSTDIR\projectm-presets\Rocke - Personal Comet.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Aderrasi - Oceanic Bassograph (Underwater Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Harlequin's Maddess.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Harlequin's Madness (Dark Disorder Mix.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness 2 (Frozen Time Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness 4 (Spirit Of Twisted Madness M.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness (A Million Miles From Earth Mi.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness (Boxfresh Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness (Duel Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Altars Of Madness (Surealist Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - A Million Miles from Earth.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - A Million Miles from Earth (Pathfinder Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - A Million Miles From Earth (Wormhole Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar and Krash - Hallucinogenic Pyramids (Extra Beat Ti.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar and Unchained - Braindance Visions.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar and Unchained - Life After Pie (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Attacking Freedom.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Bellanova (New Wave Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Biohazard Warning.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Chapel Of Ghouls.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Che - Adela The Flower (Altars Of Madness Mix 2).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Che - Asylum Animations.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Chemical Spirituality.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Clouded Judgement 3.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Cosmic Echoes 1.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Cosmic Echoes 2.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Cosmic Havoc.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Cosmic Mosaic (Active Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Dark Ritual (Star Of Destiny Denied Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Dark Ritual (Star Of Destiny Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Decreasing Dreams (Extended Movement Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Dreamcatcher.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Explosive Minds.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Forgotten Moon.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Fractopia (Fantic Dancing Lights Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Fractopia (Galaxy Swirl Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Fractopia (Upspoken Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Fractopia (Upspoken Mix)_Phat_Speak_When_Spoken_2.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Frozen Rapture .milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Future Speakers.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Fvese - Dark Subconscious.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Fvese - Deadly Flower.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Fvese - Mosaic Waves.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Fvese - Paranormal Static.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Fvese - Stranger Minds (Astral Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Fvese - Stranger Minds.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Approach (Vectrip Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Bipolar 2 (Vectrip Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Dynamic Swirls 3 (Broken Destiny Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Dynamic Swirls 3 (Mysticial Awakening Mi.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Dynamic Swirls 3 (Poltergiest Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Dynamic Swirls 3 (Smoke Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Dynamic Swirls 3 (Smoking Delusion Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Dynamic Swirls 3 (Voyage Of Twisted Soul.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Ice Planet.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Octoplasm.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Octotrip.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Geiss - Octotrip (MultiTrip Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Halcyon Dreams 3.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Hallucinogenic Pyramids (Beat Time Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Delight (Endless Tunnel Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Dynamic Fractal 1.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Dynamic Fractal 2.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Dynamic Fractal 3.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Dynamic Fractal (Crazed Spiral Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Dynamic Fractal (Dual Spiral Mix ).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Fractal Encounter 2.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Fractal Encounter.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Spirit.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Harlequin's Spirit (Twisted Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Hyperspace (Frozen Rapture Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Hyperspace (Hyper Speed Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Hyperspace.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Idiot24-7 - Balk Acid.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Idiot24-7 - Mixed Emotions (Harlequin's Shame Mi.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Idiot24-7 - Mixed Emotions (Harlequin's Shame Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Illusion - Shifting Sphere.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Inner Thoughts (Clouded Judgement Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Inner Thoughts (Dark Secret Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Inner Thoughts (Distant Memories Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Inner Thoughts (Frantic Thoughts Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Inner Thoughts (Strange Cargo Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Kalideostars (Altars Of Madness MIx).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Kalideostars.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Kalideostars (Round  Round Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Krash - Cerebral Demons.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Krash - Flowing Synergy.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Krash - Interwoven (Contra Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - LabFunk.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Lost Souls of the Bermuda Triangle (Darkest Soul.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Magic Carpet.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Mosaics Of Ages.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Multiverse Starfield 1.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Multiverse Starfield 3.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Omnipresence Resurrection.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Omnipresence Resurrection (Raw Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Oozing Resistance.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Pandora's Volcano.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Parallel Universe.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Rocke - Answer.42 (Trippy S. Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Rocke - Headspin.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Rocke - Sugar Spun Sister.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Sea Shells.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Snapshot Of Space.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Solarized Space.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Solarized Space (Space DNA Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Space.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Space (Twisted Dimension Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Sperl - Tuxflower.prjm"
  Delete "$INSTDIR\projectm-presets\Rovastar - Starquake (Sunquake Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & StudioMusic - More Cherished Desires.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & StudioMusic - Twisted Spider Web.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Telek - Altars of Madness (Rolling Oceans Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Telek - Cosmic Fireworks.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - The Awakening.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - The Chaos Of Colours (Drifting Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - The Chaos Of Colours.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - The Shroomery.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Timeless Voyage.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Touchdown on Mars (Detailed Pictures Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - Tripmaker.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - twisted bytes.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Unchained - Ambrosia Mystic (Dark Heart Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Unchained - Centre Of Gravity.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Unchained - Demonology (Vampire Soul Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Unchained - Oddball World.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Unchained - Voodoo Chess Magnet (Everglow Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Unchained - Xen Traffic.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - VooV's Movement (After Dark Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar - VooV's Movement.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Zylot - Azirphaeli's Plan (Multiplan Mix).milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Zylot - Narell's Fever.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Zylot - Passion Flower.milk"
  Delete "$INSTDIR\projectm-presets\Rovastar & Zylot - Sea Of Zigrot.milk"
  Delete "$INSTDIR\projectm-presets\Rozzer & Zylot - Force Field Generator (Slowtime Tweak).milk"
  Delete "$INSTDIR\projectm-presets\Rozzor & Aderrasi - Canon.milk"
  Delete "$INSTDIR\projectm-presets\Rozzor and che - Inside the House of nil.milk"
  Delete "$INSTDIR\projectm-presets\Rozzor and Idiot - Any Other Deep Rising.milk"
  Delete "$INSTDIR\projectm-presets\Rozzor and Rovastar - Altars Of Madness 3 (ooze tweak).milk"
  Delete "$INSTDIR\projectm-presets\Rozzor and Rovastar - Altars Of Madness 3 (ooze tweak with .milk"
  Delete "$INSTDIR\projectm-presets\Rozzor and StudioMusic - Vertigyny (Geiss shape mod).milk"
  Delete "$INSTDIR\projectm-presets\Rozzor and Zylot - Associative Order.milk"
  Delete "$INSTDIR\projectm-presets\Rozzor & Che - Inside The House Of Nil.milk"
  Delete "$INSTDIR\projectm-presets\Rozzor - Learning Curve (Invert tweak).milk"
  Delete "$INSTDIR\projectm-presets\Rozzor & Rovastar - Oozing Resistance (Waveform Mod).milk"
  Delete "$INSTDIR\projectm-presets\shifter - escape the worm - Eo.S. + Phat 5362.milk"
  Delete "$INSTDIR\projectm-presets\shifter - escape the worm - Eo.S. + Phat - Before_It_Eats_Your_Brain_Mix_v2.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic Aderrasi & nil - LA movement (Intellectual Sens.milk"
  Delete "$INSTDIR\projectm-presets\Studio Music and Unchained - Rapid Alteration.milk"
  Delete "$INSTDIR\projectm-presets\Studio Music - Cherished Desires.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic - Harmonic Bliss (elated mix).milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic - It's Only Make Believe.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic - Numerosity.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic - Twisted Galaxy.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic & Unchained - Entity.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic & Unchained - Minor Alteration.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic & Unchained - So Much Love.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic & Unchained - State Of Discretion.milk"
  Delete "$INSTDIR\projectm-presets\StudioMusic & Unchained - Wrenched Fate.milk"
  Delete "$INSTDIR\projectm-presets\TEcHNO and SandStorm - Psychodelic Highway.milk"
  Delete "$INSTDIR\projectm-presets\Telek - City Helix Lattice.milk"
  Delete "$INSTDIR\projectm-presets\Telek - Directive Swagger (Spectral Inferno) (fix...) maybe.milk"
  Delete "$INSTDIR\projectm-presets\Telek EMPR - Scanner - Trust me I've got a Melways.milk"
  Delete "$INSTDIR\projectm-presets\Telek - Flicker.milk"
  Delete "$INSTDIR\projectm-presets\Telek - Flicker (xis).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Lost Star (Flash).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Recirculate (Cool).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Sine Wave.milk"
  Delete "$INSTDIR\projectm-presets\Telek - Slow Shift Matrix (bb4.5).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Slow Shift Matrix (Ethereal Drift).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Slow Shift Matrix.milk"
  Delete "$INSTDIR\projectm-presets\Telek - Slow Thing (Spiderman Mix).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Spiral Tabletop (New and Improved!).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Spokes (More Dynamic).milk"
  Delete "$INSTDIR\projectm-presets\Telek - Target Practice (tracking retreat slide).milk"
  Delete "$INSTDIR\projectm-presets\TobiasWolfBoi - Cataract.milk"
  Delete "$INSTDIR\projectm-presets\TobiasWolfBoi - The Pit.milk"
  Delete "$INSTDIR\projectm-presets\Tschoey - Music Flower.milk"
  Delete "$INSTDIR\projectm-presets\Tux.tga"
  Delete "$INSTDIR\projectm-presets\Unchained - All You Can Eat.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - A Matter Of Taste (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Bad Karma Oddnezz Style.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo 1.0.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo 10.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo 2.0.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo 2.1.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo 2.2.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo 2.3.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Beat Demo (Demonology Mix).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Cartoon Factory.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Che - Oddnezz 3.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Che - Oddnezz 4 (Done it again).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Cranked On Failure.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & CTho - Bad Vibes.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Custom Gramatix (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Deeper Logic.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Free to Feel (Valium Remix).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - French Clothing.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Games With Light & Sound.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Ghostlight Whisper.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - God Of The Game (Remix).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Goofy Beat Detection.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Goo Kung Fu.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Housed In A Childish Mind.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Illusion - Dual Wave 3.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Illusion - Logic Morph.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Illusion - Spirit Morph.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - In Memory Of Peg.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Invariant Under Rigorous Motions.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Jaded Emotion.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Jaundice.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Making a Science of It 4.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Morat's Final Voyage.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Non-Professional Music Analyzer.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Painful Plasma (Multi-Wave Mirrored Rage) -- Ro.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Perverted Dialect.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Picture Of Exile.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Picture Of Nectar.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Picture Of Poison.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - ReAwoke.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Resistance.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Ribald Ballad.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - For The Seagull.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Luckless.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Rainbow Obscura.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Slow Solstice.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Triptionary.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Wormhole Pillars (Hall of Shadows mi.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Wormhole Pillars.milk"
  Delete "$INSTDIR\projectm-presets\Unchained & Rovastar - Xen Traffic.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Shaping The Grid.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Subjective Experience Of The Manifold.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Unclaimed Wreckage 2 (Shamanic).milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Unclaimed Wreckage.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Unified Drag 2.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - ventilation.milk"
  Delete "$INSTDIR\projectm-presets\Unchained - Working the Grid.milk"
  Delete "$INSTDIR\projectm-presets\Zylot & Aderrasi - Oceanic Bassograph (New Jersey Shore Mix.milk"
  Delete "$INSTDIR\projectm-presets\Zylot and Rovastar - Iouo Stone Morphic Fusion.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Azirphaeli's Mirror.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Block Of Sound (Abstract Architecture Mix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Block Of Sound (Fractal Construction Mix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Color Of Music.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Crystal Ball (Magical Reaction Mix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - De(-a)range(d)(ment) complex.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - De(-a)range(d)(ment) strain.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Digiscape Advanced Processor.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Ether Storm.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Global Earthquake.milk"
  Delete "$INSTDIR\projectm-presets\Zylot & Idiot - ATan2 Demo (Spiraling Mad Mix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Inside The Planar Portal.milk"
  Delete "$INSTDIR\projectm-presets\Zylot & Krash - Extremophile.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - light of the path.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Mixing Pot.milk"
  Delete "$INSTDIR\projectm-presets\Zylot & Mstress - Celebrate.milk"
  Delete "$INSTDIR\projectm-presets\Zylot & Mstress - Toxic Storm On Acid Sea (The End Of The W.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Puddle Of Music.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Rainbow Planet Under Attack.milk"
  Delete "$INSTDIR\projectm-presets\Zylot & Rovastar - Crystal Ball (Cerimonial Decor Mix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Rush.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - S Pulse Virus.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - String.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Tangent Universe (Collapsed With Artifact Mix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - The Deeper.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - The Inner Workings of my New Computer.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Visionarie (geiss aspect ratio fix).milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Waves Of Blood.milk"
  Delete "$INSTDIR\projectm-presets\Zylot - Wisps.milk"

  Delete "$INSTDIR\gio-modules\libgiognutls.dll"

  Delete "$INSTDIR\Uninstall.exe"
  
  ; Remove the installation folders.
  RMDir "$INSTDIR\gstreamer-plugins"
  RMDir "$INSTDIR\projectm-presets"
  RMDir "$INSTDIR\imageformats"
  RMDir "$INSTDIR\gio-modules"
  RMDir "$INSTDIR"

  ; Remove the Shortcuts
  SetShellVarContext all

  Delete "$SMPROGRAMS\${PRODUCT_NAME}\${PRODUCT_NAME}.lnk"
  Delete "$SMPROGRAMS\${PRODUCT_NAME}\Uninstall.lnk"
  RMDir /r "$SMPROGRAMS\${PRODUCT_NAME}"
  
  ; Remove the entry from 'installed programs list'
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"

  ; Check the OS.  If Vista or newer, use Default Programs
  nsisos::osversion
  StrCpy $R0 $0
  IntCmp $R0 6 HasDefaultPrograms NoDefaultPrograms HasDefaultPrograms

  HasDefaultPrograms:
    ; Unregister from Default Programs
    ${UnRegisterCapabilities}
    Goto done
  NoDefaultPrograms:
    ; Remove file associations
    ${unregisterExtension} ".mp3" "MP3 Audio File"
    ${unregisterExtension} ".flac" "FLAC Audio File"
    ${unregisterExtension} ".ogg" "OGG Audio File"
    ${unregisterExtension} ".spx" "OGG Speex Audio File"
    ${unregisterExtension} ".mp4" "MP4 Audio File"
    ${unregisterExtension} ".aac" "AAC Audio File"
    ${unregisterExtension} ".wma" "WMA Audio File"
    ${unregisterExtension} ".wav" "WAV Audio File"

    ${unregisterExtension} ".pls" "PLS Audio File"
    ${unregisterExtension} ".m3u" "M3U Audio File"
    ${unregisterExtension} ".xspf" "XSPF Audio File"
    ${unregisterExtension} ".asx" "Windows Media Audio/Video playlist"
  done:
SectionEnd
