{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetIsPickable: Boolean;
    procedure SetIsPickable(const Value: Boolean);
    function GetViewport: TAbstractViewportNode;
    procedure SetViewport(const Value: TAbstractViewportNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdIsPickable: TSFBool;
    { Internal wrapper for property @code(IsPickable). This wrapper API may change, we advise to access simpler @code(IsPickable) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdIsPickable: TSFBool read FFdIsPickable;
    {  }
    property IsPickable: Boolean read GetIsPickable write SetIsPickable;

    strict private FFdViewport: TSFNode;
    { Internal wrapper for property @code(Viewport). This wrapper API may change, we advise to access simpler @code(Viewport) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdViewport: TSFNode read FFdViewport;
    {  }
    property Viewport: TAbstractViewportNode read GetViewport write SetViewport;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractLayerNode ----------------------------------------------- }

function TAbstractLayerNode.GetIsPickable: Boolean;
begin
  Result := FdIsPickable.Value;
end;

procedure TAbstractLayerNode.SetIsPickable(const Value: Boolean);
begin
  FdIsPickable.Send(Value);
end;

function TAbstractLayerNode.GetViewport: TAbstractViewportNode;
begin
  if FdViewport.Value is TAbstractViewportNode then
    Result := TAbstractViewportNode(FdViewport.Value)
  else
    Result := nil;
end;

procedure TAbstractLayerNode.SetViewport(const Value: TAbstractViewportNode);
begin
  FdViewport.Send(Value);
end;

class function TAbstractLayerNode.ClassX3DType: String;
begin
  Result := 'X3DLayerNode';
end;

procedure TAbstractLayerNode.CreateNode;
begin
  inherited;

  FFdIsPickable := TSFBool.Create(Self, True, 'isPickable', true);
   FdIsPickable.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdIsPickable);

  FFdViewport := TSFNode.Create(Self, True, 'viewport', [TAbstractViewportNode]);
   FdViewport.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdViewport);

  DefaultContainerField := 'layers';
end;

{$endif read_implementation}
