{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDepth: Single;
    procedure SetDepth(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdDepth: TSFFloat;
    { Internal wrapper for property @code(Depth). This wrapper API may change, we advise to access simpler @code(Depth) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDepth: TSFFloat read FFdDepth;
    {  }
    property Depth: Single read GetDepth write SetDepth;

{$endif read_interface}

{$ifdef read_implementation}

{ TText3DNode ----------------------------------------------- }

function TText3DNode.GetDepth: Single;
begin
  Result := FdDepth.Value;
end;

procedure TText3DNode.SetDepth(const Value: Single);
begin
  FdDepth.Send(Value);
end;

class function TText3DNode.ClassX3DType: String;
begin
  Result := 'Text3D';
end;

procedure TText3DNode.CreateNode;
begin
  inherited;

  FFdDepth := TSFFloat.Create(Self, True, 'depth', 0.1);
   FdDepth.ChangeAlways := chGeometry;
  AddField(FFdDepth);
end;

{$endif read_implementation}
