{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetSrcFactor: TBlendingSourceFactor;
    procedure SetSrcFactor(const Value: TBlendingSourceFactor);
    function GetDestFactor: TBlendingDestinationFactor;
    procedure SetDestFactor(const Value: TBlendingDestinationFactor);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
    function GetColorTransparency: Single;
    procedure SetColorTransparency(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdSrcFactor: TSFStringEnum;
    { Internal wrapper for property @code(SrcFactor). This wrapper API may change, we advise to access simpler @code(SrcFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSrcFactor: TSFStringEnum read FFdSrcFactor;
    {  }
    property SrcFactor: TBlendingSourceFactor read GetSrcFactor write SetSrcFactor;

    strict private FFdDestFactor: TSFStringEnum;
    { Internal wrapper for property @code(DestFactor). This wrapper API may change, we advise to access simpler @code(DestFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDestFactor: TSFStringEnum read FFdDestFactor;
    {  }
    property DestFactor: TBlendingDestinationFactor read GetDestFactor write SetDestFactor;

    strict private FFdColor: TSFColor;
    { Internal wrapper for property @code(Color). This wrapper API may change, we advise to access simpler @code(Color) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColor: TSFColor read FFdColor;
    {  }
    property Color: TCastleColorRGB read GetColor write SetColor;

    strict private FFdColorTransparency: TSFFloat;
    { Internal wrapper for property @code(ColorTransparency). This wrapper API may change, we advise to access simpler @code(ColorTransparency) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdColorTransparency: TSFFloat read FFdColorTransparency;
    {  }
    property ColorTransparency: Single read GetColorTransparency write SetColorTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TBlendModeNode ----------------------------------------------- }

function TBlendModeNode.GetSrcFactor: TBlendingSourceFactor;
begin
  Result := TBlendingSourceFactor(FdSrcFactor.EnumValue);
end;

procedure TBlendModeNode.SetSrcFactor(const Value: TBlendingSourceFactor);
begin
  FdSrcFactor.SendEnumValue(Ord(Value));
end;

function TBlendModeNode.GetDestFactor: TBlendingDestinationFactor;
begin
  Result := TBlendingDestinationFactor(FdDestFactor.EnumValue);
end;

procedure TBlendModeNode.SetDestFactor(const Value: TBlendingDestinationFactor);
begin
  FdDestFactor.SendEnumValue(Ord(Value));
end;

function TBlendModeNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TBlendModeNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

function TBlendModeNode.GetColorTransparency: Single;
begin
  Result := FdColorTransparency.Value;
end;

procedure TBlendModeNode.SetColorTransparency(const Value: Single);
begin
  FdColorTransparency.Send(Value);
end;

class function TBlendModeNode.ClassX3DType: String;
begin
  Result := 'BlendMode';
end;

procedure TBlendModeNode.CreateNode;
begin
  inherited;

  FFdSrcFactor := TSFStringEnum.Create(Self, True, 'srcFactor', @BlendingSourceFactorNames, Ord(High(BlendingSourceFactorNames)) + 1, Ord(bsSrcAlpha));
   FdSrcFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSrcFactor);

  FFdDestFactor := TSFStringEnum.Create(Self, True, 'destFactor', @BlendingDestinationFactorNames, Ord(High(BlendingDestinationFactorNames)) + 1, Ord(bdOneMinusSrcAlpha));
   FdDestFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDestFactor);

  FFdColor := TSFColor.Create(Self, True, 'color', Vector3(1, 1, 1));
   FdColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdColor);

  FFdColorTransparency := TSFFloat.Create(Self, True, 'colorTransparency', 0);
   FdColorTransparency.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdColorTransparency);

  DefaultContainerField := 'blendMode';
end;

{$endif read_implementation}
