{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetBody1: TRigidBodyNode;
    procedure SetBody1(const Value: TRigidBodyNode);
    function GetBody2: TRigidBodyNode;
    procedure SetBody2(const Value: TRigidBodyNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdBody1: TSFNode;
    { X3D field "body1". } { }
    public property FdBody1: TSFNode read FFdBody1;
    { X3D field "body1". } { }
    property Body1: TRigidBodyNode read GetBody1 write SetBody1;

    strict private FFdBody2: TSFNode;
    { X3D field "body2". } { }
    public property FdBody2: TSFNode read FFdBody2;
    { X3D field "body2". } { }
    property Body2: TRigidBodyNode read GetBody2 write SetBody2;

    strict private FFdForceOutput: TMFString;
    { X3D field "forceOutput". } { }
    public property FdForceOutput: TMFString read FFdForceOutput;
    { Set X3D field "forceOutput". } { }
    procedure SetForceOutput(const Value: array of string);
    { Set X3D field "forceOutput". } { }
    procedure SetForceOutput(const Value: TCastleStringList);

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractRigidJointNode ----------------------------------------------- }

function TAbstractRigidJointNode.GetBody1: TRigidBodyNode;
begin
  if FdBody1.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody1.Value)
  else
    Result := nil;
end;

procedure TAbstractRigidJointNode.SetBody1(const Value: TRigidBodyNode);
begin
  FdBody1.Send(Value);
end;

function TAbstractRigidJointNode.GetBody2: TRigidBodyNode;
begin
  if FdBody2.Value is TRigidBodyNode then
    Result := TRigidBodyNode(FdBody2.Value)
  else
    Result := nil;
end;

procedure TAbstractRigidJointNode.SetBody2(const Value: TRigidBodyNode);
begin
  FdBody2.Send(Value);
end;

procedure TAbstractRigidJointNode.SetForceOutput(const Value: array of string);
begin
  FdForceOutput.Send(Value);
end;

procedure TAbstractRigidJointNode.SetForceOutput(const Value: TCastleStringList);
begin
  FdForceOutput.Send(Value);
end;

class function TAbstractRigidJointNode.ClassX3DType: String;
begin
  Result := 'X3DRigidJointNode';
end;

procedure TAbstractRigidJointNode.CreateNode;
begin
  inherited;

  FFdBody1 := TSFNode.Create(Self, True, 'body1', [TRigidBodyNode]);
   FdBody1.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBody1);

  FFdBody2 := TSFNode.Create(Self, True, 'body2', [TRigidBodyNode]);
   FdBody2.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBody2);

  FFdForceOutput := TMFString.Create(Self, True, 'forceOutput', ['NONE']);
   FdForceOutput.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdForceOutput);
  { X3D specification comment: ["ALL","NONE",...] }

  DefaultContainerField := 'joints';
end;

{$endif read_implementation}
