{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCoord: TAbstractCoordinateNode;
    procedure SetCoord(const Value: TAbstractCoordinateNode);
    function GetDirection: TVector3;
    procedure SetDirection(const Value: TVector3);
    function GetInternal: Boolean;
    procedure SetInternal(const Value: Boolean);
  public
    { X3D field "coord". } { }
    property Coord: TAbstractCoordinateNode read GetCoord write SetCoord;
    { X3D field "direction". } { }
    property Direction: TVector3 read GetDirection write SetDirection;
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: array of LongInt);
    { Set X3D field "coordIndex". } { }
    procedure SetCoordIndex(const Value: TLongIntList);
    { X3D field "internal". } { }
    property Internal: Boolean read GetInternal write SetInternal;

{$endif read_interface}

{$ifdef read_implementation}

{ TVolumeEmitterNode ----------------------------------------------- }

function TVolumeEmitterNode.GetCoord: TAbstractCoordinateNode;
begin
  if FdCoord.Value is TAbstractCoordinateNode then
    Result := TAbstractCoordinateNode(FdCoord.Value)
  else
    Result := nil;
end;

procedure TVolumeEmitterNode.SetCoord(const Value: TAbstractCoordinateNode);
begin
  FdCoord.Send(Value);
end;

function TVolumeEmitterNode.GetDirection: TVector3;
begin
  Result := FdDirection.Value;
end;

procedure TVolumeEmitterNode.SetDirection(const Value: TVector3);
begin
  FdDirection.Send(Value);
end;

procedure TVolumeEmitterNode.SetCoordIndex(const Value: array of LongInt);
begin
  FdCoordIndex.Send(Value);
end;

procedure TVolumeEmitterNode.SetCoordIndex(const Value: TLongIntList);
begin
  FdCoordIndex.Send(Value);
end;

function TVolumeEmitterNode.GetInternal: Boolean;
begin
  Result := FdInternal.Value;
end;

procedure TVolumeEmitterNode.SetInternal(const Value: Boolean);
begin
  FdInternal.Send(Value);
end;

{$endif read_implementation}
