{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdTransparency: TSFFloat;
    { X3D field "transparency". } { }
    public property FdTransparency: TSFFloat read FFdTransparency;
    { X3D field "transparency". } { }
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TUnlitMaterialNode ----------------------------------------------- }

function TUnlitMaterialNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TUnlitMaterialNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

class function TUnlitMaterialNode.ClassX3DType: String;
begin
  Result := 'UnlitMaterial';
end;

procedure TUnlitMaterialNode.CreateNode;
begin
  inherited;

  FFdTransparency := TSFFloat.Create(Self, True, 'transparency', 0);
   FdTransparency.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransparency);
  { X3D specification comment: [0,1] }

  DefaultContainerField := 'material';
end;

{$endif read_implementation}
