{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  public
    { Set X3D field "backUrl". } { }
    procedure SetBackUrl(const Value: array of string);
    { Set X3D field "backUrl". } { }
    procedure SetBackUrl(const Value: TCastleStringList);
    { Set X3D field "bottomUrl". } { }
    procedure SetBottomUrl(const Value: array of string);
    { Set X3D field "bottomUrl". } { }
    procedure SetBottomUrl(const Value: TCastleStringList);
    { Set X3D field "frontUrl". } { }
    procedure SetFrontUrl(const Value: array of string);
    { Set X3D field "frontUrl". } { }
    procedure SetFrontUrl(const Value: TCastleStringList);
    { Set X3D field "leftUrl". } { }
    procedure SetLeftUrl(const Value: array of string);
    { Set X3D field "leftUrl". } { }
    procedure SetLeftUrl(const Value: TCastleStringList);
    { Set X3D field "rightUrl". } { }
    procedure SetRightUrl(const Value: array of string);
    { Set X3D field "rightUrl". } { }
    procedure SetRightUrl(const Value: TCastleStringList);
    { Set X3D field "topUrl". } { }
    procedure SetTopUrl(const Value: array of string);
    { Set X3D field "topUrl". } { }
    procedure SetTopUrl(const Value: TCastleStringList);

{$endif read_interface}

{$ifdef read_implementation}

{ TBackgroundNode ----------------------------------------------- }

procedure TBackgroundNode.SetBackUrl(const Value: array of string);
begin
  FdBackUrl.Send(Value);
end;

procedure TBackgroundNode.SetBackUrl(const Value: TCastleStringList);
begin
  FdBackUrl.Send(Value);
end;

procedure TBackgroundNode.SetBottomUrl(const Value: array of string);
begin
  FdBottomUrl.Send(Value);
end;

procedure TBackgroundNode.SetBottomUrl(const Value: TCastleStringList);
begin
  FdBottomUrl.Send(Value);
end;

procedure TBackgroundNode.SetFrontUrl(const Value: array of string);
begin
  FdFrontUrl.Send(Value);
end;

procedure TBackgroundNode.SetFrontUrl(const Value: TCastleStringList);
begin
  FdFrontUrl.Send(Value);
end;

procedure TBackgroundNode.SetLeftUrl(const Value: array of string);
begin
  FdLeftUrl.Send(Value);
end;

procedure TBackgroundNode.SetLeftUrl(const Value: TCastleStringList);
begin
  FdLeftUrl.Send(Value);
end;

procedure TBackgroundNode.SetRightUrl(const Value: array of string);
begin
  FdRightUrl.Send(Value);
end;

procedure TBackgroundNode.SetRightUrl(const Value: TCastleStringList);
begin
  FdRightUrl.Send(Value);
end;

procedure TBackgroundNode.SetTopUrl(const Value: array of string);
begin
  FdTopUrl.Send(Value);
end;

procedure TBackgroundNode.SetTopUrl(const Value: TCastleStringList);
begin
  FdTopUrl.Send(Value);
end;

{$endif read_implementation}
