{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    property Center: TVector3 read GetCenter write SetCenter;
    property Rotation: TVector4 read GetRotation write SetRotation;
    property Scale: TVector3 read GetScale write SetScale;
    property Translation: TVector3 read GetTranslation write SetTranslation;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureTransform3DNode ----------------------------------------------- }

function TTextureTransform3DNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TTextureTransform3DNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TTextureTransform3DNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure TTextureTransform3DNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function TTextureTransform3DNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure TTextureTransform3DNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function TTextureTransform3DNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure TTextureTransform3DNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

{$endif read_implementation}
