//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Item/ItemViewOverlayButtons.h
//! @brief     Defines class ItemViewOverlayButtons
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_ITEM_ITEMVIEWOVERLAYBUTTONS_H
#define BORNAGAIN_GUI_VIEW_ITEM_ITEMVIEWOVERLAYBUTTONS_H

#include <QObject>
#include <functional>

class QAbstractItemView;
class QAction;

class ItemViewOverlayButtons : public QObject {
    Q_OBJECT
public:
    using FnGetActions = std::function<QList<QAction*>(const QModelIndex&, bool)>;

    static void install(QAbstractItemView* view, FnGetActions fnGetActions);

private:
    bool eventFilter(QObject* obj, QEvent* event) override;

    ItemViewOverlayButtons(QObject* parent);
    void updateRecursive(const QModelIndex& index);
    void update();
    void installOverlay(const QModelIndex& index);

    FnGetActions m_getActions;
    QAbstractItemView* m_view;
};


#endif // BORNAGAIN_GUI_VIEW_ITEM_ITEMVIEWOVERLAYBUTTONS_H
