# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to the Samsung SCH-A870 Phone"""

from prototypes import *
from prototypes_samsung import *
from p_brew import *
from p_samsungscha950 import *
from common import basename

# We use LSB for all integer like fields
UINT=UINTlsb
BOOL=BOOLlsb

# Calendar stuff
CAL_PATH='sch_event'
CAL_INDEX_FILE_NAME=CAL_PATH+'/usr_tsk'
CAL_FILE_NAME_PREFIX=CAL_PATH+'/usr_tsk_'
CAL_MAX_EVENTS=100

CAL_REMINDER_OFF=0
CAL_REMINDER_ONCE=1
CAL_REMINDER_2MIN=2
CAL_REMINDER_15MIN=3

GROUP_INDEX_FILE_NAME='pb/group_name.dat'

# Call log/history
CL_MAX_ENTRIES=90

PB_FLG_CRINGTONE=0X4000

PIC_INDEX_HDR='0|/brew/16452/mp|\x0A'

class PictureIndexEntry(BaseProtogenClass):
    __fields=['filename', 'name', 'pathname', 'dunno1', 'filesize']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PictureIndexEntry,self).__init__(**dict)
        if self.__class__ is PictureIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PictureIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PictureIndexEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_filename
        except:
            self.__field_filename=STRING(**{ 'default': '' })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_name
        except:
            self.__field_name=STRING(**{'sizeinbytes': 64,  'terminator': 0,                'default': self._name() })
        self.__field_name.writetobuffer(buf)
        try: self.__field_pathname
        except:
            self.__field_pathname=STRING(**{'sizeinbytes': 58,  'terminator': 0,                'default': self._pathname() })
        self.__field_pathname.writetobuffer(buf)
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 2,  'default': 0x0300 })
        self.__field_dunno1.writetobuffer(buf)
        self.__field_filesize.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=STRING(**{'sizeinbytes': 64,  'terminator': 0,                'default': self._name() })
        self.__field_name.readfrombuffer(buf)
        self.__field_pathname=STRING(**{'sizeinbytes': 58,  'terminator': 0,                'default': self._pathname() })
        self.__field_pathname.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 2,  'default': 0x0300 })
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_filesize=UINT(**{'sizeinbytes': 4})
        self.__field_filesize.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_filename(self):
        try: self.__field_filename
        except:
            self.__field_filename=STRING(**{ 'default': '' })
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,STRING):
            self.__field_filename=value
        else:
            self.__field_filename=STRING(value,**{ 'default': '' })

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=STRING(**{'sizeinbytes': 64,  'terminator': 0,                'default': self._name() })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,STRING):
            self.__field_name=value
        else:
            self.__field_name=STRING(value,**{'sizeinbytes': 64,  'terminator': 0,                'default': self._name() })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_pathname(self):
        try: self.__field_pathname
        except:
            self.__field_pathname=STRING(**{'sizeinbytes': 58,  'terminator': 0,                'default': self._pathname() })
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,STRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=STRING(value,**{'sizeinbytes': 58,  'terminator': 0,                'default': self._pathname() })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def __getfield_dunno1(self):
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 2,  'default': 0x0300 })
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 2,  'default': 0x0300 })

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_filesize(self):
        return self.__field_filesize.getvalue()

    def __setfield_filesize(self, value):
        if isinstance(value,UINT):
            self.__field_filesize=value
        else:
            self.__field_filesize=UINT(value,**{'sizeinbytes': 4})

    def __delfield_filesize(self): del self.__field_filesize

    filesize=property(__getfield_filesize, __setfield_filesize, __delfield_filesize, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('filename', self.__field_filename, None)
        yield ('name', self.__field_name, None)
        yield ('pathname', self.__field_pathname, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('filesize', self.__field_filesize, None)

    def _name(self):
        return '%(base)s.%(ext)s' % {
            'base': common.stripext(self.filename)[:10],
            'ext': common.getext(self.filename) }
    def _pathname(self):
        global PIC_PATH
        return '/%(path)s/%(filename)s'%{
            'path': PIC_PATH,
            'filename': self.filename }




class PictureIndexFile(BaseProtogenClass):
    __fields=['header', 'items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PictureIndexFile,self).__init__(**dict)
        if self.__class__ is PictureIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PictureIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PictureIndexFile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=STRING(**{'sizeinbytes': 128,  'terminator': 0,                 'default': PIC_INDEX_HDR })
        self.__field_header.writetobuffer(buf)
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PictureIndexEntry })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=STRING(**{'sizeinbytes': 128,  'terminator': 0,                 'default': PIC_INDEX_HDR })
        self.__field_header.readfrombuffer(buf)
        self.__field_items=LIST(**{ 'elementclass': PictureIndexEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=STRING(**{'sizeinbytes': 128,  'terminator': 0,                 'default': PIC_INDEX_HDR })
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,STRING):
            self.__field_header=value
        else:
            self.__field_header=STRING(value,**{'sizeinbytes': 128,  'terminator': 0,                 'default': PIC_INDEX_HDR })

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PictureIndexEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PictureIndexEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('items', self.__field_items, None)




class GroupEntry(BaseProtogenClass):
    __fields=['name', 'index', 'numofmembers', 'dunno1']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(GroupEntry,self).__init__(**dict)
        if self.__class__ is GroupEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(GroupEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(GroupEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_name.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self.__field_numofmembers.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=USTRING(**{'sizeinbytes': 65,  'encoding': ENCODING,                 'terminator': 0 })
        self.__field_name.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 3})
        self.__field_index.readfrombuffer(buf)
        self.__field_numofmembers=UINT(**{'sizeinbytes': 4})
        self.__field_numofmembers.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_dunno1.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 65,  'encoding': ENCODING,                 'terminator': 0 })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 3})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_numofmembers(self):
        return self.__field_numofmembers.getvalue()

    def __setfield_numofmembers(self, value):
        if isinstance(value,UINT):
            self.__field_numofmembers=value
        else:
            self.__field_numofmembers=UINT(value,**{'sizeinbytes': 4})

    def __delfield_numofmembers(self): del self.__field_numofmembers

    numofmembers=property(__getfield_numofmembers, __setfield_numofmembers, __delfield_numofmembers, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('index', self.__field_index, None)
        yield ('numofmembers', self.__field_numofmembers, None)
        yield ('dunno1', self.__field_dunno1, None)




class GroupIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(GroupIndexFile,self).__init__(**dict)
        if self.__class__ is GroupIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(GroupIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(GroupIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': GroupEntry }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': GroupEntry })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': GroupEntry })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': GroupEntry })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': GroupEntry })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class CalIndexEntry(BaseProtogenClass):
    __fields=['index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalIndexEntry,self).__init__(**dict)
        if self.__class__ is CalIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_index=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)




class CalIndexFile(BaseProtogenClass):
    __fields=['next_index', 'zero1', 'numofevents', 'zero2', 'numofnotes', 'zero3', 'numofactiveevents', 'zero4', 'events', 'notes', 'activeevents']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalIndexFile,self).__init__(**dict)
        if self.__class__ is CalIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalIndexFile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_next_index.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UNKNOWN(**{'sizeinbytes': 12,  'pad': 0 })
        self.__field_zero1.writetobuffer(buf)
        self.__field_numofevents.writetobuffer(buf)
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 6,  'pad': 0 })
        self.__field_zero2.writetobuffer(buf)
        self.__field_numofnotes.writetobuffer(buf)
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        self.__field_zero3.writetobuffer(buf)
        self.__field_numofactiveevents.writetobuffer(buf)
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 112,  'pad': 0 })
        self.__field_zero4.writetobuffer(buf)
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        self.__field_events.writetobuffer(buf)
        try: self.__field_notes
        except:
            self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })
        self.__field_notes.writetobuffer(buf)
        try: self.__field_activeevents
        except:
            self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })
        self.__field_activeevents.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_next_index=UINT(**{'sizeinbytes': 2})
        self.__field_next_index.readfrombuffer(buf)
        self.__field_zero1=UNKNOWN(**{'sizeinbytes': 12,  'pad': 0 })
        self.__field_zero1.readfrombuffer(buf)
        self.__field_numofevents=UINT(**{'sizeinbytes': 2})
        self.__field_numofevents.readfrombuffer(buf)
        self.__field_zero2=UNKNOWN(**{'sizeinbytes': 6,  'pad': 0 })
        self.__field_zero2.readfrombuffer(buf)
        self.__field_numofnotes=UINT(**{'sizeinbytes': 2})
        self.__field_numofnotes.readfrombuffer(buf)
        self.__field_zero3=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        self.__field_zero3.readfrombuffer(buf)
        self.__field_numofactiveevents=UINT(**{'sizeinbytes': 2})
        self.__field_numofactiveevents.readfrombuffer(buf)
        self.__field_zero4=UNKNOWN(**{'sizeinbytes': 112,  'pad': 0 })
        self.__field_zero4.readfrombuffer(buf)
        self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        self.__field_events.readfrombuffer(buf)
        self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })
        self.__field_notes.readfrombuffer(buf)
        self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })
        self.__field_activeevents.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_next_index(self):
        return self.__field_next_index.getvalue()

    def __setfield_next_index(self, value):
        if isinstance(value,UINT):
            self.__field_next_index=value
        else:
            self.__field_next_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_next_index(self): del self.__field_next_index

    next_index=property(__getfield_next_index, __setfield_next_index, __delfield_next_index, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UNKNOWN(**{'sizeinbytes': 12,  'pad': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero1=value
        else:
            self.__field_zero1=UNKNOWN(value,**{'sizeinbytes': 12,  'pad': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_numofevents(self):
        return self.__field_numofevents.getvalue()

    def __setfield_numofevents(self, value):
        if isinstance(value,UINT):
            self.__field_numofevents=value
        else:
            self.__field_numofevents=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofevents(self): del self.__field_numofevents

    numofevents=property(__getfield_numofevents, __setfield_numofevents, __delfield_numofevents, None)

    def __getfield_zero2(self):
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 6,  'pad': 0 })
        return self.__field_zero2.getvalue()

    def __setfield_zero2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero2=value
        else:
            self.__field_zero2=UNKNOWN(value,**{'sizeinbytes': 6,  'pad': 0 })

    def __delfield_zero2(self): del self.__field_zero2

    zero2=property(__getfield_zero2, __setfield_zero2, __delfield_zero2, None)

    def __getfield_numofnotes(self):
        return self.__field_numofnotes.getvalue()

    def __setfield_numofnotes(self, value):
        if isinstance(value,UINT):
            self.__field_numofnotes=value
        else:
            self.__field_numofnotes=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofnotes(self): del self.__field_numofnotes

    numofnotes=property(__getfield_numofnotes, __setfield_numofnotes, __delfield_numofnotes, None)

    def __getfield_zero3(self):
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 2,  'pad': 0 })
        return self.__field_zero3.getvalue()

    def __setfield_zero3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero3=value
        else:
            self.__field_zero3=UNKNOWN(value,**{'sizeinbytes': 2,  'pad': 0 })

    def __delfield_zero3(self): del self.__field_zero3

    zero3=property(__getfield_zero3, __setfield_zero3, __delfield_zero3, None)

    def __getfield_numofactiveevents(self):
        return self.__field_numofactiveevents.getvalue()

    def __setfield_numofactiveevents(self, value):
        if isinstance(value,UINT):
            self.__field_numofactiveevents=value
        else:
            self.__field_numofactiveevents=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numofactiveevents(self): del self.__field_numofactiveevents

    numofactiveevents=property(__getfield_numofactiveevents, __setfield_numofactiveevents, __delfield_numofactiveevents, None)

    def __getfield_zero4(self):
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 112,  'pad': 0 })
        return self.__field_zero4.getvalue()

    def __setfield_zero4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero4=value
        else:
            self.__field_zero4=UNKNOWN(value,**{'sizeinbytes': 112,  'pad': 0 })

    def __delfield_zero4(self): del self.__field_zero4

    zero4=property(__getfield_zero4, __setfield_zero4, __delfield_zero4, None)

    def __getfield_events(self):
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })
        return self.__field_events.getvalue()

    def __setfield_events(self, value):
        if isinstance(value,LIST):
            self.__field_events=value
        else:
            self.__field_events=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 103,             'createdefault': True })

    def __delfield_events(self): del self.__field_events

    events=property(__getfield_events, __setfield_events, __delfield_events, None)

    def __getfield_notes(self):
        try: self.__field_notes
        except:
            self.__field_notes=LIST(**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })
        return self.__field_notes.getvalue()

    def __setfield_notes(self, value):
        if isinstance(value,LIST):
            self.__field_notes=value
        else:
            self.__field_notes=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 30,             'createdefault': True })

    def __delfield_notes(self): del self.__field_notes

    notes=property(__getfield_notes, __setfield_notes, __delfield_notes, None)

    def __getfield_activeevents(self):
        try: self.__field_activeevents
        except:
            self.__field_activeevents=LIST(**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })
        return self.__field_activeevents.getvalue()

    def __setfield_activeevents(self, value):
        if isinstance(value,LIST):
            self.__field_activeevents=value
        else:
            self.__field_activeevents=LIST(value,**{ 'elementclass': CalIndexEntry,             'length': 324,             'createdefault': True })

    def __delfield_activeevents(self): del self.__field_activeevents

    activeevents=property(__getfield_activeevents, __setfield_activeevents, __delfield_activeevents, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('next_index', self.__field_next_index, None)
        yield ('zero1', self.__field_zero1, None)
        yield ('numofevents', self.__field_numofevents, None)
        yield ('zero2', self.__field_zero2, None)
        yield ('numofnotes', self.__field_numofnotes, None)
        yield ('zero3', self.__field_zero3, None)
        yield ('numofactiveevents', self.__field_numofactiveevents, None)
        yield ('zero4', self.__field_zero4, None)
        yield ('events', self.__field_events, None)
        yield ('notes', self.__field_notes, None)
        yield ('activeevents', self.__field_activeevents, None)




class CalEntry(BaseProtogenClass):
    __fields=['titlelen', 'title', 'start', 'start2', 'exptime', 'one', 'zero1', 'alert', 'three', 'alarm', 'reminder', 'ringtoneindex', 'zero4', 'duration', 'zero5']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(CalEntry,self).__init__(**dict)
        if self.__class__ is CalEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(CalEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(CalEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_titlelen.writetobuffer(buf)
        self.__field_title.writetobuffer(buf)
        self.__field_start.writetobuffer(buf)
        try: self.__field_start2
        except:
            self.__field_start2=DateTime(**{'sizeinbytes': 4,  'default': self.start })
        self.__field_start2.writetobuffer(buf)
        self.__field_exptime.writetobuffer(buf)
        try: self.__field_one
        except:
            self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        self.__field_one.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero1.writetobuffer(buf)
        self.__field_alert.writetobuffer(buf)
        try: self.__field_three
        except:
            self.__field_three=UINT(**{'sizeinbytes': 1,  'default': 3 })
        self.__field_three.writetobuffer(buf)
        self.__field_alarm.writetobuffer(buf)
        try: self.__field_reminder
        except:
            self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })
        self.__field_reminder.writetobuffer(buf)
        self.__field_ringtoneindex.writetobuffer(buf)
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 5,  'pad': 0 })
        self.__field_zero4.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        try: self.__field_zero5
        except:
            self.__field_zero5=UNKNOWN(**{'sizeinbytes': 7,  'pad': 0 })
        self.__field_zero5.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_titlelen=UINT(**{'sizeinbytes': 2})
        self.__field_titlelen.readfrombuffer(buf)
        self.__field_title=USTRING(**{ 'sizeinbytes': self.titlelen,                'encoding': ENCODING,                'terminator': None })
        self.__field_title.readfrombuffer(buf)
        self.__field_start=DateTime(**{'sizeinbytes': 4})
        self.__field_start.readfrombuffer(buf)
        self.__field_start2=DateTime(**{'sizeinbytes': 4,  'default': self.start })
        self.__field_start2.readfrombuffer(buf)
        self.__field_exptime=ExpiringTime(**{'sizeinbytes': 4})
        self.__field_exptime.readfrombuffer(buf)
        self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        self.__field_one.readfrombuffer(buf)
        self.__field_zero1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero1.readfrombuffer(buf)
        self.__field_alert=UINT(**{'sizeinbytes': 1})
        self.__field_alert.readfrombuffer(buf)
        self.__field_three=UINT(**{'sizeinbytes': 1,  'default': 3 })
        self.__field_three.readfrombuffer(buf)
        self.__field_alarm=UINT(**{'sizeinbytes': 1})
        self.__field_alarm.readfrombuffer(buf)
        self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })
        self.__field_reminder.readfrombuffer(buf)
        self.__field_ringtoneindex=UINT(**{'sizeinbytes': 1})
        self.__field_ringtoneindex.readfrombuffer(buf)
        self.__field_zero4=UNKNOWN(**{'sizeinbytes': 5,  'pad': 0 })
        self.__field_zero4.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self.__field_zero5=UNKNOWN(**{'sizeinbytes': 7,  'pad': 0 })
        self.__field_zero5.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_titlelen(self):
        return self.__field_titlelen.getvalue()

    def __setfield_titlelen(self, value):
        if isinstance(value,UINT):
            self.__field_titlelen=value
        else:
            self.__field_titlelen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_titlelen(self): del self.__field_titlelen

    titlelen=property(__getfield_titlelen, __setfield_titlelen, __delfield_titlelen, None)

    def __getfield_title(self):
        return self.__field_title.getvalue()

    def __setfield_title(self, value):
        if isinstance(value,USTRING):
            self.__field_title=value
        else:
            self.__field_title=USTRING(value,**{ 'sizeinbytes': self.titlelen,                'encoding': ENCODING,                'terminator': None })

    def __delfield_title(self): del self.__field_title

    title=property(__getfield_title, __setfield_title, __delfield_title, None)

    def __getfield_start(self):
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,DateTime):
            self.__field_start=value
        else:
            self.__field_start=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, None)

    def __getfield_start2(self):
        try: self.__field_start2
        except:
            self.__field_start2=DateTime(**{'sizeinbytes': 4,  'default': self.start })
        return self.__field_start2.getvalue()

    def __setfield_start2(self, value):
        if isinstance(value,DateTime):
            self.__field_start2=value
        else:
            self.__field_start2=DateTime(value,**{'sizeinbytes': 4,  'default': self.start })

    def __delfield_start2(self): del self.__field_start2

    start2=property(__getfield_start2, __setfield_start2, __delfield_start2, None)

    def __getfield_exptime(self):
        return self.__field_exptime.getvalue()

    def __setfield_exptime(self, value):
        if isinstance(value,ExpiringTime):
            self.__field_exptime=value
        else:
            self.__field_exptime=ExpiringTime(value,**{'sizeinbytes': 4})

    def __delfield_exptime(self): del self.__field_exptime

    exptime=property(__getfield_exptime, __setfield_exptime, __delfield_exptime, None)

    def __getfield_one(self):
        try: self.__field_one
        except:
            self.__field_one=UINT(**{'sizeinbytes': 1,  'default': 1 })
        return self.__field_one.getvalue()

    def __setfield_one(self, value):
        if isinstance(value,UINT):
            self.__field_one=value
        else:
            self.__field_one=UINT(value,**{'sizeinbytes': 1,  'default': 1 })

    def __delfield_one(self): del self.__field_one

    one=property(__getfield_one, __setfield_one, __delfield_one, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UINT):
            self.__field_zero1=value
        else:
            self.__field_zero1=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_alert(self):
        return self.__field_alert.getvalue()

    def __setfield_alert(self, value):
        if isinstance(value,UINT):
            self.__field_alert=value
        else:
            self.__field_alert=UINT(value,**{'sizeinbytes': 1})

    def __delfield_alert(self): del self.__field_alert

    alert=property(__getfield_alert, __setfield_alert, __delfield_alert, None)

    def __getfield_three(self):
        try: self.__field_three
        except:
            self.__field_three=UINT(**{'sizeinbytes': 1,  'default': 3 })
        return self.__field_three.getvalue()

    def __setfield_three(self, value):
        if isinstance(value,UINT):
            self.__field_three=value
        else:
            self.__field_three=UINT(value,**{'sizeinbytes': 1,  'default': 3 })

    def __delfield_three(self): del self.__field_three

    three=property(__getfield_three, __setfield_three, __delfield_three, None)

    def __getfield_alarm(self):
        return self.__field_alarm.getvalue()

    def __setfield_alarm(self, value):
        if isinstance(value,UINT):
            self.__field_alarm=value
        else:
            self.__field_alarm=UINT(value,**{'sizeinbytes': 1})

    def __delfield_alarm(self): del self.__field_alarm

    alarm=property(__getfield_alarm, __setfield_alarm, __delfield_alarm, None)

    def __getfield_reminder(self):
        try: self.__field_reminder
        except:
            self.__field_reminder=UINT(**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })
        return self.__field_reminder.getvalue()

    def __setfield_reminder(self, value):
        if isinstance(value,UINT):
            self.__field_reminder=value
        else:
            self.__field_reminder=UINT(value,**{'sizeinbytes': 1,  'default': CAL_REMINDER_ONCE })

    def __delfield_reminder(self): del self.__field_reminder

    reminder=property(__getfield_reminder, __setfield_reminder, __delfield_reminder, None)

    def __getfield_ringtoneindex(self):
        return self.__field_ringtoneindex.getvalue()

    def __setfield_ringtoneindex(self, value):
        if isinstance(value,UINT):
            self.__field_ringtoneindex=value
        else:
            self.__field_ringtoneindex=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ringtoneindex(self): del self.__field_ringtoneindex

    ringtoneindex=property(__getfield_ringtoneindex, __setfield_ringtoneindex, __delfield_ringtoneindex, None)

    def __getfield_zero4(self):
        try: self.__field_zero4
        except:
            self.__field_zero4=UNKNOWN(**{'sizeinbytes': 5,  'pad': 0 })
        return self.__field_zero4.getvalue()

    def __setfield_zero4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero4=value
        else:
            self.__field_zero4=UNKNOWN(value,**{'sizeinbytes': 5,  'pad': 0 })

    def __delfield_zero4(self): del self.__field_zero4

    zero4=property(__getfield_zero4, __setfield_zero4, __delfield_zero4, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def __getfield_zero5(self):
        try: self.__field_zero5
        except:
            self.__field_zero5=UNKNOWN(**{'sizeinbytes': 7,  'pad': 0 })
        return self.__field_zero5.getvalue()

    def __setfield_zero5(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero5=value
        else:
            self.__field_zero5=UNKNOWN(value,**{'sizeinbytes': 7,  'pad': 0 })

    def __delfield_zero5(self): del self.__field_zero5

    zero5=property(__getfield_zero5, __setfield_zero5, __delfield_zero5, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('titlelen', self.__field_titlelen, None)
        yield ('title', self.__field_title, None)
        yield ('start', self.__field_start, None)
        yield ('start2', self.__field_start2, None)
        yield ('exptime', self.__field_exptime, None)
        yield ('one', self.__field_one, None)
        yield ('zero1', self.__field_zero1, None)
        yield ('alert', self.__field_alert, None)
        yield ('three', self.__field_three, None)
        yield ('alarm', self.__field_alarm, None)
        yield ('reminder', self.__field_reminder, None)
        yield ('ringtoneindex', self.__field_ringtoneindex, None)
        yield ('zero4', self.__field_zero4, None)
        yield ('duration', self.__field_duration, None)
        yield ('zero5', self.__field_zero5, None)




class NotePadEntry(BaseProtogenClass):
    __fields=['textlen', 'text', 'creation', 'creation2', 'zero2', 'five', 'zero3']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(NotePadEntry,self).__init__(**dict)
        if self.__class__ is NotePadEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(NotePadEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(NotePadEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_textlen.writetobuffer(buf)
        self.__field_text.writetobuffer(buf)
        self.__field_creation.writetobuffer(buf)
        try: self.__field_creation2
        except:
            self.__field_creation2=DateTime(**{'sizeinbytes': 4,  'default': self.creation })
        self.__field_creation2.writetobuffer(buf)
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 7,  'pad': 0 })
        self.__field_zero2.writetobuffer(buf)
        try: self.__field_five
        except:
            self.__field_five=UINT(**{'sizeinbytes': 1,  'default': 5 })
        self.__field_five.writetobuffer(buf)
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 19,  'pad': 0 })
        self.__field_zero3.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_textlen=UINT(**{'sizeinbytes': 2})
        self.__field_textlen.readfrombuffer(buf)
        self.__field_text=USTRING(**{ 'terminator': None,                'encoding': ENCODING,                'sizeinbytes': self.textlen })
        self.__field_text.readfrombuffer(buf)
        self.__field_creation=DateTime(**{'sizeinbytes': 4})
        self.__field_creation.readfrombuffer(buf)
        self.__field_creation2=DateTime(**{'sizeinbytes': 4,  'default': self.creation })
        self.__field_creation2.readfrombuffer(buf)
        self.__field_zero2=UNKNOWN(**{'sizeinbytes': 7,  'pad': 0 })
        self.__field_zero2.readfrombuffer(buf)
        self.__field_five=UINT(**{'sizeinbytes': 1,  'default': 5 })
        self.__field_five.readfrombuffer(buf)
        self.__field_zero3=UNKNOWN(**{'sizeinbytes': 19,  'pad': 0 })
        self.__field_zero3.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_textlen(self):
        return self.__field_textlen.getvalue()

    def __setfield_textlen(self, value):
        if isinstance(value,UINT):
            self.__field_textlen=value
        else:
            self.__field_textlen=UINT(value,**{'sizeinbytes': 2})

    def __delfield_textlen(self): del self.__field_textlen

    textlen=property(__getfield_textlen, __setfield_textlen, __delfield_textlen, None)

    def __getfield_text(self):
        return self.__field_text.getvalue()

    def __setfield_text(self, value):
        if isinstance(value,USTRING):
            self.__field_text=value
        else:
            self.__field_text=USTRING(value,**{ 'terminator': None,                'encoding': ENCODING,                'sizeinbytes': self.textlen })

    def __delfield_text(self): del self.__field_text

    text=property(__getfield_text, __setfield_text, __delfield_text, None)

    def __getfield_creation(self):
        return self.__field_creation.getvalue()

    def __setfield_creation(self, value):
        if isinstance(value,DateTime):
            self.__field_creation=value
        else:
            self.__field_creation=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_creation(self): del self.__field_creation

    creation=property(__getfield_creation, __setfield_creation, __delfield_creation, None)

    def __getfield_creation2(self):
        try: self.__field_creation2
        except:
            self.__field_creation2=DateTime(**{'sizeinbytes': 4,  'default': self.creation })
        return self.__field_creation2.getvalue()

    def __setfield_creation2(self, value):
        if isinstance(value,DateTime):
            self.__field_creation2=value
        else:
            self.__field_creation2=DateTime(value,**{'sizeinbytes': 4,  'default': self.creation })

    def __delfield_creation2(self): del self.__field_creation2

    creation2=property(__getfield_creation2, __setfield_creation2, __delfield_creation2, None)

    def __getfield_zero2(self):
        try: self.__field_zero2
        except:
            self.__field_zero2=UNKNOWN(**{'sizeinbytes': 7,  'pad': 0 })
        return self.__field_zero2.getvalue()

    def __setfield_zero2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero2=value
        else:
            self.__field_zero2=UNKNOWN(value,**{'sizeinbytes': 7,  'pad': 0 })

    def __delfield_zero2(self): del self.__field_zero2

    zero2=property(__getfield_zero2, __setfield_zero2, __delfield_zero2, None)

    def __getfield_five(self):
        try: self.__field_five
        except:
            self.__field_five=UINT(**{'sizeinbytes': 1,  'default': 5 })
        return self.__field_five.getvalue()

    def __setfield_five(self, value):
        if isinstance(value,UINT):
            self.__field_five=value
        else:
            self.__field_five=UINT(value,**{'sizeinbytes': 1,  'default': 5 })

    def __delfield_five(self): del self.__field_five

    five=property(__getfield_five, __setfield_five, __delfield_five, None)

    def __getfield_zero3(self):
        try: self.__field_zero3
        except:
            self.__field_zero3=UNKNOWN(**{'sizeinbytes': 19,  'pad': 0 })
        return self.__field_zero3.getvalue()

    def __setfield_zero3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zero3=value
        else:
            self.__field_zero3=UNKNOWN(value,**{'sizeinbytes': 19,  'pad': 0 })

    def __delfield_zero3(self): del self.__field_zero3

    zero3=property(__getfield_zero3, __setfield_zero3, __delfield_zero3, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('textlen', self.__field_textlen, None)
        yield ('text', self.__field_text, None)
        yield ('creation', self.__field_creation, None)
        yield ('creation2', self.__field_creation2, None)
        yield ('zero2', self.__field_zero2, None)
        yield ('five', self.__field_five, None)
        yield ('zero3', self.__field_zero3, None)




class cl_list(BaseProtogenClass):
    __fields=['index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_list,self).__init__(**dict)
        if self.__class__ is cl_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_list,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_index=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)




class cl_index_file(BaseProtogenClass):
    __fields=['incoming', 'outgoing', 'missed', 'dunno1', 'incoming_count', 'outgoing_count', 'missed_count']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_index_file,self).__init__(**dict)
        if self.__class__ is cl_index_file:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_index_file,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_index_file,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_incoming.writetobuffer(buf)
        self.__field_outgoing.writetobuffer(buf)
        self.__field_missed.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_incoming_count.writetobuffer(buf)
        self.__field_outgoing_count.writetobuffer(buf)
        self.__field_missed_count.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_incoming=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_incoming.readfrombuffer(buf)
        self.__field_outgoing=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_outgoing.readfrombuffer(buf)
        self.__field_missed=LIST(**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })
        self.__field_missed.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 992})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_incoming_count=UINT(**{'sizeinbytes': 4})
        self.__field_incoming_count.readfrombuffer(buf)
        self.__field_outgoing_count=UINT(**{'sizeinbytes': 4})
        self.__field_outgoing_count.readfrombuffer(buf)
        self.__field_missed_count=UINT(**{'sizeinbytes': 4})
        self.__field_missed_count.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_incoming(self):
        return self.__field_incoming.getvalue()

    def __setfield_incoming(self, value):
        if isinstance(value,LIST):
            self.__field_incoming=value
        else:
            self.__field_incoming=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_incoming(self): del self.__field_incoming

    incoming=property(__getfield_incoming, __setfield_incoming, __delfield_incoming, None)

    def __getfield_outgoing(self):
        return self.__field_outgoing.getvalue()

    def __setfield_outgoing(self, value):
        if isinstance(value,LIST):
            self.__field_outgoing=value
        else:
            self.__field_outgoing=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_outgoing(self): del self.__field_outgoing

    outgoing=property(__getfield_outgoing, __setfield_outgoing, __delfield_outgoing, None)

    def __getfield_missed(self):
        return self.__field_missed.getvalue()

    def __setfield_missed(self, value):
        if isinstance(value,LIST):
            self.__field_missed=value
        else:
            self.__field_missed=LIST(value,**{ 'length': CL_MAX_ENTRIES,             'elementclass': cl_list })

    def __delfield_missed(self): del self.__field_missed

    missed=property(__getfield_missed, __setfield_missed, __delfield_missed, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 992})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_incoming_count(self):
        return self.__field_incoming_count.getvalue()

    def __setfield_incoming_count(self, value):
        if isinstance(value,UINT):
            self.__field_incoming_count=value
        else:
            self.__field_incoming_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_incoming_count(self): del self.__field_incoming_count

    incoming_count=property(__getfield_incoming_count, __setfield_incoming_count, __delfield_incoming_count, None)

    def __getfield_outgoing_count(self):
        return self.__field_outgoing_count.getvalue()

    def __setfield_outgoing_count(self, value):
        if isinstance(value,UINT):
            self.__field_outgoing_count=value
        else:
            self.__field_outgoing_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_outgoing_count(self): del self.__field_outgoing_count

    outgoing_count=property(__getfield_outgoing_count, __setfield_outgoing_count, __delfield_outgoing_count, None)

    def __getfield_missed_count(self):
        return self.__field_missed_count.getvalue()

    def __setfield_missed_count(self, value):
        if isinstance(value,UINT):
            self.__field_missed_count=value
        else:
            self.__field_missed_count=UINT(value,**{'sizeinbytes': 4})

    def __delfield_missed_count(self): del self.__field_missed_count

    missed_count=property(__getfield_missed_count, __setfield_missed_count, __delfield_missed_count, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('incoming', self.__field_incoming, None)
        yield ('outgoing', self.__field_outgoing, None)
        yield ('missed', self.__field_missed, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('incoming_count', self.__field_incoming_count, None)
        yield ('outgoing_count', self.__field_outgoing_count, None)
        yield ('missed_count', self.__field_missed_count, None)




class cl_file(BaseProtogenClass):
    __fields=['cl_type', 'number', 'datetime', 'duration']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(cl_file,self).__init__(**dict)
        if self.__class__ is cl_file:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(cl_file,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(cl_file,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_cl_type.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_datetime.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cl_type=UINT(**{'sizeinbytes': 1})
        self.__field_cl_type.readfrombuffer(buf)
        self.__field_number=STRING(**{'sizeinbytes': 35,  'terminator': 0 })
        self.__field_number.readfrombuffer(buf)
        self.__field_datetime=DateTime1(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cl_type(self):
        return self.__field_cl_type.getvalue()

    def __setfield_cl_type(self, value):
        if isinstance(value,UINT):
            self.__field_cl_type=value
        else:
            self.__field_cl_type=UINT(value,**{'sizeinbytes': 1})

    def __delfield_cl_type(self): del self.__field_cl_type

    cl_type=property(__getfield_cl_type, __setfield_cl_type, __delfield_cl_type, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{'sizeinbytes': 35,  'terminator': 0 })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime1):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime1(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cl_type', self.__field_cl_type, None)
        yield ('number', self.__field_number, None)
        yield ('datetime', self.__field_datetime, None)
        yield ('duration', self.__field_duration, None)

    def _valid(self):
        global CL_VALID_TYPE
        return bool(self.cl_type in CL_VALID_TYPE and self.number)
    valid=property(fget=_valid)




class NumberEntry(BaseProtogenClass):
    __fields=['number', 'option', 'speeddial', 'ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(NumberEntry,self).__init__(**dict)
        if self.__class__ is NumberEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(NumberEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(NumberEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_number.writetobuffer(buf)
        self.__field_option.writetobuffer(buf)
        if self.option & PB_FLG_SPEEDDIAL:
            self.__field_speeddial.writetobuffer(buf)
        if self.option & PB_FLG_RINGTONE:
            self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_number=STRING(**{ 'terminator': None,               'pascal': True })
        self.__field_number.readfrombuffer(buf)
        self.__field_option=UINT(**{'sizeinbytes': 1})
        self.__field_option.readfrombuffer(buf)
        if self.option & PB_FLG_SPEEDDIAL:
            self.__field_speeddial=UINT(**{'sizeinbytes': 2})
            self.__field_speeddial.readfrombuffer(buf)
        if self.option & PB_FLG_RINGTONE:
            self.__field_ringtone=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{ 'terminator': None,               'pascal': True })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_option(self):
        return self.__field_option.getvalue()

    def __setfield_option(self, value):
        if isinstance(value,UINT):
            self.__field_option=value
        else:
            self.__field_option=UINT(value,**{'sizeinbytes': 1})

    def __delfield_option(self): del self.__field_option

    option=property(__getfield_option, __setfield_option, __delfield_option, None)

    def __getfield_speeddial(self):
        return self.__field_speeddial.getvalue()

    def __setfield_speeddial(self, value):
        if isinstance(value,UINT):
            self.__field_speeddial=value
        else:
            self.__field_speeddial=UINT(value,**{'sizeinbytes': 2})

    def __delfield_speeddial(self): del self.__field_speeddial

    speeddial=property(__getfield_speeddial, __setfield_speeddial, __delfield_speeddial, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('number', self.__field_number, None)
        yield ('option', self.__field_option, None)
        if self.option & PB_FLG_SPEEDDIAL:
            yield ('speeddial', self.__field_speeddial, None)
        if self.option & PB_FLG_RINGTONE:
            yield ('ringtone', self.__field_ringtone, None)




class PBEntry(BaseProtogenClass):
    __fields=['info', 'zero1', 'name', 'email', 'email2', 'home', 'work', 'cell', 'fax', 'cell2', 'datetime', 'group', 'ringtone', 'wallpaper', 'wallpaper_range']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PBEntry,self).__init__(**dict)
        if self.__class__ is PBEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PBEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PBEntry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_info.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_zero1.writetobuffer(buf)
        if self.info & PB_FLG_NAME:
            self.__field_name.writetobuffer(buf)
        if self.info & PB_FLG_EMAIL:
            self.__field_email.writetobuffer(buf)
        if self.info & PB_FLG_EMAIL2:
            self.__field_email2.writetobuffer(buf)
        if self.info & PB_FLG_HOME:
            self.__field_home.writetobuffer(buf)
        if self.info & PB_FLG_WORK:
            self.__field_work.writetobuffer(buf)
        if self.info & PB_FLG_CELL:
            self.__field_cell.writetobuffer(buf)
        if self.info & PB_FLG_FAX:
            self.__field_fax.writetobuffer(buf)
        if self.info & PB_FLG_CELL2:
            self.__field_cell2.writetobuffer(buf)
        if self.info & PB_FLG_DATE:
            self.__field_datetime.writetobuffer(buf)
        if self.info & PB_FLG_GROUP:
            self.__field_group.writetobuffer(buf)
        if self.info & PB_FLG_CRINGTONE:
            self.__field_ringtone.writetobuffer(buf)
        if self.info & PB_FLG_WP:
            self.__field_wallpaper.writetobuffer(buf)
            self.__field_wallpaper_range.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_info=UINT(**{'sizeinbytes': 2})
        self.__field_info.readfrombuffer(buf)
        self.__field_zero1=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_zero1.readfrombuffer(buf)
        if self.info & PB_FLG_NAME:
            self.__field_name=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })
            self.__field_name.readfrombuffer(buf)
        if self.info & PB_FLG_EMAIL:
            self.__field_email=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })
            self.__field_email.readfrombuffer(buf)
        if self.info & PB_FLG_EMAIL2:
            self.__field_email2=USTRING(**{ 'terminator': None,                    'encoding': ENCODING,                   'pascal': True })
            self.__field_email2.readfrombuffer(buf)
        if self.info & PB_FLG_HOME:
            self.__field_home=NumberEntry()
            self.__field_home.readfrombuffer(buf)
        if self.info & PB_FLG_WORK:
            self.__field_work=NumberEntry()
            self.__field_work.readfrombuffer(buf)
        if self.info & PB_FLG_CELL:
            self.__field_cell=NumberEntry()
            self.__field_cell.readfrombuffer(buf)
        if self.info & PB_FLG_FAX:
            self.__field_fax=NumberEntry()
            self.__field_fax.readfrombuffer(buf)
        if self.info & PB_FLG_CELL2:
            self.__field_cell2=NumberEntry()
            self.__field_cell2.readfrombuffer(buf)
        if self.info & PB_FLG_DATE:
            self.__field_datetime=DateTime(**{'sizeinbytes': 4})
            self.__field_datetime.readfrombuffer(buf)
        if self.info & PB_FLG_GROUP:
            self.__field_group=UINT(**{'sizeinbytes': 1})
            self.__field_group.readfrombuffer(buf)
        if self.info & PB_FLG_CRINGTONE:
            self.__field_ringtone=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_ringtone.readfrombuffer(buf)
        if self.info & PB_FLG_WP:
            self.__field_wallpaper=STRING(**{ 'terminator': None,                   'pascal': True })
            self.__field_wallpaper.readfrombuffer(buf)
            self.__field_wallpaper_range=UINT(**{'sizeinbytes': 4})
            self.__field_wallpaper_range.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_info(self):
        return self.__field_info.getvalue()

    def __setfield_info(self, value):
        if isinstance(value,UINT):
            self.__field_info=value
        else:
            self.__field_info=UINT(value,**{'sizeinbytes': 2})

    def __delfield_info(self): del self.__field_info

    info=property(__getfield_info, __setfield_info, __delfield_info, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UINT):
            self.__field_zero1=value
        else:
            self.__field_zero1=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_email(self):
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                    'pascal': True })

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def __getfield_email2(self):
        return self.__field_email2.getvalue()

    def __setfield_email2(self, value):
        if isinstance(value,USTRING):
            self.__field_email2=value
        else:
            self.__field_email2=USTRING(value,**{ 'terminator': None,                    'encoding': ENCODING,                   'pascal': True })

    def __delfield_email2(self): del self.__field_email2

    email2=property(__getfield_email2, __setfield_email2, __delfield_email2, None)

    def __getfield_home(self):
        return self.__field_home.getvalue()

    def __setfield_home(self, value):
        if isinstance(value,NumberEntry):
            self.__field_home=value
        else:
            self.__field_home=NumberEntry(value,)

    def __delfield_home(self): del self.__field_home

    home=property(__getfield_home, __setfield_home, __delfield_home, None)

    def __getfield_work(self):
        return self.__field_work.getvalue()

    def __setfield_work(self, value):
        if isinstance(value,NumberEntry):
            self.__field_work=value
        else:
            self.__field_work=NumberEntry(value,)

    def __delfield_work(self): del self.__field_work

    work=property(__getfield_work, __setfield_work, __delfield_work, None)

    def __getfield_cell(self):
        return self.__field_cell.getvalue()

    def __setfield_cell(self, value):
        if isinstance(value,NumberEntry):
            self.__field_cell=value
        else:
            self.__field_cell=NumberEntry(value,)

    def __delfield_cell(self): del self.__field_cell

    cell=property(__getfield_cell, __setfield_cell, __delfield_cell, None)

    def __getfield_fax(self):
        return self.__field_fax.getvalue()

    def __setfield_fax(self, value):
        if isinstance(value,NumberEntry):
            self.__field_fax=value
        else:
            self.__field_fax=NumberEntry(value,)

    def __delfield_fax(self): del self.__field_fax

    fax=property(__getfield_fax, __setfield_fax, __delfield_fax, None)

    def __getfield_cell2(self):
        return self.__field_cell2.getvalue()

    def __setfield_cell2(self, value):
        if isinstance(value,NumberEntry):
            self.__field_cell2=value
        else:
            self.__field_cell2=NumberEntry(value,)

    def __delfield_cell2(self): del self.__field_cell2

    cell2=property(__getfield_cell2, __setfield_cell2, __delfield_cell2, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_group(self):
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 1})

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,STRING):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=STRING(value,**{ 'terminator': None,                   'pascal': True })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_wallpaper_range(self):
        return self.__field_wallpaper_range.getvalue()

    def __setfield_wallpaper_range(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper_range=value
        else:
            self.__field_wallpaper_range=UINT(value,**{'sizeinbytes': 4})

    def __delfield_wallpaper_range(self): del self.__field_wallpaper_range

    wallpaper_range=property(__getfield_wallpaper_range, __setfield_wallpaper_range, __delfield_wallpaper_range, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('info', self.__field_info, None)
        yield ('zero1', self.__field_zero1, None)
        if self.info & PB_FLG_NAME:
            yield ('name', self.__field_name, None)
        if self.info & PB_FLG_EMAIL:
            yield ('email', self.__field_email, None)
        if self.info & PB_FLG_EMAIL2:
            yield ('email2', self.__field_email2, None)
        if self.info & PB_FLG_HOME:
            yield ('home', self.__field_home, None)
        if self.info & PB_FLG_WORK:
            yield ('work', self.__field_work, None)
        if self.info & PB_FLG_CELL:
            yield ('cell', self.__field_cell, None)
        if self.info & PB_FLG_FAX:
            yield ('fax', self.__field_fax, None)
        if self.info & PB_FLG_CELL2:
            yield ('cell2', self.__field_cell2, None)
        if self.info & PB_FLG_DATE:
            yield ('datetime', self.__field_datetime, None)
        if self.info & PB_FLG_GROUP:
            yield ('group', self.__field_group, None)
        if self.info & PB_FLG_CRINGTONE:
            yield ('ringtone', self.__field_ringtone, None)
        if self.info & PB_FLG_WP:
            yield ('wallpaper', self.__field_wallpaper, None)
            yield ('wallpaper_range', self.__field_wallpaper_range, None)




class ss_number_entry(BaseProtogenClass):
    __fields=['number', 'speeddial', 'primary', 'zero', 'ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_number_entry,self).__init__(**dict)
        if self.__class__ is ss_number_entry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_number_entry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_number_entry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_number
        except:
            self.__field_number=STRING(**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })
        self.__field_number.writetobuffer(buf)
        try: self.__field_speeddial
        except:
            self.__field_speeddial=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_speeddial.writetobuffer(buf)
        try: self.__field_primary
        except:
            self.__field_primary=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_primary.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=STRING(**{'sizeinbytes': 8,  'pad': 0,               'default': '' })
        self.__field_zero.writetobuffer(buf)
        try: self.__field_ringtone
        except:
            self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_number=STRING(**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })
        self.__field_number.readfrombuffer(buf)
        self.__field_speeddial=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_speeddial.readfrombuffer(buf)
        self.__field_primary=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_primary.readfrombuffer(buf)
        self.__field_zero=STRING(**{'sizeinbytes': 8,  'pad': 0,               'default': '' })
        self.__field_zero.readfrombuffer(buf)
        self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=STRING(**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,STRING):
            self.__field_number=value
        else:
            self.__field_number=STRING(value,**{ 'terminator': 0,               'default': '',               'maxsizeinbytes': PB_MAX_NUMBER_LEN,               'raiseontruncate': False })

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_speeddial(self):
        try: self.__field_speeddial
        except:
            self.__field_speeddial=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_speeddial.getvalue()

    def __setfield_speeddial(self, value):
        if isinstance(value,UINT):
            self.__field_speeddial=value
        else:
            self.__field_speeddial=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_speeddial(self): del self.__field_speeddial

    speeddial=property(__getfield_speeddial, __setfield_speeddial, __delfield_speeddial, None)

    def __getfield_primary(self):
        try: self.__field_primary
        except:
            self.__field_primary=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_primary.getvalue()

    def __setfield_primary(self, value):
        if isinstance(value,UINT):
            self.__field_primary=value
        else:
            self.__field_primary=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_primary(self): del self.__field_primary

    primary=property(__getfield_primary, __setfield_primary, __delfield_primary, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=STRING(**{'sizeinbytes': 8,  'pad': 0,               'default': '' })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,STRING):
            self.__field_zero=value
        else:
            self.__field_zero=STRING(value,**{'sizeinbytes': 8,  'pad': 0,               'default': '' })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': 0,               'default': '' })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('number', self.__field_number, None)
        yield ('speeddial', self.__field_speeddial, None)
        yield ('primary', self.__field_primary, None)
        yield ('zero', self.__field_zero, None)
        yield ('ringtone', self.__field_ringtone, None)




class ss_pb_entry(BaseProtogenClass):
    __fields=['name', 'email', 'email2', 'zero1', 'ringtone', 'wallpaper', 'zero2', 'home', 'work', 'cell', 'dummy', 'fax', 'cell2', 'zero3', 'group', 'zero4']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_entry,self).__init__(**dict)
        if self.__class__ is ss_pb_entry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_entry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_entry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_name.writetobuffer(buf)
        try: self.__field_email
        except:
            self.__field_email=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email.writetobuffer(buf)
        try: self.__field_email2
        except:
            self.__field_email2=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email2.writetobuffer(buf)
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 3,  'default': 0 })
        self.__field_zero1.writetobuffer(buf)
        try: self.__field_ringtone
        except:
            self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_ringtone.writetobuffer(buf)
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_wallpaper.writetobuffer(buf)
        try: self.__field_zero2
        except:
            self.__field_zero2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero2.writetobuffer(buf)
        try: self.__field_home
        except:
            self.__field_home=ss_number_entry()
        self.__field_home.writetobuffer(buf)
        try: self.__field_work
        except:
            self.__field_work=ss_number_entry()
        self.__field_work.writetobuffer(buf)
        try: self.__field_cell
        except:
            self.__field_cell=ss_number_entry()
        self.__field_cell.writetobuffer(buf)
        try: self.__field_dummy
        except:
            self.__field_dummy=ss_number_entry()
        self.__field_dummy.writetobuffer(buf)
        try: self.__field_fax
        except:
            self.__field_fax=ss_number_entry()
        self.__field_fax.writetobuffer(buf)
        try: self.__field_cell2
        except:
            self.__field_cell2=ss_number_entry()
        self.__field_cell2.writetobuffer(buf)
        try: self.__field_zero3
        except:
            self.__field_zero3=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_zero3.writetobuffer(buf)
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_group.writetobuffer(buf)
        try: self.__field_zero4
        except:
            self.__field_zero4=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_zero4.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=USTRING(**{ 'terminator': 0,                'maxsizeinbytes': PB_MAX_NAME_LEN,                'encoding': ENCODING,                'raiseontruncate': False })
        self.__field_name.readfrombuffer(buf)
        self.__field_email=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email.readfrombuffer(buf)
        self.__field_email2=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        self.__field_email2.readfrombuffer(buf)
        self.__field_zero1=UINT(**{'sizeinbytes': 3,  'default': 0 })
        self.__field_zero1.readfrombuffer(buf)
        self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_wallpaper=STRING(**{ 'terminator': 0,               'default': '' })
        self.__field_wallpaper.readfrombuffer(buf)
        self.__field_zero2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero2.readfrombuffer(buf)
        self.__field_home=ss_number_entry()
        self.__field_home.readfrombuffer(buf)
        self.__field_work=ss_number_entry()
        self.__field_work.readfrombuffer(buf)
        self.__field_cell=ss_number_entry()
        self.__field_cell.readfrombuffer(buf)
        self.__field_dummy=ss_number_entry()
        self.__field_dummy.readfrombuffer(buf)
        self.__field_fax=ss_number_entry()
        self.__field_fax.readfrombuffer(buf)
        self.__field_cell2=ss_number_entry()
        self.__field_cell2.readfrombuffer(buf)
        self.__field_zero3=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_zero3.readfrombuffer(buf)
        self.__field_group=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_group.readfrombuffer(buf)
        self.__field_zero4=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_zero4.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{ 'terminator': 0,                'maxsizeinbytes': PB_MAX_NAME_LEN,                'encoding': ENCODING,                'raiseontruncate': False })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_email(self):
        try: self.__field_email
        except:
            self.__field_email=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def __getfield_email2(self):
        try: self.__field_email2
        except:
            self.__field_email2=USTRING(**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })
        return self.__field_email2.getvalue()

    def __setfield_email2(self, value):
        if isinstance(value,USTRING):
            self.__field_email2=value
        else:
            self.__field_email2=USTRING(value,**{ 'terminator': 0,                'encoding': ENCODING,                'default': '',                'maxsizeinbytes': PB_MAX_EMAIL_LEN,                'raiseontruncate': False })

    def __delfield_email2(self): del self.__field_email2

    email2=property(__getfield_email2, __setfield_email2, __delfield_email2, None)

    def __getfield_zero1(self):
        try: self.__field_zero1
        except:
            self.__field_zero1=UINT(**{'sizeinbytes': 3,  'default': 0 })
        return self.__field_zero1.getvalue()

    def __setfield_zero1(self, value):
        if isinstance(value,UINT):
            self.__field_zero1=value
        else:
            self.__field_zero1=UINT(value,**{'sizeinbytes': 3,  'default': 0 })

    def __delfield_zero1(self): del self.__field_zero1

    zero1=property(__getfield_zero1, __setfield_zero1, __delfield_zero1, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=STRING(**{ 'terminator': 0,               'default': '' })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,STRING):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=STRING(value,**{ 'terminator': 0,               'default': '' })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=STRING(**{ 'terminator': 0,               'default': '' })
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,STRING):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=STRING(value,**{ 'terminator': 0,               'default': '' })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_zero2(self):
        try: self.__field_zero2
        except:
            self.__field_zero2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_zero2.getvalue()

    def __setfield_zero2(self, value):
        if isinstance(value,UINT):
            self.__field_zero2=value
        else:
            self.__field_zero2=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_zero2(self): del self.__field_zero2

    zero2=property(__getfield_zero2, __setfield_zero2, __delfield_zero2, None)

    def __getfield_home(self):
        try: self.__field_home
        except:
            self.__field_home=ss_number_entry()
        return self.__field_home.getvalue()

    def __setfield_home(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_home=value
        else:
            self.__field_home=ss_number_entry(value,)

    def __delfield_home(self): del self.__field_home

    home=property(__getfield_home, __setfield_home, __delfield_home, None)

    def __getfield_work(self):
        try: self.__field_work
        except:
            self.__field_work=ss_number_entry()
        return self.__field_work.getvalue()

    def __setfield_work(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_work=value
        else:
            self.__field_work=ss_number_entry(value,)

    def __delfield_work(self): del self.__field_work

    work=property(__getfield_work, __setfield_work, __delfield_work, None)

    def __getfield_cell(self):
        try: self.__field_cell
        except:
            self.__field_cell=ss_number_entry()
        return self.__field_cell.getvalue()

    def __setfield_cell(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_cell=value
        else:
            self.__field_cell=ss_number_entry(value,)

    def __delfield_cell(self): del self.__field_cell

    cell=property(__getfield_cell, __setfield_cell, __delfield_cell, None)

    def __getfield_dummy(self):
        try: self.__field_dummy
        except:
            self.__field_dummy=ss_number_entry()
        return self.__field_dummy.getvalue()

    def __setfield_dummy(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_dummy=value
        else:
            self.__field_dummy=ss_number_entry(value,)

    def __delfield_dummy(self): del self.__field_dummy

    dummy=property(__getfield_dummy, __setfield_dummy, __delfield_dummy, None)

    def __getfield_fax(self):
        try: self.__field_fax
        except:
            self.__field_fax=ss_number_entry()
        return self.__field_fax.getvalue()

    def __setfield_fax(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_fax=value
        else:
            self.__field_fax=ss_number_entry(value,)

    def __delfield_fax(self): del self.__field_fax

    fax=property(__getfield_fax, __setfield_fax, __delfield_fax, None)

    def __getfield_cell2(self):
        try: self.__field_cell2
        except:
            self.__field_cell2=ss_number_entry()
        return self.__field_cell2.getvalue()

    def __setfield_cell2(self, value):
        if isinstance(value,ss_number_entry):
            self.__field_cell2=value
        else:
            self.__field_cell2=ss_number_entry(value,)

    def __delfield_cell2(self): del self.__field_cell2

    cell2=property(__getfield_cell2, __setfield_cell2, __delfield_cell2, None)

    def __getfield_zero3(self):
        try: self.__field_zero3
        except:
            self.__field_zero3=UINT(**{'sizeinbytes': 4,  'default': 0 })
        return self.__field_zero3.getvalue()

    def __setfield_zero3(self, value):
        if isinstance(value,UINT):
            self.__field_zero3=value
        else:
            self.__field_zero3=UINT(value,**{'sizeinbytes': 4,  'default': 0 })

    def __delfield_zero3(self): del self.__field_zero3

    zero3=property(__getfield_zero3, __setfield_zero3, __delfield_zero3, None)

    def __getfield_group(self):
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_zero4(self):
        try: self.__field_zero4
        except:
            self.__field_zero4=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_zero4.getvalue()

    def __setfield_zero4(self, value):
        if isinstance(value,UINT):
            self.__field_zero4=value
        else:
            self.__field_zero4=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_zero4(self): del self.__field_zero4

    zero4=property(__getfield_zero4, __setfield_zero4, __delfield_zero4, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('email', self.__field_email, None)
        yield ('email2', self.__field_email2, None)
        yield ('zero1', self.__field_zero1, None)
        yield ('ringtone', self.__field_ringtone, None)
        yield ('wallpaper', self.__field_wallpaper, None)
        yield ('zero2', self.__field_zero2, None)
        yield ('home', self.__field_home, None)
        yield ('work', self.__field_work, None)
        yield ('cell', self.__field_cell, None)
        yield ('dummy', self.__field_dummy, None)
        yield ('fax', self.__field_fax, None)
        yield ('cell2', self.__field_cell2, None)
        yield ('zero3', self.__field_zero3, None)
        yield ('group', self.__field_group, None)
        yield ('zero4', self.__field_zero4, None)




class ss_pb_write_req(BaseProtogenClass):
    __fields=['hdr', 'zero', 'entry']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_write_req,self).__init__(**dict)
        if self.__class__ is ss_pb_write_req:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_write_req,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_write_req,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_WRITE })
        self.__field_hdr.writetobuffer(buf)
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_WRITE })
        self.__field_hdr.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_zero.readfrombuffer(buf)
        self.__field_entry=ss_pb_entry()
        self.__field_entry.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        try: self.__field_hdr
        except:
            self.__field_hdr=ss_cmd_hdr(**{ 'command': SS_CMD_PB_WRITE })
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,**{ 'command': SS_CMD_PB_WRITE })

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_zero(self):
        try: self.__field_zero
        except:
            self.__field_zero=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,ss_pb_entry):
            self.__field_entry=value
        else:
            self.__field_entry=ss_pb_entry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('zero', self.__field_zero, None)
        yield ('entry', self.__field_entry, None)




class ss_pb_write_resp(BaseProtogenClass):
    __fields=['hdr', 'zero', 'index']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ss_pb_write_resp,self).__init__(**dict)
        if self.__class__ is ss_pb_write_resp:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ss_pb_write_resp,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ss_pb_write_resp,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_hdr.writetobuffer(buf)
        self.__field_zero.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_hdr=ss_cmd_hdr()
        self.__field_hdr.readfrombuffer(buf)
        self.__field_zero=UINT(**{'sizeinbytes': 1})
        self.__field_zero.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_hdr(self):
        return self.__field_hdr.getvalue()

    def __setfield_hdr(self, value):
        if isinstance(value,ss_cmd_hdr):
            self.__field_hdr=value
        else:
            self.__field_hdr=ss_cmd_hdr(value,)

    def __delfield_hdr(self): del self.__field_hdr

    hdr=property(__getfield_hdr, __setfield_hdr, __delfield_hdr, None)

    def __getfield_zero(self):
        return self.__field_zero.getvalue()

    def __setfield_zero(self, value):
        if isinstance(value,UINT):
            self.__field_zero=value
        else:
            self.__field_zero=UINT(value,**{'sizeinbytes': 1})

    def __delfield_zero(self): del self.__field_zero

    zero=property(__getfield_zero, __setfield_zero, __delfield_zero, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('hdr', self.__field_hdr, None)
        yield ('zero', self.__field_zero, None)
        yield ('index', self.__field_index, None)




class pBOOL(BaseProtogenClass):
    __fields=['value']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pBOOL,self).__init__(**dict)
        if self.__class__ is pBOOL:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pBOOL,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pBOOL,kwargs)
        if len(args):
            dict2={'sizeinbytes': 'P'}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_value=BOOL(*args,**dict2)
        # Make all P fields that haven't already been constructed
        try: self.__field_value
        except:
            self.__field_value=BOOL()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_value(self):
        return self.__field_value.getvalue()

    def __setfield_value(self, value):
        if isinstance(value,BOOL):
            self.__field_value=value
        else:
            self.__field_value=BOOL(value,)

    def __delfield_value(self): del self.__field_value

    value=property(__getfield_value, __setfield_value, __delfield_value, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('value', self.__field_value, None)




class sms_header(BaseProtogenClass):
    __fields=['index', 'msg_len', 'callback_len', 'bitmap1', 'bitmap2', 'dunno1', 'body_len', 'file_type', 'msg_type', 'enhance_delivery', 'is_txt_msg', 'in_msg', 'sent_msg', 'draft_msg', 'body']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_header,self).__init__(**dict)
        if self.__class__ is sms_header:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_header,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_header,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_index.writetobuffer(buf)
        self.__field_msg_len.writetobuffer(buf)
        self.__field_callback_len.writetobuffer(buf)
        self.__field_bitmap1.writetobuffer(buf)
        self.__field_bitmap2.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_body_len.writetobuffer(buf)
        self.__field_file_type.writetobuffer(buf)
        self.__field_msg_type.writetobuffer(buf)
        self.__field_enhance_delivery.writetobuffer(buf)
        self.__field_is_txt_msg.writetobuffer(buf)
        self.__field_in_msg.writetobuffer(buf)
        self.__field_sent_msg.writetobuffer(buf)
        self.__field_draft_msg.writetobuffer(buf)
        if self.is_txt_msg.value:
            self.__field_body.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 2})
        self.__field_index.readfrombuffer(buf)
        self.__field_msg_len=UINT(**{'sizeinbytes': 1})
        self.__field_msg_len.readfrombuffer(buf)
        self.__field_callback_len=UINT(**{'sizeinbytes': 1})
        self.__field_callback_len.readfrombuffer(buf)
        self.__field_bitmap1=UINT(**{'sizeinbytes': 1})
        self.__field_bitmap1.readfrombuffer(buf)
        self.__field_bitmap2=UINT(**{'sizeinbytes': 1})
        self.__field_bitmap2.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_body_len=UINT(**{'sizeinbytes': 2})
        self.__field_body_len.readfrombuffer(buf)
        self.__field_file_type=UINT(**{'sizeinbytes': 2})
        self.__field_file_type.readfrombuffer(buf)
        self.__field_msg_type=UINT(**{'sizeinbytes': 1})
        self.__field_msg_type.readfrombuffer(buf)
        self.__field_enhance_delivery=UINT(**{'sizeinbytes': 1})
        self.__field_enhance_delivery.readfrombuffer(buf)
        self.__field_is_txt_msg=pBOOL(**{ 'value': self.file_type==SMS_TXT_TYPE and self.msg_type in SMS_VALID_TYPE })
        self.__field_is_txt_msg.readfrombuffer(buf)
        self.__field_in_msg=pBOOL(**{ 'value': self.msg_type==SMS_TYPE_IN })
        self.__field_in_msg.readfrombuffer(buf)
        self.__field_sent_msg=pBOOL(**{ 'value': self.msg_type==SMS_TYPE_SENT })
        self.__field_sent_msg.readfrombuffer(buf)
        self.__field_draft_msg=pBOOL(**{ 'value': self.msg_type==SMS_TYPE_DRAFT })
        self.__field_draft_msg.readfrombuffer(buf)
        if self.is_txt_msg.value:
            self.__field_body=sms_body(**{            'msg_len': self.msg_len,            'has_callback': self.bitmap2 & SMS_FLG2_CALLBACK,            'has_priority': self.bitmap2 & SMS_FLG2_PRIORITY,            'has_1byte': self.bitmap2 & SMS_FLG2_SOMETHING,            'has_1byte2': self.bitmap2 & SMS_FLG2_MSG,            'has_40bytes': self.bitmap1 & SMS_FLG1_HAS40 })
            self.__field_body.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_msg_len(self):
        return self.__field_msg_len.getvalue()

    def __setfield_msg_len(self, value):
        if isinstance(value,UINT):
            self.__field_msg_len=value
        else:
            self.__field_msg_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msg_len(self): del self.__field_msg_len

    msg_len=property(__getfield_msg_len, __setfield_msg_len, __delfield_msg_len, None)

    def __getfield_callback_len(self):
        return self.__field_callback_len.getvalue()

    def __setfield_callback_len(self, value):
        if isinstance(value,UINT):
            self.__field_callback_len=value
        else:
            self.__field_callback_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_len(self): del self.__field_callback_len

    callback_len=property(__getfield_callback_len, __setfield_callback_len, __delfield_callback_len, None)

    def __getfield_bitmap1(self):
        return self.__field_bitmap1.getvalue()

    def __setfield_bitmap1(self, value):
        if isinstance(value,UINT):
            self.__field_bitmap1=value
        else:
            self.__field_bitmap1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_bitmap1(self): del self.__field_bitmap1

    bitmap1=property(__getfield_bitmap1, __setfield_bitmap1, __delfield_bitmap1, None)

    def __getfield_bitmap2(self):
        return self.__field_bitmap2.getvalue()

    def __setfield_bitmap2(self, value):
        if isinstance(value,UINT):
            self.__field_bitmap2=value
        else:
            self.__field_bitmap2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_bitmap2(self): del self.__field_bitmap2

    bitmap2=property(__getfield_bitmap2, __setfield_bitmap2, __delfield_bitmap2, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_body_len(self):
        return self.__field_body_len.getvalue()

    def __setfield_body_len(self, value):
        if isinstance(value,UINT):
            self.__field_body_len=value
        else:
            self.__field_body_len=UINT(value,**{'sizeinbytes': 2})

    def __delfield_body_len(self): del self.__field_body_len

    body_len=property(__getfield_body_len, __setfield_body_len, __delfield_body_len, None)

    def __getfield_file_type(self):
        return self.__field_file_type.getvalue()

    def __setfield_file_type(self, value):
        if isinstance(value,UINT):
            self.__field_file_type=value
        else:
            self.__field_file_type=UINT(value,**{'sizeinbytes': 2})

    def __delfield_file_type(self): del self.__field_file_type

    file_type=property(__getfield_file_type, __setfield_file_type, __delfield_file_type, None)

    def __getfield_msg_type(self):
        return self.__field_msg_type.getvalue()

    def __setfield_msg_type(self, value):
        if isinstance(value,UINT):
            self.__field_msg_type=value
        else:
            self.__field_msg_type=UINT(value,**{'sizeinbytes': 1})

    def __delfield_msg_type(self): del self.__field_msg_type

    msg_type=property(__getfield_msg_type, __setfield_msg_type, __delfield_msg_type, None)

    def __getfield_enhance_delivery(self):
        return self.__field_enhance_delivery.getvalue()

    def __setfield_enhance_delivery(self, value):
        if isinstance(value,UINT):
            self.__field_enhance_delivery=value
        else:
            self.__field_enhance_delivery=UINT(value,**{'sizeinbytes': 1})

    def __delfield_enhance_delivery(self): del self.__field_enhance_delivery

    enhance_delivery=property(__getfield_enhance_delivery, __setfield_enhance_delivery, __delfield_enhance_delivery, None)

    def __getfield_is_txt_msg(self):
        return self.__field_is_txt_msg.getvalue()

    def __setfield_is_txt_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_is_txt_msg=value
        else:
            self.__field_is_txt_msg=pBOOL(value,**{ 'value': self.file_type==SMS_TXT_TYPE and self.msg_type in SMS_VALID_TYPE })

    def __delfield_is_txt_msg(self): del self.__field_is_txt_msg

    is_txt_msg=property(__getfield_is_txt_msg, __setfield_is_txt_msg, __delfield_is_txt_msg, None)

    def __getfield_in_msg(self):
        return self.__field_in_msg.getvalue()

    def __setfield_in_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_in_msg=value
        else:
            self.__field_in_msg=pBOOL(value,**{ 'value': self.msg_type==SMS_TYPE_IN })

    def __delfield_in_msg(self): del self.__field_in_msg

    in_msg=property(__getfield_in_msg, __setfield_in_msg, __delfield_in_msg, None)

    def __getfield_sent_msg(self):
        return self.__field_sent_msg.getvalue()

    def __setfield_sent_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_sent_msg=value
        else:
            self.__field_sent_msg=pBOOL(value,**{ 'value': self.msg_type==SMS_TYPE_SENT })

    def __delfield_sent_msg(self): del self.__field_sent_msg

    sent_msg=property(__getfield_sent_msg, __setfield_sent_msg, __delfield_sent_msg, None)

    def __getfield_draft_msg(self):
        return self.__field_draft_msg.getvalue()

    def __setfield_draft_msg(self, value):
        if isinstance(value,pBOOL):
            self.__field_draft_msg=value
        else:
            self.__field_draft_msg=pBOOL(value,**{ 'value': self.msg_type==SMS_TYPE_DRAFT })

    def __delfield_draft_msg(self): del self.__field_draft_msg

    draft_msg=property(__getfield_draft_msg, __setfield_draft_msg, __delfield_draft_msg, None)

    def __getfield_body(self):
        return self.__field_body.getvalue()

    def __setfield_body(self, value):
        if isinstance(value,sms_body):
            self.__field_body=value
        else:
            self.__field_body=sms_body(value,**{            'msg_len': self.msg_len,            'has_callback': self.bitmap2 & SMS_FLG2_CALLBACK,            'has_priority': self.bitmap2 & SMS_FLG2_PRIORITY,            'has_1byte': self.bitmap2 & SMS_FLG2_SOMETHING,            'has_1byte2': self.bitmap2 & SMS_FLG2_MSG,            'has_40bytes': self.bitmap1 & SMS_FLG1_HAS40 })

    def __delfield_body(self): del self.__field_body

    body=property(__getfield_body, __setfield_body, __delfield_body, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)
        yield ('msg_len', self.__field_msg_len, None)
        yield ('callback_len', self.__field_callback_len, None)
        yield ('bitmap1', self.__field_bitmap1, None)
        yield ('bitmap2', self.__field_bitmap2, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('body_len', self.__field_body_len, None)
        yield ('file_type', self.__field_file_type, None)
        yield ('msg_type', self.__field_msg_type, None)
        yield ('enhance_delivery', self.__field_enhance_delivery, None)
        yield ('is_txt_msg', self.__field_is_txt_msg, None)
        yield ('in_msg', self.__field_in_msg, None)
        yield ('sent_msg', self.__field_sent_msg, None)
        yield ('draft_msg', self.__field_draft_msg, None)
        if self.is_txt_msg.value:
            yield ('body', self.__field_body, None)




class sms_msg_stat_list(BaseProtogenClass):
    __fields=['status']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_msg_stat_list,self).__init__(**dict)
        if self.__class__ is sms_msg_stat_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_msg_stat_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_msg_stat_list,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_status=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_status.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_status=UINT(**{'sizeinbytes': 1})
        self.__field_status.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('status', self.__field_status, None)




class sms_datetime_list(BaseProtogenClass):
    __fields=['datetime', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_datetime_list,self).__init__(**dict)
        if self.__class__ is sms_datetime_list:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_datetime_list,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_datetime_list,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_datetime.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_datetime=DateTime1(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        self.__field_dunno=UNKNOWN(**{'sizeinbytes': 4})
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime1):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime1(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno=value
        else:
            self.__field_dunno=UNKNOWN(value,**{'sizeinbytes': 4})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('datetime', self.__field_datetime, None)
        yield ('dunno', self.__field_dunno, None)




class sms_delivered_datetime(BaseProtogenClass):
    __fields=['datetime', 'dunno']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_delivered_datetime,self).__init__(**dict)
        if self.__class__ is sms_delivered_datetime:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_delivered_datetime,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_delivered_datetime,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_datetime.writetobuffer(buf)
        self.__field_dunno.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_datetime=LIST(**{ 'elementclass': sms_datetime_list,             'length': 10 })
        self.__field_datetime.readfrombuffer(buf)
        self.__field_dunno=UNKNOWN(**{'sizeinbytes': 20})
        self.__field_dunno.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,LIST):
            self.__field_datetime=value
        else:
            self.__field_datetime=LIST(value,**{ 'elementclass': sms_datetime_list,             'length': 10 })

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_dunno(self):
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno=value
        else:
            self.__field_dunno=UNKNOWN(value,**{'sizeinbytes': 20})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('datetime', self.__field_datetime, None)
        yield ('dunno', self.__field_dunno, None)




class sms_body(BaseProtogenClass):
    __fields=['msg_len', 'has_callback', 'has_priority', 'has_1byte', 'has_1byte2', 'has_40bytes', 'dunno1', 'msg', 'dunno2', 'callback_len', 'callback', 'priority', 'dunno3', 'dunno4', 'datetime', 'dunno5', 'addr_len0', 'addr_len1', 'addr_len2', 'addr_len3', 'addr_len4', 'addr_len5', 'addr_len6', 'addr_len7', 'addr_len8', 'addr_len9', 'addr0', 'addr1', 'addr2', 'addr3', 'addr4', 'addr5', 'addr6', 'addr7', 'addr8', 'addr9', 'dunno6', 'dunno7', 'dunno8', 'dunno9', 'msg_stat']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sms_body,self).__init__(**dict)
        if self.__class__ is sms_body:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sms_body,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sms_body,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_msg_len
        except:
            self.__field_msg_len=UINT()
        try: self.__field_has_callback
        except:
            self.__field_has_callback=BOOL(**{ 'default': True })
        try: self.__field_has_priority
        except:
            self.__field_has_priority=BOOL(**{ 'default': False })
        try: self.__field_has_1byte
        except:
            self.__field_has_1byte=BOOL(**{ 'default': False })
        try: self.__field_has_1byte2
        except:
            self.__field_has_1byte2=BOOL(**{ 'default': True })
        try: self.__field_has_40bytes
        except:
            self.__field_has_40bytes=BOOL(**{ 'default': False })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_dunno1.writetobuffer(buf)
        self.__field_msg.writetobuffer(buf)
        if self.has_callback:
            self.__field_dunno2.writetobuffer(buf)
            self.__field_callback_len.writetobuffer(buf)
            self.__field_callback.writetobuffer(buf)
        if self.has_priority:
            self.__field_priority.writetobuffer(buf)
        if self.has_1byte:
            self.__field_dunno3.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self.__field_datetime.writetobuffer(buf)
        self.__field_dunno5.writetobuffer(buf)
        self.__field_addr_len0.writetobuffer(buf)
        self.__field_addr_len1.writetobuffer(buf)
        self.__field_addr_len2.writetobuffer(buf)
        self.__field_addr_len3.writetobuffer(buf)
        self.__field_addr_len4.writetobuffer(buf)
        self.__field_addr_len5.writetobuffer(buf)
        self.__field_addr_len6.writetobuffer(buf)
        self.__field_addr_len7.writetobuffer(buf)
        self.__field_addr_len8.writetobuffer(buf)
        self.__field_addr_len9.writetobuffer(buf)
        if self.addr_len0:
            self.__field_addr0.writetobuffer(buf)
        if self.addr_len1:
            self.__field_addr1.writetobuffer(buf)
        if self.addr_len2:
            self.__field_addr2.writetobuffer(buf)
        if self.addr_len3:
            self.__field_addr3.writetobuffer(buf)
        if self.addr_len4:
            self.__field_addr4.writetobuffer(buf)
        if self.addr_len5:
            self.__field_addr5.writetobuffer(buf)
        if self.addr_len6:
            self.__field_addr6.writetobuffer(buf)
        if self.addr_len7:
            self.__field_addr7.writetobuffer(buf)
        if self.addr_len8:
            self.__field_addr8.writetobuffer(buf)
        if self.addr_len9:
            self.__field_addr9.writetobuffer(buf)
        if not self.has_1byte and self.has_1byte2:
            self.__field_dunno6.writetobuffer(buf)
        if self.has_1byte2:
            self.__field_dunno7.writetobuffer(buf)
        self.__field_dunno8.writetobuffer(buf)
        if self.has_40bytes:
            self.__field_dunno9.writetobuffer(buf)
        self.__field_msg_stat.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 50})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_msg=USTRING(**{ 'sizeinbytes': self.msg_len,                'encoding': ENCODING,                'terminator': None })
        self.__field_msg.readfrombuffer(buf)
        if self.has_callback:
            self.__field_dunno2=UNKNOWN(**{'sizeinbytes': 3})
            self.__field_dunno2.readfrombuffer(buf)
            self.__field_callback_len=UINT(**{'sizeinbytes': 1})
            self.__field_callback_len.readfrombuffer(buf)
            self.__field_callback=STRING(**{ 'sizeinbytes': self.callback_len,                   'terminator': None })
            self.__field_callback.readfrombuffer(buf)
        if self.has_priority:
            self.__field_priority=UINT(**{'sizeinbytes': 1})
            self.__field_priority.readfrombuffer(buf)
        if self.has_1byte:
            self.__field_dunno3=UNKNOWN(**{'sizeinbytes': 1})
            self.__field_dunno3.readfrombuffer(buf)
        self.__field_dunno4=UNKNOWN(**{'sizeinbytes': 40})
        self.__field_dunno4.readfrombuffer(buf)
        self.__field_datetime=DateTime1(**{'sizeinbytes': 4})
        self.__field_datetime.readfrombuffer(buf)
        self.__field_dunno5=UNKNOWN(**{'sizeinbytes': 13})
        self.__field_dunno5.readfrombuffer(buf)
        self.__field_addr_len0=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len0.readfrombuffer(buf)
        self.__field_addr_len1=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len1.readfrombuffer(buf)
        self.__field_addr_len2=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len2.readfrombuffer(buf)
        self.__field_addr_len3=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len3.readfrombuffer(buf)
        self.__field_addr_len4=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len4.readfrombuffer(buf)
        self.__field_addr_len5=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len5.readfrombuffer(buf)
        self.__field_addr_len6=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len6.readfrombuffer(buf)
        self.__field_addr_len7=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len7.readfrombuffer(buf)
        self.__field_addr_len8=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len8.readfrombuffer(buf)
        self.__field_addr_len9=UINT(**{'sizeinbytes': 1})
        self.__field_addr_len9.readfrombuffer(buf)
        if self.addr_len0:
            self.__field_addr0=STRING(**{ 'sizeinbytes': self.addr_len0,                   'terminator': None })
            self.__field_addr0.readfrombuffer(buf)
        if self.addr_len1:
            self.__field_addr1=STRING(**{ 'sizeinbytes': self.addr_len1,                   'terminator': None })
            self.__field_addr1.readfrombuffer(buf)
        if self.addr_len2:
            self.__field_addr2=STRING(**{ 'sizeinbytes': self.addr_len2,                   'terminator': None })
            self.__field_addr2.readfrombuffer(buf)
        if self.addr_len3:
            self.__field_addr3=STRING(**{ 'sizeinbytes': self.addr_len3,                   'terminator': None })
            self.__field_addr3.readfrombuffer(buf)
        if self.addr_len4:
            self.__field_addr4=STRING(**{ 'sizeinbytes': self.addr_len4,                   'terminator': None })
            self.__field_addr4.readfrombuffer(buf)
        if self.addr_len5:
            self.__field_addr5=STRING(**{ 'sizeinbytes': self.addr_len5,                   'terminator': None })
            self.__field_addr5.readfrombuffer(buf)
        if self.addr_len6:
            self.__field_addr6=STRING(**{ 'sizeinbytes': self.addr_len6,                   'terminator': None })
            self.__field_addr6.readfrombuffer(buf)
        if self.addr_len7:
            self.__field_addr7=STRING(**{ 'sizeinbytes': self.addr_len7,                   'terminator': None })
            self.__field_addr7.readfrombuffer(buf)
        if self.addr_len8:
            self.__field_addr8=STRING(**{ 'sizeinbytes': self.addr_len8,                   'terminator': None })
            self.__field_addr8.readfrombuffer(buf)
        if self.addr_len9:
            self.__field_addr9=STRING(**{ 'sizeinbytes': self.addr_len9,                   'terminator': None })
            self.__field_addr9.readfrombuffer(buf)
        if not self.has_1byte and self.has_1byte2:
            self.__field_dunno6=UNKNOWN(**{'sizeinbytes': 1})
            self.__field_dunno6.readfrombuffer(buf)
        if self.has_1byte2:
            self.__field_dunno7=UNKNOWN(**{'sizeinbytes': 1})
            self.__field_dunno7.readfrombuffer(buf)
        self.__field_dunno8=UNKNOWN(**{'sizeinbytes': 21})
        self.__field_dunno8.readfrombuffer(buf)
        if self.has_40bytes:
            self.__field_dunno9=UNKNOWN(**{'sizeinbytes': 40})
            self.__field_dunno9.readfrombuffer(buf)
        self.__field_msg_stat=LIST(**{ 'elementclass': sms_msg_stat_list,             'length': 10 })
        self.__field_msg_stat.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_msg_len(self):
        return self.__field_msg_len.getvalue()

    def __setfield_msg_len(self, value):
        if isinstance(value,UINT):
            self.__field_msg_len=value
        else:
            self.__field_msg_len=UINT(value,)

    def __delfield_msg_len(self): del self.__field_msg_len

    msg_len=property(__getfield_msg_len, __setfield_msg_len, __delfield_msg_len, None)

    def __getfield_has_callback(self):
        try: self.__field_has_callback
        except:
            self.__field_has_callback=BOOL(**{ 'default': True })
        return self.__field_has_callback.getvalue()

    def __setfield_has_callback(self, value):
        if isinstance(value,BOOL):
            self.__field_has_callback=value
        else:
            self.__field_has_callback=BOOL(value,**{ 'default': True })

    def __delfield_has_callback(self): del self.__field_has_callback

    has_callback=property(__getfield_has_callback, __setfield_has_callback, __delfield_has_callback, None)

    def __getfield_has_priority(self):
        try: self.__field_has_priority
        except:
            self.__field_has_priority=BOOL(**{ 'default': False })
        return self.__field_has_priority.getvalue()

    def __setfield_has_priority(self, value):
        if isinstance(value,BOOL):
            self.__field_has_priority=value
        else:
            self.__field_has_priority=BOOL(value,**{ 'default': False })

    def __delfield_has_priority(self): del self.__field_has_priority

    has_priority=property(__getfield_has_priority, __setfield_has_priority, __delfield_has_priority, None)

    def __getfield_has_1byte(self):
        try: self.__field_has_1byte
        except:
            self.__field_has_1byte=BOOL(**{ 'default': False })
        return self.__field_has_1byte.getvalue()

    def __setfield_has_1byte(self, value):
        if isinstance(value,BOOL):
            self.__field_has_1byte=value
        else:
            self.__field_has_1byte=BOOL(value,**{ 'default': False })

    def __delfield_has_1byte(self): del self.__field_has_1byte

    has_1byte=property(__getfield_has_1byte, __setfield_has_1byte, __delfield_has_1byte, None)

    def __getfield_has_1byte2(self):
        try: self.__field_has_1byte2
        except:
            self.__field_has_1byte2=BOOL(**{ 'default': True })
        return self.__field_has_1byte2.getvalue()

    def __setfield_has_1byte2(self, value):
        if isinstance(value,BOOL):
            self.__field_has_1byte2=value
        else:
            self.__field_has_1byte2=BOOL(value,**{ 'default': True })

    def __delfield_has_1byte2(self): del self.__field_has_1byte2

    has_1byte2=property(__getfield_has_1byte2, __setfield_has_1byte2, __delfield_has_1byte2, None)

    def __getfield_has_40bytes(self):
        try: self.__field_has_40bytes
        except:
            self.__field_has_40bytes=BOOL(**{ 'default': False })
        return self.__field_has_40bytes.getvalue()

    def __setfield_has_40bytes(self, value):
        if isinstance(value,BOOL):
            self.__field_has_40bytes=value
        else:
            self.__field_has_40bytes=BOOL(value,**{ 'default': False })

    def __delfield_has_40bytes(self): del self.__field_has_40bytes

    has_40bytes=property(__getfield_has_40bytes, __setfield_has_40bytes, __delfield_has_40bytes, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 50})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_msg(self):
        return self.__field_msg.getvalue()

    def __setfield_msg(self, value):
        if isinstance(value,USTRING):
            self.__field_msg=value
        else:
            self.__field_msg=USTRING(value,**{ 'sizeinbytes': self.msg_len,                'encoding': ENCODING,                'terminator': None })

    def __delfield_msg(self): del self.__field_msg

    msg=property(__getfield_msg, __setfield_msg, __delfield_msg, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_callback_len(self):
        return self.__field_callback_len.getvalue()

    def __setfield_callback_len(self, value):
        if isinstance(value,UINT):
            self.__field_callback_len=value
        else:
            self.__field_callback_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_callback_len(self): del self.__field_callback_len

    callback_len=property(__getfield_callback_len, __setfield_callback_len, __delfield_callback_len, None)

    def __getfield_callback(self):
        return self.__field_callback.getvalue()

    def __setfield_callback(self, value):
        if isinstance(value,STRING):
            self.__field_callback=value
        else:
            self.__field_callback=STRING(value,**{ 'sizeinbytes': self.callback_len,                   'terminator': None })

    def __delfield_callback(self): del self.__field_callback

    callback=property(__getfield_callback, __setfield_callback, __delfield_callback, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UNKNOWN(value,**{'sizeinbytes': 40})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def __getfield_datetime(self):
        return self.__field_datetime.getvalue()

    def __setfield_datetime(self, value):
        if isinstance(value,DateTime1):
            self.__field_datetime=value
        else:
            self.__field_datetime=DateTime1(value,**{'sizeinbytes': 4})

    def __delfield_datetime(self): del self.__field_datetime

    datetime=property(__getfield_datetime, __setfield_datetime, __delfield_datetime, None)

    def __getfield_dunno5(self):
        return self.__field_dunno5.getvalue()

    def __setfield_dunno5(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno5=value
        else:
            self.__field_dunno5=UNKNOWN(value,**{'sizeinbytes': 13})

    def __delfield_dunno5(self): del self.__field_dunno5

    dunno5=property(__getfield_dunno5, __setfield_dunno5, __delfield_dunno5, None)

    def __getfield_addr_len0(self):
        return self.__field_addr_len0.getvalue()

    def __setfield_addr_len0(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len0=value
        else:
            self.__field_addr_len0=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len0(self): del self.__field_addr_len0

    addr_len0=property(__getfield_addr_len0, __setfield_addr_len0, __delfield_addr_len0, None)

    def __getfield_addr_len1(self):
        return self.__field_addr_len1.getvalue()

    def __setfield_addr_len1(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len1=value
        else:
            self.__field_addr_len1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len1(self): del self.__field_addr_len1

    addr_len1=property(__getfield_addr_len1, __setfield_addr_len1, __delfield_addr_len1, None)

    def __getfield_addr_len2(self):
        return self.__field_addr_len2.getvalue()

    def __setfield_addr_len2(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len2=value
        else:
            self.__field_addr_len2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len2(self): del self.__field_addr_len2

    addr_len2=property(__getfield_addr_len2, __setfield_addr_len2, __delfield_addr_len2, None)

    def __getfield_addr_len3(self):
        return self.__field_addr_len3.getvalue()

    def __setfield_addr_len3(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len3=value
        else:
            self.__field_addr_len3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len3(self): del self.__field_addr_len3

    addr_len3=property(__getfield_addr_len3, __setfield_addr_len3, __delfield_addr_len3, None)

    def __getfield_addr_len4(self):
        return self.__field_addr_len4.getvalue()

    def __setfield_addr_len4(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len4=value
        else:
            self.__field_addr_len4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len4(self): del self.__field_addr_len4

    addr_len4=property(__getfield_addr_len4, __setfield_addr_len4, __delfield_addr_len4, None)

    def __getfield_addr_len5(self):
        return self.__field_addr_len5.getvalue()

    def __setfield_addr_len5(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len5=value
        else:
            self.__field_addr_len5=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len5(self): del self.__field_addr_len5

    addr_len5=property(__getfield_addr_len5, __setfield_addr_len5, __delfield_addr_len5, None)

    def __getfield_addr_len6(self):
        return self.__field_addr_len6.getvalue()

    def __setfield_addr_len6(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len6=value
        else:
            self.__field_addr_len6=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len6(self): del self.__field_addr_len6

    addr_len6=property(__getfield_addr_len6, __setfield_addr_len6, __delfield_addr_len6, None)

    def __getfield_addr_len7(self):
        return self.__field_addr_len7.getvalue()

    def __setfield_addr_len7(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len7=value
        else:
            self.__field_addr_len7=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len7(self): del self.__field_addr_len7

    addr_len7=property(__getfield_addr_len7, __setfield_addr_len7, __delfield_addr_len7, None)

    def __getfield_addr_len8(self):
        return self.__field_addr_len8.getvalue()

    def __setfield_addr_len8(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len8=value
        else:
            self.__field_addr_len8=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len8(self): del self.__field_addr_len8

    addr_len8=property(__getfield_addr_len8, __setfield_addr_len8, __delfield_addr_len8, None)

    def __getfield_addr_len9(self):
        return self.__field_addr_len9.getvalue()

    def __setfield_addr_len9(self, value):
        if isinstance(value,UINT):
            self.__field_addr_len9=value
        else:
            self.__field_addr_len9=UINT(value,**{'sizeinbytes': 1})

    def __delfield_addr_len9(self): del self.__field_addr_len9

    addr_len9=property(__getfield_addr_len9, __setfield_addr_len9, __delfield_addr_len9, None)

    def __getfield_addr0(self):
        return self.__field_addr0.getvalue()

    def __setfield_addr0(self, value):
        if isinstance(value,STRING):
            self.__field_addr0=value
        else:
            self.__field_addr0=STRING(value,**{ 'sizeinbytes': self.addr_len0,                   'terminator': None })

    def __delfield_addr0(self): del self.__field_addr0

    addr0=property(__getfield_addr0, __setfield_addr0, __delfield_addr0, None)

    def __getfield_addr1(self):
        return self.__field_addr1.getvalue()

    def __setfield_addr1(self, value):
        if isinstance(value,STRING):
            self.__field_addr1=value
        else:
            self.__field_addr1=STRING(value,**{ 'sizeinbytes': self.addr_len1,                   'terminator': None })

    def __delfield_addr1(self): del self.__field_addr1

    addr1=property(__getfield_addr1, __setfield_addr1, __delfield_addr1, None)

    def __getfield_addr2(self):
        return self.__field_addr2.getvalue()

    def __setfield_addr2(self, value):
        if isinstance(value,STRING):
            self.__field_addr2=value
        else:
            self.__field_addr2=STRING(value,**{ 'sizeinbytes': self.addr_len2,                   'terminator': None })

    def __delfield_addr2(self): del self.__field_addr2

    addr2=property(__getfield_addr2, __setfield_addr2, __delfield_addr2, None)

    def __getfield_addr3(self):
        return self.__field_addr3.getvalue()

    def __setfield_addr3(self, value):
        if isinstance(value,STRING):
            self.__field_addr3=value
        else:
            self.__field_addr3=STRING(value,**{ 'sizeinbytes': self.addr_len3,                   'terminator': None })

    def __delfield_addr3(self): del self.__field_addr3

    addr3=property(__getfield_addr3, __setfield_addr3, __delfield_addr3, None)

    def __getfield_addr4(self):
        return self.__field_addr4.getvalue()

    def __setfield_addr4(self, value):
        if isinstance(value,STRING):
            self.__field_addr4=value
        else:
            self.__field_addr4=STRING(value,**{ 'sizeinbytes': self.addr_len4,                   'terminator': None })

    def __delfield_addr4(self): del self.__field_addr4

    addr4=property(__getfield_addr4, __setfield_addr4, __delfield_addr4, None)

    def __getfield_addr5(self):
        return self.__field_addr5.getvalue()

    def __setfield_addr5(self, value):
        if isinstance(value,STRING):
            self.__field_addr5=value
        else:
            self.__field_addr5=STRING(value,**{ 'sizeinbytes': self.addr_len5,                   'terminator': None })

    def __delfield_addr5(self): del self.__field_addr5

    addr5=property(__getfield_addr5, __setfield_addr5, __delfield_addr5, None)

    def __getfield_addr6(self):
        return self.__field_addr6.getvalue()

    def __setfield_addr6(self, value):
        if isinstance(value,STRING):
            self.__field_addr6=value
        else:
            self.__field_addr6=STRING(value,**{ 'sizeinbytes': self.addr_len6,                   'terminator': None })

    def __delfield_addr6(self): del self.__field_addr6

    addr6=property(__getfield_addr6, __setfield_addr6, __delfield_addr6, None)

    def __getfield_addr7(self):
        return self.__field_addr7.getvalue()

    def __setfield_addr7(self, value):
        if isinstance(value,STRING):
            self.__field_addr7=value
        else:
            self.__field_addr7=STRING(value,**{ 'sizeinbytes': self.addr_len7,                   'terminator': None })

    def __delfield_addr7(self): del self.__field_addr7

    addr7=property(__getfield_addr7, __setfield_addr7, __delfield_addr7, None)

    def __getfield_addr8(self):
        return self.__field_addr8.getvalue()

    def __setfield_addr8(self, value):
        if isinstance(value,STRING):
            self.__field_addr8=value
        else:
            self.__field_addr8=STRING(value,**{ 'sizeinbytes': self.addr_len8,                   'terminator': None })

    def __delfield_addr8(self): del self.__field_addr8

    addr8=property(__getfield_addr8, __setfield_addr8, __delfield_addr8, None)

    def __getfield_addr9(self):
        return self.__field_addr9.getvalue()

    def __setfield_addr9(self, value):
        if isinstance(value,STRING):
            self.__field_addr9=value
        else:
            self.__field_addr9=STRING(value,**{ 'sizeinbytes': self.addr_len9,                   'terminator': None })

    def __delfield_addr9(self): del self.__field_addr9

    addr9=property(__getfield_addr9, __setfield_addr9, __delfield_addr9, None)

    def __getfield_dunno6(self):
        return self.__field_dunno6.getvalue()

    def __setfield_dunno6(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno6=value
        else:
            self.__field_dunno6=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno6(self): del self.__field_dunno6

    dunno6=property(__getfield_dunno6, __setfield_dunno6, __delfield_dunno6, None)

    def __getfield_dunno7(self):
        return self.__field_dunno7.getvalue()

    def __setfield_dunno7(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno7=value
        else:
            self.__field_dunno7=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno7(self): del self.__field_dunno7

    dunno7=property(__getfield_dunno7, __setfield_dunno7, __delfield_dunno7, None)

    def __getfield_dunno8(self):
        return self.__field_dunno8.getvalue()

    def __setfield_dunno8(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno8=value
        else:
            self.__field_dunno8=UNKNOWN(value,**{'sizeinbytes': 21})

    def __delfield_dunno8(self): del self.__field_dunno8

    dunno8=property(__getfield_dunno8, __setfield_dunno8, __delfield_dunno8, None)

    def __getfield_dunno9(self):
        return self.__field_dunno9.getvalue()

    def __setfield_dunno9(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno9=value
        else:
            self.__field_dunno9=UNKNOWN(value,**{'sizeinbytes': 40})

    def __delfield_dunno9(self): del self.__field_dunno9

    dunno9=property(__getfield_dunno9, __setfield_dunno9, __delfield_dunno9, None)

    def __getfield_msg_stat(self):
        return self.__field_msg_stat.getvalue()

    def __setfield_msg_stat(self, value):
        if isinstance(value,LIST):
            self.__field_msg_stat=value
        else:
            self.__field_msg_stat=LIST(value,**{ 'elementclass': sms_msg_stat_list,             'length': 10 })

    def __delfield_msg_stat(self): del self.__field_msg_stat

    msg_stat=property(__getfield_msg_stat, __setfield_msg_stat, __delfield_msg_stat, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('msg_len', self.__field_msg_len, None)
        yield ('has_callback', self.__field_has_callback, None)
        yield ('has_priority', self.__field_has_priority, None)
        yield ('has_1byte', self.__field_has_1byte, None)
        yield ('has_1byte2', self.__field_has_1byte2, None)
        yield ('has_40bytes', self.__field_has_40bytes, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('msg', self.__field_msg, None)
        if self.has_callback:
            yield ('dunno2', self.__field_dunno2, None)
            yield ('callback_len', self.__field_callback_len, None)
            yield ('callback', self.__field_callback, None)
        if self.has_priority:
            yield ('priority', self.__field_priority, None)
        if self.has_1byte:
            yield ('dunno3', self.__field_dunno3, None)
        yield ('dunno4', self.__field_dunno4, None)
        yield ('datetime', self.__field_datetime, None)
        yield ('dunno5', self.__field_dunno5, None)
        yield ('addr_len0', self.__field_addr_len0, None)
        yield ('addr_len1', self.__field_addr_len1, None)
        yield ('addr_len2', self.__field_addr_len2, None)
        yield ('addr_len3', self.__field_addr_len3, None)
        yield ('addr_len4', self.__field_addr_len4, None)
        yield ('addr_len5', self.__field_addr_len5, None)
        yield ('addr_len6', self.__field_addr_len6, None)
        yield ('addr_len7', self.__field_addr_len7, None)
        yield ('addr_len8', self.__field_addr_len8, None)
        yield ('addr_len9', self.__field_addr_len9, None)
        if self.addr_len0:
            yield ('addr0', self.__field_addr0, None)
        if self.addr_len1:
            yield ('addr1', self.__field_addr1, None)
        if self.addr_len2:
            yield ('addr2', self.__field_addr2, None)
        if self.addr_len3:
            yield ('addr3', self.__field_addr3, None)
        if self.addr_len4:
            yield ('addr4', self.__field_addr4, None)
        if self.addr_len5:
            yield ('addr5', self.__field_addr5, None)
        if self.addr_len6:
            yield ('addr6', self.__field_addr6, None)
        if self.addr_len7:
            yield ('addr7', self.__field_addr7, None)
        if self.addr_len8:
            yield ('addr8', self.__field_addr8, None)
        if self.addr_len9:
            yield ('addr9', self.__field_addr9, None)
        if not self.has_1byte and self.has_1byte2:
            yield ('dunno6', self.__field_dunno6, None)
        if self.has_1byte2:
            yield ('dunno7', self.__field_dunno7, None)
        yield ('dunno8', self.__field_dunno8, None)
        if self.has_40bytes:
            yield ('dunno9', self.__field_dunno9, None)
        yield ('msg_stat', self.__field_msg_stat, None)




