#!/bin/bash

usage(){
echo "
Written by Brian Bushnell
Last modified June 27, 2024

Description:   Starts a server for demultiplexing queries.

Usage:  demuxserver.sh port=<number>


Parameters:

port=3068           Port number.
domain=             Domain to be displayed in the help message.
                    Default is demux.jgi.doe.gov.

Java Parameters:
-Xmx                This will set Java's memory usage, overriding autodetection.
                    -Xmx20g will specify 20 gigs of RAM, and -Xmx200m will specify 200 megs.
                    The max is typically 85% of physical memory.
-eoom               This flag will cause the process to exit if an
                    out-of-memory exception occurs.  Requires Java 8u92+.
-da                 Disable assertions.

Please contact Brian Bushnell at bbushnell@lbl.gov if you encounter any problems.
"
}

#This block allows symlinked shellscripts to correctly set classpath.
pushd . > /dev/null
DIR="${BASH_SOURCE[0]}"
while [ -h "$DIR" ]; do
  cd "$(dirname "$DIR")"
  DIR="$(readlink "$(basename "$DIR")")"
done
cd "$(dirname "$DIR")"
DIR="$(pwd)/"
popd > /dev/null

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/"
CP="$DIR""current/"

z="-Xmx24g"
z2="-Xms24g"
set=0

if [ -z "$1" ] || [[ $1 == -h ]] || [[ $1 == --help ]]; then
	usage
	exit
fi

calcXmx () {
	source "$DIR""/calcmem.sh"
	setEnvironment
	parseXmx "$@"
}
calcXmx "$@"

demuxserver() {
	local CMD="java $EA $EOOM $z $z2 -cp $CP barcode.DemuxServer $@"
	echo $CMD >&2
	eval $CMD
}

demuxserver "$@"
