// Copyright 2018 The Bazel Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.hash.HashCode;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

/** Encodes a HashCode. */
public class HashCodeCodec implements ObjectCodec<HashCode> {

  @Override
  public void serialize(SerializationContext context, HashCode obj, CodedOutputStream codedOut)
      throws SerializationException, IOException {
    codedOut.writeByteArrayNoTag(obj.asBytes());
  }

  @Override
  public HashCode deserialize(DeserializationContext context, CodedInputStream codedIn)
      throws SerializationException, IOException {
    return HashCode.fromBytes(codedIn.readByteArray());
  }

  @Override
  public Class<HashCode> getEncodedClass() {
    return HashCode.class;
  }
}
