//
// BAGEL - Parallel electron correlation program.
// Filename: _sphusp_6.cc
// Copyright (C) 2014 Toru Shiozaki
//
// Author: Hai-Anh Le <anh@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/ecp/sphusplist.h>

using namespace std;
using namespace bagel;

vector<double> SphUSPList::sphusp_6(const int m) {

  vector<double> c;
  constexpr double coeff[364] = {   0.000000000000000e+00,   4.099104631151486e+00,   0.000000000000000e+00,  -1.366368210383829e+01,   0.000000000000000e+00,
   4.099104631151486e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.183309581115876e+01,   0.000000000000000e+00,
  -2.366619162231752e+01,   0.000000000000000e+00,   2.366619162231752e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -2.018259602914897e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   2.018259602914897e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.018259602914897e+01,
   0.000000000000000e+00,  -2.018259602914897e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -8.290847335634311e+00,   0.000000000000000e+00,
  -5.527231557089541e+00,   0.000000000000000e+00,   2.763615778544771e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.210892622835816e+01,
   0.000000000000000e+00,  -7.369642076119388e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   9.212052595149235e-01,   0.000000000000000e+00,   1.842410519029847e+00,   0.000000000000000e+00,
   9.212052595149235e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -1.473928415223878e+01,
   0.000000000000000e+00,  -1.473928415223878e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   1.473928415223878e+01,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   2.913106812593657e+00,   0.000000000000000e+00,
   5.826213625187314e+00,   0.000000000000000e+00,   2.913106812593657e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -1.165242725037463e+01,
   0.000000000000000e+00,  -1.165242725037463e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   4.660970900149851e+00,   0.000000000000000e+00,  -3.178460113381421e-01,   0.000000000000000e+00,  -9.535380340144261e-01,   0.000000000000000e+00,  -9.535380340144261e-01,
   0.000000000000000e+00,  -3.178460113381421e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   5.721228204086557e+00,   0.000000000000000e+00,
   1.144245640817311e+01,   0.000000000000000e+00,   5.721228204086557e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -7.628304272115410e+00,   0.000000000000000e+00,  -7.628304272115410e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   1.017107236282055e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   2.913106812593657e+00,   0.000000000000000e+00,   5.826213625187314e+00,
   0.000000000000000e+00,   2.913106812593657e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -1.165242725037463e+01,   0.000000000000000e+00,
  -1.165242725037463e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   4.660970900149851e+00,   0.000000000000000e+00,   0.000000000000000e+00,   4.606026297574617e-01,   0.000000000000000e+00,   4.606026297574617e-01,   0.000000000000000e+00,  -4.606026297574617e-01,
   0.000000000000000e+00,  -4.606026297574617e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -7.369642076119388e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   7.369642076119388e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   7.369642076119388e+00,   0.000000000000000e+00,  -7.369642076119388e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,  -2.763615778544771e+00,   0.000000000000000e+00,   5.527231557089541e+00,
   0.000000000000000e+00,   8.290847335634311e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   7.369642076119388e+00,   0.000000000000000e+00,
  -2.210892622835816e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,  -5.045649007287242e-01,   0.000000000000000e+00,   2.522824503643621e+00,   0.000000000000000e+00,   2.522824503643621e+00,
   0.000000000000000e+00,  -5.045649007287242e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   5.045649007287242e+00,   0.000000000000000e+00,
  -3.027389404372345e+01,   0.000000000000000e+00,   5.045649007287242e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   2.366619162231752e+00,   0.000000000000000e+00,  -2.366619162231752e+01,
   0.000000000000000e+00,   1.183309581115876e+01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   6.831841051919144e-01,   0.000000000000000e+00,  -1.024776157787872e+01,   0.000000000000000e+00,   1.024776157787872e+01,
   0.000000000000000e+00,  -6.831841051919144e-01,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00,
   0.000000000000000e+00,   0.000000000000000e+00,   0.000000000000000e+00};

  assert(abs(m) <= 6);
  const int size_c = (6 + 1) * (6 + 2) / 2;
  const int mu = m + 6;
  const int i0 = mu * size_c;
  for (int i = i0; i != i0 + size_c; ++i) c.push_back(coeff[i]);
  return c;

}
