#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "twister.h"
#include "game.h"
#include "spec.h"

#include "conf.h"

#include "manual.h"

#include "unmo3.h"

unsigned char cl_transp = 0x70;  // mono:00 color:70

int rec_show; // 0-none, 1-fast, 2-slow

MANUAL manual(&book,'*',cl_transp);

// clean:77, cyan:76, magen:75, blue:74, !brown!:73, green:72, red:71, black:70
static unsigned char cl_mountains = 0x76; 
static unsigned char cl_city = 0x76; 

// WRAP at column 57!

const DIALOG dlg_beginner_0[]=
{
	{
		'C',
		"You're doing pretty good, %.\n"
		"We need to stop that aliens from invading our\n"
		"planet. They spread their forces over nearby\n"
		"area. Try to eliminate as much of them as\n"
		"possible."
	},
	{
		'P',
		"Yes Sir, immediately proceeding to sector E-J."
	},
	{
		'C',
		"Be careful, they come with mega bombers fleet.\n"
		"Their bombs make huge craters in the ground.\n"
		"Good luck cadet!"
	},
	{0,0}
};


const DIALOG dlg_beginner_1[]=
{
	{
		'C',
		"So now, nasty invaders know they are going to\n"
		"have a hard time with us.\n"
		"Let's keep it that way %!."
	},
	{
		'P',
		"But why are they invading us?\n"
		"Commander?"
	},
	{
		'C',
		"Unfortunately, we don't know why and where are\n"
		"they coming from. Proceed to the next sector,\n"
		"maybe there we can find some answers.\n"
		"Watch out, you are entering their minefield!"
	},
	{
		'P',
		"Roger."
	},
	{0,0},
};

const DIALOG dlg_beginner_2[]=
{
	{
		'C',
		"You did it! Hurray!\n"
		"Many cadets have died trying to pass through\n"
		"alien minefields."
	},
	{
		'P',
		"Wasn't that bad."
	},
	{
		'C',
		"OK, I have some important mission for you.\n"
		"Our satellites have located weird behavior of\n"
		"invading ships over next sector. It seams they\n"
		"are trying to extract sulfur resources from our\n"
		"planet. Go and check what are they doing there."
	},
	{
		'P',
		"Sure. Already on the way."
	},
	{0,0}
};

const DIALOG dlg_beginner_3[]=
{
	{
		'C',
		"Great to see you, %!\n"
		"Images you've transmitted are outstanding\n"
		"information resources for us. You wouldn't\n"
		"believe what we have seen on them.",
	},
	{
		'P',
		"Sulfur, aliens, dust and craters?",
	},
	{
		'C',
		"Well, that too. But now I think we know why are\n"
		"they invading us. They change our sulfur to\n"
		"these green rolling rocks. They must have some\n"
		"reason for it. But be aware, alien forces have\n"
		"accumulated heavy tanks on your way. Good luck."
	},
	{
		'P',
		"Right, it was too easy till now :)"
	},
	{0,0}
};

const DIALOG dlg_beginner_4[]=
{
	{
		'C',
		"Hi %.\n"
		"I think we are very close to understand what\n"
		"aliens are doing here. They convey these green\n"
		"balls made of our sulfur to many different\n"
		"locations. Follow them to the next area."
	},
	{
		'P',
		"Got it."
	},
	{
		'C',
		"Satellites have detected new kind of missiles.\n"
		"It looks like they were following you for some\n"
		"time. It seams they are quite dangerous so be\n"
		"very careful. If you see one go as fast as you\n"
		"can then jump it over while slowing down."
	},
	{
		'P',
		"Thanks! You look so pretty when you're talking\n"
		"about all this military stuff."
	},
	{
		'C',
		"Ehm, that was inappropriate, dismiss cadet!"
	},
	{0,0}
};


const DIALOG dlg_champion_0[]=
{
	{
		'C',
		"Our scientists have discovered that green rocks\n"
		"which are spread out everywhere now, are some\n"
		"form of alien life. That is why they can move,\n"
		"attack or escape. We need to keep one eye open.\n"
		"Great job so far, sergeant!"
	},
	{
		'P',
		"Sergeant? Wow, thank you Commander!\n"
		"I thought I'll be held accountable for my last\n"
		"inappropriate message. I'm really sorry."
	},
	{
		'C',
		"Never mind, not a big deal. I was a bit nervy\n"
		"because of the invasion. Now we need to find\n"
		"out what happens with these green life forms.\n"
		"Keep following them, we are almost at the\n"
		"destination. See you at the next patrol camp!"
	},
	{
		'P',
		"Bye Commander!"
	},
	{
		'C',
		"Ehm :)"
	},
	{0,0}
};

const DIALOG dlg_champion_1[]=
{
	{
		'C',
		"Holy crap, those are eggs of these creatures!\n"
		"If from each egg new alien creature is going to\n"
		"grow up, we are lost %.\n"
		"This mission is pointless, there is no way to\n"
		"stop them now. Our world is lost!"
	},
	{
		'P',
		"Calm down Commander, I haven't seen those\n"
		"creatures doing anything at all. They are more\n"
		"like plants. Just vegetating there and there.\n"
		"Maybe they won't do anything bad to us, we have\n"
		"to analyze first, what these life forms are."
	},
	{
		'C',
		"Yes, you are right %.\n"
		"I'm just slowly loosing my faith we can win.\n"
		"There are so many of the eggs and now these\n"
		"creature-plants. Who knows what have they\n"
		"prepared for us?"
	},
	{
		'P',
		"Commander, I'm proceeding to J-O sector. I'll\n"
		"pick a sample of a dead creature so our\n"
		"scientists can examine it in details.\n"
		"Roger."
	},
	{0,0}
};

const DIALOG dlg_champion_2[]= 
{
	{
		'C',
		"%, have got that alien plant sample?"
	},
	{
		'P',
		"No, all plants are gone, I don't understand it.\n"
		"But something weird is going on with on-board\n"
		"devices. Several times I've completely lost the\n"
		"vision. I've almost crashed the truck! ...\n"
		"Oh NO! It's starting again..."
	},
	{
		'A',
		"PLEASE DO NOT ATTACK OUR CLEANING PLANTS!\n"
		"OUR FORCES ARE ONLY TRYING TO PROTECT THEM\n"
		"WE DO NOT WANT TO HURT YOU!\n"
		"WE ARE TRYING TO HELP YOU SAVING THE PLANET"
	},
	{
		'P',
		"Wow! What was that? Did you hear it Commander?"
	},
	{
		'C',
		"No, I don't know what are you talking about.\n"
		"Only some cracks from your communicator, but\n"
		"that's OK, we are quite far from each other."
	},
	{
		'P',
		"I think I've received a message from aliens!"
	},
	{
		'C',
		"Yeah, from my stepmother which is an alien?\n"
		"If there are no more creatures that is even\n"
		"better. Just calm down, we have a car service\n"
		"at the next patrol camp. Proceed immediately.\n"
		"Roger."
	},
	{0,0}
};

// O-T

const DIALOG dlg_champion_3[]=
{
	{
		'C',
		"So now you know, your friendly alien plants are\n"
		"doing these interferences! It is destroying all\n"
		"our devices, buildings start to fall down too!\n"
		"Hey you, alien mushroom! Or whatever I should\n"
		"call you, go back where you came from!"
	},
	{
		'A',
		"WE ARE EMITTING WAVES TO CURE YOUR PLANET FROM\n"
		"DEVASTATIONS YOU WERE DOING FOR AGES. YOUR\n"
		"RESISTANCE IS POINTLESS. ALL YOU CAN DO IS\n"
		"WAITING FOR REPAIR PROCESS COMPLETENESS.\n"
		"GOOD LUCK ON YOUR NEXT EVOLUTION PATH."
	},
	{
		'C',
		"%, I know what they want.\n"
		"They are not 'curing' our planet, they want to\n"
		"get rid off our ASCII world as it doesn't fit\n"
		"to all these GPU cards, shaders, 4K and 3D.\n"
		"They think our legacy costs them too much."
	},
	{
		'A',
		"CORRECT, YOU ARE JUST PARASITES\n"
	},
	{
		'C',
		"We need to make a new plan how to defeat them.\n"
		"Go and eliminate aliens, as many as you can.\n"
		"At least it will give us some time to regroup\n"
		"our forces."
	},
	{
		'P',
		"With pleasure!"
	},
	{0,0}
};

const DIALOG dlg_champion_4[]= 
{
	{
		'C',
		"Dear %,\n"
		"This is end of our very first Alpha release.\n"
		"If you like this game, join the Ascii Patrol\n"
		"forum to keep track on development progress,\n"
		"share your ideas and your thoughts on game."
	},
	{
		'A',
		"NOW WE WILL START OVER FROM THE BEGINNING\n"
		"HA HA HA Ha Ha Ha ha ha ha\n"
		"GOOD LUCK %!"
	},
	{
		'P',
		"He who laughs last, laughs best."
	},
	{0,0}
};

const LEVEL tutorial[] =
{
	{
		'@','@',
		120000,
		65440,
		&mountains,
		cl_mountains,
		" @", 
		"44",
		0
	},
	{
		'@','@',
		0,
		0,
		0,
		0,
		0,
		0
	}
};

const LEVEL beginner[] = 
{
	{
		'@','E',
		120000,
		65440,
		&city,
		cl_city,
		" @                                                                                                                            h2                                                                h2            h2                                                                               h3                                                                                                                                                                 h3                                                                                 h1                          #        DD                                                                                                    UU                                                                                                                                                                                                                                                                                                                                                       #    UU                                                                     D                                                                                                           h2                                                   D                                                                            h3                                                                             h2                                                                                                      #                                          D              h3                                     UU                                             h2                                                                   h3     DD                                                                    U                                                               h2    UU      h3                                                              h3                         h3                                        #                                                                                                                             h2                                                                                        h2                                                                                            h3                           DD                                                                                                      UU                                                                                                                                                                                                                                                                                                                                                                                              h1         h2                     h3                                                                                                                                                   #", 
		"4444444444444444444444444444444444444444444444444444444444444444444444444444444444333333333333333333333222222223333333333333333333333333222222222222222222222222222222221111112222222222222222222221111122222222222222222222222222222222222223333333333333333333322222222233333333333333333344444444444444444444333334444444444444444321111111112344444444444444443333333334444444444444444444321000000000000123333333333333333333333333333333333333333333333333333333333333333333344444444444444444444444333444444444444444444444444444455555555555555555555544444444444444444444444444333333333333333333333333333322222222222222222222222222111111111111111111111111222222222222222211111111111111111111111111111111111111111111111112222222222222222222211111111111111111111111111111111111111111111112222222222222222222222222211111112222222222222222222222222222222333333333333333333333333333333322222223333333333333333333333333333333333333333444444444444444444444444444444333333344444444444444444444444444433333333334444444444444444444444444444444444444444333333333333333333333333333333333333333322222222222222222222222222222222222111111122222222222222222222222222222222222222222222222222222222223333333333222233333333333333333333333333333333222222223333333333333333333333333344444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444433333333333333333333333333333332222233333333333333333333333333333333333333333333333322223333333333333333333333333333333333333333333333333332222222222222222222223333333333333333333333333333333333333333333333333333333333333333333333333333333333333344444444444444444444444333344444444444444444444444444444444444444443334444444444444444444455555555555555555555555555555555555555555555555554444445555555555555555555555555555555555555554444444444455555555555555555555555555555555555444444444444444443333334444444444444444444444444444444444444444444444444444444444444444333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333322222222222222222222221111111122222222222222222222222222222222222222221111111222222222222222222222222222222222222222222222222222222222222222222222222222221111222222222222222222222222222222222233333333333333333333333333333333333333333333333322222233333333333333333333333333333333333333333333210000000000123333333333333333332222222223333333333333333333333333332222222222222222222222222222222222222221111111122222222222222222222222222222222222222222211122222222222222222233333333333333333333333333333333333333333333333333333333222222223333333333333333332222222222222222222222222222222222222211111111222222222222222222222233322222222222233333333333333333333333333333333333333333333333222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222211112222222233333333333333333333333322222333333333333333333333333333333322222222222111222222222222222222111111112222222222221111112222222222222222222222222222222222",
		dlg_beginner_0
	},
	{
		'E','J',
		120000,
		54000,
		&mountains,
		cl_mountains,
		" @                                                                                                                                                       D                                        D                                                                                                                                                                                                                                                               U                                                #                                                                                                                                                              h2                                                                                                                                                            UU                                              h3                                      D                                                                                              #                                                                                                                  U                                                                                                                                                                                                                                         B                   h3                                                                                                                                 #                                                          h3                                                                                                                  U                                                                                                                                                                                                                                                                                                            D                       #                       D                                                                                                                                                                                                                                                                                                                                                                                      U                                                                                                    #",
		"223333333333334433333333444444433444444334444444445555555555555555445555555666555555555555543322222222222334555555555555555554445555444444443333333332222222211222222222211222222222222211222222222222211222222221122222222222222222222222210.+*-/01111111000000000000//0000000//0000011111111111111112222222222222333333344444443344444444443344444445555554455555555444444444444444334444555555554333333333334555555555666666677777777777777777777777777766777777766777777777776677777777776677777777777666666666666555555555544555555555554455555555555544555556666666666555555555444444444444444444444444455555556666666777777777766777777777777766777777667777766666667777777777777777777777776530./24566666666666666556666666666666666666665566666666556666666655666665555555555555544444444433333322111111111112234444444444444333333333322333333333333223333344444334444444444334444555555555555555555544555554444444433444443333333333333344432211111111111223444443333333332222222222222222222222222222111111112222222222333333333333333444443344444444444443344444444433444444444443333333333333333333332233333333333223333333332233333333332233333333223333333333333333333333333333332233333333333333333222222222333333332233333333333334444444444444433333333333333321100000000011233322222221122222222222233333333322333333444444444444444444444444444444443344444444455555555555555555544555555445555555555555555555555443322222222233455666666666666655666655555555555555544444444444444334444444433444444444444555555445555555555554444444444444444444444444433333322333333333333332222222222222222222222222222222222222222333333333444444444443344445555444444444433444444444443344444444444443344444444433333333333322222221122222222210.+.....*-/0111111111112222222222222222222222222222222222223333333444444334444444443333333333333333321),1233333333333333334444444444444444444444444444433444444433444444443333333333322222221122222221122222222222221122222233333333333333333333333333333322111111111223444444445555544444444444444333333333322333333444444444444444334444444444334444455555544555555544555555555555555555555555555555555544444444444333334444333333333333333344444444443333333332233333333333223333333333333223333333321/,/123333333333333333444444444444444444444444444334444444443344444443344444444444443344444444444443344444444444433444444444444333211000000000001123333333333222233333333333333333333333333333444444443344444444334444444444443333333333332222222222222222222211112222222222112222222211222222221122222222221122222222333333333333",
		dlg_beginner_1
	},
	{
		'J','O',
		120000,
		66150,
		&city,
		cl_city,
		" @                                                                                                                                                                            m                                             m                                                              m                                      m                                                     m     m                                                     m                                       m                                           m                                        m           #                                                                                      m                                 m                                           m    m                                   m                                      m                                        m                                             m                              #                                                               m                                m                                                      m       m                                   m                                             m                                            m    m                                     m                                                      m       m                                m     m                                                              m                                 m     m         #                                                                            m                                       m    m                                       m                                 m                            m     m                                                  m                                                                                      UUU                                      h2                                                                     h2                                                                        h3              #                                                                              m                                       m                                                         m     m                               m                                           m                                     m     m                                    m                                        m                                                              m    m                                 m                                     m                                                               m                                      m    m                                m                                        m                                                 m    m                              m                                       m                                                                    m                            m    m                               m                                         #", 
		"33333333333333333333333333333333333333333333333333333222222222233333333333333333333333333333333333333333333222223333333333333333333333333333333333222333333333333333333333333333333333332223333333333333333333332223333333333333333222233333333333333333333333333332222222333333333333333333333333333333222333333333333333333333333333333333333333322223333333333333333333333333322223333333333333333333333333333333333333222233333333322333333333333333333333332222333333333333322233333333333333333333333333333333333222223333333333333333333333333222222333333333222233333333333333333333333222223333333333333222222333333333333332222233333333333333333333333333333333333333333333333333332222223333333333333333333333333333333333222223333333333333223333333333333333333333333333333333332223333333333333333333333333222333333333332222233333333333333333333333333333333333333222333333333333333333333333322222233333333333332223333333333333333333333333333333222233333333333333333333333332222223333333333333333333332223333333333333333333333333333333332222333333333333333333333333333333222233333333333332223333333333333333333333333333333333333332222233333333333333333333333333322222222222333333333333333333333333333332222333333333333333333333333332233333333333333333333333333333333333332222333333333333333333333333223333333333333333222333333332233333333333333333333333333333322222233333333333333333333332223333333333333333333222333333333333322222233333333333333333333333333333333222233333333333333333333333333333333333333333333333333333332222233333322333333333333333333333333333333332223333333333333333333333222333333333333333333333333333333333322222223333333333333333333333333333333333333222223333332233333333333333332233333333332223333333333333333333332233333333333333333332222233333333333333333333322333333333333333333333333222233333333333333333333322222333333333333322333333333333333333333333333222222333333333333333333333332223333333321100001123333333333222222333333222333333333333333333333333222333333333333333333322333333333332222223333333333333333333333333333222233333333333333333333333333333322222333333333333223333333333333333333333333222222222233333333333322223333333333333333333333333333333333333322222223333333333322233333333333333333333333333333333333333333333333322222333333333333333333333333333333333332233333333333333333333333333222223333333333333333333333333333333333333332223333333333333333333332223333333333322333333333333333333333333333333333333333222233333333333333333333333333332223333333333333333333333333333333222233333333333333333333333333333333222223333333333333333333332233333333333333333333333333333333333332222223333333333333333333333333333333333333333332222223333333333333333333333333333222333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333322222333333333333333333333333333333333333322333333333333333333333333333333333333333333333333333333333333333332222233333333333333333333333333333222233333333333333333333333333333333222222222222222222222222222222222223333333333333333333333333333322222333333333333223333333333333",
		dlg_beginner_2
	},
	{
		'O','T',
		120000,
		66330,
		&mountains,
		cl_mountains,
		" @                                                                                                      b2                                                  b2                                               b4                                                              b2                                               b2                                                                                    b4                                                                          b2                     b4                                                                                                                                    #                        UUU                                             B                                                          U                                                                        B                                                       D                                                                              B                                                                                                                                       #                                           B                                                                    U                                                          D                                                                B                                                                                 UU                                                              #                                                                  b2                                                                 b4                                                                                                                                 b4                b2                                                                                                            h2        h3                                                          b3          b3                                                      #                  B                                       b4          U                                                 D       b2                                                               b2                                                            B                                            b4                                       U                                       b2                                                                                               U   h2          h2                                             D                h2          h3                                                                                                                                                                                           b4                                                  b2                                                                  b2       b4                                                                                               h2                                                   #",
		"2222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222223333333333333333333333333333333333333333333333333333344444444444444444444444444444444444444444444445555555555555555555555555555555555555555555555555555555555555555555555555566666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666665555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444444444433333333333333333333333333333333321000000000001233333333333333333333333333322222222222222222222222222222222222222222222222222222222222222222222222222222233333333333333333333333333333333333333333332222222222344444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444433333333333333333333333333333333333333333333333333333333333333333333333333332222222222222222222222222222222222222222222222222223333333333333333333333333333333333333333333334444444444444444444444444444444444444444444555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444444444444444444333333333333333333333333333333333333333333333333333333333333333333333333333333333333322222222222222222222222222222222222222222222222222222222222222222222222222211111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111112222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222233333333333333333333333333333333333333333333333333333333333333333333333334444444444444444444444444444444444444444444444445555555555555555555555555555555555555555555555555555555444444444444444444444444444444444444444444444444444444444444444444444444444444444444433333333333333333333333333333333333333333333333333333333333322222222222222222222233333333333333333333333333333333333333333333333333333333333333333333333333444444444444444444444444444444444444444444444444444444444444444444444455555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555544444444444444444444444444444444444444444444444444444444444444444444444444444333333333333333333333333333333333333333333333333333333333333333333333333332222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222233333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333444444444444444444444444444444444555555555555555555555555555555555555555666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666666543221100001223456666666655555555555555555555",
		dlg_beginner_3
	},
	{
		'T','Z',
		120000,
		67350,
		&city,
		cl_city,
		" @                                                                                                                                                                       t                                                           m                                                              t                          m                             m                         b4                                                        b2                          m    t                                                         t                               m                                           t                                              h3              m                                 b2                                                       #     U                                                                                                                                                                                                                                                                                                                                                                                   t                                                       t                                                                #                                                                            h2                                                                                                                                             t                        b4                                                              h2                                                                t                                                               #                 B                D                                                      U                                                                          B                                                                        D                                                                                                                                                                                         U                                                                           #                                                                                                                h3                                                                  t             b4                                                                                                                               b4           h2              h3                                                            t           h2                                        #                               D                                 m                                                                                              m                              h3                     m                                                   t                                                                                                                         t                t                                             #",
		"666666666666666666666666666666666666666666666666666666655555555555555555555554444444444443333332222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333322222222222222222222222222222222222222222222222222222222333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333344444444444444444444444444444444444444444444444444444444444444455555555555555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444432100000123444444444444445555555555555544444444444444444444444444444444444444433333333333333333333333333333333333333333333333333333333333333333333333444444444444444444444444444444444444444444445555555555555555554444444444444444444444444444444444333333333333333333222222222111111111111111111111111111112222222222222222222222222333333333333333333333333333333333333333334444444444444444444444444444444444444444444444444444455555555555555555555555555432211112234555555555555555555555555555555555444444444444444444444444444444444455555555555555555555555555555555555555555566666666666666666666666654////456666666666666666666666666666666666655555555555555555555555555543//////34555555555555555555555544444444444444444444444444444444444444432///////23444444444444444444443333333333333333333333333333333333333333333333333333333333321///////34444444444444444444444444555555555555555555555555555555543//////345555555555555555555555555555555444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444433333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333344444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444455555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444444333333333333333333333333333333333333333333333334444444444444444444555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444333333333333333333333333333333333333333333333333222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222222223333333333333333333333333333333333334444444444444444444444444444444444444444455555555555555555555555555555555555555555555555666666666666666666666666666666666665555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444444444444444432111111111233333333333333333333333333333333333333333333333333333333333334444444444444444444444444444444444444444444444444444444321111111123333333333333333333333333333333333333332210000001222333333333322222222222222222222222222222222222222222222222221//////122222223333333333333333333333333222222222222222",
		dlg_beginner_4
	},
	{
		'Z','@',
		0,
		0,
		0,
		0,
		0,
		0
	}
};

const LEVEL champion[] = 
{
	{
		'@','E',
		120000,
		65830,
		&city,
		cl_city,
		" @                                                                                                 b2             b2                                                                                t                                                                                     UUU                                                                                       t          h2                h3                                                                                                                      #                                          b2                                                                            b2       b3           b4                                                                                              U                                                                            t                                  b2                                                                                                 t            t            t                              # r                                                                                                                                                                                                                                                                                                                    U                                                                                        DD                              r                                                                      UU                                                                                                   D                                                                                                               U                                                                                                                  #              DB                                                                                               UB                                                                                               DB                                                                                               UB                                                                                               DB                                                                                               UB                                                                                               DB                                     #                                                         UB                                                                 UDU                                                                                        UU                                                                                                                                                                                                                                                                                                                                          #",
		"333333333333333333333333333333333333333333333333333333333444444444444444444333333444444444444445555555555555555555555555444444444444433333333333333333332222222222222222222222222222222221111122222222222222222222222221111222222222222222222223333211001123333322222222222221111111111111111111111111111111111112222222222223333333333333344444444444444444444444433333344444444444444444444444444444444444444444444444444444333333333333333333333333333222223333333333333333322222222222222222222211111112222222222222222222222222223333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333344444444444444444444444444444444444444444444444444444444444444444444455555555555555555555555555432222234555555555555555555444444445555555555555555555555544444444444444444333333333333333322222233333333210//////01233333333333333333333322223333333344444444444444444444555555555555555444444455555555555555544444444444444444444444444444443333344444444444444444444444444444444444444444444444444333333333444444444444444444444445555555555555555555555544444555555555555555444444444555555555555555544444444444444444444333444444444455555555555554444444433333344444444444444444444444443333444444444445555555555554444444444444444444433333444444445555555555555555555555444444555555555555555555555555444445555555555544444444444444444333333333333333332222222222222111112222222222222222222222222222222222222222221111122222222223333333333333333333333333444444444444444443333333333333333333333333222222233333333333333333333333333333333332222222222223333333333333333333332223333333332222222222222222222222222222222222221111111111222222222222222222222233333333333333333444444444444444445555555555444445555555555555555555555555555555444444444455555555555444444433344444444444444444444444555555555555544444444444444444443333334444444444444444433333444444455555555555544444444444444444444433334444444455555555555555555555555555544444455555555555555555555554444455555555444444444444444444444444444555555555555444455555555555555555555555544444444455555544444444444444444444443333333333333333333333333332222222333333333333333333333333332222222222111112222223333333333333333333322222222333333333333333333332222333333333444444444444444444444455555555555555444444444555555555555544445555555555555544444444443333333332222222222222222222222221111122222222222222222222222222333333333333333333333344444444444444444443333334444444444444444444444333344444444455555555555555555555544444444444444433333333444444444444444444433333333444444444443333333333333333333333222222222222222222221111111222222222222222222222222222233333333344444444455555555555444455555555555555555444445555555555555555554444444444444444444444333333333333333333333333333333322222233333333333333333333333222222222211112222222233333333333333322223333333333333333333333333333222333333333344444444443333444444445555555555555544444555555555555555555555554445555555555444444444333333333222222222222222221111111222222222222222222222222333333333333333332222222222222222222221111112222222222222",
		dlg_champion_0
	},
	{
		'E','J',
		120000,
		67050,
		&mountains,
		cl_mountains,
		" @                                                                                           U                                                                                                  D                                             c                             U                                                                     B                               c                                                      U                                                                                       D                                                                                          B                                        c                                             U                                                                 #               D                                                                                            B                                     c                                          U                            c                                           D                                                                             B                                                                      #   U                                                     c                         D                     c                                                                 UU                                                                                              D                                                       c                    B                          c                                                   UU              c                                          #                             D                                                                                      D                                                                        U                                                                            DD                                                                       U                                                                      UU                                                                                   B          c                                                             U                                   c                                        D                      #                                                         D                                                                                U                        c                                            c                              U                                                                                      U                                                                                      DD                                     c                                                  UU                     c                                                   c              D                                                                                                                                                                                       #",
		"4444444444444444444444444444444444444444444444444444444444444444444444444455555555555555555555554444444444444444444333333333333322222222222222111111111111111111111122222222222223333333333334444444444444444444444444444445555555555555555432222222222345555555555555555555555555555555555555555555555555555544444444444443333333333332222222222222222222222222222222222222222222222222222222222222222222222222222222222223333333333333333333333333333344444444444445555555555556666666666666666666666555555555555554444444444444433333333333333333322222222222222222222223333333333333333333333333333333333322222222222222222222222222222223333333344444445555554322222222223455555555555544444444444444444444444444444444444555555555555555555555444444444444444444433333333333333222222222222221111111111111111111112222222222222333333333333344444444444444444444444444444555555555555555555555555555555555555555555555555555555432222222222345555555555555554444444444444333333333333322222222222222222222222222222222222222222222222222222222222222222222222222222222222333333333333333333333333333334444444444444555555555555566666666666666666666655555555555555444444444444443333333333333333333222222222222222222222333333333333333333333333333333333332222222222222222222222222222222233333334444444455555554322222222223455555555554444444444444444444444444444444444455555555555555555555554444444444444444443333333333333322222222222222111111111111111111111122222222222233333333333334444444444444444444444444444455555555555555543222222222234555555555555555555555555555555555543222222222234555555544444444444433333333333332222222222222222222222222222222222222222222222222222222222222222222222222222222222233333333333333333333333333333344444444444455555555555556666666666666666666666555555555555554444444444444333333333333333333322222222222222222222233333333333333333333333333333333333322222222222222222222222222222223333333444444445555555555555555555555555555555444444444444444444444444444444444445555555555555555555555444444444444444444433333333333332222222222222211111111111111111111112222222222222333333333333444444444444444444444444444444555555555555555555555555555555555555555555555555555543222222222234555555555555555554444444444444333333333333222222222222222222222222222222222222222222222222222222222222222222222222222222222222333333333333333333333333333334444444444444555555555555666666666666666666666655555555555555444444444444433333333333333333332222222222222222222222333333333333333333333333333333333332222222222222222222222222222222333333334444444555555432222222222345555555555554444444444444444444444444444444444455555555555555555555544444444444444444443333333333333222222222222222111111111111111111111222222222222233333333333334444444444444444444444444444455555555555555555555555555555555555555543222222222234555555555555555555555555555555444444444444433333333333332222222222222222222222222222222222222222222222222222222222222222222222222222222222233333333333333333333333333333444444444444455555555555556666666666666666666665555555555555544444444444444333333333333333333322222222222222222222233333333333333333333333333333333",
		dlg_champion_1
	},
	{
		'J','O',
		120000,
		61350,
		&city,
		cl_city,
		" @                                                                                                    m                                                    m                                                     m                       m                              m       m                                m    m                                                             m                                                     m                                   m                                                 m    h2                               m                                  m                                h3                       m                              m      m     h2                       h2           m                                                                    #                                                                                                                                 h2                                        m                                        m     m                             m    m                                           m                           m                              m                                          h3                                                    #                                                                        b2   b2     b2                                                B DD                                                                  b2    b4       b2                B UU                     b4      b4                                                                B                        #                                              B                                                                               B                                                                           B                                                                                              B                                                                              B                                                                               B                                                                                         B                               #                                               B                                                                                                                                   D                                                                                         U                                                                       X1    D                                                                                                         U                                                             U                                                                                                                                   #X9",
		"555555555555555555554455433334433333333344555555555555555555555555555555555544455555555555555555544555555555555555544555445555555555555445555555555555555555555555445555555555555555555444555555555555555555445555555555555555445554455555555555554455555555555555555555555554455555555555555555555555544555555555555555544555445555555555554432111233455555555555555554455555555555555555555555555555555555555444444444444444444444445555555555555555555555555554444455555555555554322112223454445444554455555555555555445555555555555544444554454455555555554455555555555555555555555554455543321112233555554445555555555555555554455555555555555554455544544555555555544555555555555555555555555544555555555555555555544455555555555555555544555555555555555544555445445555555555445555555555555555555554454455555555555555555555444444444444444444444444444444444444444333333333333333333333333333333333333333222222222222222222222222222222222222112345555555544555555555555555554455544544555555555544555555555555555555555555445555555555555555555444454455555555555555544555555555555555445555445445555555555445555555555555555555555554455555555555555555554445555555555555555554455555555555555554455554454455555555554455555555555555555555567888876555555555555555544455555555555555555544444444444444444444444444444444444444444444444444444444444444444444444444444444444444444555555555555555555445555555555555555445555445445555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555544555555555555555544555543321112234555544555555555555555555555555445555555555555555555444555555555555555555445555555555555555445554455445555555555445555555555555555555555554455555555555555555554445555555555555555554455555555555555554455544554455555555544555555555555555555555555544555555555555555555544455555555555555555544555555555443111233455445555555555555445555555555555555555555555445555555432211222345444555555555555555555445555555555555555445554455555555555554455555555555555555555555544555555555555555555444455555555555555555554455555555555555554455544544555555555544555555555555555555555555544555555555555555555544455555555555555555544555555555555555544555445445555555555445555555555555555555555554455555555555555555555444555555555555555555445555555555555554455554454455555555544454455544555555555555555544555555555555555555554455555555555555555544555555555555555554455544544555555555544555555555555555555555555445555555555555555555444555555555555555555445555555555555555445555445445555555555445555555555555555555555554455555555555555555555445555555555555555554455555555555555554455554454455555555554455555555555555555555555544555555555555555555544455555555555555555544555555555555554444445544544555555555544555555555555555555433211122345555555555555554455",
		dlg_champion_2
	},
	{
		'O','T',
		120000,
		59810,
		&mountains,
		cl_mountains,
		" @                                                                          h2                       h3                      h1                                                                               U   c   DD   X1                                            r                                                                          c                                                                                 c                                        BB                                                                            U                                                                     #                                  m     m                                                                                    B                                          t                                                       b1                                 b2                                           b3                                                                           b4                                                         U                                                                       #                                                                                                                      B                                                                               B                                                                                                                                                                                                                                           U                                                                             #                                                                                      t                                                                              t                                                                                      t                                            t                                             t                                                                             UDB                                                                             U            #                                                                                                             B                                                                                                                                                                                 D                                                                                                                       U                                                                                                                                                                                                              #",
		"5544554555444454444444443333343333333334444444444444444444444444444444444444444444444444444444445555555555555555555555555555555555555555555555555555555555444444444444444444444444455555555555555555555555555555555555555555554444444444444444444444444445555555555555555555543322112223444444445555555555555555555555555555555555555555555555554432222222223455555555554444444444444444444444444444444444444444444444444444444444444444444444445555555555555555555555555555555444444444332211222334544444444555555555555555555555555555555555555555555555555555555555555555555555555555444444444444444444444444444444444444455555555555555555555555555555555555555555555555555555555555555554444444444444444444444444555555555555555555555555555555555555555444444444444444444444444444444444444444444444444444444444444444444444444444444445555555555555555555555555555555555555555555555555554444444444444444444444444445555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555554444444444444444444444444444444444444444444444333333333333333333333333333333333333344444444444444444444444444444444444444444444455555555445544445444444445555554444455554455444555555554444445555555555555554444444444455555555554444445555555445554444544444444555554444444554455544555555554444444555555555555555444444444555555555554444445555555544554444444444444555555444444555445544455555555444444444455555555555544444444455555555555444444555555554455444454433221122223444444555544554455555555544444455555555555555544444444444555555544444444455555554455544445444444445555554444455544554445555555544444445555555445555554444444445555555555544444444444444444444444444444444444444433333344444444444444433334444444444444444444444444444444444455555555555555544432111233444444444555555555555555555555555555555555555555554332211222234444444555555555555555555555555555555555555555555555555555555555555555555555444444444444444444444444444444444444444444444433333333333333333333333333333333333333333333333333333444444444444444444444444444444444444444444445555555555555555555555555555555555555555555555555555555555555555555555555555555555444444444444444444444444555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555555554432211222234555555555555444",
		dlg_champion_3
	},
	{
		'T','Z',
		120000,
		72780,
		&city,
		cl_city,
		" @                                                                                                        c   X1                                                                c              c                                                                      c                                                                                    c                                                                                                   c                                                                             c                                                                        c                     c                                   #                                                                                                          t                X1                  c                                                             c                                                                            t                                                                                  h2                                                                                                           t                #                                            t   X1                                                                                                                                                                                                                                                                                                                       c         t        c                                                                                              #                                                                D                          U                     D          m             U                        D           m            U                        D        m         m       U                       D                        U                       D                       U                        D          m            U                         D        m                  U                            D   m                                  U     m                                   m        m                           D                                                         #                                                                                                                                                                                            t                                            t                                            t                                                                   t                                                           t                                                    t                                                                    #                                                                     h3                                                    h2        D                                U             b3                              b2              D                                U             b4           b2                                         D                                   U             b2            b2                             b2                                             b1                       b4                                                           b4           #",
		"55555555555555555555555555555555555555555555555555555555555444444444444444444444444444333333333333333333333333333333332222222222222222222222222222222222222222222222222222222222222222222210.123333333333333333333333333333444444432..234444444444444444444444555555555555555544443444443333333444444432...2344444444444444444444444444555555555555555544444444443333333444444432....23444444555555544443444443333333444444432...2344444444444444444444444444555555555555555444444444444444444333333333333333333333333333444444432..23444444444444444444444455555555555555554444344444333333333333333322222222222222222222222222222222210.01222222222222222222222222222222222223333333333333333333333334444444444444444444444444444444444444444455555555555555555555555666666666543.344444444444444444333333333333333444444444445555555555554310/............./0123333333333333333333333333333333333333333321000156666666666666666666666666653........0233333333333333333333333333320/.2455555555555555555555555555555554210/....../01111111111111111111111111111111110...........13444444444444444444444444444444444444431...................12222222222222222222222222233333333333333344444444444445555555555555555555555555555555555555555555420..................0111111111111111111111111111111111111111111110.................134444444444444444444444444444444444444444431.......................0111111111111111111111111111111110................03566666666666666666666665310/.............................0111111111111111111111111111222222222222222222222233333333333333333333333333333333333333444444444444444444444444444444444444444444444433333333333333333333333333333333333333333333344444444444444444444444555555555554455554332111223455554455555555555555555555555544555555555555555555544455555555555555555544555555555555555544555445544555555555544555555555555555555555555445555555555555555555444555555555555555555445555555555555555445554455445555555554455555555555555555555555554455555555555555555554445555555555555555554455555555544311123345544555555555555544555555555555555555555555544555555543221122234544455555555555555555544555555555555555544555445555555555555445555555555555555555555554455555555555555555544445555555555555555555445555555555555555445554454455555555554455555555555555555555555554455555555555555555554445555555555555554444444444444444444444444444444333333333333333333333333332222222222222222222222222222111111111111111111111111111111000000000000000000000000000000000000000000000100233333333333333333333333333333333333333333333455555555555555555555555555555555555555555445677777777777777777777777777777777776666666666655555555555555555555555555555555555555555555555555555543333333333333333333333333333333333333333333333333333321111111111111111111111111111111111111111111111111111124555555445555555555555555555555554455555555555555555554445555555555555555554455555555555555444444554454455555555554455555555555555555543321112234555555555555555555555555555445543333443333333334455555555555555555555555555555555554445555555555555555554455555555555555554455544555555555555544555555555555555555555555544555555555555555555544455555555555555555544555555555555555544555445555555555555445555555555555555555555555445555555555555555555555554455555555555555554455544555555555555455555555555555444444444555555555554444445555555544554444444444444555555444444543212100000012123444444444455555555555544444444455555",
		dlg_champion_4
	},
	{
		'Z','@',
		0,
		0,
		0,
		0,
		0,
		0
	}
};

const LEVEL dummy[] =
{
	{'@','E',0,0,0,0,"",""},
	{'E','J',0,0,0,0,"",""},
	{'J','O',0,0,0,0,"",""},
	{'O','T',0,0,0,0,"",""},
	{'T','Z',0,0,0,0,"",""},
	{'Z','@',0,0,0,0,0,0}
};

/*const*/ LEVEL test_area[]=
{
	{
		'@','#',
		120000,
		30000,
		&city,
		cl_city,
		" @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     #",
		"222233333333333333322333333333322222222222211222222211222222222112222222222222112221001222222222111111111111111222222221122222222211222222222112222222222211222222222211222222222111111112222222333333344444444443343223444443344444444444444443333333333444443344444445555555555445555554444444444444443333333333333333333222222222112222222222222112222222222112222222222211222211111111111110000/0/0111111111111111111222222223333332233333322222221122222222221111111111122222222111111112222222333333333223333333333322333332222222112222222222221122222111111111111111100111111111111110/012221122222211222222222222222222333332233333333322333333332233333333333322333333333223333333333223333333322222222222222211111111001111111111000000000000000000000001111111221122210/011111111222222222222233333334433444444444444433444444334444444444443344444444444444445555554455555555445555555555444444444334444444334443223444433444444444444433444444334444443344444444444333444444333333322333333333223333333223333333223333333333332233333333333333333333322222222222211222222222222111111100111111111100111110//01100111111111111100111111111100111111111100111111100111111111111112222211222222222222112222222222211222222211222222221122222222112222222112222222110/0122112222222222221122222222222221122222211222222222211222222222112222222222233333333333222222221122222222100122211111111112222222222222222221122222222222112222222222211222222222222112222221111111122222223222222221122222222222110//011100111111112222222222221122222211111111222222233333333322333333333333322333333333223333333333332233333333333322222222221122222222222112222222211222222222211222222222211222222222221012333333333322333332222222112222222222222112222222211111111100111111111111100111111100111111000000/00/0000111111001111111110011111111111111111111112222222222222222222333333343344444444444444333333333333322221001222221111111111001111111111100111111111001111111111100111111111111100111111111222222222211222222222222211222222233333211233334444444444444444444444443333333332222222222222222222112222222221122222222112222222222112222222222211222222222211222222112222222233333333333332222222222211222222222222211210012112222221122222222222211111111222222222222222111111111222222222211222222222233333332222222233333334444444433444444444443344444444433333333322333333333333322222222222221122222222112222222211210012112222222211222222222222222223333333322222222112222222222222112222222222211222222222112222222222222221111111111001111111100111111111111100111111110//011112222222222112222222211111111222222233332233333333333333222222222222111111111111100111111100000000111111122222222211222222222222211222222222222333211233332233333333444444433444444444443344444433444444444443344444433444444443344444433444443333333333332233333333333332233333333333223333333332101222222222222222111111112222222333333223333333333223333333333332222222221122222222211111111111111111000000001111111211222222222221111111111111100000000111111111111111111112222222221122222222333333333333"
	},
	{'Z','@',0,0,0,0,0}
};


// source for campaign menu
const COURSE campaign[] =
{
	/*
	{
		"Tutorial",
		tutorial, 0
	},
	*/
	{	// 0
		"Mission One",
		beginner, 0
	},
	{	// 1
		"The Lowering",
		champion, 0
	},

	{	// 2
		"Magnetic Mud",
		dummy, 1
	},
	{	// 3
		"Reveal",
		dummy, 1
	},
	{	// 4
		"Repayment",
		dummy, 1
	},

	{0},

	{
		"Test Area",
		test_area
	},
	{0,0}
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// intererences with optional noissy phrases, as post write screen effects (add method to Screen)
Field::Field()
{
	thr=5;
	Rand();
}

void Field::Rand()
{
	for (int i=0; i<10; i++)
	{
		generator[i][0]=twister_rand()%(240*16)-40;
		generator[i][1]=twister_rand()%(130*16)-40;
		generator[i][2]=twister_rand()%(32*16)+20*16 + 20*16;

		generator[i][3]=(twister_rand()%64-32)/8;
		if (generator[i][3]==0)
			generator[i][3]=32/8;

		generator[i][4]=(twister_rand()%32-16)/8;
		if (generator[i][4]==0)
			generator[i][4]=16/8;
	}
}

void Field::Animate()
{
	for (int i=0; i<10; i++)
	{
		generator[i][0]+=generator[i][3] - 3;
		generator[i][1]+=generator[i][4];

		if (generator[i][0]>200*16)
		{
			generator[i][0]-=240*16;
			/*
			generator[i][3]=twister_rand()%64-32;
			if (generator[i][3]==0)
				generator[i][3]=32;
			*/

		}

		if (generator[i][0]<-40*16)
		{
			generator[i][0]+=240*16;
			/*
			generator[i][3]=twister_rand()%64-32;
			if (generator[i][3]==0)
				generator[i][3]=32;
			*/
		}

		if (generator[i][1]>90*16)
		{
			generator[i][1]-=130*16;
			/*
			generator[i][4]=twister_rand()%32-16;
			if (generator[i][4]==0)
				generator[i][4]=16;
			*/
		}

		if (generator[i][1]<-40*16)
		{
			generator[i][1]+=130*16;
			/*
			generator[i][4]=twister_rand()%32-16;
			if (generator[i][4]==0)
				generator[i][4]=16;
			*/
		}

	}
}

float Field::field(int x, int y)
{
	int fy = y + 50-t->scr_height;

	float f = 0;

	for (int i=0; i<10; i++)
	{
		int dx = x*16-generator[i][0];
		int dy = 2*(fy*16-generator[i][1]);
		float d = sqrtf((float)(dx*dx+dy*dy));
		float v = generator[i][2] / (d+1);
		f+=v;
	}

	int h = t->scr_height - t->GetMaxHeight(x,5);

	if (y>=h)
		f=0;
	else
		f-= 4 / (h-y);

	return f * t->interference_mul;
}

char Field::cb(int x, int y)
{
	return field(x,y)>thr;
}

char Field::cb(int x, int y, void* p)
{
	Field* f = (Field*)p;
	return f->cb(x,y);
}


// iso-contouring on arbitrary field generation callback (separate SCREEN class)
void IsoContour(SCREEN* s, unsigned char cl, char (*cb)(int x, int y, void* p), void* p, char interior=0, char exterior=0)
{
	char sample[3][3]; // [y][x]

	static unsigned long shader[16] =
	{
	//    yxyxyx            yxyxyx            yxyxyx            yxyxyx
	//	  s1s2dd     ch     s1s2dd     ch     s1s2dd     ch     s1s2dd     ch
		0x00010000 | '/', 0x01020300 | '\\',0x02120400 | '_', 0x02120500 | '_',
		0x10011000 | '\\',0x01111100 | '_', 0x01111200 | '_', 0x01121300 | '/',
		0x10112000 | '/', 0x11122300 | '\\',0x12222400 | '_', 0x12222500 | '_',
		0x20113000 | '\\',0x11213100 | '_', 0x11213200 | '_', 0x11223300 | '/',
	};

	for (int x=2; x<=s->w+1; x+=6)
	{
		// calc 3 top samples
		sample[0][0] = cb(x-3,0,p);
		sample[0][1] = cb(x,1,p);
		sample[0][2] = cb(x+3,0,p);

		for (int y=1; y<s->h; y+=4)
		{
			// calc 3 middle 
			sample[1][0] = cb(x-3,y+1,p);
			sample[1][1] = cb(x,y+2,p);
			sample[1][2] = cb(x+3,y+1,p);

			// and 3 bottom samples
			sample[2][0] = cb(x-3,y+3,p);
			sample[2][1] = cb(x,y+4,p);
			sample[2][2] = cb(x+3,y+3,p);

			if (interior || exterior)
			for (int dy=-1; dy<3; dy++)
			{
				for (int dx=-2; dx<4; dx++)
				{
					int sx = x+dx;
					int sy = y+dy;
					if (sx<s->w && sy<s->h)
					{
						if (cb(sx,sy,p))
						{
							if (interior)
								s->buf[sx+sy*(s->w+1)]=interior;
						}
						else
						{
							if (exterior)
								s->buf[sx+sy*(s->w+1)]=exterior;
						}
					}
				}
			}

			for (int i=0; i<16; i++)
			{
				int s1x,s1y;
				int s2x,s2y;

				s1y = (shader[i] >> 28) & 0xF;
				s1x = (shader[i] >> 24) & 0xF;
				s2y = (shader[i] >> 20) & 0xF;
				s2x = (shader[i] >> 16) & 0xF;

				if (sample[s1y][s1x] ^ sample[s2y][s2x])
				{
					int dy = (shader[i] >> 12) & 0xF;
					int dx = (shader[i] >> 8) & 0xF;
					dx+= x-2;
					dy+= y-1;

					if (dx<s->w && dy<s->h)
					{
						int c = dx+(s->w+1)*dy; 
						s->buf[c] = shader[i] & 0xFF;

						if (s->color)
							s->color[c] = (s->color[c]&0xF0) | (cl&0x0F);
					}
				}
			}

			// move 3 bottom samples to top
			sample[0][0] = sample[2][0];
			sample[0][1] = sample[2][1];
			sample[0][2] = sample[2][2];
		}
	}
}

void Interference(SCREEN* s, int dist, int noise, unsigned long phase, int freq, int amp, bool sync)
{
	for (int y=0; y<s->h; y++)
	{
		char* ptr = s->buf + y*(s->w+1);

		if (dist>0 || amp>0)
		{
			int dx = twister_rand()%(2*(dist+1)-1)-dist;
			dx += (int)sinf((phase*4+freq*y)*0.001f)*amp;
			if (dx>s->w)
				dx = s->w;
			else
			if (dx<-s->w)
				dx = -s->w;

			if (dx>0)
				memmove(ptr+dx,ptr,s->w-dx);
			else
			if (dx<0)
				memmove(ptr,ptr-dx,s->w+dx);

			if (s->color)
			{
				char* clr = s->color + y*(s->w+1);
				if (dx>0)
				{
					memmove(clr+dx,clr,s->w-dx);
					//memset(clr,0,dx);
				}
				else
				if (dx<0)
				{
					memmove(clr,clr-dx,s->w+dx);
					//memset(clr+s->w+dx,0,-dx);
				}

			}
		}

		if (noise>0)
		{
			for (int x=0; x<s->w; x++)
			{
				if (twister_rand()%noise==0)
				{
					if (ptr[x]=='.')
						ptr[x]=' ';
					else
						ptr[x]='.';
				}
			}
		}
	}

	if (sync)
	{
		int sync_y = (phase/30)%s->h;

		if (sync_y)
		{
			char tmp[161*50];
			memcpy(tmp,s->buf,(s->w+1)*s->h);

			for (int y=0; y<s->h; y++)
				memcpy(s->buf+y*(s->w+1), tmp+((y+sync_y)%s->h)*(s->w+1),s->w);

			if (s->color)
			{
				memcpy(tmp,s->color,(s->w+1)*s->h);
				for (int y=0; y<s->h; y++)
					memcpy(s->color+y*(s->w+1), tmp+((y+sync_y)%s->h)*(s->w+1),s->w);
			}
		}
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static SPRITE* sprite_garbage = 0;

static SPRITE* NewSprite()
{
	SPRITE* s=sprite_garbage;
	if (s)
	{
		sprite_garbage = s->next;
		s->Init();
	}
	else
		s = new SPRITE();

	return s;
}


static SPRITE* NewSprite(const ASSET* anim)
{
	SPRITE* s=sprite_garbage;
	if (s)
	{
		sprite_garbage = s->next;
		s->Init(anim);
	}
	else
		s = new SPRITE(anim);

	return s;
}

static SPRITE* NewSprite(const char* name)
{
	SPRITE* s=sprite_garbage;
	if (s)
	{
		sprite_garbage = s->next;
		s->Init(name);
	}
	else
		s = new SPRITE(name);

	return s;
}

static SPRITE* NewSprite(int _score)
{
	SPRITE* s=sprite_garbage;
	if (s)
	{
		sprite_garbage = s->next;
		s->Init(_score);
	}
	else
		s = new SPRITE(_score);

	return s;
}

static void DeleteSprite(SPRITE* s)
{
	s->next=sprite_garbage;
	sprite_garbage=s;
}

void GamePreAlloc()
{
	for (int i=0; i<100; i++)
	{
		SPRITE* s = new SPRITE();
		DeleteSprite(s);
	}
}


unsigned char cl_label  = 0x0F;
unsigned char cl_score  = 0x70;

unsigned char cl_statbkgnd = 0x80;
unsigned char cl_statvalue = 0x7B;
unsigned char cl_statlabel = 0x7F;

unsigned char cl_ground = 0x73;
char ch_ground='%';

unsigned char cl_bullet = 0x7F;
char ch_bullet='|';

unsigned char cl_basher = 0x7F;//0xAF;
unsigned char cl_drone  = 0x7F;//0xDF;
unsigned char cl_ufo  = 0x7F;//0xEF;
char ch_basher='W';
char ch_drone='V';
char ch_ufo='U';


int tank_score=300;
int creature_score=250; // times 2 if flesh is destoryed too
int group_score=400; // times number of flyiers
int rocket_score=500;
int ball_score=100; // times size
int heap_score=50; // times size
int ufo_score=100;
int drone_score=50;
int basher_score=250;

// SPRITES lowercase (on ground enemies and obstacles)
// -----------------------------------------
// s			- start base?
// h1,h2,h3		- heaps: 1-tiny 2-regular 3-double
// m			- land mine
// b1,b2,b3,b4	- balls: 1-tiny 2-small 3-regular 4-large
// c			- creature
// t			- tank
// r			- rocket 

// SPRITES uppercase (flying objects)
// U            - ufo
// D			- drone
// B			- bomber

void resize_con_output(CON_OUTPUT* s, int _w, int _h, char transp)
{
	if (_w<=0 || _h<=0)
		return;
	if (s->arr)
		free_con_output(s);
	s->arr = 0;

	int size = (_w+1)*_h;
	if (s->color)
		size*=2;

	char* buf2 = new char[size];
	memset(buf2,transp,(_w+1)*_h);
	for (int i=0; i<_h; i++)
		buf2[(_w+1)*i+_w]='\n';
	buf2[(_w+1)*_h-1]=0;
		
	int mh = MIN(s->h,_h);
	int mw = MIN(s->w,_w);
	for (int i=0; i<mh; i++)
		memcpy(buf2+(_w+1)*i,s->buf+(s->w+1)*i,mw);

	char* color2 = 0;
	if (s->color)
	{
		color2 = buf2+(_w+1)*_h;
		for (int i=0; i<mh; i++)
			memcpy(color2+(_w+1)*i,s->color+(s->w+1)*i,mw);
	}

	delete [] s->buf;

	s->buf = buf2;
	s->color = color2;
	s->w=_w;
	s->h=_h;
}

SCREEN::~SCREEN()
{
	free_con_output(this);
	delete [] buf;
}
	
SCREEN::SCREEN(int _w, int _h, char transp, unsigned char _tcolor)
{
	color=0;
	arr=0;
	t=transp;
	w=_w;
	h=_h;

	int size = (w+1)*h;
	if (_tcolor)
		size*=2;
	buf = new char[size];
	for (int i=0; i<h; i++)
		buf[(w+1)*i+w]='\n';
	buf[(w+1)*h-1]=0;
	if (_tcolor)
		color = buf+(w+1)*h;
	tcolor = _tcolor;
}

void SCREEN::Clear()
{
	for (int y=0; y<h; y++)
	{
		for (int x=0; x<w; x++)
		{
			buf[(w+1)*y+x]=t;
		}
	}

	if (color)
		memset(color,tcolor,(w+1)*h);
}

void SCREEN::Resize(int _w, int _h)
{
	resize_con_output(this, _w,_h,t);
}


void SCREEN::BlendPage(SCREEN* scr, int dx, int dy, int sx, int sy, int sw, int sh)
{
	ClipTo(scr,dx,dy,sx,sy,sw,sh);

	char* clr = color;
	if (!scr->color)
		clr=0;

	for (int y=0; y<sh; y++)
	{
		for (int x=0; x<sw; x++)
		{
			char under = scr->buf [ (scr->w+1)*(dy+y) + dx+x ];
			char over  = buf [ (w+1)*(sy+y) + sx+x ];

			if (over!=t)
			{
				scr->buf[(scr->w+1)*(y+dy)+dx+x] = buf[(w+1)*(y+sy)+x+sx];
				if (clr)
				{
					unsigned char cl = clr[(w+1)*(y+sy)+x+sx];
					if (over=='|' && under!=t)
					{
						cl = scr->color[(scr->w+1)*(y+dy)+dx+x];
						switch (cl&0xf0)
						{
							case 0xF0: cl = 0xF7; break;
							case 0x70: cl = 0x78; break;
							case 0x80: cl = 0x80; break;
						}
					}

					scr->color[(scr->w+1)*(y+dy)+dx+x] = cl;
				}
			}
		}
	}
}


void SCREEN::Paint(SCREEN* scr, int dx, int dy, int sx, int sy, int sw, int sh, bool blend)
{
	ClipTo(scr,dx,dy,sx,sy,sw,sh);

	if (blend)
	{
		for (int y=0; y<sh; y++)
		{
			for (int x=0; x<sw; x++)
			{
				char under = scr->buf [ (scr->w+1)*(dy+y) + dx+x ];
				char over  = buf [ (w+1)*(sy+y) + sx+x ];

				if (over!=t)
				{
					if (over!='_' && over!=',' && over!='.' || 
						// under!='*' && under!=':' && under!='(' && under!='|' && under!=')' && under!='/' && under!='\\' || 
						under==',' || under=='.' || under=='_' || under==' ' || 
						(sy+y>0 && buf [ (w+1)*(sy+y-1) + sx+x ]!=t))
					{

						// TODO: COLOR
						if (scr->color && color)
							scr->color [ (scr->w+1)*(dy+y) + dx+x ] = color [ (w+1)*(sy+y) + sx+x ];

						scr->buf [ (scr->w+1)*(dy+y) + dx+x ] = buf [ (w+1)*(sy+y) + sx+x ];
					}
				}
			}
		}
	}
	else
	for (int y=0; y<sh; y++)
		memcpy(scr->buf + (scr->w+1)*(dy+y) + dx, buf + (w+1)*(sy+y) + sx, sw*sizeof(char) );
}

int SCREEN::Write(int dw, int dh, int sx, int sy, int sw, int sh)
{
	if (sw<0)
		sw=w;
	if (sh<0)
		sh=h;

	if (sx<0)
	{
		sw+=sx;
		sx=0;
	}
	if (sy<0)
	{
		sh+=sy;
		sy=0;
	}

	if (sx+sw>w)
	{
		sw = w-sx;
	}
	if (sy+sh>h)
	{
		sh = h-sy;
	}

	vsync_wait();

	return screen_write(this, dw,dh,sx,sy,sw,sh);
}


bool SCREEN::ClipTo(SCREEN* scr, int& dx, int& dy, int& sx, int& sy, int& sw, int& sh)
{
	if (sw<0)
		sw=w;
	if (sh<0)
		sh=h;
	if (dx<0)
	{
		sx+=-dx;
		sw+=dx;
		dx=0;
	}
	if (dy<0)
	{
		sy+=-dy;
		sh+=dy;
		dy=0;
	}

	if (sx<0)
	{
		dx+=-sx;
		sw+=sx;
		sx=0;
	}
	if (sy<0)
	{
		dy+=-sy;
		sh+=sy;
		sy=0;
	}

	if (sx+sw>w)
	{
		sw = w-sx;
	}
	if (sy+sh>h)
	{
		sh = h-sy;
	}

	if (dx+sw>scr->w)
	{
		sw = scr->w-dx;
	}
	if (dy+sh>scr->h)
	{
		sh = scr->h-dy;
	}

	return sw>0 && sh>0;
}

SPRITE::~SPRITE() 
{
}

SPRITE::SPRITE()
{
	Init();
}

void SPRITE::Init()
{
	attrib_mask=0xFF;
	attrib_over=0x00;
	data_pos=-1;
	group_id=-1;
	cookie=0;
	cookie_data[0]=0;
	cookie_data[1]=0;
	cookie_data[2]=0;
	cookie_data[3]=0;
	x_offset = 0;
	y_offset = 0;
	next = 0;
	prev = 0;
	data = 0;
	width = 0;
	height = 0;
	frames = 0;
	frame = 0;
	asset.mono = 0;
	asset.shade = 0;
	asset.color = 0;
}

SPRITE::SPRITE(const ASSET* anim)
{
	Init(anim);
}

void SPRITE::Init(const ASSET* anim)
{
	attrib_mask=0xFF;
	attrib_over=0x00;
	data_pos=-1;
	group_id=-1;
	cookie=0;
	cookie_data[0]=0;
	cookie_data[1]=0;
	cookie_data[2]=0;
	cookie_data[3]=0;
	x_offset = 0;
	y_offset = 0;
	next = 0;
	prev = 0;
	data = anim;
	width = AnimWidth(data);
	height = AnimHeight(data);
	frames = AnimFrames(data);
	frame = 0;
	asset.mono = 0;
	asset.shade = 0;
	asset.color = 0;
}

SPRITE::SPRITE(const char* name)
{
	Init(name);
}

void SPRITE::Init(const char* name)
{
	attrib_mask=0xFF;
	attrib_over=0x00;
	data_pos=-1;

	int l = (int)strlen(name);
	if (l>80)
		l=80;
	memcpy(score_text,name,l);
	score_text[l]=0;

	memset(score_attr,cl_label,80);

	score_anim[0] = score_text;
	score_anim[1] = 0;

	score_color[0] = score_attr;
	score_color[1] = 0;

	asset.mono = score_anim;
	asset.shade = score_anim;
	asset.color = score_color;

	x_offset = 0;
	y_offset = 0;
	next = 0;
	prev = 0;
	data = &asset;
	width = AnimWidth(data);
	height = AnimHeight(data);
	frames = AnimFrames(data);
	frame = 0;
}

SPRITE::SPRITE(int _score)
{
	Init(_score);
}

void SPRITE::Init(int _score)
{
	attrib_mask=0xFF;
	attrib_over=0x00;
	data_pos=-1;

	score_anim[0] = score_text;
	score_anim[1] = 0;

	memset(score_attr,cl_score,16);
	score_color[0] = score_attr;
	score_color[1] = 0;


	// 5 digs max?

	char t[8];
	int l = sprintf_s(t,8,"%d",_score);

	for (int i=0; i<l; i++)
	{
		score_text[2*i]=t[i];
		score_text[2*i+1]=' ';//'*';
	}

	score_text[2*l-1]=0;

	// TODO: SCORE COLOR?

	asset.mono = score_anim;
	asset.shade = score_anim;
	asset.color = score_color;

	group_id=-1;
	cookie='scor';

	x_offset = 0;
	y_offset = 0;
	next = 0;
	prev = 0;
	data = &asset;
	width = AnimWidth(data);
	height = AnimHeight(data);
	frames = AnimFrames(data);
	frame = 0;
}

void SPRITE::SetFrame(int fr)
{
	if (fr<0)
		fr+=frames*(1-fr/frames);

	frame = fr%frames;
}

bool SPRITE::HitTest(int sx, int sy)
{
	if (sx<0 || sy<0 || sx>=width || sy>=height)
		return false;
	const char* img = data->mono[frame];
	char c = img[(width+1)*sy+sx];

	// 1. must not be transparent
	if (c == '*')
		return false;
		
	// 2. rocket flames are not lethal
	if (cookie=='r' && sx<width/2)
		return false;

	return true;
}

void SPRITE::Paint(SCREEN* scr, int dx, int dy, int sx, int sy, int sw, int sh, char bgkey, bool blend)
{
	if (sw<0)
		sw=width;
	if (sh<0)
		sh=height;
	if (dx<0)
	{
		sx-=dx;
		sw+=dx;
		dx=0;
	}
	if (dy<0)
	{
		sy-=dy;
		sh+=dy;
		dy=0;
	}

	if (dx+sw>scr->w)
	{
		sw=scr->w-dx;
	}
	if (dy+sh>scr->h)
	{
		sh=scr->h-dy;
	}

	if (sx+sw>width)
	{
		sw = width-sx;
	}

	if (sy+sh>height)
	{
		sh = height-sy;
	}
		
	const char* img = data->mono[frame];
	const char* clr=0;

	if (scr->color)
	{
		img = data->shade[frame];
		clr = data->color[frame];
	}

	for (int y=0; y<sh; y++)
	{
		for (int x=0; x<sw; x++)
		{
			char under = scr->buf[(scr->w+1)*(y+dy)+dx+x];
			char over  = img[(width+1)*(y+sy)+x+sx];

			if (over!='*' && (!bgkey || under==bgkey))
			{
				if (!blend ||
					over!='_' && over!=',' && over!='.' || 
					//under!='*' && under!=':' && under!='(' && under!='|' && under!=')' && under!='/' && under!='\\' || 
					under==',' || under=='.' || under=='_' || under==' ' || 
					(sy+y>0 && img[(width+1)*(y+sy-1)+x+sx]!='*'))
				{
					scr->buf[(scr->w+1)*(y+dy)+dx+x] = img[(width+1)*(y+sy)+x+sx];
					if (clr)
					{
						unsigned char fg = ( clr[(width+1)*(y+sy)+x+sx] & attrib_mask ) | attrib_over; // used by intro and gameover
						unsigned char bg = ( clr[(width+1)*(y+sy)+x+sx] & attrib_mask ) | ( ~clr[(width+1)*(y+sy)+x+sx] & attrib_over ); // used by fonts

						// new bg protection
						/*
						if ((over=='_' || over==',' || over=='.') && (sy+y>0 && img[(width+1)*(y+sy-1)+x+sx]=='*'))
							bg = scr->color[(scr->w+1)*(y+dy)+dx+x];
						*/

						scr->color[(scr->w+1)*(y+dy)+dx+x] = (fg & 0x0F) | (bg & 0xF0);
					}
				}
			}
		}
	}
}

int SPRITE::AnimWidth(const ASSET* a)
{
	if (!a)
		return 0;
	const char** anim = a->mono;

	if (!anim || !anim[0])
		return 0;
	const char* brk = strchr(anim[0],'\n');
	if (brk)
		return (int)(brk-anim[0]);
	return (int)strlen(anim[0]);
}

int SPRITE::AnimHeight(const ASSET* a)
{
	if (!a)
		return 0;
	const char** anim = a->mono;

	if (!anim || !anim[0])
		return 0;

	int c=1;
	const char* brk = strchr(anim[0],'\n');
	for (int i=0; brk; i++)
	{
		brk = strchr(brk+1,'\n');
		c++;
	}

	return c;
}

int SPRITE::AnimFrames(const ASSET* a)
{
	if (!a)
		return 0;
	const char** anim = a->mono;

	if (!anim)
		return 0;
	int c=0;
	for (int i=0; anim[i]; i++)
		c++;
	return c;
}

CHASSIS::~CHASSIS() 
{
}

CHASSIS::CHASSIS():SPRITE(&chassis), b(&boom) 
{
	ex = -1;
}

void CHASSIS::Paint(SCREEN* s, int dx, int dy, int sx, int sy, int sw, int sh, char underkey, bool blend)
{
	if (ex>=4)
		return;

	if (ex<2)
		SPRITE::Paint(s,dx,dy,sx,sy,sw,sh,underkey);

	if (ex<0)
		return;

	b.Paint(s,dx,dy,sx,sy,sw,sh);
}

void CHASSIS::Explode(int f)
{
	if (f>=0)
	b.SetFrame(f);
	ex = f;
}

SCROLL::~SCROLL() 
{
}

SCROLL::SCROLL(int _w, int _h, char transp, unsigned char _tcolor) : SCREEN(_w,_h,transp,_tcolor) 
{
	scroll=0;
}

void SCROLL::Paint(SCREEN* scr, int dx, int dy, int sx, int sy, int sw, int sh, bool blend)
{
	if (!ClipTo(scr,dx,dy,sx,sy,sw,sh))
		return;

	int a = scroll%w;
	if (blend)
	{
		for (int y=0; y<sh; y++)
		{
			for (int x=0; x<sw-a; x++)
			{
				char under = scr->buf [ (scr->w+1)*(dy+y) + dx+x ];
				char over  = buf [ (w+1)*(sy+y) + sx+a+x ];

				if (over!=t)
				{
					if (over!='_' && over!=',' && over!='.' || 
						// under!='*' && under!=':' && under!='(' && under!='|' && under!=')' && under!='/' && under!='\\' || 
						under==',' || under=='.' || under=='_' || under==' ' || 
						(sy+y>0 && buf [ (w+1)*(sy+y-1) + sx+a+x ]!=t))
					{
						scr->buf [ (scr->w+1)*(dy+y) + dx+x ] = buf [ (w+1)*(sy+y) + sx+a+x ];
						if (scr->color && color)
							scr->color [ (scr->w+1)*(dy+y) + dx+x ] = color [ (w+1)*(sy+y) + sx+a+x ];
					}
				}
			}
			for (int x=0; x<a; x++)
			{
				char under = scr->buf [ (scr->w+1)*(dy+y) + dx+(sw-a)+x ];
				char over  = buf [ (w+1)*(sy+y) + sx+x ];

				if (over!=t)
				{
					if (over!='_' && over!=',' && over!='.' || 
						// under!='*' && under!=':' && under!='(' && under!='|' && under!=')' && under!='/' && under!='\\' ||
						under==',' || under=='.' || under=='_' || under==' ' || 
						(sy+y>0 && buf [ (w+1)*(sy+y-1) + sx+x ]!=t))
					{
						scr->buf [ (scr->w+1)*(dy+y) + dx+(sw-a)+x ] = buf [ (w+1)*(sy+y) + sx+x ];
						if (scr->color && color)
							scr->color [ (scr->w+1)*(dy+y) + dx+(sw-a)+x ] = color [ (w+1)*(sy+y) + sx+x ];
					}
				}
			}
		}
	}
	else
	for (int y=0; y<sh; y++)
	{
		if (sw>a)
		{
			memcpy(scr->buf + (scr->w+1)*(dy+y) + dx, buf + (w+1)*(sy+y) + sx+a, (sw-a)*sizeof(char) );
			if (scr->color && color)
				memcpy(scr->color + (scr->w+1)*(dy+y) + dx, color + (w+1)*(sy+y) + sx+a, (sw-a)*sizeof(char) );
		}
		if (a>0)
		{
			memcpy(scr->buf + (scr->w+1)*(dy+y) + dx+(sw-a), buf + (w+1)*(sy+y) + sx, a*sizeof(char) );
			if (scr->color && color)
				memcpy(scr->color + (scr->w+1)*(dy+y) + dx+(sw-a), color + (w+1)*(sy+y) + sx, a*sizeof(char) );
		}
	}
}

void SCROLL::Resize(int _w, int _h)
{
	if (_w<=0 || _h<=0)
		return;

	if (arr)
		free_con_output(this);
	arr = 0;

	int size = (_w+1)*_h;
	if (tcolor)
		size*=2;

	char* buf2 = new char[size];
	for (int i=0; i<_h; i++)
		buf2[(_w+1)*i+_w]='\n';
	buf2[(_w+1)*_h-1]=0;
		
	int mh = MIN(h,_h);
	int mw = MIN(w,_w);

	for (int i=mh; i<_h; i++)
		memset(buf2+(_w+1)*i,t,_w);

	char* color2 = 0;
	if (tcolor)
	{
		color2 = buf2+(_w+1)*_h;
		memset(color2,tcolor,(_w+1)*_h);
	}


	for (int i=0; i<mh; i++)
	{
		if (_w>w)
		{
			int _a = (scroll-1)%_w;
			int a = (scroll-1)%w;
			for (int j=scroll-1; j>=scroll-w; j--)
			{
				buf2[(_w+1)*i+_a] = buf[(w+1)*i+a];

				if (tcolor)
					color2[(_w+1)*i+_a] = color[(w+1)*i+a];

				if (--_a<0)
					_a=_w-1;
				if (--a<0)
					a=w-1;
			}
		}
		else
		if (_w<w)
		{
			int _scroll = scroll - (w-_w);
			int _a = (_scroll-_w)%_w;
			int a = (scroll-w)%w;
			for (int j=_scroll-_w; j<_scroll; j++)
			{
				buf2[(_w+1)*i+_a] = buf[(w+1)*i+a];

				if (tcolor)
					color2[(_w+1)*i+_a] = color[(w+1)*i+a];

				if (++_a>=_w)
					_a=0;
				if (++a>=w)
					a=0;
			}
		}
		else
		{
			memcpy(buf2+(_w+1)*i,buf+(w+1)*i,mw);
			if (tcolor)
				memcpy(color2+(_w+1)*i,color+(w+1)*i,mw);
		}
	}

	int dw = _w-w;

	delete [] buf;
	buf = buf2;
	color = color2;

	w=_w;
	h=_h;

	if (dw>0)
		Scroll(dw);
	else
	if (dw<0)
		scroll += dw;
}

void SCROLL::Scroll(int s)
{
	scroll+=s;
}

BACKGROUND::~BACKGROUND()
{
}

BACKGROUND::BACKGROUND(int _w, int _h, unsigned char _tcolor) : SCROLL(_w,_h,' ',_tcolor) 
{ 
	Scroll(w); 
}

void BACKGROUND::Scroll(int s)
{
	// pure visual rng
	// twister_switch(1);

	for (int i=0; i<s; i++)
	{
		int q = twister_rand()%(3*h);

		int a = scroll%w;

		if (color)
		{
			for (int y=0; y<h; y++)
			{
				buf[(w+1)*y+a] = '.';
				color[(w+1)*y+a] = tcolor;
			}

			if (q<h)
			{
				buf[(w+1)*q+a] = '.';
				color[(w+1)*q+a] = (cl_transp&0xF0)+9+twister_rand()%7;
			}
		}
		else
		{
			for (int y=0; y<h; y++)
				buf[(w+1)*y+a] = ' ';

			if (q<h)
			{
				buf[(w+1)*q+a] = '.';
				twister_rand(); // keep in sync with color
			}
		}

		scroll++;
	}

	//twister_switch(0);
}

LANDSCAPE::~LANDSCAPE() 
{
}

LANDSCAPE::LANDSCAPE(int _w, int _h, const ASSET* _data, unsigned char _tcolor) : SCROLL(_w,_h,'*',_tcolor) 
{ 
	data = _data;
		
	// len = (int)strlen(data->mono[0])/h;
	// now we have \n per row (except last one)
	len = (int)(strlen(data->mono[0])-(h-1))/h;

	Scroll(w); 
}

void LANDSCAPE::Scroll(int s)
{
	for (int i=0; i<s; i++)
	{
		int a = scroll%w;
		int b = scroll%len;

		// TODO: COLOR
		// if this landscape contains color
		// copy shade+color otherwise just mono

		const char* img = data->mono[0];
		const char* clr = 0;

		if (color)
		{
			img = data->shade[0];
			clr = data->color[0];
		}

		for (int y=0; y<h; y++)
		{
			//buf[(w+1)*y+a] = data->mono[0][y*len+b];
			// now we have \n per row (except last one)
			buf[(w+1)*y+a] = img[y*(len+1)+b];

			if (color)
				color[(w+1)*y+a] = clr[y*(len+1)+b];
		}


		scroll++;
	}
}

TERRAIN::~TERRAIN() 
{
	if (check_point)
		delete [] check_point;

	if (data)
		delete [] data;

	SPRITE* spr = head;
	while (spr)
	{
		SPRITE* nxt = spr->next;
		DeleteSprite(spr);
		spr=nxt;
	}

	spr = fly_head;
	while (spr)
	{
		SPRITE* nxt = spr->next;
		DeleteSprite(spr);
		spr=nxt;
	}
}
	
TERRAIN::TERRAIN(int _w, int _h, int _scrh, unsigned char _tcolor, const char* sprite, const char* height, char* _hitbin, char _base_point, char _start_point, int _lives) : SCROLL(_w,_h,'*',_tcolor) 
{
	hitbin = _hitbin;
	hits = 0;

	lives = _lives;

	interference_size = 0;

	group_id = -1;
	memset(group_len,0,sizeof(int)*16);
	memset(group_mul,0,sizeof(int)*16);

	sprite_scroll = -1;
	scr_height = _scrh;

	bullets = 0;

	items = sprite;
	items_len = (int)strlen(items);

	// analyse checkpoints
	base_point = _base_point; // ( for check_point[1] )
	_start_point = _start_point - _base_point + 1;

	int nchk=0;
	for (const char* ptr = items-1; ptr; ptr = strchr(ptr+1,'#'))
		nchk++;

	check_point = 0;
	check_points = nchk;
	if (nchk)
	{
		check_point = new int[nchk];

		nchk=0;
		for (const char* ptr = items-1; ptr; ptr = strchr(ptr+1,'#'))
		{
			check_point[nchk] = (int)(ptr-items);
			nchk++;
		}
	}

	check_passed = _start_point;
	if (check_passed> nchk)
		check_passed = nchk;

	scroll = check_point[_start_point] - 21;
	if (scroll<0)
		scroll=0;

	check_scroll = check_passed;
	for (int i = scroll; i<items_len && i<scroll+w; i++)
		if (items[i]=='#')
			check_scroll--;

	len = (int)strlen(height);
	data = new char[len+1];
	memcpy(data,height,len+1);

	head = tail = 0;
	fly_head = fly_tail = 0;

	Scroll(w); 
}

void TERRAIN::Resize(int _w, int _h)
{
	SCROLL::Resize(_w,_h);
}

int TERRAIN::GetMaxHeight(int x, int n)
{
	int mh=0;
	for (int i=0; i<n; i++)
	{
		int c=0;
		int a = (scroll+x+i)%w;
		for (int y=h-1; y>=0; y--)
		{
			if (buf[y*(w+1)+a]=='*' || buf[y*(w+1)+a]=='_' || buf[y*(w+1)+a]==',' || buf[y*(w+1)+a]=='.' || buf[y*(w+1)+a]=='/' || buf[y*(w+1)+a]=='\\')
				break;
			c++;
		}

		if (c>mh)
			mh=c;
	}

	return mh;
}

bool TERRAIN::HitTest(CHASSIS* ch_spr, int x, int y, int fr)
{
	const char* img = ch_spr->data->mono[ch_spr->frame];
	int ch_w = ch_spr->width;
	int ch_h = ch_spr->height;

	// y is in terrain space  y' = y - (h-t.h)
	int y_fix = y + (scr_height-h);
	for (int i=0; i<bullets; i++)
	{
		BULLET* b = bullet + i;

		int ofsx = b->sx - x;
		int ofsy = b->y - y_fix;

		// ofsy>=2 as we don't want a hit at the top of roof
		if (ofsx>=0 && ofsy>=2 && ofsx<ch_w && ofsy<ch_h)
		{
			if (img[(ch_w+1)*ofsy+ofsx]!='*')
			{
				return true;
			}
		}
	}

	// check suiciders
	{
		SPRITE* spr = fly_tail;
		while (spr)
		{
			SPRITE* nxt = spr->prev;

			switch (spr->cookie)
			{
				case 'B':
				case 'U':
				case 'D':
				{
					// check if this is suicider
					if (spr->cookie_data[3] == scr_height)
					{
						int ofsx = x - spr->x_offset;
						int ofsy = y_fix - spr->y_offset;

						// convert bullet's xy to sprite system
						int sx = ofsx;
						int sy = ofsy;
						int sw = ch_w;
						int sh = ch_h;

						// clip screen rect to sprite rect
						if (sx<0)
						{
							sw += sx;
							sx = 0;
						}
						if (sy<0)
						{
							sh += sy;
							sy = 0;
						}
						if (sx+sw>spr->width)
						{
							sw=spr->width-sx;
						}
						if (sy+sh>spr->height)
						{
							sh=spr->height-sy;
						}

						for (int qx=sx; qx<sx+sw; qx++)
						{
							for (int qy=sy; qy<sy+sh; qy++)
							{
								// qy-ofsy>=2 don't hit at top of the roof
								if (img[(ch_w+1)*(qy-ofsy)+qx-ofsx]!='*' && qy-ofsy>=2)
								{
									if (spr->HitTest(qx,qy))
									{
										if (spr->cookie == 'B')
										{
											spr->data = &fly_boom1;
											PlaySFX(BOMBER_DEATH);
										}
										else
										if (spr->cookie == 'U')
										{
											spr->data = &fly_boom2;
											PlaySFX(UFO_DEATH);
										}
										else
										{
											spr->data = &fly_boom2;
											PlaySFX(DRONE_DEATH);
										}

										spr->cookie='poof';
										spr->cookie_data[0]=fr;
										spr->frame=0;
										spr->width = SPRITE::AnimWidth(spr->data);
										spr->height = SPRITE::AnimHeight(spr->data);
										spr->frames = SPRITE::AnimFrames(spr->data);

										return true;
									}
								}
							}
						}
					}

					break;
				}
			}

			spr = nxt;
		}
	}

	x+=scroll-w;

	// here we also test for passed checkpoints
	bool passed = false;
	int pass = x+ch_w/2;
	for (int i=check_passed+1; i<check_points; i++)
	{
		if (check_point[i]>=pass)
			break;
		else
		if (check_passed<i)
		{
			check_passed = i;
			passed = true;
		}
	}

	if (passed)
	{
		if (check_passed+1 >= check_points)
			PlaySFX(LAST_CHECKPOINT);
		else
			PlaySFX(CHECKPOINT_PASS);

		// time to protect killed enemies from being respawned after player is reborn
		for (int i=0; i<hits; i++)
		{
			hitbin[ hitcur[i] >> 3 ] |= (1 << (hitcur[i] & 0x7));
		}
		hits = 0;
	}

	SPRITE* spr = tail;
	while (spr)
	{
		SPRITE* nxt = spr->prev;

		if (spr->cookie=='scor' || spr->cookie=='poof' || spr->cookie=='base')
		{
			spr=nxt;
			continue;
		}

		if (spr->cookie=='h1' || spr->cookie=='h2' || spr->cookie=='h3')
		{
			if (spr->frame == spr->frames-1)
			{
				spr=nxt;
				continue;
			}
		}

		int ofsx = x - spr->x_offset;
		int ofsy = y - spr->y_offset;

		if (spr->cookie=='m')
		{
			// let it work 2 lines above ground
			// to reach chassis
			ofsy+=2;
		}

		// convert bullet's xy to sprite system
		int sx = ofsx;
		int sy = ofsy;
		int sw = ch_w;
		int sh = ch_h;

		// clip screen rect to sprite rect
		if (sx<0)
		{
			sw += sx;
			sx = 0;
		}
		if (sy<0)
		{
			sh += sy;
			sy = 0;
		}
		if (sx+sw>spr->width)
		{
			sw=spr->width-sx;
		}
		if (sy+sh>spr->height)
		{
			sh=spr->height-sy;
		}

		for (int qx=sx; qx<sx+sw; qx++)
		{
			for (int qy=sy; qy<sy+sh; qy++)
			{
				// qy-ofsy>=2 don't hit at top of the roof
				if (img[(ch_w+1)*(qy-ofsy)+qx-ofsx]!='*' && qy-ofsy>=2)
				{
					if (spr->HitTest(qx,qy))
					{
						if (spr->cookie=='m')
						{


							// convert it to ground_boom
							spr->data = &ground_boom;
							spr->cookie='poof';
							spr->cookie_data[0]=fr;
							spr->frame=1;
							spr->width = SPRITE::AnimWidth(spr->data);
							spr->height = SPRITE::AnimHeight(spr->data);
							spr->frames = SPRITE::AnimFrames(spr->data);

							spr->x_offset += 2 - spr->width/2;
							spr->y_offset += 1 - spr->height;

						}

						return true;
					}
				}
			}
		}

		spr=nxt;
	}

	return false;
}

bool TERRAIN::BulletTest(int fr, int x, int y, int* game_score)
{
	// hit test with flying objects (including their bullets)

	for (int i=0; i<bullets; i++)
	{
		BULLET* b = bullet + i;
		if (x>=b->sx-1 &&  x<=b->sx+1 && y==b->y)
		{
			// create poof
			SPRITE* spr = NewSprite(&co_boom);
			spr->cookie='poof';
			spr->cookie_data[0]=fr;
			spr->x_offset = x-(spr->width+1)/2;
			spr->y_offset = y-(spr->height)/2;
			spr->frame=0;



			// kill both bullets!
			StopSFX(bullet[i].voice,100);
			PlaySFX(BULLET_BULLET);

			if (i<bullets-1)
				memmove(b,b+1,sizeof(BULLET)*(bullets-i-1));
			bullets--;

			spr->next = fly_head;
			if (fly_head)
				fly_head->prev = spr;
			fly_head = spr;
			if (!fly_tail)
				fly_tail = spr;

			return true;
		}
	}

	SPRITE* spr = fly_tail;
	while (spr)
	{
		SPRITE* nxt = spr->prev;
		if (spr->cookie=='poof' || spr->cookie=='scor')
		{
			spr = nxt;
			continue;
		}

		int ofsx = x - spr->x_offset;
		int ofsy = y - spr->y_offset;

		// convert bullet's xy to sprite system
		int sx = ofsx;
		int sy = ofsy;
		int sw = 1;// bullets width
		int sh = 1;// bullets height

		// clip bullet rect to sprite rect
		if (sx<0)
		{
			sw += sx;
			sx = 0;
		}
		if (sy<0)
		{
			sh += sy;
			sy = 0;
		}
		if (sx+sw>spr->width)
		{
			sw=spr->width-sx;
		}
		if (sy+sh>spr->height)
		{
			sh=spr->height-sy;
		}
			
		bool hit = false;
		for (int qx=sx; !hit && qx<sx+sw; qx++)
		{
			for (int qy=sy; qy<sy+sh; qy++)
			{
				if (spr->HitTest(qx,qy))
				{
					hit = true;
					break;
				}
			}
		}

		if (hit)
		{
			if (spr->cookie=='D' || spr->cookie=='U' || spr->cookie=='B')
			{
				if (spr->group_id>=0)
				{
					if (group_len[spr->group_id]==1)
					{
						PlaySFX(FLY_BONUS);

						// GROUP SCORE
						SPRITE* score = NewSprite(group_score * group_mul[spr->group_id]);
						if (game_score)
							*game_score += group_score * group_mul[spr->group_id];

						score->cookie_data[0] = fr;
						score->x_offset = spr->x_offset + spr->width/2 - score->width/2;
						score->y_offset = spr->y_offset + spr->height/2 - score->height/2;

						score->next = fly_head;
						if (fly_head)
							fly_head->prev = score;
						fly_head = score;
						if (!fly_tail)
							fly_tail = score;
					}
					group_len[spr->group_id]--;
					spr->group_id=-1;
				}
			}

			// do some poof?
			switch( spr->cookie )
			{
				case 'B':
				{
					hitcur[hits] = spr->data_pos;
					hits++;

					if (game_score)
						*game_score += basher_score;

					spr->data = &fly_boom1;
					spr->cookie='poof';
					spr->cookie_data[0]=fr;
					spr->frame=0;
					spr->width = SPRITE::AnimWidth(spr->data);
					spr->height = SPRITE::AnimHeight(spr->data);
					spr->frames = SPRITE::AnimFrames(spr->data);

					PlaySFX(BOMBER_DEATH);

					spr=0;
					break;
				}

				case 'U':
				case 'D':
				{
					hitcur[hits] = spr->data_pos;
					hits++;

					if (game_score)
						*game_score += spr->cookie=='U' ? ufo_score : drone_score;

					PlaySFX(spr->cookie=='U' ? UFO_DEATH : DRONE_DEATH);

					spr->data = &fly_boom2;
					spr->cookie='poof';
					spr->cookie_data[0]=fr;
					spr->frame=0;
					spr->width = SPRITE::AnimWidth(spr->data);
					spr->height = SPRITE::AnimHeight(spr->data);
					spr->frames = SPRITE::AnimFrames(spr->data);

					spr=0;
					break;
				}
			}

			if (spr)
			{
				if (spr->prev)
					spr->prev->next = spr->next;
				else
					fly_head = spr->next;

				if (spr->next)
					spr->next->prev = spr->prev;
				else
					fly_tail = spr->prev;

				DeleteSprite(spr);
			}

			return true;
		}

		spr = nxt;
	}

	return false;
}

bool TERRAIN::CannonTest(int x, int y, int f, int fr, int* game_score)
{
	// here xy is in unscrolled coords
	x+=scroll-w;

	// terrain hittest ?
	// ...

	// should we test flying objects too, especially suiciders?
	// ...

		
	SPRITE* hitspr = 0;
	int hitpos = -1;

	SPRITE* spr = tail;
	while (spr)
	{
		SPRITE* nxt = spr->prev;
		if (spr->cookie=='scor' || spr->cookie=='poof' || spr->cookie=='base')
		{
			spr = nxt;
			continue;
		}

		// generic sprite hittest

		int ofsx = x - spr->x_offset;
		int ofsy = y - spr->y_offset;

		// convert bullet's xy to sprite system
		int sx = ofsx;
		int sy = ofsy;
		int sw = 7;// bullets width
		int sh = 3;// bullets height

		// clip bullet rect to sprite rect
		if (sx<0)
		{
			sw += sx;
			sx = 0;
		}
		if (sy<0)
		{
			sh += sy;
			sy = 0;
		}
		if (sx+sw>spr->width)
		{
			sw=spr->width-sx;
		}
		if (sy+sh>spr->height)
		{
			sh=spr->height-sy;
		}

		const char* img = cannon.mono[f];

		int xhit = -1;
		for (int qx=sx; xhit<0 && qx<sx+sw; qx++)
		{
			for (int qy=sy; qy<sy+sh; qy++)
			{
				if (img[8*(qy-ofsy)+qx-ofsx]!='*')
				{
					if (spr->HitTest(qx,qy))
					{
						xhit = qx-ofsx;
						break;
					}
				}
			}
		}

		// remember smallest x & sprite

		if (xhit>=0 && (xhit<=hitpos || !hitspr))
		{
			hitpos=xhit;
			hitspr=spr;
		}

		spr=nxt;
	}

	if (hitspr)
	{
		SPRITE* spr = hitspr;

		int h0 = 'h0';
		int b0 = 'b0';
			
		// custom handler
		switch (spr->cookie)
		{
			case 'h1':
			case 'h2':
			{
				// ADDHIT
				PlaySFX(HEAP_DEATH);

				hitcur[hits] = spr->data_pos;
				hits++;

				if (game_score)
					*game_score += heap_score*(spr->cookie-h0);

				if (spr->frame<1)
					spr->frame++;
				spr=0;
				break;
			}

			case 'h3':
			{
				// ADDHIT? -- only if final hit
				PlaySFX(HEAP_DEATH);

				if (game_score)
					*game_score += heap_score*(spr->cookie-h0);

				if (spr->frame<2)
				{
					spr->frame++;
					if (spr->frame==2)
					{
						hitcur[hits] = spr->data_pos;
						hits++;
					}
				}

				spr=0;
				break;
			}

			case 'b1':
			case 'b2':
			case 'b3':
			{
				// ADDHIT
				PlaySFX(BALL_DEATH);

				hitcur[hits] = spr->data_pos;
				hits++;

				if (game_score)
					*game_score += ball_score*(spr->cookie-b0);

				break;
			}

			case 'b4':
			{
				// ADDHIT? -- hmmm no, it is not killed yet
				PlaySFX(BALL_DEATH);

				if (game_score)
					*game_score += ball_score*(spr->cookie-b0);

				SPRITE* b2 = NewSprite(&ball2);
				b2->data_pos = spr->data_pos;
				b2->x_offset = spr->x_offset+2;
				b2->y_offset = spr->y_offset+1;
				b2->frame=0;
				b2->cookie='b2';
				b2->cookie_data[0]=spr->cookie_data[0];
				b2->cookie_data[1]=spr->cookie_data[1];
				b2->cookie_data[2]=spr->cookie_data[2];
				b2->next=spr->next;
				b2->prev=spr->prev;
				DeleteSprite(spr);

				if (b2->next)
					b2->next->prev=b2;
				else
					tail = b2;

				if (b2->prev)
					b2->prev->next=b2;
				else
					head = b2;
						
				spr = 0;
				break;
			}

			case 'r':
			{
				PlaySFX(ROCKET_DEATH);
				// ADDHIT
				hitcur[hits] = spr->data_pos;
				hits++;

				// insert score sprite
				SPRITE* score = NewSprite(rocket_score);
				if (game_score)
					*game_score += rocket_score;

				score->cookie_data[0] = fr;
				score->x_offset = spr->x_offset + spr->width/2 - score->width/2;
				score->y_offset = spr->y_offset + spr->height/2 - score->height/2;

				score->next = head;
				if (head)
					head->prev = score;
				head = score;
				if (!tail)
					tail = score;

				break;
			}

			case 't':
			{
				PlaySFX(TANK_DEATH);
				// ADDHIT
				hitcur[hits] = spr->data_pos;
				hits++;

				// insert score sprite
				SPRITE* score = NewSprite(tank_score);
				if (game_score)
					*game_score += tank_score;

				score->cookie_data[0] = fr;
				score->x_offset = spr->x_offset + spr->width/2 - score->width/2;
				score->y_offset = spr->y_offset + spr->height/2 - score->height/2;

				score->next = head;
				if (head)
					head->prev = score;
				head = score;
				if (!tail)
					tail = score;

				break;
			}

			case 'tb':
			{
				PlaySFX(BULLET_BULLET);
				break;
			}

			case 'c':
			{
				if (spr->frame!=3)
				{
					PlaySFX(CREATURE_DEATH);
					// ADDHIT?
					// YES - creatures often hides in holes
					// making it impossible to hit their dead corps

					hitcur[hits] = spr->data_pos;
					hits++;

					// insert score sprite
					SPRITE* score = NewSprite(creature_score);
					if (game_score)
						*game_score += creature_score;

					score->cookie_data[0] = fr;
					score->x_offset = spr->x_offset + spr->width/2 - score->width/2;
					score->y_offset = spr->y_offset + spr->height/2 - score->height/2;

					score->next = head;
					if (head)
						head->prev = score;
					head = score;
					if (!tail)
						tail = score;
							
					spr->frame = 3;
					spr = 0;
				}
				else
				{
					// ADDHIT? NO! it is already killed
					PlaySFX(CREATURE_CORPS);
					// extra dead body points
					if (game_score)
						*game_score += creature_score;
				}

				break;
			}

			case 'm':
			{
				// mines are indestructible (no add hit)
				spr=0;
				break;
			}
		}

		if (spr)
		{
			// whould be nice to have explotion for each kind of sprite
			// ... at the moment just delete it

			if (spr->prev)
				spr->prev->next = spr->next;
			else
				head = spr->next;

			if (spr->next)
				spr->next->prev = spr->prev;
			else
				tail = spr->prev;

			DeleteSprite(spr);
		}

		return true;
	}

	return false;
}

void TERRAIN::DismissSprites(int fr, int speed)
{
	lives--;

	SPRITE* spr;

	spr = head;
	while (spr)
	{
		SPRITE* nxt = spr->next;
		switch (spr->cookie)
		{
			case 'r':
			{
				int phase = 0;
				if (scroll-spr->cookie_data[0]>4*spr->width)
					phase++;
				if (scroll-spr->cookie_data[0]>4*spr->width + 200)
					phase++;

				if (phase<2)
				{
					// rocket self destruction?
					// ...
				}
				break;
			}
		}
		spr=nxt;
	}
}

void TERRAIN::AnimateSprites(int fr, int speed, bool expl)
{
	fld.t = this;
	fld.Animate();

	// animate bullets from flying objects
	for (int i=0; i<bullets; i++)
	{
		BULLET* b = bullet+i;
				
		int dt = fr-b->fr;

		// here we MUST use double ALU (so js has the same precission!)
		b->sx = b->x + (int)((b->vx*(log(20.0+dt)-log(20.0))/16)); // <- switch to numerical intergrals

		b->y = b->oy + (dt*dt)/2000;

		int dh = GetMaxHeight(b->sx,1);
		int dy = scr_height - dh;

		int dep=0;

		if (b->y>=dy)
		{
			if (b->cookie == 'B')
			{
				// MAKE CRATER!

				// - in data
				// - on screen buffer

				int rad = 6+twister_rand()%4;
					
				dep = 2+twister_rand()%4;
				if (dep>5*rad/12)
					dep=5*rad/12;

				/*
					_________________ ileft
					|        _________ icenter
					|       |       __ iright
				_|       |      |_________ level  
				%%\            /%%  ^
				%%%\          /%%%  | dep
				%%%%\________/%%%%__v
				%%%%%%\____/%%%%%%  <-round
					|<----->|
					rad
				*/

				int icenter = b->sx+scroll-w;
				int ileft = b->sx-rad+scroll-w;
				int iright = b->sx+rad+scroll-w;
					
				if (ileft<0)
					ileft=0;
				if (ileft>=len)
					ileft=len-1;

				if (iright<0)
					iright=0;
				if (iright>=len)
					iright=len-1;


				int left = data[ileft];
				int right = data[iright];
				int level = MAX(left,right);

				dy++;

				int prv=data[ileft];
				for (int x = ileft; x<=iright; x++)
				{
					int r = ABS(x-icenter);
					int d = level - dep;
					if (r>rad-dep)
						d = level - (rad-r); 

					int round=0;
					if (ABS(x-icenter)<rad/2)
						round=1;

					data[x] = MIN(data[x],d-round);
					if (data[x]<1)
						data[x]=1;
				}

				// clip it to visible part!
				if (ileft<scroll-w)
					ileft=scroll-w;
				if (iright>=scroll)
					iright=scroll-1;

				if (iright-ileft>0)
				{
					int org_scroll = scroll;
					scroll = ileft;
					Scroll(iright-ileft+1);
					scroll = org_scroll;
				}

				// convert to poofs all ground sprites affected by crater (except b1-b4 and rocket)
				SPRITE* spr = head;
				while (spr)
				{
					SPRITE* nxt = spr->next;
					switch (spr->cookie)
					{
						case 'r':
						case 'b1':
						case 'b2':
						case 'b3':
						case 'b4':
						case 'poof':
							break;

						default:
							if (spr->x_offset+spr->width>=ileft && spr->x_offset<=iright)
							{
								int cx = spr->x_offset + spr->width/2;
								int cy = spr->y_offset + spr->height;
								spr->data = &ground_boom;
								spr->cookie='poof';
								spr->cookie_data[0]=fr;
								spr->frame=0;
								spr->width = SPRITE::AnimWidth(spr->data);
								spr->height = SPRITE::AnimHeight(spr->data);
								spr->frames = SPRITE::AnimFrames(spr->data);

								spr->x_offset = cx - spr->width/2;
								spr->y_offset = cy - spr->height;
							}
					}

					spr = nxt;
				}

			}

			// add poof 

			// create poof

			SPRITE* spr;
			if (b->cookie == 'B') // mega boom
			{
				spr = NewSprite(&boom);
				PlaySFX(BOMB_EXPL);
			}
			else
			{
				spr = NewSprite(&ground_boom);
				PlaySFX(BOMB_GROUND);
			}

			spr->cookie='poof';
			spr->cookie_data[0]=fr;
			spr->x_offset = b->sx-(spr->width+1)/2;
			spr->y_offset = dy-spr->height + dep/2;
			spr->frame=0;

			StopSFX(bullet[i].voice,100);

			if (i<bullets-1)
				memmove(b,b+1,sizeof(BULLET)*(bullets-i-1));
			bullets--;
			i--;

			// but they should be fixed to ground!
			spr->x_offset += scroll-w;
			spr->y_offset -= scr_height-h;
			spr->next = head;
			if (head)
				head->prev = spr;
			head = spr;
			if (!tail)
				tail = spr;
			/*
			spr->next = fly_head;
			if (fly_head)
				fly_head->prev = spr;
			fly_head = spr;
			if (!fly_tail)
				fly_tail = spr;
			*/
		}
	}


	SPRITE* spr = fly_head;
	while (spr)
	{
		SPRITE* nxt = spr->next;
		switch (spr->cookie)
		{
			case 'scor':
			{
				if (fr - spr->cookie_data[0] < 150)
					spr=0;
				break;
			}

			case 'poof':
			{
				int f = (fr - spr->cookie_data[0]) / 8;
				if (f<spr->frames) // otherwise die
				{
					spr->SetFrame(f);
					spr=0;
				}

				break;
			}

			case 'U':
			case 'D':
			case 'B':
			{
				// check life time ( cookie_data[1] : birth scroll )
				// if too long, randomize: kamikadze, dismiss

				// dont suicide if too close to last checkpoint
				if (scroll-w < check_point[check_points-1] - 145)
				{
					if (spr->cookie_data[2] != -spr->width &&
						spr->cookie_data[2] != w &&
						spr->cookie_data[3] != -spr->height &&
						spr->cookie_data[3] != scr_height)
					{
						// escape if scrolled more that 5 small screens
						if ( scroll - spr->cookie_data[1] > 400) 
						{
							int cmd = twister_rand()%4;
							// 0 - escape left
							// 1 - escape right
							// 2 - escape up
							// 3 - escape down (kamikadze)

							// 'B's don't suicide
							if (cmd==3 && spr->cookie=='B')
								cmd=2;

							// no kamikadze on introductory ;)
							if (cmd==3 && items==beginner[0].sprite)
								cmd=2;

							int dy = 4;
							if (scr_height>25)
								dy += (scr_height-25)/4;

							switch (cmd)
							{
								case 0:
								{
									spr->cookie_data[2] = -spr->width;
									spr->cookie_data[3] = twister_rand()%dy;
									break;
								}
								case 1:
								{
									spr->cookie_data[2] = w;
									spr->cookie_data[3] = twister_rand()%dy;
									break;
								}
								case 2:
								{
									spr->cookie_data[2] = twister_rand()%(80-spr->width);
									spr->cookie_data[3] = -spr->height;
									break;
								}
								case 3:
								{
									spr->cookie_data[2] = twister_rand()%(80-spr->width);
									spr->cookie_data[3] = scr_height;
									break;
								}
							}
						}
					}
				}

				// test suicider collision with terrain
				if (spr->cookie_data[3] == scr_height)
				{
					int dh = GetMaxHeight(spr->x_offset,spr->width);
					if (spr->y_offset + spr->height >= scr_height - dh)
					{
						PlaySFX(ROCKET_DEATH);

						// time to die
						if (spr->cookie == 'B')
							spr->data = &fly_boom1;
						else
							spr->data = &fly_boom2;
						spr->cookie='poof';
						spr->cookie_data[0]=fr;
						spr->frame=0;
						spr->width = SPRITE::AnimWidth(spr->data);
						spr->height = SPRITE::AnimHeight(spr->data);
						spr->frames = SPRITE::AnimFrames(spr->data);

						if (spr->group_id>=0)
						{
							group_len[spr->group_id]--;
							spr->group_id=-1;
						}

						spr=0;
						break;
					}
				}

				// if previous move is finished spr->x_offset,y_offset == cookie_data[2],cookie_data[3]

				if (spr->x_offset == spr->cookie_data[2] && spr->y_offset == spr->cookie_data[3])
				{
					if (spr->x_offset == -spr->width ||
						spr->x_offset == w ||
						spr->y_offset == -spr->height)
					{
						// escaped, will be removed
						break;
					}

					spr->cookie_data[2] = twister_rand()%(80-spr->width);

					int dy = 4;
					if (scr_height>25)
						dy += (scr_height-25)/4;

					spr->cookie_data[3] = twister_rand()%dy;
				}

				if (((fr+spr->cookie_data[1])&7)==0)
				{
					if (spr->x_offset < spr->cookie_data[2])
						spr->x_offset++;
					else
					if (spr->x_offset > spr->cookie_data[2])
						spr->x_offset--;
				}

				// suiciders goes faster
				int sp = 16;
				if (scr_height>25)
					sp = 400 / (scr_height*3 - 50);
				if (sp<2)
					sp=2;

				if ( (spr->cookie_data[3] == scr_height && ((fr+spr->cookie_data[1])%sp)==0) ||
						((fr+spr->cookie_data[1])&31)==0)
				//if (((fr+spr->cookie_data[1])&31)==0)
				{
					if (spr->y_offset < spr->cookie_data[3])
						spr->y_offset++;
					else
					if (spr->y_offset > spr->cookie_data[3])
						spr->y_offset--;
				}

				// suiciders and (escapers on introductory) dont shoot
				if ( spr->cookie_data[3] != scr_height &&
						( items!=beginner[0].sprite || 
						spr->cookie_data[2] != -spr->width && 
						spr->cookie_data[2] != w &&
						spr->cookie_data[3] != -spr->height ) )
				{
					if (spr->cookie_data[0]<0)
					{
						spr->cookie_data[0]=fr+twister_rand()%512;
					}
					else
					if (scroll-w < check_point[check_points-1] - 145) // dont shoot if too close to last_checkpoint
					if (!expl && spr->cookie_data[0]<=fr && bullets<sizeof(bullet)/sizeof(BULLET))
					{
						spr->cookie_data[0]=fr+256+twister_rand()%256;

						BULLET* b = bullet+bullets;
						bullets++;

						PlaySFX(FLY_BOMB,&b->voice);

						b->cookie = spr->cookie;

						if (spr->cookie == 'B')
						{
							// crater making bomb
							b->sx = spr->x_offset + (spr->width+1)/2;
							b->x = b->sx;
							b->y = spr->y_offset + spr->height-1;
							b->fr = fr;
							b->vx = (65-b->x)*(twister_rand()%8+8); // aim bit in front of vehicle
							b->oy = b->y;
						}
						else
						{
							b->sx = spr->x_offset + (spr->width+1)/2;
							b->x = b->sx;
							b->y = spr->y_offset + spr->height-1;
							b->fr = fr;
							b->vx = (80/2-b->x)*(twister_rand()%16); // aim at half of regular screen
							b->oy = b->y;
						}
					}
				}

				// finaly animate sprite's frames
				spr->SetFrame(fr/8);
				spr=0;
				break;
			}
		}

		if (spr)
		{
			if (spr->group_id>=0)
			{
				group_len[spr->group_id]--;
				spr->group_id=-1;
			}

			if (spr->prev)
				spr->prev->next = spr->next;
			else
				fly_head = spr->next;

			if (spr->next)
				spr->next->prev = spr->prev;
			else
				fly_tail = spr->prev;

			DeleteSprite(spr);
		}

		spr=nxt;
	}

	// animate sprites
	spr = head;
	while (spr)
	{
		SPRITE* nxt = spr->next;
		switch (spr->cookie)
		{
			case 'base':
			{
				spr->SetFrame(fr/16);
				break;
			}

			case 'poof':
			{
				int f = (fr - spr->cookie_data[0]) / 8;
				if (f<spr->frames) // otherwise die
				{
					spr->SetFrame(f);
				}
				else
				{
					if (spr->prev)
						spr->prev->next = spr->next;
					else
						head = spr->next;

					if (spr->next)
						spr->next->prev = spr->prev;
					else
						tail = spr->prev;

					DeleteSprite(spr);
					spr=0;
				}

				break;
			}

			case 'scor':
			{
				if (fr - spr->cookie_data[0] >= 150)
				{
					// hide
					if (spr->prev)
						spr->prev->next = spr->next;
					else
						head = spr->next;

					if (spr->next)
						spr->next->prev = spr->prev;
					else
						tail = spr->prev;

					DeleteSprite(spr);
					spr=0;
				}
				break;
			}

			case 'b1':
			case 'b2':
			case 'b3':
			case 'b4':
			{
				if ((fr&7)==0)
				{
					if (spr->cookie_data[1]<0 && spr->x_offset - (scroll-w) < 80)
						spr->cookie_data[1]=fr;
					if (spr->cookie_data[1]>=0)
					{
						int dx = spr->cookie_data[2];
						int dh = GetMaxHeight(spr->x_offset+dx - (scroll-w),spr->width);
						int dy = h - dh - spr->height - spr->y_offset;

						if (dy>=0)
						{
							int f = (fr-spr->cookie_data[1])/8 + spr->cookie_data[0];
							if (dx>0)
								f = (spr->cookie_data[1]-fr)/8 + spr->cookie_data[0];

							spr->x_offset += dx;
							spr->y_offset += dy;
							spr->SetFrame(f);
						}
						else
						{
							dx = -spr->cookie_data[2];
							dh = GetMaxHeight(spr->x_offset+dx - (scroll-w),spr->width);
							dy = h - dh - spr->height - spr->y_offset;
							if (dy<0)
							{
								spr->cookie_data[2] = -spr->cookie_data[2];
							}
						}
					}
					else
					{
						// just in case of basher made hole here
						int dh = GetMaxHeight(spr->x_offset - (scroll-w),spr->width);
						int dy = h - dh - spr->height - spr->y_offset;
						if (dy>=0)
							spr->y_offset += dy;
					}
				}
				break;
			}

			case 't':
			{
				int x = spr->x_offset - (scroll - w);

				if (x<70)
				{
					if (spr->cookie_data[0]<0 || 
						fr - spr->cookie_data[0] > 200) // shot every 2 sec
					{
						spr->cookie_data[0] = fr;

						PlaySFX(TANK_SHOT);

						// emitt!
						SPRITE* tb = NewSprite(&tank_bullet);
						tb->x_offset = spr->x_offset -1; // - 3;
						tb->y_offset = spr->y_offset +1;
						tb->frame=0;
						tb->cookie='tb';

						tb->next = spr;
						tb->prev = spr->prev;
						spr->prev = tb;
						if (tb->prev)
							tb->prev->next=tb;
						else
							head=tb;
					}
				}
				break;
			}

			case 'tb':
			{
				if ((fr&3)==0)
				{
					spr->x_offset--;
					// ensure offset_y is on ground
					int dh = GetMaxHeight(spr->x_offset - (scroll-w),spr->width);
					if (spr->y_offset > h - dh - spr->height)
					{
						// die
						if (spr->prev)
							spr->prev->next = spr->next;
						else
							head = spr->next;

						if (spr->next)
							spr->next->prev = spr->prev;
						else
							tail = spr->prev;

						DeleteSprite(spr);
					}
				}
				break;
			}

			case 'r':
			{
				int phase = 0;
				if (scroll-spr->cookie_data[0]>4*spr->width)
					phase++;
				if (scroll-spr->cookie_data[0]>4*spr->width + 200)
					phase++;

				if (phase==0)
				{
					spr->x_offset = scroll-w-spr->width + 1 + (scroll-spr->cookie_data[0])/4;
				}
				else
				if (phase==1)
				{
					spr->x_offset = scroll-w;
					spr->cookie_data[1] = speed;
					spr->cookie_data[2] = fr;
				}
				else
				if (phase==2)
				{
					spr->x_offset = scroll-w + (fr-spr->cookie_data[2])*spr->cookie_data[1]/1500;
					if (spr->x_offset > scroll)
					{
						if (spr->prev)
							spr->prev->next = spr->next;
						else
							head = spr->next;

						if (spr->next)
							spr->next->prev = spr->prev;
						else
							tail = spr->prev;

						DeleteSprite(spr);
						break;
					}
				}

				int q = h-1 - GetMaxHeight(spr->x_offset-(scroll-w),30);
				spr->y_offset =  q - spr->height;

				int f = (spr->x_offset/2)%7;
				spr->SetFrame(f);
				break;
			}

			case 'm':
			{
				int f = ((fr+spr->x_offset*20)/32)%2;

				spr->SetFrame(f);
				break;
			}

			case 'c':
			{
				if (spr->frame!=3)
				{
					int f = ((fr+spr->x_offset*20)/32)%4;
					if (f==3)
						f=1;

					spr->SetFrame(f);
				}
				break;
			}

		}
		spr=nxt;
	}
}

void TERRAIN::Paint(SCREEN* scr, int dx, int dy, int sx, int sy, int sw, int sh, bool blend)
{
	SCROLL::Paint(scr, dx, dy, sx, sy, sw, sh, blend);

	if (sw<0)
		sw=w;
	if (sh<0)
		sh=h;


	// paint bullets
	for (int i=0; i<bullets; i++)
	{
		BULLET* b=bullet+i;
		if (b->sx>=0 && b->sx<w && b->y>=0 && b->y<scr->h)
		{
			switch (b->cookie)
			{
				case 'B':
					scr->buf[(scr->w+1)*b->y+b->sx] = ch_basher;
					if (scr->color)
						scr->color[(scr->w+1)*b->y+b->sx] = cl_basher;
					break;

				case 'U':
					scr->buf[(scr->w+1)*b->y+b->sx] = ch_ufo;
					if (scr->color)
						scr->color[(scr->w+1)*b->y+b->sx] = cl_ufo;
					break;

				case 'D':
					scr->buf[(scr->w+1)*b->y+b->sx] = ch_drone;
					if (scr->color)
						scr->color[(scr->w+1)*b->y+b->sx] = cl_drone;
					break;
			}
		}
	}


	// NO CLIPPING HERE!
	// we need sprites to be painted outside of terrain canvas too,

	SPRITE* spr = fly_tail;
	while (spr)
	{
		int sdx = spr->x_offset;
		int sdy = spr->y_offset - (scr->h - h);
		int ssx = 0;
		int ssy = 0;
		int ssw = spr->width;
		int ssh = spr->height;

		spr->Paint(scr,dx+sdx,dy+sdy,ssx,ssy,ssw,ssh);
		spr=spr->prev;
	}

	spr = tail;
	while (spr)
	{
		int sdx = spr->x_offset-scroll+w;
		int sdy = spr->y_offset;
		int ssx = 0;
		int ssy = 0;
		int ssw = spr->width;
		int ssh = spr->height;

		spr->Paint(scr,dx+sdx,dy+sdy,ssx,ssy,ssw,ssh);
		spr=spr->prev;
	}
}

void TERRAIN::Scroll(int s)
{
	for (int i=0; i<s; i++)
	{
		if (sprite_scroll<scroll)
		{
			SPRITE* spr = 0;
			// left align rocket & flyers
			{
				int x = scroll - w;

				if ( x>=0 && x<items_len && ( hitbin[x >> 3]&(1 << (x&0x7)) )==0)
				{
					int q = h-1 - (data[len-1]-'0');
					if (x<len)
						q = h-1 - (data[x]-'0');


					int dy = 4;
					if (scr_height>25)
						dy += (scr_height-25)/4;

					switch(items[x])
					{
						case 'X':
						{
							int size = items[x+1]-'0';
							if (size<0 || size>9)
								size = 0;

							interference_size = size;
							interference_from = x;

							interference_to = -1;
							for (int i=0; i<check_points; i++)
							{
								if (check_point[i]>x)
								{
									interference_to = check_point[i];
									break;
								}
							}

							if (interference_to<0)
								interference_size = 0;

							interference_mul=0;

							break;
						}

						case 'r':
						{
							spr = NewSprite(&rocket);
							spr->data_pos = x;

							spr->x_offset = x-spr->width + 1;
							spr->y_offset = q - spr->height - 1;
							spr->frame=0;
							spr->cookie='r';
							spr->cookie_data[0] = scroll;

							spr->next = head;
							if (head)
								head->prev = spr;
							head = spr;
							if (!tail)
								tail = spr;

							spr = 0; // added to ground

							break;
						}

						case 'U':
						{
							spr = NewSprite(&ufo);
							spr->data_pos = x;

							spr->x_offset = twister_rand()%(80-spr->width);
							spr->y_offset = twister_rand()%dy; // from top of screen!
							spr->frame=0;
							spr->cookie='U';
							spr->cookie_data[0] = -1; // last shoot frame
							spr->cookie_data[1] = scroll; // scroll of birth
							spr->cookie_data[2] = spr->x_offset; // move to x
							spr->cookie_data[3] = spr->y_offset; // move to y

							break;
						}

						case 'D':
						{
							spr = NewSprite(&drone);
							spr->data_pos = x;

							spr->x_offset = twister_rand()%(80-spr->width);
							spr->y_offset = twister_rand()%dy; // from top of screen!
							spr->frame=0;
							spr->cookie='D';
							spr->cookie_data[0] = -1; // last shoot frame
							spr->cookie_data[1] = scroll; // scroll of birth
							spr->cookie_data[2] = spr->x_offset; // move to x
							spr->cookie_data[3] = spr->y_offset; // move to y

							break;
						}

						case 'B':
						{
							spr = NewSprite(&basher);
							spr->data_pos = x;

							spr->x_offset = twister_rand()%(80-spr->width);
							spr->y_offset = twister_rand()%dy; // from top of screen!
							spr->frame=0;
							spr->cookie='B';
							spr->cookie_data[0] = -1; // last shoot frame
							spr->cookie_data[1] = scroll; // scroll of birth
							spr->cookie_data[2] = spr->x_offset; // move to x
							spr->cookie_data[3] = spr->y_offset; // move to y

							break;
						}
					}

					if (spr)
					{
						if (group_id>=0)
						{
							spr->group_id = group_id;
							group_len[group_id]++;
							group_mul[group_id]++;
						}
						else
						{
							if (x<items_len-1 && (items[x+1]=='U' || items[x+1]=='D'  || items[x+1]=='B'))
							{
								for (group_id=15; group_id>=0; group_id--)
								{
									if (group_len[group_id]==0)
										break;
								}

								if (group_id>=0)
								{
									group_len[group_id]=1;
									group_mul[group_id]=1;
									spr->group_id=group_id;
								}
							}
						}

						spr->next = fly_head;
						if (fly_head)
							fly_head->prev = spr;
						fly_head = spr;
						if (!fly_tail)
							fly_tail = spr;
					}
					else
					{
						group_id=-1;
					}
				}
			}

			if (!spr)
			{
				group_id=-1;

				int x = scroll;

				if (x>=0 && x<items_len && ( hitbin[x >> 3]&(1 << (x&0x7)) )==0)
				{
					int q = h-1 - (data[len-1]-'0');
					if (x<len)
						q = h-1 - (data[x]-'0');

					switch(items[x])
					{
						case '#':
						{
							// checkpoint
							char name[8];
							sprintf_s(name,8,"[ %c ]",base_point + check_scroll);
							spr = NewSprite(name);
							spr->x_offset = x;
							spr->y_offset = h-2;
							spr->frame=0;
							spr->cookie='chkp';

							check_scroll++;
							break;
						}

						case '@':
						{
							// start base
							int lev = data[x]-'0';

							spr = NewSprite(&base);
							spr->x_offset = x;
							spr->y_offset = h-lev-spr->height;
							spr->frame=0;
							spr->cookie='base';

							// fix terrain elevation
							for (int i=x; i<x+spr->width+5; i++)
							{
								if (i<len)
								data[i]='0'+lev;
							}
							for (int i=x+spr->width+5; i<x+spr->width+20; i+=5)
							{
								if (i<len)
								{
									int dy = data[i] - data[i-1];
									if (!ABS(dy))
										break;

									int v = dy>0 ? data[i-1]+1 : data[i-1]-1;
									for (int j=0; j<5; j++)
										if (i+j<len)
											data[i+j]=v;
								}
							}

							break;
						}

						case 't':
						{
							spr = NewSprite(&tank);
							spr->data_pos = x;

							spr->x_offset = x;
							spr->y_offset = q - spr->height;
							spr->frame=0;
							spr->cookie='t';
							spr->cookie_data[0] = -1; // last shoot frame
							break;
						}

						case 'b':
						{
							// analyse terrain slope

							int dir=0;
							int r=1;
							while (!dir && MAX(ABS(x+r),ABS(x-r))<len)
							{
								if (x+r<len && data[x]!=data[x+r])
								{
									if (data[x]<data[x+r])
										dir=-1;
									else
										dir=1;
								}
								else
								if (x-r>0 && data[x]!=data[x-r])
								{
									if (data[x-r]<data[x])
										dir=-1;
									else
										dir=1;
								}
								r++;
							}

							int size = items[x+1]-'0';
							if (size<1)
								size=1;
							if (size>4)
								size=4;

							const ASSET* anim=0;
							switch (size)
							{
								case 1: anim = &ball1; break;
								case 2: anim = &ball2; break;
								case 3: anim = &ball3; break;
								case 4: anim = &ball4; break;
							}

							spr = NewSprite(anim);
							spr->data_pos = x;

							spr->x_offset = x;
							spr->y_offset = q - spr->height;
							spr->frame=twister_rand()%spr->frames;
							spr->cookie=('b'<<8)|(size+'0');
							spr->cookie_data[0] = spr->frame; // start sprite frame 
							spr->cookie_data[1] = -1; // start game frame
							spr->cookie_data[2] = dir;
							break;
						}

						case 'm':
						{
							spr = NewSprite(&land_mine);
							spr->data_pos = x;

							spr->x_offset = x;
							spr->y_offset = q - spr->height + 1;
							spr->frame=0;
							spr->cookie='m';
							break;
						}

						case 'c':
						{
							spr = NewSprite(&creature);
							spr->data_pos = x;

							spr->x_offset = x;
							spr->y_offset = q - spr->height;
							spr->frame=0;
							spr->cookie='c';
							break;
						}
						case 'h':
						{
							int size = items[x+1]-'0';
							if (size<1)
								size=1;
							if (size>3)
								size=3;

							const ASSET* anim=0;
							switch (size)
							{
								case 1: anim = &heap1; break;
								case 2: anim = &heap2; break;
								case 3: anim = &heap3; break;
							}

							spr = NewSprite(anim);
							spr->data_pos = x;

							spr->x_offset = x;
							spr->y_offset = q - spr->height + 1;
							spr->frame=0;
							spr->cookie=('h'<<8)|(size+'0');
							break;
						}
					}

				}

				if (spr)
				{
					// add on ground object

					spr->next = head;
					if (head)
						head->prev = spr;
					head = spr;
					if (!tail)
						tail = spr;
				}
			}

			sprite_scroll = scroll;
		}

		int x = scroll;
		int q = h-1 - (data[len-1]-'0');
		if (x<len)
			q = h-1 - (data[x]-'0');

		int p = q;
		if (scroll>0 && scroll<=len)
			p = h-1 - (data[scroll-1]-'0');

		int n=q;
		if (scroll<len-1)
			n = h-1 - (data[scroll+1]-'0');

		int a = scroll%w;
		for (int y=0; y<q && y<h; y++)
			buf[(w+1)*y+a] = '*';

		for (int y=q; y<h; y++)
		{
			buf[(w+1)*y+a] = ch_ground;
			if (color)
				color[(w+1)*y+a] = cl_ground;
		}

		if (p==q && q==n && q<=h)
		{
			int stone = (twister_rand()%100)<20;
			if (stone)
			{
				buf[(w+1)*(q-1)+a] = "____...,"[twister_rand()%8];
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;

			}
		}
		else
		if (q<=h)
		{
			//  _
			// %%
			// %%%
			if (p==q && q==n-1)
			{
				buf[(w+1)*(q-1)+a] = '_';
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;
			}
			if (n==q && q==p-1)
			{
				buf[(w+1)*(q-1)+a] = '_';
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;
			}

			// %\ 	 %, 
			// %%%	 %%%
			if (p==q-1 && q==n)
			{
				buf[(w+1)*(q-1)+a] = "\\,"[twister_rand()%1];
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;
			}
			if (n==q-1 && q==p)
			{
				buf[(w+1)*(q-1)+a] = "/,"[twister_rand()%1];
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;
			}

			// %\	 %,  
			// %%	 %%
			// %%%	 %%%
			if (p==q-1 && q==n-1)
			{
				buf[(w+1)*(q-1)+a] = "\\,"[twister_rand()%1];
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;
			}
			if (n==q-1 && q==p-1)
			{
				buf[(w+1)*(q-1)+a] = "/,"[twister_rand()%1];
				if (color)
					color[(w+1)*(q-1)+a] = tcolor;
			}
		}

		if (interference_size)
		{
			int x = scroll-w;
			int e = interference_to;
			if (x>=e)
			{
				interference_size = 0;
				interference_mul = 0;
			}
			else
			{
				float mul = (interference_size-1)/8.0f + 1.0f;
				if (x<interference_from+40)
				{
					interference_mul = mul * (x-interference_from)/40.0f;
				}
				else
				if (x>e-40)
				{
					interference_mul = mul * (e-x)/40.0f;
				}
				else
				{
					interference_mul = mul;
				}
			}
		}

		scroll++;
	}


	SPRITE* spr = head;
	while (spr)
	{
		SPRITE* nxt = spr->next;
		if (scroll-w > spr->x_offset+spr->width)
		{
			if (spr->prev)
				spr->prev->next = spr->next;
			else
				head = spr->next;

			if (spr->next)
				spr->next->prev = spr->prev;
			else
				tail = spr->prev;

			DeleteSprite(spr);
		}
		spr=nxt;
	}
}


FNT::FNT(const ASSET* f) : fnt(f)
{
}

void FNT::Paint(SCREEN* s, int x, int y, unsigned char cl, const char* txt)
{
	const char* ptr = txt;
	int dx = x - 1;
	while (*ptr)
	{
		int gl = *ptr == ':' ? gl=10 : *ptr == '.' ? gl=11 : *ptr == '%' ? gl=12 : *ptr - '0';
		if (gl>=0 && gl<fnt.frames)
		{
			fnt.SetFrame(gl);
			fnt.attrib_mask = ((cl&0x0F)<<4) | 0x0F;
			fnt.attrib_over = (cl&0xF0);
			fnt.Paint(s,dx,y,0,0,-1,-1,0,false);
		}

		dx += 5;
		ptr++;
	}
}

LEVEL_MODAL::LEVEL_MODAL(SCREEN* _s, int _lives, int _start_lives, int* _score, int* _level_time, const char* _player_name,
			const char* _course_name, const LEVEL* _current_level, int start, char* _hitbin, FILE* _rec) :
	b(_s->w,16+_s->h-19-(_s->h-30)/2,cl_transp?_current_level->sky:0),
	m(_s->w,16,_current_level->bkgnd,cl_transp),
	d(_s->w,16,&dunes,cl_transp),
	t(_s->w,10,_s->h, cl_transp, _current_level->sprite, _current_level->height, _hitbin, _current_level->name + 1, _current_level->name + start, _lives)
{
	s=_s;

	score = _score;
	level_time = _level_time;
	lives = _lives;
	start_lives = _start_lives;
	player_name = _player_name;

	jump_voice = 0;

	current_level = _current_level;
	course_name = _course_name;
	x=16;

	write_size = 0;
	write_persec = 0;

	w=s->w;
	h=s->h;
	speed=0;
		
	if (start!=0)
	{
		// after death, start it harder
		PlayLoop(0,0,9,21);
		speed = 200;
	}

	chaisis_vert = 0; 

	key_state = 0;

	/*
	tch_state = 0;
	memset(tch_id,-1,sizeof(int)*32);
	tch_quit.Event.TouchEvent.id = -1;
	*/
	speed_id = -1;
	jump_id = -1;
	fire_id = -1;
	exit_id = -1;


	vely = 0;
	posy = -1; // grounded

	expl=-1;
	expl_x=0;
	wheel_posx[0] = wheel_posx[1] = wheel_posx[2] = 0;
	wheel_vert[0] = wheel_vert[1] = wheel_vert[2] = 0;
	wheel_vely[0] = wheel_vely[1] = wheel_vely[2] = 0;
	wheel_velx[0] = wheel_velx[1] = wheel_velx[2] = 0;

	fr = 0;
	freeze_fr = -1;

	start_tm = get_time();
	lag_tm = start_tm;

	t_scroll_div = 100;
	d_scroll_div = 300;
	m_scroll_div = 900;
	b_scroll_div = 2700;

	// absolute hi-res scroll position
	scroll = (t.scroll-t.w)*t_scroll_div; 

	cannon_hit = false;
	cannon_t = -1;
	cannon_x = 0;
	cannon_x2 = 0;
	cannon_y = 0;
	cannon_sx = 0;

	bullets = 0;
	bullet_fr = -1;

	// level passed anim
	post_split = 0;
	post_scroll = 0;
	post_x = 0;

	fr=-1;

	record_fr = -1;

	rec_score = 0;
	if (score)
		rec_score = *score;

	rec_len=0;

	if (!_rec)
	{
		record_file = 0;

		record_rel = has_key_releases();
		unsigned char has_rel = record_rel;

		record_mode = 'W';

		has_rel ^= rec_score;
		crypt_enc(&has_rel);

		rec_write(has_rel);
	}
	else
	{
		record_mode = 'R';
		record_file = _rec;

		// read sticky byte
		unsigned char has_rel;
		if (fread(&has_rel,1,1,record_file)!=1)
			record_rel = has_key_releases();
		else
		{
			crypt_dec((unsigned char*)&has_rel);
			has_rel ^= *score;
			record_rel = !!has_rel;
		}

		record_cmd = Fetch(&record_fr);
		//record_fr--;

		// prefetch first record_cmd
		// set record_fr to its dispatch frame
	}
}

int LEVEL_MODAL::Run()
{
	//return -1;

	const static int wheel_pos[3] = {1,5,10};

	unsigned long this_tm = get_time();

	if (record_mode!='R' && record_mode!='X' || rec_show==2)
	{
		if (freeze_fr<0 && this_tm - lag_tm > 100)
		{
			// LAAAAG! we don't allow playing at frq<10Hz
			start_tm += this_tm - lag_tm;
		}

		lag_tm = this_tm;
	}
	else
	{
		// if fast?
		// force time to match next rec frame
		if (record_cmd==0xFF00)
		{
			// advance by 10 seconds if there is no more input
			record_fr+=1000; 
		}

		this_tm = start_tm + record_fr*10;
	}

	int this_fr = (this_tm-start_tm)/10;

	if (freeze_fr<0)
	while (fr<this_fr)
	{
		if (record_mode=='R' && fr>=record_fr)
			break;

		if (t.check_passed+1 < t.check_points || t.check_points==1) // or only start point is defined
		{
			if (speed)
			{
				if (level_time)
					*level_time += 10;
			}

			scroll+=speed/10;
			post_scroll = scroll;

			if (speed==0 && fr>200)
			{
				// at level begin, start it softer
				PlayLoop(0,0,9,21);
				speed=200;
			}

			if (expl<0 && (fr&7)==0 && speed) // (speed=0 -> intro!)
			{
				int xx = 19 - (300-speed)/16;
				if (x<xx)
					x++;
				if (x>xx)
					x--;
			}

			post_x = x;
		}
		else
		{
			// last checkpoint passed? 

			FadeOut(2000);

			post_split+=5;
			if (post_split > 1000)
				post_split = 1000;

			post_scroll += speed/10;
			scroll += (1000 * speed - post_split*speed +5000)/10000;

			x = post_x + (post_scroll - scroll)/t_scroll_div;
		}


		int prev_b = b.scroll; // used for scroll scoreing

		b.Scroll((scroll+(b.w-b.scroll)*b_scroll_div)/b_scroll_div); 
		m.Scroll((scroll+(m.w-m.scroll)*m_scroll_div)/m_scroll_div); 
		d.Scroll((scroll+(d.w-d.scroll)*d_scroll_div)/d_scroll_div); 
		t.Scroll((scroll+(t.w-t.scroll)*t_scroll_div)/t_scroll_div); 

		// scrolling score, (not exploded, not first frame, not passed level yet)
		if (expl<0 && fr>=0 && t.check_passed+1 < t.check_points)
		{
			int offs_b = b.scroll - prev_b;
			if (score)
				*score += offs_b*10;
		}

		t.AnimateSprites(fr,speed,expl>=0);

		// animate & hitest cannon bullets
		if (cannon_t>=0)
		{
			int dt = fr-cannon_t;
			int ofs = dt*2;
			if (ofs>20)
				ofs=20;
			int pos = cannon_x + ofs;

			int f=0;
			if (dt>=5)
				f = (dt-5)/12;

			if (f>2)
				cannon_t = -1;
			else
			{
				c.SetFrame(f);

				// hit test with terrain & its sprites, 
				// (pass coords in unscrolled terrain)
				if (!cannon_hit)
				{
					if (t.CannonTest( pos, cannon_y - (h-t.h), f, fr, score))
					{
						// convert it as naturaly ending in the hit point
						//f=2;
						cannon_t = fr-29 + 12;
						cannon_x = pos-20;

						// prevent from hitting anything else
						cannon_hit = true;
					}
				}

				if (f==2)
					pos -= (t.scroll-cannon_x2);
				else
					cannon_x2 = t.scroll; // store to make it easier to paint final poof

				cannon_sx = pos;
			}
		}

		// vertical bullets
		for (int i=0; i<bullets; i++)
		{
			BULLET* b=bullet+i;
			int bx = (b->x - t.scroll)*1000 + (fr-b->fr)* b->vx;
				
			// round toward previous sx!
			int dx = (bx - 1000 * b->sx + 250) / 1000;
			b->sx += dx;

			if ((fr&0x3)==0)
				b->y--;
			if (b->y<0 || t.BulletTest(fr,b->sx,b->y, score))
			{
				if (i<bullets-1)
					memmove(b,b+1,sizeof(BULLET)*(bullets-i-1));
				bullets--;
				i--;
				continue;
			}
		}


		int mdh = 0;
		int udh = h;

		if (expl<0)
		{
			for (int wh=0; wh<3; wh++)
			{
				int dh = t.GetMaxHeight(x + wheel_pos[wh], 4);
				mdh = dh>mdh ? dh : mdh;
				udh = dh<udh ? dh : udh;
			}

			if (posy>=0) // flying
			{
				// posy is 32 times screen coord!
				posy += vely;
				vely -= 2;

				// check grounding
				if ((mdh+udh+1)/2 >= posy/256 && vely<=0)
				{
					StopSFX(jump_voice,100);
					posy = -1;
					vely = 0;

					chaisis_vert = h-(mdh+udh+1)/2-6  + ((key_state&2)>>1);

					for (int wh=0; wh<3; wh++)
					{
						int dh = t.GetMaxHeight(x + wheel_pos[wh], 4);
						wheel[wh].SetFrame(post_scroll/200+wh);
						wheel_vert[wh] = h-dh-3;
					}
				}
				else
				{
					chaisis_vert = h-(posy/256)-6 + ((key_state&2)>>1);

					for (int wh=0; wh<3; wh++)
					{
						int dh = posy/256;
						wheel[wh].SetFrame(post_scroll/200+wh);
						wheel_vert[wh] = h-dh-3;
					}
				}
			}
			else
			{
				chaisis_vert = h-(mdh+udh+1)/2-6  + ((key_state&2)>>1);

				for (int wh=0; wh<3; wh++)
				{
					// smash stones
					int dh = t.GetMaxHeight(x + wheel_pos[wh], 4);
					wheel[wh].SetFrame(post_scroll/200+wh);
					wheel_vert[wh] = h-dh-3;
				}
			}

			// suspension gets broken!
			if (t.check_passed+1 < t.check_points)
			if (ABS(wheel_vert[0]-wheel_vert[1])>1 || 
				ABS(wheel_vert[1]-wheel_vert[2])>1 || 
				ABS(wheel_vert[0]-wheel_vert[2])>2)
			{
				// should match middle wheel
				chaisis_vert = wheel_vert[1]-1  + ((key_state&2)>>1);

				wheel_vely[0] = twister_rand()%150+40;
				wheel_vely[1] = twister_rand()%150+40;
				wheel_vely[2] = twister_rand()%150+40;

				wheel_velx[0] = -(twister_rand()%50+100);
				wheel_velx[1] = (twister_rand()%100-49);
				wheel_velx[2] = +(twister_rand()%50+100);

				if (wheel_velx[1]>=0)
					wheel_velx[1] += 50;
				if (wheel_velx[1]<0)
					wheel_velx[1] -= 50;

				wheel_posx[0] = x + wheel_pos[0];
				wheel_posx[1] = x + wheel_pos[1];
				wheel_posx[2] = x + wheel_pos[2];

				wheel_posx[0]<<=8;
				wheel_posx[1]<<=8;
				wheel_posx[2]<<=8;
				wheel_vert[0]<<=8;
				wheel_vert[1]<<=8;
				wheel_vert[2]<<=8;

				expl_x = t.scroll;

				t.DismissSprites(fr,speed);

				expl=0;
				lives--;

				FadeOut(4000);
				PlaySFX(CAR_EXPLODE);
			}
		}
		else
		{
			if ((fr&15)==0)
			{
				expl++;
				chassis.Explode(expl);
				if (expl>=25)
				{
					return t.check_passed;
				}
				speed-=speed*20/100;
			}

			// simulate jumping wheels
			for (int wh=0; wh<3; wh++)
			{
				wheel[wh].SetFrame(post_scroll/200+wh + fr/8);

				wheel_posx[wh]+=wheel_velx[wh];
				wheel_vert[wh]-=wheel_vely[wh];
				wheel_vely[wh]-=8;

				int x=wheel_posx[wh]>>8;
				int y=wheel_vert[wh]>>8;

				int dh = t.GetMaxHeight(x, 4);
				int gr = h-dh-3;
				if (y>gr)
				{
					y=gr;
					wheel_vert[wh] = y<<8;
					wheel_vely[wh] = ABS(wheel_vely[wh]);

					PlaySFX((SFX)(WHEEL_BOUNCE0 + wh));
				}
			}
		}

		if (expl<0 && t.check_passed+1 < t.check_points)
		{
			if (t.HitTest(&chassis,x,chaisis_vert - (h-t.h), fr))
			{
				wheel_vely[0] = twister_rand()%150+40;
				wheel_vely[1] = twister_rand()%150+40;
				wheel_vely[2] = twister_rand()%150+40;

				wheel_velx[0] = -(twister_rand()%50+100);
				wheel_velx[1] = (twister_rand()%100-49);
				wheel_velx[2] = +(twister_rand()%50+100);

				if (wheel_velx[1]>=0)
					wheel_velx[1] += 50;
				if (wheel_velx[1]<0)
					wheel_velx[1] -= 50;

				wheel_posx[0] = x + wheel_pos[0];
				wheel_posx[1] = x + wheel_pos[1];
				wheel_posx[2] = x + wheel_pos[2];

				wheel_posx[0]<<=8;
				wheel_posx[1]<<=8;
				wheel_posx[2]<<=8;
				wheel_vert[0]<<=8;
				wheel_vert[1]<<=8;
				wheel_vert[2]<<=8;

				expl_x = t.scroll;

				t.DismissSprites(fr,speed);

				expl=0;
				lives--;

				FadeOut(4000);
				PlaySFX(CAR_EXPLODE);
			}
		}

		
		if ((key_state & 12) != 12 && expl<0 && speed) // (speed=0 -> intro!)
		{
			if ((key_state & 8) || t.check_passed+1 >= t.check_points && t.check_points>1) // ACC
			{
				speed+=(speed+75)/150;

				if (t.check_passed+1 < t.check_points || t.check_points<=1)
				{
					if (speed>460)
						speed=460;
				}
				else
				{
					if (speed>1000)
						speed=1000;
				}
			}
			else
			if (key_state & 4) // BRK
			{
				speed-=(speed+75)/150;
				if (speed<200)
					speed=200;
			}
			else
			{
				if (speed<300)
				{
					speed+=(speed+100)/200;
					if (speed>300)
						speed=300;
				}
				if (speed>300)
				{
					speed-=(speed+100)/200;
					if (speed<300)
						speed=300;
				}
			}
		}


		// check if level passed
		if (t.check_passed+1 >= t.check_points)
		{
			if (x>=s->w*3/2)
				return -1;
		}

		fr++;
	} // frame loop


	////////////////////////////////
	// PAINT

	if (record_mode!='X' && record_mode!='R' || rec_show>0)
	{
		s->Clear();

		b.Paint(s, 0,1, 0,1);
		m.Paint(s, 0,h-25  - (h-30)/2, 0,0, -1,-1, true);
		d.Paint(s, 0,h-19  - (h-30)/2, 0,0, -1,-1, true);

		if (cannon_t>=0)
			c.Paint(s, cannon_sx, cannon_y , 0,0);

		for (int i=0; i<bullets; i++)
		{
			BULLET* b=bullet+i;
			if (b->sx>=0 && b->sx<w)
			{
				s->buf[(s->w+1)*b->y+b->sx] = ch_bullet;
				if (s->color)
					s->color[(s->w+1)*b->y+b->sx] = cl_bullet;
			}
		}

		if (expl<0)
		{
			chassis.Paint(s, x, chaisis_vert, 0,0);

			/*
			for (int wh=0; wh<3; wh++)
				wheel[wh].Paint(s, x + wheel_pos[wh], wheel_vert[wh], 0,0);
			*/
		}
		else
		{
			chassis.Paint(s, x+(expl_x-t.scroll)/2, chaisis_vert, 0,0);

			/*
			for (int wh=0; wh<3; wh++)
				wheel[wh].Paint(s, wheel_posx[wh]>>8, wheel_vert[wh]>>8, 0,0);
			*/
		}

		t.Paint(s, 0,h-t.h, 0,0, -1,-1, true);

		if (expl<0)
		{
			for (int wh=0; wh<3; wh++)
				wheel[wh].Paint(s, x + wheel_pos[wh], wheel_vert[wh], 0,0);
		}
		else
		{
			for (int wh=0; wh<3; wh++)
				wheel[wh].Paint(s, wheel_posx[wh]>>8, wheel_vert[wh]>>8, 0,0);
		}

		if (t.interference_size)
		{
			t.fld.thr = 6;
			IsoContour(s,0x8,Field::cb,&t.fld,0,0);

			t.fld.thr = 7;
			IsoContour(s,0x6,Field::cb,&t.fld,0,0);

			t.fld.thr = 10;
			IsoContour(s,0xE,Field::cb,&t.fld,0,0);

			float field = t.fld.field(x+chassis.width/2,chaisis_vert+chassis.height/2);

			// THIS PART CANNOT HAVE AN INFUENCE ON TWISTER
			{
				twister_switch(1);

				if (field>5)
					Interference(s,
						(int)(0.5f*(field>5.0f ? field-5.0f : 0.0f)), 
						(int)(1.0f*(field>3 ? 3+20/(field) : 0)), 
						scroll, 100, 
						(int)(0.5f*(field>7? field-7:0)), 
						field>20.0f);

				twister_switch(0);
			}
		}

		/*
		if (current_level==campaign[0].level)
		{
			// tut
			static unsigned int man_t=get_time();
			unsigned int t = get_time();
			int adv = (t-man_t)/20;
			man_t += adv*20;

			static int anim=-10;
			anim += adv;

			if (anim>44*manual.sheets+10)
				anim=-10;

			int a = anim;

			if (a>22*manual.sheets+10)
				a=44*manual.sheets+10-a;

			if (a<0)
				a=0;
			if (a>22*manual.sheets)
				a=22*manual.sheets;

			int p = a/22;
			a -= 22*p;

			manual.SetPage(p,a);
			manual.Paint(s,s->w - manual.w,10,0,0);
		}
		*/

		if (fr<1000 && (lives == start_lives || expl>=0 && lives+1 == start_lives))
		{
			char line1[64]="";
			char line2[64]="";
			char line3[64]="";

			int len1 = sprintf_s(line1,64,"Chapter: %s",course_name);
			int len2 = sprintf_s(line2,64,"Area:    [%c-%c]",current_level->name,current_level->name2);
			int len3 = sprintf_s(line3,64,"Player:  %s",player_name);

			int t = 32*fr/100 - 32;

			int clip1 = MIN(len1,MAX(0,t-16));
			int clip2 = MIN(len2,MAX(0,t-32));
			int clip3 = MIN(len3,MAX(0,t-48));

			if (clip1>0 && clip1<len1)
				line1[clip1++] = '#';
			if (clip2>0 && clip2<len2)
				line2[clip2++] = '#';
			if (clip3>0 && clip3<len3)
				line3[clip3++] = '#';

			int width = MAX(MAX(len1,len2),len3);
			
			int y1 = 8;
			int y2 = 9;
			int y3 = 11;
			int dx = (s->w - width) / 2;

			if (fr>550)
				y1-=(fr-550)*16/100;
			if (fr>560)
				y2-=(fr-560)*16/100;
			if (fr>580)
				y3-=(fr-580)*16/100;

			if (y1>0)
				memcpy(s->buf + y1*(s->w+1)+dx, line1, clip1);
			if (y2>0)
				memcpy(s->buf + y2*(s->w+1)+dx, line2, clip2);
			if (y3>0)
				memcpy(s->buf + y3*(s->w+1)+dx, line3, clip3);

			if (s->color)
			{
				static char color1[]={0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71, 
									  0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74,0x74};
				static char color2[]={0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71,0x71, 
									  0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70,0x70};
				if (y1>0)
					memcpy(s->color + y1*(s->w+1)+dx, color1, clip1);
				if (y2>0)
					memcpy(s->color + y2*(s->w+1)+dx, color1, clip2);
				if (y3>0)
					memcpy(s->color + y3*(s->w+1)+dx, color2, clip3);
			}
		}

	}

	////////////////////////////////
	// WRITE OUT

	int dw = 0;
	int dh = 0;

	//##
	GetTerminalWH(&dw,&dh);
	//##

	int nw = dw;
	int nh = dh;

	if (nw<80)
		nw=80;
	if (nw>160)
		nw=160;

	if (nh<25)
		nh=25;
	if (nh>50)
		nh=50;

	if (nw!=w || nh!=h)
	{
		Record(REC_SIZ,fr,nw,nh);

		s->Resize(nw,nh);
			
		b.Resize(nw,16+h-19-(nh-30)/2);
		t.scr_height = nh;

		if (nw!=w)
		{
			t.Resize(nw,10);
			m.Resize(nw,16);
			d.Resize(nw,16);
		}
			

		w = nw;
		h = nh;
	}

	if (record_mode!='X' && record_mode!='R' || rec_show>0)
	{
		// every sec elapsed report bytes written
		static unsigned long prev_tm = this_tm;
		if (this_tm-prev_tm > 1000)
		{
			prev_tm += 1000;
			write_persec = write_size;
			write_size = 0;
		}

		char status[81];
		/*
		sprintf_s(status,81,"  Cars: %d Gear:%d %s %s [%c-%c] Pos: %d Write: %d b/sec  ",
			lives,
			key_state&4 ? 1 : key_state&8 ? 3 : 2, 
			key_state&2 ? "Crouch" : posy>=0 ? " Jump " : "      ", 
			course_name,
			current_level->name+t.check_passed, current_level->name+t.check_passed +1, 
			t.scroll-t.w, 
			write_persec);
		*/

		// left
		int statlen;
		statlen = sprintf_s(status,81,"  Score: % 7d", score?*score:0);
		memcpy(s->buf,status,statlen);
		if (s->color)
		{
			memset(s->color,cl_statlabel,9);
			memset(s->color+9,cl_statvalue,statlen-9);
		}

		int cars_ofs = statlen;
		statlen = sprintf_s(status,81," Cars: %d",lives);
		memcpy(s->buf+cars_ofs,status,statlen);
		if (s->color)
		{
			memset(s->color+cars_ofs,cl_statlabel,7);
			memset(s->color+cars_ofs+7,cl_statvalue,statlen-7);
		}


		// center
		statlen = sprintf_s(status,81,"  Level: %s [%c-%c]  ", course_name, current_level->name+t.check_passed, current_level->name+t.check_passed +1);
		memcpy(s->buf+(s->w-statlen)/2,status,statlen);
		if (s->color)
		{
			memset(s->color+(s->w-statlen)/2,cl_statlabel,9);
			memset(s->color+(s->w-statlen)/2+9,cl_statvalue,statlen-9);
		}
		
		// right
		int t_min = *level_time/(1000*60);
		int t_sec = (*level_time - t_min*(1000*60))/1000;
		int t_hnd = (*level_time/10) % 100;
		statlen = sprintf_s(status,81,"Time: %02d:%02d.%02d  ", t_min,t_sec,t_hnd);
		memcpy(s->buf+s->w-statlen,status,statlen);
		if (s->color)
		{
			memset(s->color+s->w-statlen,cl_statlabel,6);
			memset(s->color+s->w-statlen+6,cl_statvalue,statlen-6);
		}

		if (s->color)
		{
			for (int x=0; x<s->w; x++)
			{
				s->color[x] = (s->color[x] & 0x0F) | cl_statbkgnd;
			}
		}

		write_size += s->Write(dw,dh,0,0,-1,-1);
	}

	/////////////////////////////////
	// HANDLE KEYBOARD INPUT

	CON_INPUT ir[4];
	int irn=0;

	//##
	GetInputLen(&irn);
	//##
	while (irn)
	{
		//##
		ReadInput(ir,4,&irn);
		//##
		for (int i=0; i<irn; i++)
		{
			/*
				TOUCH LAYOUT:
				             draggable        tappable
				        :    LEFT HAND    :  RIGHT HAND  : 3 :
				     -- +-----+-----+-----+--------------+---+ -- 0
				        |     |     |     |              | X | 3 cells
				        | LFT |     | RGT |      JUMP    +---+ -- 
				        |     |     |     +------------------+ -- v-half
				     -- +-----+-----+-----+                  |
				3 cells | L-L | DWN | L-R |      FIRE        |
				     -- +-----+-----+-----+------------------+ -- height
				        :     :     :     :                  :
				        0    1/6   2/6  h-half             width
			*/

			if (ir[i].EventType==CON_INPUT_TCH_BEGIN)
			{
				if (ir[i].Event.TouchEvent.x < (s->w>>1))
				{
					if (speed_id<0)
					{
						speed_id = ir[i].Event.TouchEvent.id;

						int old = key_state;

						key_state &= ~0x0E;

						if (ir[i].Event.TouchEvent.x < s->w*1/6)
						{
							// left
							key_state |= 4;
							if (!(old & 4))
								Record(REC_KEY,fr,KBD_LT,1);
						}
						else
						{
							if (old & 4)
								Record(REC_KEY,fr,KBD_LT,0);
						}

						if (ir[i].Event.TouchEvent.x >= s->w*2/6)
						{
							// right
							key_state |= 8;
							if (!(old & 8))
								Record(REC_KEY,fr,KBD_RT,1);
						}
						else
						{
							if (old & 8)
								Record(REC_KEY,fr,KBD_RT,0);
						}

						if (ir[i].Event.TouchEvent.y >= s->h-3)
						{
							// down
							key_state |= 2;
							if (!(old & 2))
								Record(REC_KEY,fr,KBD_DN,1);
						}
						else
						{
							if (old & 2)
								Record(REC_KEY,fr,KBD_DN,0);
						}
					}
				}
				else
				{
					if (ir[i].Event.TouchEvent.y >= (s->h>>1))
					{
						if (fire_id<0)
						{
							// fire
							fire_id = ir[i].Event.TouchEvent.id;

							if (!(key_state & 16))
							{
								key_state |= 16;
								Record(REC_KEY,fr,13,1);

								if (freeze_fr<0 && bullets<32 && ((fr-bullet_fr)>=20 || bullet_fr<0)) // FIRE
								{
									if (expl<0)
									{
										BULLET* b = bullet+bullets;
										bullets++;
										b->sx = x+4;
										b->x = t.scroll + b->sx;
										b->y = chaisis_vert;
										b->fr = fr;
										b->vx = speed;
										bullet_fr = fr;

										PlaySFX(CAR_LASER);
									}
								}

								if (freeze_fr<0 && cannon_t<0) // FIRE
								{
									if (expl<0)
									{
										cannon_t = fr;
										cannon_x = x + 13 - 2;
										cannon_y = chaisis_vert+2;
										cannon_hit = false;

										PlaySFX(CAR_CANNON);
									}
								}
							}
						}
					}
					else
					{
						if (ir[i].Event.TouchEvent.y < 3 && ir[i].Event.TouchEvent.x >= s->w-3)
						{
							if (exit_id<0)
								exit_id = ir[i].Event.TouchEvent.id;
						}
						else
						if (jump_id<0)
						{
							// jump
							jump_id = ir[i].Event.TouchEvent.id;

							if (!(key_state & 1))
							{
								key_state |= 1;
								Record(REC_KEY,fr,KBD_UP,1);

								if (freeze_fr<0 && posy<0) // JUMP
								{
									int extra_vel = 128*speed*(wheel_vert[0]-wheel_vert[2])/(10*t_scroll_div*(wheel_pos[2]-wheel_pos[0]));
									if (expl<0)
									{
										vely = 80 + extra_vel;
										posy = -256*(chaisis_vert + 6-h) + vely;
										PlaySFX(CAR_JUMP,&jump_voice);
									}
								}
							}
						}
					}
				}
			}
			else
			if (ir[i].EventType==CON_INPUT_TCH_MOVE)
			{
				DBG("------MOVE\n");

				if (ir[i].Event.TouchEvent.id == speed_id)
				{
					int old = key_state;
					key_state &= ~0x0E;

					if (ir[i].Event.TouchEvent.x < s->w*1/6)
					{
						// left
						key_state |= 4;
						if (!(old & 4))
							Record(REC_KEY,fr,KBD_LT,1);
					}
					else
					{
						if (old & 4)
							Record(REC_KEY,fr,KBD_LT,0);
					}

					if (ir[i].Event.TouchEvent.x >= s->w*2/6)
					{
						// right
						key_state |= 8;
						if (!(old & 8))
							Record(REC_KEY,fr,KBD_RT,1);
					}
					else
					{
						if (old & 8)
							Record(REC_KEY,fr,KBD_RT,0);
					}

					if (ir[i].Event.TouchEvent.y >= s->h-3)
					{
						// down
						key_state |= 2;
						if (!(old & 2))
							Record(REC_KEY,fr,KBD_DN,1);
					}
					else
					{
						if (old & 2)
							Record(REC_KEY,fr,KBD_DN,0);
					}
				}
			}
			else
			if (ir[i].EventType==CON_INPUT_TCH_END)
			{
				DBG("------END\n");

				if (ir[i].Event.TouchEvent.id == speed_id)
				{
					speed_id = -1;

					if (key_state & 2)
						Record(REC_KEY,fr,KBD_DN,0);
					if (key_state & 4)
						Record(REC_KEY,fr,KBD_LT,0);
					if (key_state & 8)
						Record(REC_KEY,fr,KBD_RT,0);

					key_state &= ~0x0E;
				}

				if (ir[i].Event.TouchEvent.id == fire_id)
				{
					if (key_state & 16)
						Record(REC_KEY,fr,13,0);
					key_state &= ~16;
					fire_id = -1;
				}

				if (ir[i].Event.TouchEvent.id == jump_id)
				{
					if (key_state & 1)
						Record(REC_KEY,fr,KBD_UP,0);
					key_state &= ~1;
					jump_id = -1;
				}

				if (ir[i].Event.TouchEvent.id == exit_id)
				{
					exit_id = -1;

					if (ir[i].Event.TouchEvent.y < 3 && ir[i].Event.TouchEvent.x >= s->w-3)
					{
						if (key_state & 1)
							Record(REC_KEY,fr,KBD_UP,0);
						if (key_state & 2)
							Record(REC_KEY,fr,KBD_DN,0);
						if (key_state & 4)
							Record(REC_KEY,fr,KBD_LT,0);
						if (key_state & 8)
							Record(REC_KEY,fr,KBD_RT,0);
						if (key_state & 16)
							Record(REC_KEY,fr,13,0);

						key_state = 0;
						speed_id = -1;
						fire_id = -1;
						jump_id = -1;

						return -2;
					}
				}
			}
			else
			if (ir[i].EventType==CON_INPUT_FOC)
			{
				Record(REC_FOC,fr,ir[i].Event.FocusEvent.bSetFocus,0);

				if (!ir[i].Event.FocusEvent.bSetFocus)
				{
					key_state = 0;
					/*
					tch_state = 0;
					memset(tch_id,-1,sizeof(int)*32);
					tch_quit.Event.TouchEvent.id = -1;
					*/
					speed_id = -1;
					jump_id = -1;
					fire_id = -1;
					exit_id = -1;
				}
			}
			else
			if (ir[i].EventType==CON_INPUT_KBD)
			{
				int key = 0;
				switch (ConfMapInput(ir[i].Event.KeyEvent.uChar.AsciiChar))
				{
					/*
					case 'R':
					case 'r':
						key=32; break; // ???
					*/

					case 27:
						key=64; break;

					case KBD_UP: 
						key=1; break;

					// SNEAKING
					case KBD_DN: 
						key=2; break;

					case KBD_LT: 
						key=4; break;

					case KBD_RT: 
						key=8; break;

					case 13:
						key=16; break;

					/*
					case '1':
						key=1<<8; break;
					case '2':
						key=1<<9; break;
					case '3':
						key=1<<10; break;
					case '4':
						key=1<<11; break;
					case '5':
						key=1<<12; break;
					case '6':
						key=1<<13; break;
					case '7':
						key=1<<14; break;
					case '8':
						key=1<<15; break;
					case '9':
						key=1<<16; break;
					case '0':
						key=1<<17; break;
					*/

				}

				if (key)
				{
					int old = key_state;

					if (ir[i].Event.KeyEvent.bKeyDown && !(key_state&key) /*&& !(tch_state&key)*/)
					{
						//##
						if (!HasKeyReleases())
						//##
						{
							// sticky 'A' , release 'D'								
							if (key==4)
							{
								if (key_state&8)
								{
									key_state &= ~8; // release right
									/*
									tch_state &= ~8;
									tch_id[3] = -1;
									*/
									speed_id = -1;
								}
								else
								{
									key_state |= 4; // press left
								}
							}
						}

						//##
						if (!HasKeyReleases())
						//##
						{
							// sticky 'D' , release 'A'								
							if (key==8)
							{
								if (key_state&4)
								{
									key_state &= ~4; // release left
									/*
									tch_state &= ~4;
									tch_id[2] = -1;
									*/
									speed_id = -1;
								}
								else
								{
									key_state |= 8; // press right
								}
							}
						}

						//##
						if (!HasKeyReleases())
						//##
						{
							// sticky 'S'								
							if (key==2 && posy<0)
							{
								key_state |= 2; // press down
							}
						}

						if (freeze_fr<0 && key==1 && posy<0) // JUMP
						{
							int extra_vel = 128*speed*(wheel_vert[0]-wheel_vert[2])/(10*t_scroll_div*(wheel_pos[2]-wheel_pos[0]));
							//##
							if (!HasKeyReleases())
							//##
							{
								// release 'S'								
								if (key_state&2)
								{
									key_state &= ~2; // release down
									/*
									tch_state &= ~2;
									tch_id[1] = -1;
									*/
									speed_id = -1;
								}
								else
								{
									// trigger jump
									if (expl<0)
									{
										vely = 80 + extra_vel;
										posy = -256*(chaisis_vert + 6-h) + vely;

										PlaySFX(CAR_JUMP,&jump_voice);
									}
								}
							}
							else
							if (expl<0)
							{
								vely = 80 + extra_vel;
								posy = -256*(chaisis_vert + 6-h) + vely;

								PlaySFX(CAR_JUMP,&jump_voice);
							}
						}

						if (freeze_fr<0 && key==16 && bullets<32 && ((fr-bullet_fr)>=20 || bullet_fr<0)) // FIRE
						{
							if (expl<0)
							{
								BULLET* b = bullet+bullets;
								bullets++;
								b->sx = x+4;
								b->x = t.scroll + b->sx;
								b->y = chaisis_vert;
								b->fr = fr;
								b->vx = speed;
								bullet_fr = fr;

								PlaySFX(CAR_LASER);
							}
						}

						if (freeze_fr<0 && key==16 && cannon_t<0) // FIRE
						{
							if (expl<0)
							{
								cannon_t = fr;
								cannon_x = x + 13 - 2;
								cannon_y = chaisis_vert+2;
								cannon_hit = false;

								PlaySFX(CAR_CANNON);
							}
						}

						if (key==(1<<8) || key==(1<<17))
						{
							// give up

							chaisis_vert = wheel_vert[1]-1  + ((key_state&2)>>1);

							wheel_vely[0] = twister_rand()%150+40;
							wheel_vely[1] = twister_rand()%150+40;
							wheel_vely[2] = twister_rand()%150+40;

							wheel_velx[0] = -(twister_rand()%50+100);
							wheel_velx[1] = (twister_rand()%100-49);
							wheel_velx[2] = +(twister_rand()%50+100);

							if (wheel_velx[1]>=0)
								wheel_velx[1] += 50;
							if (wheel_velx[1]<0)
								wheel_velx[1] -= 50;

							wheel_posx[0] = x + wheel_pos[0];
							wheel_posx[1] = x + wheel_pos[1];
							wheel_posx[2] = x + wheel_pos[2];

							wheel_posx[0]<<=8;
							wheel_posx[1]<<=8;
							wheel_posx[2]<<=8;
							wheel_vert[0]<<=8;
							wheel_vert[1]<<=8;
							wheel_vert[2]<<=8;

							expl_x = t.scroll;

							t.DismissSprites(fr,speed);

							if (key==(1<<17))
							{
								t.check_passed=0;
							}

							expl=0;
							lives--;

							FadeOut(4000);
							PlaySFX(CAR_EXPLODE);
						}

						if (key==32) // REFRESH
						{
							if (s->arr)
								free_con_output(s);
							s->arr = 0;
						}

						if (key==(1<<16) || key==64) // QUIT
						{
							return -2;
						}

						if (key==(1<<9))
						{
							if (freeze_fr<0)
								freeze_fr = fr;
							else
							{
								start_tm = this_tm/*get_time()*/ - 10*freeze_fr;
								freeze_fr = -1;
							}
						}

						//##
						// if (HasKeyReleases())
						//##

							// exec press action
							// OutputDebugString(L"DOWN!!!!!!!!!!!!!!!!!!!!!!!!\n");

						if (HasKeyReleases())
							key_state ^= key;

						if (!(old & key))
						{
							switch (key)
							{
								case 1:  Record(REC_KEY,fr,KBD_UP,1); break;
								case 2:  Record(REC_KEY,fr,KBD_DN,1); break;
								case 4:  Record(REC_KEY,fr,KBD_LT,1); break;
								case 8:  Record(REC_KEY,fr,KBD_RT,1); break;
								case 16: Record(REC_KEY,fr,13,1); break;
							}
						}
					}
					else
					if (!ir[i].Event.KeyEvent.bKeyDown && (key_state&key) /*&& !(tch_state&key)*/)
					{
						//##
						// if (HasKeyReleases())
						//##

						// exec release action
						// OutputDebugString(L"UP!!!!!!!!!!!!!!!!!!!!!!!!!!\n");

						if (HasKeyReleases())
							key_state ^= key;

						if (old & key)
						{
							switch (key)
							{
								case 1:  Record(REC_KEY,fr,KBD_UP,0); break;
								case 2:  Record(REC_KEY,fr,KBD_DN,0); break;
								case 4:  Record(REC_KEY,fr,KBD_LT,0); break;
								case 8:  Record(REC_KEY,fr,KBD_RT,0); break;
								case 16: Record(REC_KEY,fr,13,0); break;
							}
						}
					}
				}
			}
		}

		irn=0;

		//##
		GetInputLen(&irn);
		//##
	}

	//////////////////////////////////////////
	// GIVE SOME REST TO CPU

	// moved to write
	//Sleep(8);

	return -3;
}

LEVEL_MODAL::~LEVEL_MODAL()
{
	Record(0,fr,0,0);
	if (!record_file && record_mode=='W')
	{
		if (rec_len<=sizeof(rec_buf))
		{
			fopen_s(&record_file,record_path(),"ab");
			if (record_file)
			{
				fwrite(rec_buf,rec_len,1,record_file);
				fclose(record_file);
				record_file = 0;
				write_fs();
			}
		}
	}
	else
	if (record_file && record_mode=='R')
	{
		// ensure file is positioned just after REC_END
		while (record_cmd != 0xFF00)
		{
			record_cmd = Fetch(0);
		}
	}
}

void LEVEL_MODAL::GetTerminalWH(int* _w, int* _h)
{
	if (record_mode=='R')
	{
		if (fr<record_fr)
		{
			if (_w)
				*_w = w;
			if (_h)
				*_h = h;
			return;
		}

		if (record_cmd==0xFF00)
		{
			record_mode='X';

			if (_w)
				*_w = w;
			if (_h)
				*_h = h;
			return;
		}

		int ev = record_cmd >> 13;

		if (ev!=4 && ev!=5)
		{
			if (_w)
				*_w = w;
			if (_h)
				*_h = h;
			return;
		}

		if (_w)
			*_w = 80 + (record_cmd&0xFF);
		if (_h)
			*_h = 25 + ((record_cmd>>8)&0x3f);

		record_cmd = Fetch(&record_fr);

		return;
	}

	if (record_mode=='X')
	{
		// return old wh
		if (_w)
			*_w = w;
		if (_h)
			*_h = h;
		return;
	}

	get_terminal_wh(_w,_h);
}

bool LEVEL_MODAL::GetInputLen(int* len)
{
	if (record_mode=='R')
	{
		int l=0;
		if (fr<record_fr)
		{
			if (len)
				*len=0;
			return true;
		}

		if (record_cmd==0xFF00)
		{
			record_mode='X';
			if (len)
				*len=0;
			return true;
		}

		int ev = record_cmd >> 13;

		if (ev!=4 && ev!=5)
			l=1;

		if (len)
			*len=l;

		return true;
	}

	if (record_mode=='X')
	{
		if (len)
			*len=0;
		return true;
	}

	return get_input_len(len);
}

void LEVEL_MODAL::ReadInput(CON_INPUT* ir, int n, int* r)
{
	if (record_mode=='R')
	{
		int i=0;
		while (i<n)
		{
			if (fr<record_fr)
				break;

			if (record_cmd==0xFF00)
			{
				record_mode='X';
				break;
			}

			int ev = record_cmd >> 13;
			if (ev!=4 && ev!=5)
			{
				// decode it into ir[i]

				if (ev==2 || ev==3)
				{
					char key = 13;
					switch ((record_cmd>>8) & 0x7)
					{
						/*
						case 1: key = KBD_UP; break;
						case 2: key = KBD_DN; break;
						case 3: key = KBD_LT; break;
						case 4: key = KBD_RT; break;
						*/
						case 1: key = KBD_LT; break;
						case 2: key = KBD_RT; break;
						case 3: key = KBD_UP; break;
						case 4: key = KBD_DN; break;
					}

					ir[i].EventType = CON_INPUT_KBD;
					ir[i].Event.KeyEvent.uChar.AsciiChar = key;
					ir[i].Event.KeyEvent.bKeyDown = (ev==2);
				}
				else
				{
					ir[i].EventType = CON_INPUT_FOC;
					ir[i].Event.FocusEvent.bSetFocus = (ev==6);
				}

				// fetch next
				record_cmd = Fetch(&record_fr);
			}
			else
			{
				// next is wh
				break;
			}

			i++;
		}

		if (r)
			*r = i;

		// fetch skips until rec_fr<fr
		// fill ir until next ev is REC_FOC or REC_KEY
		return;
	}

	if (record_mode=='X')
	{
		if (r)
			*r=0;
		return;
	}

	read_input(ir,n,r);
}

bool LEVEL_MODAL::HasKeyReleases()
{
	if (record_mode=='R')
		return record_rel;

	// TODO: Mask against ~conf_sticky !!!
	return has_key_releases();
}


void LEVEL_MODAL::rec_write(unsigned char r)
{
	if (rec_len<sizeof(rec_buf))
		rec_buf[rec_len]=r;
	rec_len++;
}

void LEVEL_MODAL::Record(int ev, unsigned int _fr, unsigned long a, unsigned long b)
{
	if (record_file || record_mode!='W')
		return;

	// first of all check if and which skip frames should we emitt

	int diff_fr = _fr - record_fr;
	// frames are @ 100Hz
	while (diff_fr)
	{
		if (diff_fr > 32)
		{
			// emitt long skip	
			int d = diff_fr;
			if (diff_fr > 8224)
				d=8224;
			
			diff_fr-=d;

			d-=33; // bias
			d|=0x2000; // cmd

			unsigned char d0 = (d>>8)&0xFF;
			unsigned char d1 = d&0xFF;

			d0 ^= rec_score;
			d1 ^= rec_score>>8;
			crypt_enc(&d0);
			crypt_enc(&d1);

			rec_write(d0);
			rec_write(d1);
		}
		else
		if (diff_fr > 0)
		{
			// emitt short skip	
			int d = diff_fr;
			diff_fr = 0;
			
			d-=1;
			d|=0x00; // cmd

			unsigned char d0 = d&0xFF;
			
			d0 ^= rec_score;
			crypt_enc(&d0);
			
			rec_write(d0);
		}
	}

	record_fr = _fr;

	switch (ev)
	{
		case REC_END:
		{
			unsigned char d0 = 0xFF;
			
			d0 ^= rec_score;
			crypt_enc(&d0);

			rec_write(d0);

			break;
		}

		case REC_KEY: // key up/dn
		{
			unsigned char d0 = a&0xFF;
			if (a>=8)
				d0=0;

			if (b)
				d0 |= 0x40;
			else
				d0 |= 0x60;

			d0 ^= rec_score;
			crypt_enc(&d0);

			rec_write(d0);
			break;
		}

		case REC_FOC: // focus in/out
		{
			unsigned char d0 = a ? 1:0;

			d0 ^= rec_score;
			crypt_enc(&d0);

			rec_write(d0);
			break;
		}

		case REC_SIZ: // resize
		{
			unsigned char d0 = (b-25)&0x3f;
			unsigned char d1 = (a-80)&0xFF;

			d0 |= 0x80;

			d0 ^= rec_score;
			d1 ^= rec_score>>8;
			crypt_enc(&d0);
			crypt_enc(&d1);


			rec_write(d0);
			rec_write(d1);

			break;
		}
	}

	if (score)
		rec_score = *score;
}

int LEVEL_MODAL::Fetch(int* _fr)
{
	if (record_mode=='X')
	{
		if (_fr)
			*_fr = record_fr;
		return 0xFF00;
	}

	// returned frame is sum of record_fr + skipped amount
	int skip = 0;
	int cmd = -1;

	while (cmd<0)
	{
		int d;
		unsigned char b0,b1;
		if ( fread(&b0,1,1,record_file) != 1)
		{
			cmd=0xFF00;
			break;
		}

		crypt_dec(&b0);
		b0 ^= (*score);

		int ev = (b0 >> 5) & 0x7;

		switch (ev)
		{
			case 0:
				skip += 1 + (b0&0x1f);
				break;

			case 1:
				if ( fread(&b1,1,1,record_file) != 1)
				{
					cmd=0xFF00;
					break;
				}

				crypt_dec(&b1);
				b1 ^= (*score)>>8;

				d = ( (b0&0x1f)<<8 ) | b1;
				skip += ( 33 + d );
				break;

			case 2:
			case 3:
			case 6:
			case 7:
				cmd = b0<<8;
				break;

			case 4:
			case 5:
				if ( fread(&b1,1,1,record_file) != 1)
				{
					cmd=0xFF00;
					break;
				}

				crypt_dec(&b1);
				b1 ^= (*score)>>8;

				cmd = (b0<<8) | b1;
				break;
		}
	}

	if (_fr)
		*_fr = record_fr + skip;

	return cmd;
}



int InterScreenInput()
{
	CON_INPUT ir[4];
	int irn=0;

	bool hit = false;
	get_input_len(&irn);
	while (irn)
	{
		read_input(ir,4,&irn);
		for (int i=0; i<irn; i++)
		{
			if (ir[i].EventType == CON_INPUT_TCH_END)
			{
				int w,h;
				get_terminal_wh(&w,&h);

				if (ir[i].Event.TouchEvent.x >= w-(w>>3) && 
					ir[i].Event.TouchEvent.y <= (h>>3))
				{
					return -2;
				}

				hit = true;
			}
			else
			if (ir[i].EventType == CON_INPUT_KBD && ir[i].Event.KeyEvent.uChar.AsciiChar!=0)
			{
				if (ir[i].Event.KeyEvent.bKeyDown)
				{
					// any key press
					if (ConfMapInput(ir[i].Event.KeyEvent.uChar.AsciiChar)==27)
						return -2;
					hit = true;
				}
			}
		}

		irn=0;
		get_input_len(&irn);
	}

	// moved to write
	//Sleep(8);

	if (hit)
		return -1;

	return 0;
}

