#!/usr/bin/python
from __future__ import absolute_import, division, print_function
# Copyright 2019-2023 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

__metaclass__ = type

ANSIBLE_METADATA = {'status': ['preview'],
                    'supported_by': 'community',
                    'metadata_version': '1.1'}

DOCUMENTATION = '''
---
module: fmgr_extensioncontroller_extenderprofile_cellular
short_description: FortiExtender cellular configuration.
description:
    - This module is able to configure a FortiManager device.
    - Examples include all parameters and values which need to be adjusted to data sources before usage.

version_added: "2.2.0"
author:
    - Xinwei Du (@dux-fortinet)
    - Xing Li (@lix-fortinet)
    - Jie Xue (@JieX19)
    - Link Zheng (@chillancezen)
    - Frank Shen (@fshen01)
    - Hongbin Lu (@fgtdev-hblu)
notes:
    - Running in workspace locking mode is supported in this FortiManager module, the top
      level parameters workspace_locking_adom and workspace_locking_timeout help do the work.
    - To create or update an object, use state present directive.
    - To delete an object, use state absent directive.
    - Normally, running one module can fail when a non-zero rc is returned. you can also override
      the conditions to fail or succeed with parameters rc_failed and rc_succeeded

options:
    access_token:
        description: The token to access FortiManager without using username and password.
        required: false
        type: str
    bypass_validation:
        description: Only set to True when module schema diffs with FortiManager API structure, module continues to execute without validating parameters.
        required: false
        type: bool
        default: false
    enable_log:
        description: Enable/Disable logging for task.
        required: false
        type: bool
        default: false
    forticloud_access_token:
        description: Authenticate Ansible client with forticloud API access token.
        required: false
        type: str
    proposed_method:
        description: The overridden method for the underlying Json RPC request.
        required: false
        type: str
        choices:
          - update
          - set
          - add
    rc_succeeded:
        description: The rc codes list with which the conditions to succeed will be overriden.
        type: list
        required: false
        elements: int
    rc_failed:
        description: The rc codes list with which the conditions to fail will be overriden.
        type: list
        required: false
        elements: int
    workspace_locking_adom:
        description: The adom to lock for FortiManager running in workspace mode, the value can be global and others including root.
        required: false
        type: str
    workspace_locking_timeout:
        description: The maximum time in seconds to wait for other user to release the workspace lock.
        required: false
        type: int
        default: 300
    adom:
        description: the parameter (adom) in requested url
        type: str
        required: true
    extender-profile:
        description: the parameter (extender-profile) in requested url
        type: str
        required: true
    extensioncontroller_extenderprofile_cellular:
        description: the top level parameters set
        required: false
        type: dict
        suboptions:
            controller-report:
                type: dict
                description: no description
                suboptions:
                    interval:
                        type: int
                        description: Controller report interval.
                    signal-threshold:
                        type: int
                        description: Controller report signal threshold.
                    status:
                        type: str
                        description: FortiExtender controller report status.
                        choices:
                            - 'disable'
                            - 'enable'
            dataplan:
                type: raw
                description: (list) no description
            modem1:
                type: dict
                description: no description
                suboptions:
                    auto-switch:
                        type: dict
                        description: no description
                        suboptions:
                            dataplan:
                                type: str
                                description: Automatically switch based on data usage.
                                choices:
                                    - 'disable'
                                    - 'enable'
                            disconnect:
                                type: str
                                description: Auto switch by disconnect.
                                choices:
                                    - 'disable'
                                    - 'enable'
                            disconnect-period:
                                type: int
                                description: Automatically switch based on disconnect period.
                            disconnect-threshold:
                                type: int
                                description: Automatically switch based on disconnect threshold.
                            signal:
                                type: str
                                description: Automatically switch based on signal strength.
                                choices:
                                    - 'disable'
                                    - 'enable'
                            switch-back:
                                type: list
                                elements: str
                                description: no description
                                choices:
                                    - 'time'
                                    - 'timer'
                            switch-back-time:
                                type: str
                                description: Automatically switch over to preferred SIM/carrier at a specified time in UTC
                            switch-back-timer:
                                type: int
                                description: Automatically switch over to preferred SIM/carrier after the given time
                    conn-status:
                        type: int
                        description: no description
                    default-sim:
                        type: str
                        description: Default SIM selection.
                        choices:
                            - 'sim1'
                            - 'sim2'
                            - 'carrier'
                            - 'cost'
                    gps:
                        type: str
                        description: FortiExtender GPS enable/disable.
                        choices:
                            - 'disable'
                            - 'enable'
                    modem-id:
                        type: int
                        description: Modem ID.
                    preferred-carrier:
                        type: str
                        description: Preferred carrier.
                    redundant-intf:
                        type: str
                        description: Redundant interface.
                    redundant-mode:
                        type: str
                        description: FortiExtender mode.
                        choices:
                            - 'disable'
                            - 'enable'
                    sim1-pin:
                        type: str
                        description: SIM #1 PIN status.
                        choices:
                            - 'disable'
                            - 'enable'
                    sim1-pin-code:
                        type: raw
                        description: (list) no description
                    sim2-pin:
                        type: str
                        description: SIM #2 PIN status.
                        choices:
                            - 'disable'
                            - 'enable'
                    sim2-pin-code:
                        type: raw
                        description: (list) no description
            modem2:
                type: dict
                description: no description
                suboptions:
                    auto-switch:
                        type: dict
                        description: no description
                        suboptions:
                            dataplan:
                                type: str
                                description: Automatically switch based on data usage.
                                choices:
                                    - 'disable'
                                    - 'enable'
                            disconnect:
                                type: str
                                description: Auto switch by disconnect.
                                choices:
                                    - 'disable'
                                    - 'enable'
                            disconnect-period:
                                type: int
                                description: Automatically switch based on disconnect period.
                            disconnect-threshold:
                                type: int
                                description: Automatically switch based on disconnect threshold.
                            signal:
                                type: str
                                description: Automatically switch based on signal strength.
                                choices:
                                    - 'disable'
                                    - 'enable'
                            switch-back:
                                type: list
                                elements: str
                                description: no description
                                choices:
                                    - 'time'
                                    - 'timer'
                            switch-back-time:
                                type: str
                                description: Automatically switch over to preferred SIM/carrier at a specified time in UTC
                            switch-back-timer:
                                type: int
                                description: Automatically switch over to preferred SIM/carrier after the given time
                    conn-status:
                        type: int
                        description: no description
                    default-sim:
                        type: str
                        description: Default SIM selection.
                        choices:
                            - 'sim1'
                            - 'sim2'
                            - 'carrier'
                            - 'cost'
                    gps:
                        type: str
                        description: FortiExtender GPS enable/disable.
                        choices:
                            - 'disable'
                            - 'enable'
                    modem-id:
                        type: int
                        description: Modem ID.
                    preferred-carrier:
                        type: str
                        description: Preferred carrier.
                    redundant-intf:
                        type: str
                        description: Redundant interface.
                    redundant-mode:
                        type: str
                        description: FortiExtender mode.
                        choices:
                            - 'disable'
                            - 'enable'
                    sim1-pin:
                        type: str
                        description: SIM #1 PIN status.
                        choices:
                            - 'disable'
                            - 'enable'
                    sim1-pin-code:
                        type: raw
                        description: (list) no description
                    sim2-pin:
                        type: str
                        description: SIM #2 PIN status.
                        choices:
                            - 'disable'
                            - 'enable'
                    sim2-pin-code:
                        type: raw
                        description: (list) no description
            sms-notification:
                type: dict
                description: no description
                suboptions:
                    alert:
                        type: dict
                        description: no description
                        suboptions:
                            data-exhausted:
                                type: str
                                description: Display string when data exhausted.
                            fgt-backup-mode-switch:
                                type: str
                                description: Display string when FortiGate backup mode switched.
                            low-signal-strength:
                                type: str
                                description: Display string when signal strength is low.
                            mode-switch:
                                type: str
                                description: Display string when mode is switched.
                            os-image-fallback:
                                type: str
                                description: Display string when falling back to a previous OS image.
                            session-disconnect:
                                type: str
                                description: Display string when session disconnected.
                            system-reboot:
                                type: str
                                description: Display string when system rebooted.
                    receiver:
                        type: list
                        elements: dict
                        description: no description
                        suboptions:
                            alert:
                                type: list
                                elements: str
                                description: no description
                                choices:
                                    - 'system-reboot'
                                    - 'data-exhausted'
                                    - 'session-disconnect'
                                    - 'low-signal-strength'
                                    - 'mode-switch'
                                    - 'os-image-fallback'
                                    - 'fgt-backup-mode-switch'
                            name:
                                type: str
                                description: FortiExtender SMS notification receiver name.
                            phone-number:
                                type: str
                                description: Receiver phone number.
                            status:
                                type: str
                                description: SMS notification receiver status.
                                choices:
                                    - 'disable'
                                    - 'enable'
                    status:
                        type: str
                        description: FortiExtender SMS notification status.
                        choices:
                            - 'disable'
                            - 'enable'

'''

EXAMPLES = '''
- hosts: fortimanager-inventory
  collections:
    - fortinet.fortimanager
  connection: httpapi
  vars:
    ansible_httpapi_use_ssl: True
    ansible_httpapi_validate_certs: False
    ansible_httpapi_port: 443
  tasks:
    - name: FortiExtender cellular configuration.
      fmgr_extensioncontroller_extenderprofile_cellular:
        bypass_validation: False
        workspace_locking_adom: <value in [global, custom adom including root]>
        workspace_locking_timeout: 300
        rc_succeeded: [0, -2, -3, ...]
        rc_failed: [-2, -3, ...]
        adom: <your own value>
        extender-profile: <your own value>
        extensioncontroller_extenderprofile_cellular:
          controller-report:
            interval: <integer>
            signal-threshold: <integer>
            status: <value in [disable, enable]>
          dataplan: <list or string>
          modem1:
            auto-switch:
              dataplan: <value in [disable, enable]>
              disconnect: <value in [disable, enable]>
              disconnect-period: <integer>
              disconnect-threshold: <integer>
              signal: <value in [disable, enable]>
              switch-back:
                - time
                - timer
              switch-back-time: <string>
              switch-back-timer: <integer>
            conn-status: <integer>
            default-sim: <value in [sim1, sim2, carrier, ...]>
            gps: <value in [disable, enable]>
            modem-id: <integer>
            preferred-carrier: <string>
            redundant-intf: <string>
            redundant-mode: <value in [disable, enable]>
            sim1-pin: <value in [disable, enable]>
            sim1-pin-code: <list or string>
            sim2-pin: <value in [disable, enable]>
            sim2-pin-code: <list or string>
          modem2:
            auto-switch:
              dataplan: <value in [disable, enable]>
              disconnect: <value in [disable, enable]>
              disconnect-period: <integer>
              disconnect-threshold: <integer>
              signal: <value in [disable, enable]>
              switch-back:
                - time
                - timer
              switch-back-time: <string>
              switch-back-timer: <integer>
            conn-status: <integer>
            default-sim: <value in [sim1, sim2, carrier, ...]>
            gps: <value in [disable, enable]>
            modem-id: <integer>
            preferred-carrier: <string>
            redundant-intf: <string>
            redundant-mode: <value in [disable, enable]>
            sim1-pin: <value in [disable, enable]>
            sim1-pin-code: <list or string>
            sim2-pin: <value in [disable, enable]>
            sim2-pin-code: <list or string>
          sms-notification:
            alert:
              data-exhausted: <string>
              fgt-backup-mode-switch: <string>
              low-signal-strength: <string>
              mode-switch: <string>
              os-image-fallback: <string>
              session-disconnect: <string>
              system-reboot: <string>
            receiver:
              -
                alert:
                  - system-reboot
                  - data-exhausted
                  - session-disconnect
                  - low-signal-strength
                  - mode-switch
                  - os-image-fallback
                  - fgt-backup-mode-switch
                name: <string>
                phone-number: <string>
                status: <value in [disable, enable]>
            status: <value in [disable, enable]>

'''

RETURN = '''
meta:
    description: The result of the request.
    type: dict
    returned: always
    contains:
        request_url:
            description: The full url requested.
            returned: always
            type: str
            sample: /sys/login/user
        response_code:
            description: The status of api request.
            returned: always
            type: int
            sample: 0
        response_data:
            description: The api response.
            type: list
            returned: always
        response_message:
            description: The descriptive message of the api response.
            type: str
            returned: always
            sample: OK.
        system_information:
            description: The information of the target system.
            type: dict
            returned: always
rc:
    description: The status the request.
    type: int
    returned: always
    sample: 0
version_check_warning:
    description: Warning if the parameters used in the playbook are not supported by the current FortiManager version.
    type: list
    returned: complex
'''
from ansible.module_utils.basic import AnsibleModule
from ansible.module_utils.connection import Connection
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import NAPIManager
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_galaxy_version
from ansible_collections.fortinet.fortimanager.plugins.module_utils.napi import check_parameter_bypass


def main():
    jrpc_urls = [
        '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular',
        '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular'
    ]

    perobject_jrpc_urls = [
        '/pm/config/adom/{adom}/obj/extension-controller/extender-profile/{extender-profile}/cellular/{cellular}',
        '/pm/config/global/obj/extension-controller/extender-profile/{extender-profile}/cellular/{cellular}'
    ]

    url_params = ['adom', 'extender-profile']
    module_primary_key = None
    module_arg_spec = {
        'access_token': {
            'type': 'str',
            'required': False,
            'no_log': True
        },
        'bypass_validation': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'enable_log': {
            'type': 'bool',
            'required': False,
            'default': False
        },
        'forticloud_access_token': {
            'type': 'str',
            'required': False,
            'no_log': True
        },
        'proposed_method': {
            'type': 'str',
            'required': False,
            'choices': [
                'set',
                'update',
                'add'
            ]
        },
        'rc_succeeded': {
            'required': False,
            'type': 'list',
            'elements': 'int'
        },
        'rc_failed': {
            'required': False,
            'type': 'list',
            'elements': 'int'
        },
        'workspace_locking_adom': {
            'type': 'str',
            'required': False
        },
        'workspace_locking_timeout': {
            'type': 'int',
            'required': False,
            'default': 300
        },
        'adom': {
            'required': True,
            'type': 'str'
        },
        'extender-profile': {
            'required': True,
            'type': 'str'
        },
        'extensioncontroller_extenderprofile_cellular': {
            'required': False,
            'type': 'dict',
            'revision': {
                '7.2.1': True,
                '7.2.2': True,
                '7.2.3': True,
                '7.2.4': True,
                '7.4.0': True,
                '7.4.1': True
            },
            'options': {
                'controller-report': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'interval': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'int'
                        },
                        'signal-threshold': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'int'
                        },
                        'status': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        }
                    }
                },
                'dataplan': {
                    'required': False,
                    'revision': {
                        '7.2.1': True,
                        '7.2.2': True,
                        '7.2.3': True,
                        '7.2.4': True,
                        '7.4.0': True,
                        '7.4.1': True
                    },
                    'type': 'raw'
                },
                'modem1': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'auto-switch': {
                            'required': False,
                            'type': 'dict',
                            'options': {
                                'dataplan': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                },
                                'disconnect': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                },
                                'disconnect-period': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'int'
                                },
                                'disconnect-threshold': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'int'
                                },
                                'signal': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                },
                                'switch-back': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'list',
                                    'choices': [
                                        'time',
                                        'timer'
                                    ],
                                    'elements': 'str'
                                },
                                'switch-back-time': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'switch-back-timer': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'int'
                                }
                            }
                        },
                        'conn-status': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'int'
                        },
                        'default-sim': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'sim1',
                                'sim2',
                                'carrier',
                                'cost'
                            ],
                            'type': 'str'
                        },
                        'gps': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'modem-id': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'int'
                        },
                        'preferred-carrier': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'str'
                        },
                        'redundant-intf': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'str'
                        },
                        'redundant-mode': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'sim1-pin': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'sim1-pin-code': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'raw'
                        },
                        'sim2-pin': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'sim2-pin-code': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'raw'
                        }
                    }
                },
                'modem2': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'auto-switch': {
                            'required': False,
                            'type': 'dict',
                            'options': {
                                'dataplan': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                },
                                'disconnect': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                },
                                'disconnect-period': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'int'
                                },
                                'disconnect-threshold': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'int'
                                },
                                'signal': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                },
                                'switch-back': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'list',
                                    'choices': [
                                        'time',
                                        'timer'
                                    ],
                                    'elements': 'str'
                                },
                                'switch-back-time': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'switch-back-timer': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'int'
                                }
                            }
                        },
                        'conn-status': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'int'
                        },
                        'default-sim': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'sim1',
                                'sim2',
                                'carrier',
                                'cost'
                            ],
                            'type': 'str'
                        },
                        'gps': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'modem-id': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'int'
                        },
                        'preferred-carrier': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'str'
                        },
                        'redundant-intf': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'str'
                        },
                        'redundant-mode': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'sim1-pin': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'sim1-pin-code': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'raw'
                        },
                        'sim2-pin': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        },
                        'sim2-pin-code': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'raw'
                        }
                    }
                },
                'sms-notification': {
                    'required': False,
                    'type': 'dict',
                    'options': {
                        'alert': {
                            'required': False,
                            'type': 'dict',
                            'options': {
                                'data-exhausted': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'fgt-backup-mode-switch': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'low-signal-strength': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'mode-switch': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'os-image-fallback': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'session-disconnect': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'system-reboot': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                }
                            }
                        },
                        'receiver': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'type': 'list',
                            'options': {
                                'alert': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'list',
                                    'choices': [
                                        'system-reboot',
                                        'data-exhausted',
                                        'session-disconnect',
                                        'low-signal-strength',
                                        'mode-switch',
                                        'os-image-fallback',
                                        'fgt-backup-mode-switch'
                                    ],
                                    'elements': 'str'
                                },
                                'name': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'phone-number': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'type': 'str'
                                },
                                'status': {
                                    'required': False,
                                    'revision': {
                                        '7.2.1': True,
                                        '7.2.2': True,
                                        '7.2.3': True,
                                        '7.2.4': True,
                                        '7.4.0': True,
                                        '7.4.1': True
                                    },
                                    'choices': [
                                        'disable',
                                        'enable'
                                    ],
                                    'type': 'str'
                                }
                            },
                            'elements': 'dict'
                        },
                        'status': {
                            'required': False,
                            'revision': {
                                '7.2.1': True,
                                '7.2.2': True,
                                '7.2.3': True,
                                '7.2.4': True,
                                '7.4.0': True,
                                '7.4.1': True
                            },
                            'choices': [
                                'disable',
                                'enable'
                            ],
                            'type': 'str'
                        }
                    }
                }
            }

        }
    }

    params_validation_blob = []
    check_galaxy_version(module_arg_spec)
    module = AnsibleModule(argument_spec=check_parameter_bypass(module_arg_spec, 'extensioncontroller_extenderprofile_cellular'),
                           supports_check_mode=False)

    fmgr = None
    if module._socket_path:
        connection = Connection(module._socket_path)
        connection.set_option('access_token', module.params['access_token'] if 'access_token' in module.params else None)
        connection.set_option('enable_log', module.params['enable_log'] if 'enable_log' in module.params else False)
        connection.set_option('forticloud_access_token',
                              module.params['forticloud_access_token'] if 'forticloud_access_token' in module.params else None)
        fmgr = NAPIManager(jrpc_urls, perobject_jrpc_urls, module_primary_key, url_params, module, connection, top_level_schema_name='data')
        fmgr.validate_parameters(params_validation_blob)
        fmgr.process_partial_curd(argument_specs=module_arg_spec)
    else:
        module.fail_json(msg='MUST RUN IN HTTPAPI MODE')
    module.exit_json(meta=module.params)


if __name__ == '__main__':
    main()
