# B.1 Why are anarchists against authority and hierarchy?

First, it is necessary to indicate what kind of authority anarchism
challenges. While it is customary for some opponents of anarchism to assert
that anarchists oppose all kinds of authority, the reality of the situation is
more complex. While anarchists have, on occasion, stated their opposition to
"all authority" a closer reading quickly shows that anarchists reject only one
specific form of authority, what we tend to call hierarchy (see [section
H.4](secH4.md) for more details). This can be seen when Bakunin stated that
_"the principle of **authority**"_ was the _"eminently theological,
metaphysical and political idea that the masses, **always** incapable of
governing themselves, must submit at all times to the benevolent yoke of a
wisdom and a justice, which in one way or another, is imposed from above."_
[**Marxism, Freedom and the State**, p. 33]

Other forms of authority are more acceptable to anarchists, it depends whether
the authority in question becomes a source of **power** over others or not.
That is the key to understanding the anarchist position on authority -- if it
is **_hierarchical_** authority, then anarchists are against it. . The reason
is simple:

> _"[n]o one should be entrusted with power, inasmuch as anyone invested with
authority must . . . became an oppressor and exploiter of society."_ [Bakunin,
**The Political Philosophy of Bakunin**, p. 249]

This distinction between forms of authority is important. As Erich Fromm
pointed out, _"authority"_ is _"a broad term with two entirely different
meanings: it can be either 'rational' or 'irrational' authority. Rational
authority is based on competence, and it helps the person who leans on it to
grow. Irrational authority is based on power and serves to exploit the person
subjected to it."_ [**To Have or To Be**, pp. 44-45] The same point was made
by Bakunin over 100 years earlier when he indicated the difference between
authority and _"natural influence."_ For Bakunin, individual freedom _"results
from th[e] great number of material, intellectual, and moral influences which
every individual around him [or her] and which society . . . continually
exercise . . . To abolish this mutual influence would be to die."_
Consequently, _"when we reclaim the freedom of the masses, we hardly wish to
abolish the effect of any individual's or any group of individual's natural
influence upon the masses. What we wish is to abolish artificial, privileged,
legal, and official influences."_ [**The Basic Bakunin**, p. 140 and p. 141]

It is, in other words, the difference between taking part in a decision and
listening to alternative viewpoints and experts (_"natural influence"_) before
making your mind up and having a decision **made for you** by a separate group
of individuals (who may or may not be elected) because that is their role in
an organisation or society. In the former, the individual exercises their
judgement and freedom (i.e. is based on rational authority). In the latter,
they are subjected to the wills of others, to hierarchical authority (i.e. is
based on irrational authority). This is because rational authority _"not only
permits but requires constant scrutiny and criticism . . . it is always
temporary, its acceptance depending on its performance."_ The source of
irrational authority, on the other hand, _"is always power over people . . .
Power on the one side, fear on the other, are always the buttresses on which
irrational authority is built."_ Thus former is based upon _"equality"_ while
the latter _"is by its very nature based upon inequality."_ [Erich Fromm,
**Man for Himself**, pp. 9-10]

This crucial point is expressed in the difference between **having** authority
and **being** an authority. Being an authority just means that a given person
is generally recognised as competent for a given task, based on his or her
individual skills and knowledge. Put differently, it is socially acknowledged
expertise. In contrast, having authority is a social relationship based on
status and power derived from a hierarchical position, not on individual
ability. Obviously this does not mean that competence is not an element for
obtaining a hierarchical position; it just means that the real or alleged
initial competence is transferred to the title or position of the authority
and so becomes independent of individuals, i.e. institutionalised (or what
Bakunin termed _"official"_).

This difference is important because the way people behave is more a product
of the institutions in which we are raised than of any inherent nature. In
other words, social relationships **shape** the individuals involved. This
means that the various groups individuals create have traits, behaviours and
outcomes that cannot be understood by reducing them to the individuals within
them. That is, groups consist not only of individuals, but also relationships
between individuals and these relationships will affect those subject to them.
For example, obviously _"the exercise of power by some disempowers others"_
and so through a _"combination of physical intimidation, economic domination
and dependency, and psychological limitations, social institutions and
practices affect the way everyone sees the world and her or his place in it."_
This, as we discuss in the [next section](secB1.md#secb11), impacts on those
involved in such authoritarian social relationships as _"the exercise of power
in any institutionalised form -- whether economic, political or sexual --
brutalises both the wielder of power and the one over whom it is exercised."_
[Martha A. Ackelsberg, **Free Women of Spain**, p. 41]

Authoritarian social relationships means dividing society into (the few) order
givers and (the many) order takers, impoverishing the individuals involved
(mentally, emotionally and physically) and society as a whole. Human
relationships, in all parts of life, are stamped by authority, not liberty.
And as freedom can only be created by freedom, authoritarian social
relationships (and the obedience they require) do not and cannot educate a
person in freedom -- only participation (self-management) in all areas of life
can do that. _"In a society based on exploitation and servitude,"_ in
Kropotkin's words, _"human nature itself is degraded"_ and it is only _"as
servitude disappears"_ shall we _"regain our rights."_ [**Anarchism**, p. 104]

Of course, it will be pointed out that in any collective undertaking there is
a need for co-operation and co-ordination and this need to "subordinate" the
individual to group activities is a form of authority. Therefore, it is
claimed, a democratically managed group is just as "authoritarian" as one
based on hierarchical authority. Anarchists are not impressed by such
arguments. Yes, we reply, of course in any group undertaking there is a need
make and stick by agreements but anarchists argue that to use the word
"authority" to describe two fundamentally different ways of making decisions
is playing with words. It obscures the fundamental difference between free
association and hierarchical imposition and confuses co-operation with command
(as we note in [section H.4](secH4.md), Marxists are particularly fond of
this fallacy). Simply put, there are two different ways of co-ordinating
individual activity within groups -- either by authoritarian means or by
libertarian means. Proudhon, in relation to workplaces, makes the difference
clear:

> _"either the workman. . . will be simply the employee of the proprietor-
capitalist-promoter; or he will participate. . . [and] have a voice in the
council, in a word he will become an associate.  
>  _

>

> _"In the first case the workman is subordinated, exploited: his permanent
condition is one of obedience. . . In the second case he resumes his dignity
as a man and citizen. . . he forms part of the producing organisation, of
which he was before but the slave; as, in the town, he forms part of the
sovereign power, of which he was before but the subject . . . we need not
hesitate, for we have no choice. . . it is necessary to form an ASSOCIATION
among workers . . . because without that, they would remain related as
subordinates and superiors, and there would ensue two . . . castes of masters
and wage-workers, which is repugnant to a free and democratic society."_
[**General Idea of the Revolution**, pp. 215-216]

In other words, associations can be based upon a form of **rational**
authority, based upon **natural influence** and so reflect freedom, the
ability of individuals to think, act and feel and manage their own time and
activity. Otherwise, we include elements of slavery into our relationships
with others, elements that poison the whole and shape us in negative ways (see
[section B.1.1](secB1.md#secb11)). Only the reorganisation of society in a
libertarian way (and, we may add, the mental transformation such a change
requires and would create) will allow the individual to _"achieve more or less
complete blossoming, whilst continuing to develop"_ and banish _"that spirit
of submission that has been artificially thrust upon him [or her]"_ [Nestor
Makhno, **The Struggle Against the State and Other Essays**, p. 62]

So, anarchists _"ask nothing better than to see [others]. . . exercise over us
a natural and legitimate influence, freely accepted, and never imposed . . .
We accept all natural authorities and all influences of fact, but none of
right."_ [Bakunin, **The Political Philosophy of Bakunin**, p. 255] Anarchist
support for free association within directly democratic groups is based upon
such organisational forms increasing influence and reducing irrational
authority in our lives. Members of such organisations can create and present
their own ideas and suggestions, critically evaluate the proposals and
suggestions from their fellows, accept those that they agree with or become
convinced by and have the option of leaving the association if they are
unhappy with its direction. Hence the influence of individuals and their free
interaction determine the nature of the decisions reached, and no one has the
right to impose their ideas on another. As Bakunin argued, in such
organisations _"no function remains fixed and it will not remain permanently
and irrevocably attached to one person. Hierarchical order and promotion do
not exist. . . In such a system, power, properly speaking, no longer exists.
Power is diffused to the collectivity and becomes the true expression of the
liberty of everyone."_ [**Bakunin on Anarchism**, p. 415]

Therefore, anarchists are opposed to **irrational** (e.g., illegitimate)
authority, in other words, hierarchy -- hierarchy being the
institutionalisation of authority within a society. Hierarchical social
institutions include the state (see [section B.2](secB2.md)), private
property and the class systems it produces (see [section B.3](secB3.md))
and, therefore, capitalism (see [section B.4](secB4.md)). Due to their
hierarchical nature, anarchists oppose these with passion. _"Every
institution, social or civil,"_ argued Voltairine de Cleyre, _"that stands
between man [or woman] and his [or her] right; every tie that renders one a
master, another a serf; every law, every statue, every be-it-enacted that
represents tyranny"_ anarchists seek to destroy. However, hierarchy exists
beyond these institutions. For example, hierarchical social relationships
include sexism, racism and homophobia (see [section
B.1.4](secB1.md#secb14)), and anarchists oppose, and fight, them all. Thus,
as well as fighting capitalism as being hierarchical (for workers _"slave in a
factory,"_ albeit _"the slavery ends with the working hours"_) de Cleyre also
opposed patriarchal social relationships which produce a _"home that rests on
slavery"_ because of a _"marriage that represents the sale and transfer of the
individuality of one of its parties to the other!"_ [**The Voltairine de
Cleyre Reader**, p. 72, p. 17 and p. 72]

Needless to say, while we discuss different forms of hierarchy in different
sections this does not imply that anarchists think they, and their negative
effects, are somehow independent or can be easily compartmentalised. For
example, the modern state and capitalism are intimately interrelated and
cannot be considered as independent of each other. Similarly, social
hierarchies like sexism and racism are used by other hierarchies to maintain
themselves (for example, bosses will use racism to divide and so rule their
workers). From this it follows that abolishing one or some of these
hierarchies, while desirable, would not be sufficient. Abolishing capitalism
while maintaining the state would not lead to a free society (and vice versa)
-- if it were possible. As Murray Bookchin notes:

> _"there can be a decidedly classless, even a non-exploitative society in the
**economic** sense that still preserves hierarchical rule and domination in
the **social** sense -- whether they take the form of the patriarchal family,
domination by age and ethnic groups, bureaucratic institutions, ideological
manipulation or a pyramidal division of labour . . . classless or not, society
would be riddles by domination and, with domination, a general condition of
command and obedience, of unfreedom and humiliation, and perhaps most
decisively, an abortion of each individual's potentiality for consciousness,
reason, selfhood, creativity, and the right to assert full control over her or
his daily live."_ [**Toward an Ecological Society**, pp. 14-5]

This clearly implies that anarchists _"challenge not only class formations but
hierarchies, not only material exploitation but domination in every form."_
[Bookchin, **Op. Cit.**, p. 15] Hence the anarchist stress on opposing
hierarchy rather than just, say, the state (as some falsely assert) or simply
economic class and exploitation (as, say, many Marxists do). As noted earlier
(in [section A.2.8](secA2.md#seca28)), anarchists consider all hierarchies
to be not only harmful but unnecessary, and think that there are alternative,
more egalitarian ways to organise social life. In fact, we argue that
hierarchical authority creates the conditions it is presumably designed to
combat, and thus tends to be self-perpetuating. Thus hierarchical
organisations erode the ability of those at the bottom to manage their own
affairs directly so requiring hierarchy and some people in positions to give
orders and the rest to follow them. Rather than prevent disorder, governments
are among its primary causes while its bureaucracies ostensibly set up to
fight poverty wind up perpetuating it, because without poverty, the high-
salaried top administrators would be out of work. The same applies to agencies
intended to eliminate drug abuse, fight crime, etc. In other words, the power
and privileges deriving from top hierarchical positions constitute a strong
incentive for those who hold them **not** to solve the problems they are
supposed to solve. (For further discussion see Marilyn French, **Beyond Power:
On Women, Men, and Morals**, Summit Books, 1985).

## B.1.1 What are the effects of authoritarian social relationships?

Hierarchical authority is inextricably connected with the marginalisation and
disempowerment of those without authority. This has negative effects on those
over whom authority is exercised, since _"[t]hose who have these symbols of
authority and those who benefit from them must dull their subject people's
realistic, i.e. critical, thinking and make them believe the fiction [that
irrational authority is rational and necessary], . . . [so] the mind is lulled
into submission by cliches . . . [and] people are made dumb because they
become dependent and lose their capacity to trust their eyes and judgement."_
[Erich Fromm, **To Have or To Be?**, p. 47]

Or, in the words of Bakunin, _"the principle of authority, applied to men who
have surpassed or attained their majority, becomes a monstrosity, a source of
slavery and intellectual and moral depravity."_ [**God and the State**, p. 41]

This is echoed by the syndicalist miners who wrote the classic **The Miners'
Next Step** when they indicate the nature of authoritarian organisations and
their effect on those involved. Leadership (i.e. hierarchical authority)
_"implies power held by the leader. Without power the leader is inept. The
possession of power inevitably leads to corruption. . . in spite of. . . good
intentions . . . [Leadership means] power of initiative, this sense of
responsibility, the self-respect which comes from expressed manhood [sic!], is
taken from the men, and consolidated in the leader. The sum of their
initiative, their responsibility, their self-respect becomes his . . . [and
the] order and system he maintains is based upon the suppression of the men,
from being independent thinkers into being 'the men' . . . In a word, he is
compelled to become an autocrat and a foe to democracy."_ Indeed, for the
_"leader,"_ such marginalisation can be beneficial, for a leader _"sees no
need for any high level of intelligence in the rank and file, except to
applaud his actions. Indeed such intelligence from his point of view, by
breeding criticism and opposition, is an obstacle and causes confusion."_
[**The Miners' Next Step**, pp. 16-17 and p. 15]

Anarchists argue that hierarchical social relationships will have a negative
effect on those subject to them, who can no longer exercise their critical,
creative and mental abilities **freely**. As Colin Ward argues, people _"do go
from womb to tomb without realising their human potential, precisely because
the power to initiate, to participate in innovating, choosing, judging, and
deciding is reserved for the top men"_ (and it usually **is** men!) [**Anarchy
in Action**, p, 42]. Anarchism is based on the insight that there is an
interrelationship between the authority structures of institutions and the
psychological qualities and attitudes of individuals. Following orders all day
hardly builds an independent, empowered, creative personality (_"authority and
servility walk ever hand in hand."_ [Peter Kropotkin, **Anarchism**, p. 81]).
As Emma Goldman made clear, if a person's _"inclination and judgement are
subordinated to the will of a master"_ (such as a boss, as most people have to
sell their labour under capitalism) then little wonder such an authoritarian
relationship _"condemns millions of people to be mere nonentities."_ [**Red
Emma Speaks**, p. 50]

As the human brain is a bodily organ, it needs to be used regularly in order
to be at its fittest. Authority concentrates decision-making in the hands of
those at the top, meaning that most people are turned into executants,
following the orders of others. If muscle is not used, it turns to fat; if the
brain is not used, creativity, critical thought and mental abilities become
blunted and side-tracked onto marginal issues, like sports and fashion. This
can only have a negative impact:

> _"Hierarchical institutions foster alienated and exploitative relationships
among those who participate in them, disempowering people and distancing them
from their own reality. Hierarchies make some people dependent on others,
blame the dependent for their dependency, and then use that dependency as a
justification for further exercise of authority. . . . Those in positions of
relative dominance tend to define the very characteristics of those
subordinate to them . . . Anarchists argue that to be always in a position of
being acted upon and never to be allowed to act is to be doomed to a state of
dependence and resignation. Those who are constantly ordered about and
prevented from thinking for themselves soon come to doubt their own capacities
. . . [and have] difficulty acting on [their] sense of self in opposition to
societal norms, standards and expectations."_ [Martha Ackelsberg, **Free Women
of Spain**, pp. 40-1]

And so, in the words of Colin Ward, the _"system makes its morons, then
despises them for their ineptitude, and rewards its 'gifted few' for their
rarity."_ [**Op. Cit.**, p. 43]

This negative impact of hierarchy is, of course, not limited to those subject
to it. Those in power are affected by it, but in different ways. As we noted
in [section A.2.15](secA2.md#seca215), power corrupts those who have it as
well as those subjected to it. The Spanish Libertarian Youth put it this way
in the 1930s:

> _"Against the principle of authority because this implies erosion of the
human personality when some men submit to the will of others, arousing in
these instincts which predispose them to cruelty and indifference in the face
of the suffering of their fellows."_ [quoted by Jose Peirats, **The CNT in the
Spanish Revolution**, vol. 2, p. 76]

Hierarchy impoverishes the human spirit. _"A hierarchical mentality,"_ notes
Bookchin, _"fosters the renunciation of the pleasures of life. It justifies
toil, guilt, and sacrifice by the 'inferiors,' and pleasure and the indulgent
gratification of virtually every caprice by their 'superiors.' The objective
history of the social structure becomes internalised as a subjective history
of the psychic structure."_ In other words, being subject to hierarchy fosters
the internalisation of oppression -- and the denial of individuality necessary
to accept it. _"Hierarchy, class, and ultimately the State,"_ he stresses,
_"penetrate the very integument of the human psyche and establish within it
unreflective internal powers of coercion and constraint . . . By using guilt
and self-blame, the inner State can control behaviour long before fear of the
coercive powers of the State have to be invoked."_ [**The Ecology of
Freedom**, p. 72 and p. 189]

In a nutshell, _"[h]ierarchies, classes, and states warp the creative powers
of humanity."_ However, that is not all. Hierarchy, anarchists argue, also
twists our relationships with the environment. Indeed, _"all our notions of
dominating nature stem from the very real domination of human by human . . .
And it is not until we eliminate domination in all its forms . . . that we
will really create a rational, ecological society."_ For _"the conflicts
within a divided humanity, structured around domination, inevitably leads to
conflicts with nature. The ecological crisis with its embattled division
between humanity and nature stems, above all, from divisions between human and
human."_ While the _"rise of capitalism, with a law of life based on
competition, capital accumulation, and limitless growth, brought these
problems -- ecological and social -- to an acute point,"_ anarchists
_"emphasise that major ecological problems have their roots in social problems
-- problems that go back to the very beginnings of patricentric culture
itself."_ [Murray Bookchin, **Remaking Society**, p. 72, p. 44, p. 72 and pp.
154-5]

Thus, anarchists argue, hierarchy impacts not only on us but also our
surroundings. The environmental crisis we face is a result of the hierarchical
power structures at the heart of our society, structures which damage the
planet's ecology at least as much as they damage humans. The problems within
society, the economic, ethnic, cultural, and gender conflicts, among many
others, lie at the core of the most serious ecological dislocations we face.
The way human beings deal with each other as social beings is crucial to
addressing the ecological crisis. Ultimately, ecological destruction is rooted
in the organisation of our society for a degraded humanity can only yield a
degraded nature (as capitalism and our hierarchical history have sadly shown).

This is unsurprising as we, as a species, shape our environment and,
consequently, whatever shapes us will impact how we do so. This means that the
individuals produced by the hierarchy (and the authoritarian mentality it
produces) will shape the planet in specific, harmful, ways. This is to be
expected as humans act upon their environment deliberately, creating what is
most suitable for their mode of existence. If that mode of living is riddled
with hierarchies, classes, states and the oppression, exploitation and
domination they create then our relations with the natural world will hardly
be any better. In other words, social hierarchy and class legitimises our
domination of the environment, planting the seeds for the believe that nature
exists, like other people, to be dominated and used as required.

Which brings us to another key reason why anarchists reject hierarchy. In
addition to these negative psychological effects from the denial of liberty,
authoritarian social relationships also produce social inequality. This is
because an individual subject to the authority of another has to obey the
orders of those above them in the social hierarchy. In capitalism this means
that workers have to follow the orders of their boss (see [next
section](secB1.md#secb12)), orders that are designed to make the boss
richer. And richer they have become, with the Chief Executive Officers (CEOs)
of big firms earning 212 times what the average US worker did in 1995 (up from
a mere 44 times 30 years earlier). Indeed, from 1994 to 1995 alone, CEO
compensation in the USA rose 16 percent, compared to 2.8 percent for workers,
which did not even keep pace with inflation, and whose stagnating wages cannot
be blamed on corporate profits, which rose a healthy 14.8 percent for that
year.

Needless to say, inequality in terms of power will translate itself into
inequality in terms of wealth (and vice versa). The effects of such social
inequality are wide-reaching. For example, health is affected significantly by
inequality. Poor people are more likely to be sick and die at an earlier age,
compared to rich people. Simply put, _"the lower the class, the worse the
health. Going beyond such static measures, even interruptions in income of the
sort caused by unemployment have adverse health effects."_ Indeed, the
sustained economic hardship associated with a low place in the social
hierarchy leads to poorer physical, psychological and cognitive functioning
(_"with consequences that last a decade or more"_). _"Low incomes, unpleasant
occupations and sustained discrimination,"_ notes Doug Henwood, _"may result
in apparently physical symptoms that confuse even sophisticated biomedical
scientists . . . Higher incomes are also associated with lower frequency of
psychiatric disorders, as are higher levels of asset ownership."_ [**After the
New Economy**, pp. 81-2]

Moreover, the **_degree_** of inequality is important (i.e. the size of the
gap between rich and poor). According to an editorial in the **British Medical
Journal** _"what matters in determining mortality and health in a society is
less the overall wealth of that society and more how evenly wealth is
distributed. The more equally wealth is distributed the better the health of
that society."_ [vol. 312, April 20, 1996, p. 985]

Research in the USA found overwhelming evidence of this. George Kaplan and his
colleagues measured inequality in the 50 US states and compared it to the age-
adjusted death rate for all causes of death, and a pattern emerged: the more
unequal the distribution of income, the greater the death rate. In other
words, it is the gap between rich and poor, and not the average income in each
state, that best predicts the death rate in each state. [_"Inequality in
income and mortality in the United States: analysis of mortality and potential
pathways,"_ **British Medical Journal**, vol. 312, April 20, 1996, pp.
999-1003]

This measure of income inequality was also tested against other social
conditions besides health. States with greater inequality in the distribution
of income also had higher rates of unemployment, higher rates of
incarceration, a higher percentage of people receiving income assistance and
food stamps, a greater percentage of people without medical insurance, greater
proportion of babies born with low birth weight, higher murder rates, higher
rates of violent crime, higher costs per-person for medical care, and higher
costs per person for police protection. Moreover states with greater
inequality of income distribution also spent less per person on education, had
fewer books per person in the schools, and had poorer educational performance,
including worse reading skills, worse mathematics skills, and lower rates of
completion of high school.

As the gap grows between rich and poor (indicating an increase in social
hierarchy within and outwith of workplaces) the health of a people
deteriorates and the social fabric unravels. The psychological hardship of
being low down on the social ladder has detrimental effects on people, beyond
whatever effects are produced by the substandard housing, nutrition, air
quality, recreational opportunities, and medical care enjoyed by the poor (see
George Davey Smith, _"Income inequality and mortality: why are they related?"_
**British Medical Journal**, Vol. 312, April 20, 1996, pp. 987-988).

So wealth does not determine health. What does is the gap between the rich and
the poor. The larger the gap, the sicker the society. Countries with a greater
degree of socioeconomic inequality show greater inequality in health status;
also, that middle-income groups in relatively unequal societies have worse
health than comparable, or even poorer, groups in more equal societies.
Unsurprisingly, this is also reflected over time. The widening income
differentials in both the USA and the UK since 1980 have coincided with a
slowing down of improvements in life-expectancy, for example.

Inequality, in short, is bad for our health: the health of a population
depends not just on the size of the economic pie, but on how the pie is
shared.

This is not all. As well as inequalities in wealth, inequalities in freedom
also play a large role in overall human well-being. According to Michael
Marmot's **The Status Syndrome: How Social Standing Affects Our Health and
Longevity**, as you move up any kind of hierarchy your health status improves.
Autonomy and position in a hierarchy are related (i.e. the higher you are in a
hierarchy, the more autonomy you have). Thus the implication of this empirical
work is that autonomy is a source of good health, that the more control you
have over your work environment and your life in general, the less likely you
are to suffer the classic stress-related illnesses, such as heart disease. As
public-Health scholars Jeffrey Johnson and Ellen Hall have noted, the
_"potential to control one's own environment is differentially distributed
along class lines."_ [quoted by Robert Kuttner, **Everything for Sale**, p.
153]

As would be expected from the very nature of hierarchy, to _"be in a life
situation where one experiences relentless demands by others, over which one
has relatively little control, is to be at risk of poor health, physically as
well as mentally."_ Looking at heart disease, the people with greatest risk
_"tended to be in occupations with high demands, low control, and low social
support. People in demanding positions but with great autonomy were at lower
risk."_ Under capitalism, _"a relatively small elite demands and gets
empowerment, self-actualisation, autonomy, and other work satisfaction that
partially compensate for long hours"_ while _"epidemiological data confirm
that lower-paid, lower-status workers are more likely to experience the most
clinically damaging forms of stress, in part because they have less control
over their work."_ [Kuttner, **Op. Cit.**, p. 153 and p. 154]

In other words, the inequality of autonomy and social participation produced
by hierarchy is itself a cause of poor health. There would be positive
feedback on the total amount of health -- and thus of social welfare -- if
social inequality was reduced, not only in terms of wealth but also,
crucially, in power. This is strong evidence in support of anarchist visions
of egalitarianism. Some social structures give more people more autonomy than
others and acting to promote social justice along these lines is a key step
toward improving our health. This means that promoting libertarian, i.e. self-
managed, social organisations would increase not only liberty but also
people's health and well-being, both physical and mental. Which is, as we
argued above, to be expected as hierarchy, by its very nature, impacts
negatively on those subject to it.

This dovetails into anarchist support for workers' control. Industrial
psychologists have found that satisfaction in work depends on the "span of
autonomy" works have. Unsurprisingly, those workers who are continually making
decisions for themselves are happier and live longer. It is the power to
control all aspects of your life -- work particularly -- that wealth and
status tend to confer that is the key determinant of health. Men who have low
job control face a 50% higher risk of new illness: heart attacks, stroke,
diabetes or merely ordinary infections. Women are at slightly lower risk but
low job control was still a factor in whether they fell ill or not.

So it is the fact that the boss is a boss that makes the employment
relationship so troublesome for health issues (and genuine libertarians). The
more bossy the boss, the worse, as a rule is the job. So part of autonomy is
not being bossed around, but that is only part of the story. And, of course,
hierarchy (inequality of power) and exploitation (the source of material
inequality) are related. As we indicate in the [next
section](secB1.md#secb12), capitalism is based on wage labour. The worker
sell their liberty to the boss for a given period of time, i.e. they loose
their autonomy. This allows the possibility of exploitation, as the worker can
produce more wealth than they receive back in wages. As the boss pockets the
difference, lack of autonomy produces increases in social inequality which, in
turn, impacts negatively on your well-being.

Then there is the waste associated with hierarchy. While the proponents of
authority like to stress its "efficiency," the reality is different. As Colin
Ward points out, being in authority _"derives from your rank in some chain of
command . . . But knowledge and wisdom are not distributed in order of rank,
and they are no one person's monopoly in any undertaking. The fantastic
inefficiency of any hierarchical organisation -- any factory, office,
university, warehouse or hospital -- is the outcome of two almost invariable
characteristics. One is that the knowledge and wisdom of the people at the
bottom of the pyramid finds no place in the decision-making leadership
hierarchy of the institution. Frequently it is devoted to making the
institution work in spite of the formal leadership structure, or alternatively
to sabotaging the ostensible function of the institution, because it is none
of their choosing. The other is that they would rather not be there anyway:
they are there through economic necessity rather than through identification
with a common task which throws up its own shifting and functional
leadership."_ [**Op. Cit.**, p. 41]

Hierarchy, in other words, blocks the flow of information and knowledge.
Rulers, as Malatesta argued, _"can only make use of the forces that exist in
society -- except for those great forces"_ their action _"paralyses and
destroys, and those rebel forces, and all that is wasted through conflicts;
inevitable tremendous losses in such an artificial system."_ And so as well as
individuals being prevented from developing to their fullest, wasting their
unfulfilled potentialities, hierarchy also harms society as a whole by
reducing efficiency and creativity. This is because input into decisions are
limited _"only to those individuals who form the government [of a hierarchical
organisation] or who by reason of their position can influence the[ir]
policy."_ Obviously this means _"that far from resulting in an increase in the
productive, organising and protective forces in society,"_ hierarchy _"greatly
reduce[s] them, limiting initiative to a few, and giving them the right to do
everything without, of course, being able to provide them with the gift of
being all-knowing."_ [**Anarchy**, p. 38 and p. 39]

Large scale hierarchical organisations, like the state, are also marked by
bureaucracy. This becomes a necessity in order to gather the necessary
information it needs to make decisions (and, obviously, to control those under
it). However, soon this bureaucracy becomes the real source of power due to
its permanence and control of information and resources. Thus hierarchy cannot
_"survive without creating around itself a new privileged class"_ as well as
being a _"privileged class and cut off from the people"_ itself. [Malatesta,
**Op. Cit.**, p. 37 and p. 36] This means that those at the top of an
institution rarely know the facts on the ground, making decisions in relative
ignorance of their impact or the actual needs of the situation or people
involved. As economist Joseph Stiglitz concluded from his own experiences in
the World Bank, _"immense time and effort are required to effect change even
from the inside, in an international bureaucracy. Such organisations are
opaque rather than transparent, and not only does far too little information
radiate from inside to the outside world, perhaps even less information from
outside is able to penetrate the organisation. The opaqueness also means that
it is hard for information from the bottom of the organisation to percolate to
the top."_ [**Globalisation and its Discontents**, p. 33] The same can be said
of any hierarchical organisation, whether a nation state or capitalist
business.

Moreover, as Ward and Malatesta indicate, hierarchy provokes a struggle
between those at the bottom and at the top. This struggle is also a source of
waste as it diverts resources and energy from more fruitful activity into
fighting it. Ironically, as we discuss in [section H.4.4](secH4.md#sech44),
one weapon forged in that struggle is the **_"work to rule,"_** namely workers
bringing their workplace to a grinding halt by following the dictates of the
boss to the letter. This is clear evidence that a workplace only operates
because workers exercise their autonomy during working hours, an autonomy
which authoritarian structures stifle and waste. A participatory workplace,
therefore, would be more efficient and less wasteful than the hierarchical one
associated with capitalism. As we discuss in [section
J.5.12](secJ5.md#secj512), hierarchy and the struggle it creates always acts
as a barrier stopping the increased efficiency associated with workers'
participation undermining the autocratic workplace of capitalism.

All this is not to suggest that those at the bottom of hierarchies are victims
nor that those at the top of hierarchies only gain benefits -- far from it. As
Ward and Malatesta indicated, hierarchy by its very nature creates resistance
to it from those subjected to it and, in the process, the potential for ending
it (see [section B.1.6](secB1.md#secb16) for more discussion). Conversely,
at the summit of the pyramid, we also see the evils of hierarchy.

If we look at those at the top of the system, yes, indeed they often do
**very** well in terms of material goods and access to education, leisure,
health and so on but they lose their humanity and individuality. As Bakunin
pointed out, _"power and authority corrupt those who exercise them as much as
those who are compelled to submit to them."_ [**The Political Philosophy of
Bakunin**, p. 249] Power operates destructively, even on those who have it,
reducing their individuality as it _"renders them stupid and brutal, even when
they were originally endowed with the best of talents. One who is constantly
striving to force everything into a mechanical order at last becomes a machine
himself and loses all human feeling."_ [Rudolf Rocker, **Anarcho-
Syndicalism**, pp. 17-8]

When it boils down to it, hierarchy is self-defeating, for if _"wealth is
other people,"_ then by treating others as less than yourself, restricting
their growth, you lose all the potential insights and abilities these
individuals have, so impoverishing your own life and **restricting your own
growth.** Unfortunately in these days material wealth (a particularly narrow
form of "self-interest") has replaced concern for developing the whole person
and leading a fulfilling and creative life (a broad self-interest, which
places the individual **within** society, one that recognises that
relationships with others shape and develop all individuals). In a
hierarchical, class based society everyone loses to some degree, even those at
the "top."

Looking at the environment, the self-defeating nature of hierarchy also
becomes clear. The destiny of human life goes hand-in-hand with the destiny of
the non-human world. While being rich and powerful may mitigate the impact of
the ecological destruction produced by hierarchies and capitalism, it will not
stop them and will, eventually, impact on the elite as well as the many.

Little wonder, then, that _"anarchism . . . works to destroy authority in all
its aspects . . . [and] refuses all hierarchical organisation."_ [Kropotkin,
**Anarchism**, p. 137]

## B.1.2 Is capitalism hierarchical?

Yes. Under capitalism workers do not exchange the products of their labour
they exchange the labour itself for money. They sell themselves for a given
period of time, and in return for wages, promise to obey their paymasters.
Those who pay and give the orders -- owners and managers -- are at the top of
the hierarchy, those who obey at the bottom. This means that capitalism, by
its very nature, is hierarchical.

As Carole Pateman argues:

> _"Capacities or labour power cannot be used without the worker using his
will, his understanding and experience, to put them into effect. The use of
labour power requires the presence of its 'owner,' and it remains mere
potential until he acts in the manner necessary to put it into use, or agrees
or is compelled so to act; that is, the worker must labour. To contract for
the use of labour power is a waste of resources unless it can be used in the
way in which the new owner requires. The fiction 'labour power' cannot be
used; what is required is that the worker labours as demanded. The employment
contract must, therefore, create a relationship of command and obedience
between employer and worker . . . In short, the contract in which the worker
allegedly sells his labour power is a contract in which, since he cannot be
separated from his capacities, he sells command over the use of his body and
himself. To obtain the right to use another is to be a (civil) master."_
[**The Sexual Contract**, pp. 150-1]

You need only compare this to Proudhon's comments quoted in [section
B.1](secB1.md) to see that anarchists have long recognised that capitalism
is, by its very nature, hierarchical. The worker is subjected to the authority
of the boss during working hours (sometimes outside work too). As Noam Chomsky
summarises, _"a corporation, factory of business is the economic equivalent of
fascism: decisions and control are strictly top-down."_ [**Letters from
Lexington**, p. 127] The worker's choices are extremely limited, for most
people it amount to renting themselves out to a series of different masters
(for a lucky few, the option of being a master is available). And master is
the right word for, as David Ellerman reminds us, _"[s]ociety seems to have
'covered up' in the popular consciousness the fact that the traditional name
[for employer and employee] is '**master and servant.'**"_ [**Property and
Contract in Economics**, p. 103]

This hierarchical control of wage labour has the effect of alienating workers
from their own work, and so from themselves. Workers no longer govern
themselves during work hours and so are no longer free. And so, due to
capitalism, there is _"an oppression in the land,"_ a _"form of slavery"_
rooted in current _"property institutions"_ which produces _"a social war,
inevitable so long as present legal-social conditions endure."_ [Voltairine de
Cleyre, **Op. Cit.**, pp. 54-5]

Some defenders of capitalism are aware of the contradiction between the
rhetoric of the system and its reality for those subject to it. Most utilise
the argument that workers consent to this form of hierarchy. Ignoring the
economic conditions which force people to sell their liberty on the labour
market (see [section B.4.3](secB4.md#secb43)), the issue instantly arises of
whether consent is enough in itself to justify the alienation/selling of a
person's liberty. For example, there have been arguments for slavery and
monarchy (i.e. dictatorship) rooted in consent. Do we really want to say that
the only thing wrong with fascism or slavery is that people do not consent to
it? Sadly, some right-wing "libertarians" come to that conclusion (see
[section B.4](secB4.md)).

Some try to redefine the reality of the command-and-obey of wage labour. _"To
speak of managing, directing, or assigning workers to various tasks is a
deceptive way of noting that the employer continually is involved in re-
negotiation of contracts on terms that must be acceptable to both parties,"_
argue two right-wing economists. [Arman Alchian and Harold Demsetz, quoted by
Ellerman, **Op. Cit.**, p. 170] So the employer-employee (or, to use the old,
more correct, terminology, master-servant) contract is thus a series of
unspoken contracts.

However, if an oral contract is not worth the paper it is written on, how
valuable is an unspoken one? And what does this _"re-negotiation of
contracts"_ amount to? The employee decides whether to obey the command or
leave and the boss decides whether the employee is obedient and productive
enough to remain in under his or her control. Hardly a relationship based on
freedom between equal partners! As such, this capitalist defence of wage
labour _"is a deceptive way of noting"_ that the employee is paid to obey. The
contract between them is simply that of obedience on one side and power on the
other. That both sides may break the contract does not alter this fact. Thus
the capitalist workplace _"is not democratic in spite of the 'consent of the
governed' to the employment contract . . . In the employment contract, the
workers alienate and transfer their legal rights to the employer to govern
their activities 'within the scope of the employment' to the employer."_
[David Ellerman, **The Democratic Worker-Owned Firm**, p. 50]

Ultimately, there is **_one_** right that cannot be ceded or abandoned, namely
the right to personality. If a person gave up their personality they would
cease to be a person yet this is what the employment contract imposes. To
maintain and develop their personality is a basic right of humanity and it
cannot be transferred to another, permanently or temporarily. To argue
otherwise would be to admit that under certain circumstances and for certain
periods of time a person is not a person but rather a thing to be used by
others. Yet this is precisely what capitalism does due to its hierarchical
nature.

This is not all. Capitalism, by treating labour as analogous to all other
commodities denies the key distinction between labour and other "resources" -
that is to say its inseparability from its bearer - labour, unlike other
"property," is endowed with will and agency. Thus when one speaks of selling
labour there is a necessary subjugation of will (hierarchy). As Karl Polanyi
writes:

> _"Labour is only another name for human activity which goes with life
itself, which is in turn not produced for sale but for entirely different
reasons, nor can that activity be detached from the rest of life itself, be
stored or mobilised . . . To allow the market mechanism to be sole director of
the fate of human beings and their natural environment . . . would result in
the demolition of society. For the alleged commodity 'labour power' cannot be
shoved about, used indiscriminately, or even left unused, without affecting
also the human individual who happens to be the bearer of this peculiar
commodity. In disposing of a man's labour power the system would,
incidentally, dispose of the physical, psychological, and moral entity 'man'
attached to that tag."_ [**The Great Transformation**, p. 72]

In other words, labour is much more than the commodity to which capitalism
tries to reduce it. Creative, self-managed work is a source of pride and joy
and part of what it means to be fully human. Wrenching control of work from
the hands of the worker profoundly harms his or her mental and physical
health. Indeed, Proudhon went so far as to argue that capitalist companies
_"plunder the bodies and souls of the wage-workers"_ and were an _"outrage
upon human dignity and personality."_ [**Op. Cit.**, p. 219] This is because
wage labour turns productive activity and the person who does it into a
commodity. People _"are not human **beings** so much as human **resources**.
To the morally blind corporation, they are tool to generate as much profit as
possible. And 'the tool can be treated just like a piece of metal -- you use
it if you want, you throw it away if you don't want it,' says Noam Chomsky.
'If you can get human beings to become tool like that, it's more efficient by
some measure of efficiency . . . a measure which is based on dehumanisation.
You have to dehumanise it. That's part of the system.'"_ [Joel Bakan, **The
Corporation**, p. 69]

Separating labour from other activities of life and subjecting it to the laws
of the market means to annihilate its natural, organic form of existence -- a
form that evolved with the human race through tens of thousands of years of
co-operative economic activity based on sharing and mutual aid -- and
replacing it with an atomistic and individualistic one based on contract and
competition. Unsurprisingly, this relationship is a very recent development
and, moreover, the product of substantial state action and coercion (see
[section F.8](secF8.md) for some discussion of this). Simply put, _"the
early labourer . . . abhorred the factory, where he [or she] felt degraded and
tortured."_ While the state ensured a steady pool of landless workers by
enforcing private property rights, the early manufacturers also utilised the
state to ensure low wages, primarily for social reasons -- only an overworked
and downtrodden labourer with no other options would agree to do whatever
their master required of them. _"Legal compulsion and parish serfdom as in
England,"_ noted Polanyi, _"the rigors of an absolutist labour police as on
the Continent, indented labour as in the early Americas were the prerequisites
of the 'willing worker.'"_ [**Op. Cit.**, pp. 164-5]

Ignoring its origins in state action, the social relationship of wage labour
is then claimed by capitalists to be a source of "freedom," whereas in fact it
is a form of (in)voluntary servitude (see sections [B.4](secB4.md) and
[A.2.14](secA2.md#seca14) for more discussion). Therefore a libertarian who
did not support economic liberty (i.e. self-government in industry,
libertarian socialism) would be no libertarian at all, and no believer in
liberty. Capitalism is based upon hierarchy and the denial of liberty. To
present it otherwise denies the nature of wage labour. However, supporters of
capitalism try to but -- as Karl Polanyi points out -- the idea that wage
labour is based upon some kind of "natural" liberty is false:

> _"To represent this principle [wage labour] as one of non-interference [with
freedom], as economic liberals were wont to do, was merely the expression of
an ingrained prejudice in favour of a definite kind of interference, namely,
such as would destroy non-contractual relations between individuals and
prevent their spontaneous re-formation."_ [**Op. Cit.**, p.163]

As noted above, capitalism itself was created by state violence and the
destruction of traditional ways of life and social interaction was part of
that task. From the start, bosses spent considerable time and energy combating
attempts of working people to join together to resist the hierarchy they were
subjected to and reassert human values. Such forms of free association between
equals (such as trade unions) were combated, just as attempts to regulate the
worse excesses of the system by democratic governments. Indeed, capitalists
prefer centralised, elitist and/or authoritarian regimes precisely because
they are sure to be outside of popular control (see [section
B.2.5](secB2.md#secb25)). They are the only way that contractual relations
based on market power could be enforced on an unwilling population. Capitalism
was born under such states and as well as backing fascist movements, they made
high profits in Nazi Germany and Fascist Italy. Today many corporations
_"regularly do business with totalitarian and authoritarian regimes -- again,
because it is profitable to do so."_ Indeed, there is a _"trend by US
corporations to invest in"_ such countries. [Joel Bakan, **Op. Cit.**, p. 89
and p. 185] Perhaps unsurprisingly, as such regimes are best able to enforce
the necessary conditions to commodify labour fully.

## B.1.3 What kind of hierarchy of values does capitalism create?

Anarchists argue that capitalism can only have a negative impact on ethical
behaviour. This flows from its hierarchical nature. We think that hierarchy
must, by its very nature, always impact negatively on morality.

As we argued in [section A.2.19](secA2.md#seca219), ethics is dependent on
both individual liberty and equality between individuals. Hierarchy violates
both and so the _"great sources of moral depravity"_ are _"capitalism,
religion, justice, government."_ In _"the domain of economy, coercion has lead
us to industrial servitude; in the domain of politics to the State . . .
[where] the nation . . . becomes nothing but a mass of obedient **subjects**
to a central authority."_ This has _"contributed and powerfully aided to
create all the present economic, political, and social evils"_ and _"has given
proof of its absolute impotence to raise the moral level of societies; it has
not even been able to maintain it at the level it had already reached."_ This
is unsurprising, as society developed _"authoritarian prejudices"_ and _"men
become more and more divided into governors and governed, exploiters and
exploited, the moral level fell . . . and the spirit of the age declined."_ By
violating equality, by rejecting social co-operation between equals in favour
of top-down, authoritarian, social relationships which turn some into the
tools of others, capitalism, like the state, could not help but erode ethical
standards as the _"moral level"_ of society is _"debased by the practice of
authority."_ [Kropotkin, **Anarchism**, pp. 137-8, p. 106 and p. 139]

However, as we as promoting general unethical behaviour, capitalism produces a
specific perverted hierarchy of values -- one that places humanity below
property. As Erich Fromm argues:

> _"The use [i.e. exploitation] of man by man is expressive of the **system of
values** underlying the capitalistic system. **Capital, the dead past, employs
labour -- the living vitality and power of the present.** In the capitalistic
hierarchy of values, capital stands higher than labour, amassed things higher
than the manifestations of life. Capital employs labour, and not labour
capital. The person who owns capital commands the person who 'only' owns his
life, human skill, vitality and creative productivity. 'Things' are higher
than man. The conflict between capital and labour is much more than the
conflict between two classes, more than their fight for a greater share of the
social product. It is the conflict between two principles of value: **that
between the world of things, and their amassment, and the world of life and
its productivity**."_ [**The Sane Society**, pp. 94-95]

Capitalism only values a person as representing a certain amount of the
commodity called "labour power," in other words, as a **thing**. Instead of
being valued as an individual -- a unique human being with intrinsic moral and
spiritual worth -- only one's price tag counts. This replacement of human
relationships by economic ones soon results in the replacement of human values
by economic ones, giving us an "ethics" of the account book, in which people
are valued by how much they earn. It also leads, as Murray Bookchin argues, to
a debasement of human values:

> _"So deeply rooted is the market economy in our minds that its grubby
language has replaced our most hallowed moral and spiritual expressions. We
now 'invest' in our children, marriages, and personal relationships, a term
that is equated with words like 'love' and 'care.' We live in a world of
'trade-offs' and we ask for the 'bottom line' of any emotional 'transaction.'
We use the terminology of contracts rather than that of loyalties and
spiritual affinities."_ [**The Modern Crisis**, p. 79]

With human values replaced by the ethics of calculation, and with only the
laws of market and state "binding" people together, social breakdown is
inevitable. Little wonder modern capitalism has seen a massive increase in
crime and dehumanisation under the freer markets established by "conservative"
governments, such as those of Thatcher and Reagan and their transnational
corporate masters. We now live in a society where people live in self-
constructed fortresses, "free" behind their walls and defences (both emotional
and physical).

Of course, some people **like** the "ethics" of mathematics. But this is
mostly because -- like all gods -- it gives the worshipper an easy rule book
to follow. "Five is greater than four, therefore five is better" is pretty
simple to understand. John Steinbeck noticed this when he wrote:

> _"Some of them [the owners] hated the mathematics that drove them [to kick
the farmers off their land], and some were afraid, and some worshipped the
mathematics because it provided a refuge from thought and from feeling."_
[**The Grapes of Wrath**, p. 34]

The debasement of the individual in the workplace, where so much time is
spent, necessarily affects a person's self-image, which in turn carries over
into the way he or she acts in other areas of life. If one is regarded as a
commodity at work, one comes to regard oneself and others in that way also.
Thus all social relationships -- and so, ultimately, **all** individuals --
are commodified. In capitalism, literally nothing is sacred -- "everything has
its price" -- be it dignity, self-worth, pride, honour -- all become
commodities up for grabs. Such debasement produces a number of social
pathologies. "Consumerism" is one example which can be traced directly to the
commodification of the individual under capitalism. To quote Fromm again,
_"**Things** have no self, and men who have become things [i.e. commodities on
the labour market] can have no self."_ [**Op. Cit.**, p. 143]

However, people still feel the **need** for selfhood, and so try to fill the
emptiness by consuming. The illusion of happiness, that one's life will be
complete if one gets a new commodity, drives people to consume. Unfortunately,
since commodities are yet more things, they provide no substitute for
selfhood, and so the consuming must begin anew. This process is, of course,
encouraged by the advertising industry, which tries to convince us to buy what
we don't need because it will make us popular/sexy/happy/free/etc. (delete as
appropriate!). But consuming cannot really satisfy the needs that the
commodities are bought to satisfy. Those needs can only be satisfied by social
interaction based on truly human values and by creative, self-directed work.

This does not mean, of course, that anarchists are against higher living
standards or material goods. To the contrary, they recognise that liberty and
a good life are only possible when one does not have to worry about having
enough food, decent housing, and so forth. Freedom and 16 hours of work a day
do not go together, nor do equality and poverty or solidarity and hunger.
However, anarchists consider consumerism to be a distortion of consumption
caused by the alienating and inhuman "account book" ethics of capitalism,
which crushes the individual and his or her sense of identity, dignity and
selfhood.

## B.1.4 Why do racism, sexism and homophobia exist?

Since racism, sexism and homophobia (hatred/fear of homosexuals) are
institutionalised throughout society, sexual, racial and gay oppression are
commonplace. The primary cause of these three evil attitudes is the need for
ideologies that justify domination and exploitation, which are inherent in
hierarchy -- in other words, "theories" that "justify" and "explain"
oppression and injustice. As Tacitus said, _"We hate those whom we injure."_
Those who oppress others always find reasons to regard their victims as
"inferior" and hence deserving of their fate. Elites need some way to justify
their superior social and economic positions. Since the social system is
obviously unfair and elitist, attention must be distracted to other, less
inconvenient, "facts," such as alleged superiority based on biology or
"nature." Therefore, doctrines of sexual, racial, and ethnic superiority are
inevitable in hierarchical, class-stratified societies.

We will take each form of bigotry in turn.

From an economic standpoint, racism is associated with the exploitation of
cheap labour at home and imperialism abroad. Indeed, early capitalist
development in both America and Europe was strengthened by the bondage of
people, particularly those of African descent. In the Americas, Australia and
other parts of the world the slaughter of the original inhabitants and the
expropriation of their land was also a key aspect in the growth of capitalism.
As the subordination of foreign nations proceeds by force, it appears to the
dominant nation that it owes its mastery to its special natural qualities, in
other words to its "racial" characteristics. Thus imperialists have frequently
appealed to the Darwinian doctrine of "Survival of the Fittest" to give their
racism a basis in "nature."

In Europe, one of the first theories of racial superiority was proposed by
Gobineau in the 1850s to establish the natural right of the aristocracy to
rule over France. He argued that the French aristocracy was originally of
Germanic origin while the "masses" were Gallic or Celtic, and that since the
Germanic race was "superior", the aristocracy had a natural right to rule.
Although the French "masses" didn't find this theory particularly persuasive,
it was later taken up by proponents of German expansion and became the origin
of German racial ideology, used to justify Nazi oppression of Jews and other
"non-Aryan" types. Notions of the "white man's burden" and "Manifest Destiny"
developed at about the same time in England and to a lesser extent in America,
and were used to rationalise Anglo-Saxon conquest and world domination on a
"humanitarian" basis.

Racism and authoritarianism at home and abroad has gone hand in hand. As
Rudolf Rocker argued, _"[a]ll advocates of the race doctrine have been and are
the associates and defenders of every political and social reaction, advocates
of the power principle in its most brutal form . . . He who thinks that he
sees in all political and social antagonisms merely blood-determined
manifestations of race, denies all conciliatory influence of ideas, all
community of ethical feeling, and must at every crisis take refuge in brute
force. In fact, race theory is only the cult of power."_ Racism aids the
consolidation of elite power for by attacking _"all the achievements . . . in
the direction of personal freedom"_ and the idea of equality _"[n]o better
moral justification could be produced for the industrial bondage which our
holders of industrial power keep before them as a picture of the future."_
[**Nationalism and Culture**, pp. 337-8]

The idea of racial superiority was also found to have great domestic utility.
As Paul Sweezy points out, _"[t]he intensification of social conflict within
the advanced capitalist countries. . . has to be directed as far as possible
into innocuous channels -- innocuous, that is to say, from the standpoint of
capitalist class rule. The stirring up of antagonisms along racial lines is a
convenient method of directing attention away from class struggle,"_ which of
course is dangerous to ruling-class interests. [**Theory of Capitalist
Development**, p. 311] Indeed, employers have often deliberately fostered
divisions among workers on racial lines as part of a strategy of "divide and
rule" (in other contexts, like Northern Ireland or Scotland, the employers
have used religion in the same way instead).

Employers and politicians have often deliberately fostered divisions among
workers on racial lines as part of a strategy of "divide and rule." In other
contexts, like Tzarist Russia, Northern Ireland or Scotland, the employers
have used religion in the same way. In others, immigrants and native born is
the dividing line. The net effect is the same, social oppressions which range
from the extreme violence anarchists like Emma Goldman denounced in the
American South (_"the atrocities rampant in the South, of negroes lynched,
tortured and burned by infuriated crowds without a hand being raised or a word
said for their protection"_ [**Emma Goldman: A Documentary History of the
American Years**, vol. 1, p. 386]) or the pogroms against Jews in Tsarist
Russia to discrimination in where people can live, what jobs people can get,
less pay and so on.

For those in power, this makes perfect sense as racism (like other forms of
bigotry) can be used to split and divide the working class by getting people
to blame others of their class for the conditions they all suffer. In this
way, the anger people feel about the problems they face are turned away from
their real causes onto scapegoats. Thus white workers are subtly (and
sometimes not so subtly) encouraged, for example, to blame unemployment,
poverty and crime on blacks or Hispanics instead of capitalism and the (white,
male) elites who run it and who directly benefit from low wages and high
profits. Discrimination against racial minorities and women makes sense for
capitalism, for in this way profits are enlarged directly and indirectly. As
jobs and investment opportunities are denied to the disadvantaged groups,
their wages can be depressed below prevailing levels and profits,
correspondingly, increased. Indirectly, discrimination adds capitalist profits
and power by increasing unemployment and setting workers against each other.
Such factors ensure that capitalism will never "compete" discrimination way as
some free-market capitalist economists argue.

In other words, capitalism has benefited and will continue to benefit from its
racist heritage. Racism has provided pools of cheap labour for capitalists to
draw upon and permitted a section of the population to be subjected to worse
treatment, so increasing profits by reducing working conditions and other non-
pay related costs. In America, blacks still get paid less than whites for the
same work (around 10% less than white workers with the same education, work
experience, occupation and other relevent demographic variables). This is
transferred into wealth inequalities. In 1998, black incomes were 54% of white
incomes while black net worth (including residential) was 12% and
nonresidential net worth just 3% of white. For Hispanics, the picture was
similar with incomes just 62% of whites, net worth, 4% and nonresidential net
worth 0%. While just under 15% of white households had zero or negative net
worth, 27% of black households and 36% Hispanic were in the same situation.
Even at similar levels of income, black households were significantly less
wealthy than white ones. [Doug Henwood, **After the New Economy**, p. 99 and
pp. 125-6]

All this means that racial minorities are _"subjected to oppression and
exploitation on the dual grounds of race and class, and thus have to fight the
extra battles against racism and discrimination."_ [Lorenzo Kom'boa Ervin,
**Anarchism and the Black Revolution**, p. 126]

Sexism only required a "justification" once women started to act for
themselves and demand equal rights. Before that point, sexual oppression did
not need to be "justified" -- it was "natural" (saying that, of course,
equality between the sexes was stronger before the rise of Christianity as a
state religion and capitalism so the "place" of women in society has fallen
over the last few hundred years before rising again thanks to the women's
movement).

The nature of sexual oppression can be seen from marriage. Emma Goldman
pointed out that marriage _"stands for the sovereignty of the man over the
women,"_ with her _"complete submission"_ to the husbands _"whims and
commands."_ [**Red Emma Speaks**, p. 164] As Carole Pateman notes, until _"the
late nineteenth century the legal and civil position of a wife resembled that
of a slave. . . A slave had no independent legal existence apart from his
master, and husband and wife became 'one person,' the person of the husband."_
Indeed, the law _"was based on the assumption that a wife was (like)
property"_ and only the marriage contract _"includes the explicit commitment
to obey."_ [**The Sexual Contract**, p. 119, p. 122 and p. 181]

However, when women started to question the assumptions of male domination,
numerous theories were developed to explain why women's oppression and
domination by men was "natural." Because men enforced their rule over women by
force, men's "superiority" was argued to be a "natural" product of their
gender, which is associated with greater physical strength (on the premise
that "might makes right"). In the 17th century, it was argued that women were
more like animals than men, thus "proving" that women had as much right to
equality with men as sheep did. More recently, elites have embraced socio-
biology in response to the growing women's movement. By "explaining" women's
oppression on biological grounds, a social system run by men and for men could
be ignored.

Women's subservient role also has economic value for capitalism (we should
note that Goldman considered capitalism to be another _"paternal arrangement"_
like marriage, both of which robbed people of their _"birthright,"_ _"stunts"_
their growth, _"poisons"_ their bodies and keeps people in _"ignorance, in
poverty and dependence."_ [**Op. Cit.**, p. 210]). Women often provide
necessary (and unpaid) labour which keeps the (usually) male worker in good
condition; and it is primarily women who raise the next generation of wage-
slaves (again without pay) for capitalist owners to exploit. Moreover, women's
subordination gives working-class men someone to look down upon and,
sometimes, a convenient target on whom they can take out their frustrations
(instead of stirring up trouble at work). As Lucy Parsons pointed out, a
working class woman is _"a slave to a slave."_

Sexism, like all forms of bigotry, is reflected in relative incomes and wealth
levels. In the US women, on average, were being paid 57% the amount men were
in 2001 (an improvement than the 39% 20 years earlier). Part of this is due to
fewer women working than men, but for those who do work outside the home their
incomes were 66% than of men's (up from 47% in 1980 and 38% in 1970). Those
who work full time, their incomes 76% of men's, up from the 60% average
through most of the 1970s. However, as with the black-white gap, this is due
in part to the stagnant income of male workers (in 1998 men's real incomes
were just 1% above 1989 levels while women's were 14% above). So rather than
the increase in income being purely the result of women entering high-paying
and largely male occupations and them closing the gender gap, it has also been
the result of the intense attacks on the working class since the 1980s which
has de-unionised and de-industrialised America. This has resulted in a lot of
high-paying male jobs have been lost and more and more women have entered the
job market to make sure their families make ends. [Henwood, **Op. Cit.**, p.
91-2]

Turning away from averages, we discover that sexism results in women being
paid about 12% less than men during the same job, with the same relative
variables (like work experience, education and so forth). Needless to say, as
with racism, such "relevant variables" are themselves shaped by
discrimination. Women, like blacks, are less likely to get job interviews and
jobs. Sexism even affects types of jobs, for example, "caring" professions pay
less than non-caring ones because they are seen as feminine and involve the
kinds of tasks which women do at home without pay. In general, female
dominated industries pay less. In 1998, occupations that were over 90% male
had a median wage almost 10% above average while those over 90% female, almost
25% below. One study found that a 30% increase in women in an occupation
translated into a 10% decline in average pay. Needless to say, having children
is bad economic news for most women (women with children earn 10 to 15% less
than women without children while for men the opposite is the case). Having
maternity level, incidentally, have a far smaller motherhood penalty.
[Henwood, **Op. Cit.**, p. 95-7]

The oppression of lesbians, gays and bisexuals is inextricably linked with
sexism. A patriarchal, capitalist society cannot see homosexual practices as
the normal human variations they are because they blur that society's rigid
gender roles and sexist stereotypes. Most young gay people keep their
sexuality to themselves for fear of being kicked out of home and all gays have
the fear that some "straights" will try to kick their sexuality out of them if
they express their sexuality freely. As with those subject to other forms of
bigotry, gays are also discriminated against economically (gay men earning
about 4-7% less than the average straight man [Henwood, **Op. Cit.**, p.
100]). Thus the social oppression which result in having an alternative
sexuality are experienced on many different levels, from extreme violence to
less pay for doing the same work.

Gays are not oppressed on a whim but because of the specific need of
capitalism for the nuclear family. The nuclear family, as the primary - and
inexpensive - creator of submissive people (growing up within the
authoritarian family gets children used to, and "respectful" of, hierarchy and
subordination - see [section B.1.5](secB1.md#secb15)) as well as provider
and carer for the workforce fulfils an important need for capitalism.
Alternative sexualities represent a threat to the family model because they
provide a different role model for people. This means that gays are going to
be in the front line of attack whenever capitalism wants to reinforce "family
values" (i.e. submission to authority, "tradition", "morality" and so on). The
introduction of Clause 28 in Britain is a good example of this, with the
government making it illegal for public bodies to promote gay sexuality (i.e.
to present it as anything other than a perversion). In American, the right is
also seeking to demonise homosexuality as part of their campaign to reinforce
the values of the patriarchal family unit and submission to "traditional"
authority. Therefore, the oppression of people based on their sexuality is
unlikely to end until sexism is eliminated.

This is not all. As well as adversely affecting those subject to them, sexism,
racism and homophobia are harmful to those who practice them (and in some way
benefit from them) within the working class itself. Why this should be the
case is obvious, once you think about it. All three divide the working class,
which means that whites, males and heterosexuals hurt themselves by
maintaining a pool of low-paid competing labour, ensuring low wages for their
own wives, daughters, mothers, relatives and friends. Such divisions create
inferior conditions and wages for all as capitalists gain a competitive
advantage using this pool of cheap labour, forcing all capitalists to cut
conditions and wages to survive in the market (in addition, such social
hierarchies, by undermining solidarity against the employer on the job and the
state possibly create a group of excluded workers who could become scabs
during strikes). Also, "privileged" sections of the working class lose out
because their wages and conditions are less than those which unity could have
won them. Only the boss really wins.

This can be seen from research into this subject. The researcher Al Szymanski
sought to systematically and scientifically test the proposition that white
workers gain from racism [_"Racial Discrimination and White Gain"_, in
**American Sociological Review**, vol. 41, no. 3, June 1976, pp. 403-414]. He
compared the situation of "white" and "non-white" (i.e. black, Native
American, Asian and Hispanic) workers in United States and found several key
things:

(1) the narrower the gap between white and black wages in an American state,
the higher white earnings were relative to white earnings elsewhere. This
means that _"whites do not benefit economically by economic discrimination.
White workers especially appear to benefit economically from the **absence**
of economic discrimination. . . both in the absolute level of their earnings
**and** in relative equality among whites."_ [p. 413] In other words, the less
wage discrimination there was against black workers, the better were the wages
that white workers received.

(2) the more "non-white" people in the population of a given American State,
the more inequality there was between whites. In other words, the existence of
a poor, oppressed group of workers reduced the wages of white workers,
although it did not affect the earnings of non-working class whites very much
(_"the greater the discrimination against [non-white] people, the greater the
inequality among whites"_ [p. 410]). So white workers clearly lost
economically from this discrimination.

(3) He also found that _"the more intense racial discrimination is, the lower
are the white earnings **because** of . . . [its effect on] working-class
solidarity."_ [p. 412] In other words, racism economically disadvantages white
workers because it undermines the solidarity between black and white workers
and weakens trade union organisation.

So overall, these white workers receive some apparent privileges from racism,
but are in fact screwed by it. Thus racism and other forms of hierarchy
actually works against the interests of those working class people who
practice it -- and, by weakening workplace and social unity, benefits the
ruling class:

> _ "As long as discrimination exists and racial or ethnic minorities are
oppressed, the entire working class is weakened. This is so because the
Capitalist class is able to use racism to drive down the wages of individual
segments of the working class by inciting racial antagonism and forcing a
fight for jobs and services. This division is a development that ultimately
undercuts the living standards of all workers. Moreover, by pitting Whites
against Blacks and other oppressed nationalities, the Capitalist class is able
to prevent workers from uniting against their common enemy. As long as workers
are fighting each other, the Capitalist class is secure."_ [Lorenzo Kom'boa
Ervin, **Op. Cit.**, pp. 12-3]

In addition, a wealth of alternative viewpoints, insights, experiences,
cultures, thoughts and so on are denied the racist, sexist or homophobe. Their
minds are trapped in a cage, stagnating within a mono-culture -- and
stagnation is death for the personality. Such forms of oppression are
dehumanising for those who practice them, for the oppressor lives as a
**role**, not as a person, and so are restricted by it and cannot express
their individuality **freely** (and so do so in very limited ways). This warps
the personality of the oppressor and impoverishes their own life and
personality. Homophobia and sexism also limits the flexibility of all people,
gay or straight, to choose the sexual expressions and relationships that are
right for them. The sexual repression of the sexist and homophobe will hardly
be good for their mental health, their relationships or general development.

From the anarchist standpoint, oppression based on race, sex or sexuality will
remain forever intractable under capitalism or, indeed, under any economic or
political system based on domination and exploitation. While individual
members of "minorities" may prosper, racism as a justification for inequality
is too useful a tool for elites to discard. By using the results of racism
(e.g. poverty) as a justification for racist ideology, criticism of the status
quo can, yet again, be replaced by nonsense about "nature" and "biology."
Similarly with sexism or discrimination against gays.

The long-term solution is obvious: dismantle capitalism and the hierarchical,
economically class-stratified society with which it is bound up. By getting
rid of capitalist oppression and exploitation and its consequent imperialism
and poverty, we will also eliminate the need for ideologies of racial or
sexual superiority used to justify the oppression of one group by another or
to divide and weaken the working class. However, struggles against bigotry
cannot be left until after a revolution. If they were two things are likely:
one, such a revolution would be unlikely to happen and, two, if it were then
these problems would more than likely remain in the new society created by it.
Therefore the negative impacts of inequality can and must be fought in the
here and now, like any form of hierarchy. Indeed, as we discuss in more detail
[section B.1.6](secB1.md#secb16) by doing so we make life a bit better in
the here and now as well as bringing the time when such inequalities are
finally ended nearer. Only this can ensure that we can all live as free and
equal individuals in a world without the blights of sexism, racism, homophobia
or religious hatred.

Needless to say, anarchists totally reject the kind of "equality" that accepts
other kinds of hierarchy, that accepts the dominant priorities of capitalism
and the state and accedes to the devaluation of relationships and
individuality in name of power and wealth. There is a kind of "equality" in
having "equal opportunities," in having black, gay or women bosses and
politicians, but one that misses the point. Saying "Me too!" instead of "What
a mess!" does not suggest real liberation, just different bosses and new forms
of oppression. We need to look at the way society is organised, not at the
sex, colour, nationality or sexuality of who is giving the orders!

## B.1.5 How is the mass-psychological basis for authoritarian civilisation
created?

We noted in [section A.3.6](secA3.md#seca36) that hierarchical,
authoritarian institutions tend to be self-perpetuating, because growing up
under their influence creates submissive/authoritarian personalities -- people
who both "respect" authority (based on fear of punishment) and desire to
exercise it themselves on subordinates. Individuals with such a character
structure do not really want to dismantle hierarchies, because they are afraid
of the responsibility entailed by genuine freedom. It seems "natural" and
"right" to them that society's institutions, from the authoritarian factory to
the patriarchal family, should be pyramidal, with an elite at the top giving
orders while those below them merely obey. Thus we have the spectacle of so-
called "Libertarians" and "anarcho" capitalists bleating about "liberty" while
at the same time advocating factory fascism and privatised states. In short,
authoritarian civilisation reproduces itself with each generation because,
through an intricate system of conditioning that permeates every aspect of
society, it creates masses of people who support the status quo.

Wilhelm Reich has given one of the most thorough analyses of the psychological
processes involved in the reproduction of authoritarian civilisation. Reich
based his analysis on four of Freud's most solidly grounded discoveries,
namely, (1) that there exists an unconscious part of the mind which has a
powerful though irrational influence on behaviour; (2) that even the small
child develops a lively "genital" sexuality, i.e. a desire for sexual pleasure
which has nothing to do with procreation; (3) that childhood sexuality along
with the Oedipal conflicts that arise in parent-child relations under monogamy
and patriarchy are usually repressed through fear of punishment or disapproval
for sexual acts and thoughts; (4) that this blocking of the child's natural
sexual activity and extinguishing it from memory does not weaken its force in
the unconscious, but actually intensifies it and enables it to manifest itself
in various pathological disturbances and anti-social drives; and (5) that, far
from being of divine origin, human moral codes are derived from the
educational measures used by the parents and parental surrogates in earliest
childhood, the most effective of these being the ones opposed to childhood
sexuality.

By studying Bronislaw Malinowsli's research on the Trobriand Islanders, a
woman-centred (matricentric) society in which children's sexual behaviour was
not repressed and in which neuroses and perversions as well as authoritarian
institutions and values were almost non-existent, Reich came to the conclusion
that patriarchy and authoritarianism originally developed when tribal
chieftains began to get economic advantages from a certain type of marriage
("cross-cousin marriages") entered into by their sons. In such marriages, the
brothers of the son's wife were obliged to pay a dowry to her in the form of
continuous tribute, thus enriching her husband's clan (i.e. the chief's). By
arranging many such marriages for his sons (which were usually numerous due to
the chief's privilege of polygamy), the chief's clan could accumulate wealth.
Thus society began to be stratified into ruling and subordinate clans based on
wealth.

To secure the permanence of these "good" marriages, strict monogamy was
required. However, it was found that monogamy was impossible to maintain
without the repression of childhood sexuality, since, as statistics show,
children who are allowed free expression of sexuality often do not adapt
successfully to life-long monogamy. Therefore, along with class stratification
and private property, authoritarian child-rearing methods were developed to
inculcate the repressive sexual morality on which the new patriarchal system
depended for its reproduction. Thus there is a historical correlation between,
on the one hand, pre-patriarchal society, primitive libertarian communism (or
_"work democracy,"_ to use Reich's expression), economic equality, and sexual
freedom, and on the other, patriarchal society, a private-property economy,
economic class stratification, and sexual repression. As Reich puts it:

> _"Every tribe that developed from a [matricentric] to a patriarchal
organisation had to change the sexual structure of its members to produce a
sexuality in keeping with its new form of life. This was a necessary change
because the shifting of power and of wealth from the democratic gens [maternal
clans] to the authoritarian family of the chief was mainly implemented with
the help of the suppression of the sexual strivings of the people. It was in
this way that sexual suppression became an essential factor in the division of
society into classes.  
>  _

>

> _"Marriage, and the lawful dowry it entailed, became the axis of the
transformation of the one organisation into the other. In view of the fact
that the marriage tribute of the wife's gens to the man's family strengthened
the male's, especially the chief's, position of power, the male members of the
higher ranking gens and families developed a keen interest in making the
nuptial ties permanent. At this stage, in other words, only the man had an
interest in marriage. In this way natural work-democracy's simple alliance,
which could be easily dissolved at any time, was transformed into the
permanent and monogamous marital relationship of patriarchy. The permanent
monogamous marriage became the basic institution of patriarchal society --
which it still is today. To safeguard these marriages, however, it was
necessary to impose greater and greater restrictions upon and to depreciate
natural genital strivings."_ [**The Mass Psychology of Fascism**, p. 90]

The suppression of natural sexuality involved in this transformation from
matricentric to patriarchal society created various anti-social drives
(sadism, destructive impulses, rape fantasies, etc.), which then also had to
be suppressed through the imposition of a compulsive morality, which took the
place the natural self-regulation that one finds in pre-patriarchal societies.
In this way, sex began to be regarded as "dirty," "diabolical," "wicked," etc.
-- which it had indeed become through the creation of secondary drives. Thus:

> _"The patriarchal- authoritarian sexual order that resulted from the
revolutionary processes of latter-day [matricentrism] (economic independence
of the chief's family from the maternal gens, a growing exchange of goods
between the tribes, development of the means of production, etc.) becomes the
primary basis of authoritarian ideology by depriving the women, children, and
adolescents of their sexual freedom, making a commodity of sex and placing
sexual interests in the service of economic subjugation. From now on,
sexuality is indeed distorted; it becomes diabolical and demonic and has to be
curbed."_ [Reich, **Op. Cit.**, p. 88]

Once the beginnings of patriarchy are in place, the creation of a fully
authoritarian society based on the psychological crippling of its members
through sexual suppression follows:

> _"The moral inhibition of the child's natural sexuality, the last stage of
which is the severe impairment of the child's **genital** sexuality, makes the
child afraid, shy, fearful of authority, obedient, 'good,' and 'docile' in the
authoritarian sense of the words. It has a crippling effect on man's
rebellious forces because every vital life-impulse is now burdened with severe
fear; and since sex is a forbidden subject, thought in general and man's
critical faculty also become inhibited. In short, morality's aim is to produce
acquiescent subjects who, despite distress and humiliation, are adjusted to
the authoritarian order. Thus, the family is the authoritarian state in
miniature, to which the child must learn to adapt himself as a preparation for
the general social adjustment required of him later. Man's authoritarian
structure -- this must be clearly established -- is basically produced by the
embedding of sexual inhibitions and fear."_ [Reich, **Op. Cit.**, p. 30]

In this way, by damaging the individual's power to rebel and think for
him/herself, the inhibition of childhood sexuality -- and indeed other forms
of free, natural expression of bioenergy (e.g. shouting, crying, running,
jumping, etc.) -- becomes the most important weapon in creating reactionary
personalities. This is why every reactionary politician puts such an emphasis
on "strengthening the family" and promoting "family values" (i.e. patriarchy,
compulsive monogamy, premarital chastity, corporal punishment, etc.). In the
words of Reich:

> _"Since authoritarian society reproduces itself in the individual structures
of the masses with the help of the authoritarian family, it follows that
political reaction has to regard and defend the authoritarian family as
**the** basis of the 'state, culture, and civilisation. . . .' [It is]
**political reaction's germ cell**, the most important centre for the
production of reactionary men and women. Originating and developing from
definite social processes, it becomes the most essential institution for the
preservation of the authoritarian system that shapes it."_ [**Op. Cit.**, pp.
104-105]

The family is the most essential institution for this purpose because children
are most vulnerable to psychological maiming in their first few years, from
the time of birth to about six years of age, during which time they are mostly
in the charge of their parents. The schools and churches then continue the
process of conditioning once the children are old enough to be away from their
parents, but they are generally unsuccessful if the proper foundation has not
been laid very early in life by the parents. Thus A.S. Neill observes that
_"the nursery training is very like the kennel training. The whipped child,
like the whipped puppy, grows into an obedient, inferior adult. And as we
train our dogs to suit our own purposes, so we train our children. In that
kennel, the nursery, the human dogs must be clean; they must feed when we
think it convenient for them to feed. I saw a hundred thousand obedient,
fawning dogs wag their tails in the Templehof, Berlin, when in 1935, the great
trainer Hitler whistled his commands."_ [**Summerhill: a Radical Approach to
Child Rearing**, p. 100]

The family is also the main agency of repression during adolescence, when
sexual energy reaches its peak. This is because the vast majority of parents
provide no private space for adolescents to pursue undisturbed sexual
relationships with their partners, but in fact actively discourage such
behaviour, often (as in fundamentalist Christian families) demanding complete
abstinence -- at the very time when abstinence is most impossible! Moreover,
since teenagers are economically dependent on their parents under capitalism,
with no societal provision of housing or dormitories allowing for sexual
freedom, young people have no alternative but to submit to irrational parental
demands for abstention from premarital sex. This in turn forces them to engage
in furtive sex in the back seats of cars or other out-of-the-way places where
they cannot relax or obtain full sexual satisfaction. As Reich found, when
sexuality is repressed and laden with anxiety, the result is always some
degree of what he terms _"orgastic impotence"_: the inability to fully
surrender to the flow of energy discharged during orgasm. Hence there is an
incomplete release of sexual tension, which results in a state of chronic
bioenergetic stasis. Such a condition, Reich found, is the breeding ground for
neuroses and reactionary attitudes. (For further details see the [section
J.6](secJ6.md)).

In this connection it is interesting to note that "primitive" societies, such
as the Trobriand Islanders, prior to their developing patriarchal-
authoritarian institutions, provided special community houses where teenagers
could go with their partners to enjoy undisturbed sexual relationships -- and
this with society's full approval. Such an institution would be taken for
granted in an anarchist society, as it is implied by the concept of freedom.
(For more on adolescent sexual liberation, see [section
J.6.8.](secJ6.md#secj68))

Nationalistic feelings can also be traced to the authoritarian family. A
child's attachment to its mother is, of course, natural and is the basis of
all family ties. Subjectively, the emotional core of the concepts of homeland
and nation are mother and family, since the mother is the homeland of the
child, just as the family is the "nation in miniature." According to Reich,
who carefully studied the mass appeal of Hitler's "National Socialism,"
nationalistic sentiments are a direct continuation of the family tie and are
rooted in a **fixated** tie to the mother. As Reich points out, although
infantile attachment to the mother is natural, **fixated** attachment is not,
but is a social product. In puberty, the tie to the mother would make room for
other attachments, i.e., natural sexual relations, **if** the unnatural sexual
restrictions imposed on adolescents did not cause it to be eternalised. It is
in the form of this socially conditioned externalisation that fixation on the
mother becomes the basis of nationalist feelings in the adult; and it is only
at this stage that it becomes a reactionary social force.

Later writers who have followed Reich in analysing the process of creating
reactionary character structures have broadened the scope of his analysis to
include other important inhibitions, besides sexual ones, that are imposed on
children and adolescents. Rianne Eisler, for example, in her book **Sacred
Pleasure**, stresses that it is not just a sex-negative attitude but a
**pleasure**-negative attitude that creates the kinds of personalities in
question. Denial of the value of pleasurable sensations permeates our
unconscious, as reflected, for example, in the common idea that to enjoy the
pleasures of the body is the "animalistic" (and hence "bad") side of human
nature, as contrasted with the "higher" pleasures of the mind and "spirit." By
such dualism, which denies a spiritual aspect to the body, people are made to
feel guilty about enjoying any pleasurable sensations -- a conditioning that
does, however, prepare them for lives based on the sacrifice of pleasure (or
indeed, even of life itself) under capitalism and statism, with their
requirements of mass submission to alienated labour, exploitation, military
service to protect ruling-class interests, and so on. And at the same time,
authoritarian ideology emphasises the value of suffering, as for example
through the glorification of the tough, insensitive warrior hero, who suffers
(and inflicts "necessary" suffering on others ) for the sake of some pitiless
ideal.

Eisler also points out that there is _"ample evidence that people who grow up
in families where rigid hierarchies and painful punishments are the norm learn
to suppress anger toward their parents. There is also ample evidence that this
anger is then often deflected against traditionally disempowered groups (such
as minorities, children, and women)."_ [**Sacred Pleasure**, p. 187] This
repressed anger then becomes fertile ground for reactionary politicians, whose
mass appeal usually rests in part on scapegoating minorities for society's
problems.

As the psychologist Else Frenkel-Brunswick documents in **The Authoritarian
Personality**, people who have been conditioned through childhood abuse to
surrender their will to the requirements of feared authoritarian parents, also
tend to be very susceptible as adults to surrender their will and minds to
authoritarian leaders. _"In other words,"_ Frenkel-Brunswick summarises, _"at
the same time that they learn to deflect their repressed rage against those
they perceive as weak, they also learn to submit to autocratic or 'strong-man'
rule. Moreover, having been severely punished for any hint of rebellion (even
'talking back' about being treated unfairly), they gradually also learn to
deny to themselves that there was anything wrong with what was done to them as
children -- and to do it in turn to their own children."_ [**The Authoritarian
Personality**, p. 187]

These are just some of the mechanisms that perpetuate the status quo by
creating the kinds of personalities who worship authority and fear freedom.
Consequently, anarchists are generally opposed to traditional child-rearing
practices, the patriarchal-authoritarian family (and its "values"), the
suppression of adolescent sexuality, and the pleasure-denying, pain-affirming
attitudes taught by the Church and in most schools. In place of these,
anarchists favour non-authoritarian, non-repressive child-rearing practices
and educational methods (see sections [J.6](secJ6.md) and [
secJ.5.13](secJ5.md#secJ513), respectively) whose purpose is to prevent, or
at least minimise, the psychological crippling of individuals, allowing them
instead to develop natural self-regulation and self-motivated learning. This,
we believe, is the only way to for people to grow up into happy, creative, and
truly freedom-loving individuals who will provide the psychological ground
where anarchist economic and political institutions can flourish.

## B.1.6 Can hierarchy be ended?

Faced with the fact that hierarchy, in its many distinctive forms, has been
with us such a long time and so negatively shapes those subject to it, some
may conclude that the anarchist hope of ending it, or even reducing it, is
little more than a utopian dream. Surely, it will be argued, as anarchists
acknowledge that those subject to a hierarchy adapt to it this automatically
excludes the creation of people able to free themselves from it?

Anarchists disagree. Hierarchy can be ended, both in specific forms and in
general. A quick look at the history of the human species shows that this is
the case. People who have been subject to monarchy have ended it, creating
republics where before absolutism reigned. Slavery and serfdom have been
abolished. Alexander Berkman simply stated the obvious when he pointed out
that _"many ideas, once held to be true, have come to be regarded as wrong and
evil. Thus the ideas of divine right of kings, of slavery and serfdom. There
was a time when the whole world believed those institutions to be right, just,
and unchangeable."_ However, they became _"discredited and lost their hold
upon the people, and finally the institutions that incorporated those ideas
were abolished"_ as _"they were useful only to the master class"_ and _"were
done away with by popular uprisings and revolutions."_ [**What is
Anarchism?**, p. 178] It is unlikely, therefore, that current forms of
hierarchy are exceptions to this process.

Today, we can see that this is the case. Malatesta's comments of over one
hundred years ago are still valid: _"the oppressed masses . . . have never
completely resigned themselves to oppression and poverty . . . [and] show
themselves thirsting for justice, freedom and wellbeing."_ [**Anarchy**, p.
33] Those at the bottom are constantly resisting both hierarchy and its the
negative effects and, equally important, creating non-hierarchical ways of
living and fighting. This constant process of self-activity and self-
liberation can be seen from the labour, women's and other movements -- in
which, to some degree, people create their own alternatives based upon their
own dreams and hopes. Anarchism is based upon, and grew out of, this process
of resistance, hope and direct action. In other words, the libertarian
elements that the oppressed continually produce in their struggles within and
against hierarchical systems are extrapolated and generalised into what is
called anarchism. It is these struggles and the anarchistic elements they
produce which make the end of all forms of hierarchy not only desirable, but
possible.

So while the negative impact of hierarchy is not surprising, neither is the
resistance to it. This is because the individual _"is not a blank sheet of
paper on which culture can write its text; he [or she] is an entity charged
with energy and structured in specific ways, which, while adapting itself,
reacts in specific and ascertainable ways to external conditions."_ In this
_"process of adaptation,"_ people develop _"definite mental and emotional
reactions which follow from specific properties"_ of our nature. [Eric Fromm,
**Man for Himself**, p. 23 and p. 22] For example:

> _ "Man can adapt himself to slavery, but he reacts to it by lowering his
intellectual and moral qualities . . . Man can adapt himself to cultural
conditions which demand the repression of sexual strivings, but in achieving
this adaptation he develops . . . neurotic symptoms. He can adapt to almost
any culture pattern, but in so far as these are contradictory to his nature he
develops mental and emotional disturbances which force him eventually change
these conditions since he cannot change his nature. . . . If . . . man could
adapt himself to all conditions without fighting those which are against his
nature, he would have no history. Human evolution is rooted in man's
adaptability and in certain indestructible qualities of his nature which
compel him to search for conditions better adjusted to his intrinsic needs."_
[**Op. Cit.**, pp. 22-23]

So as well as adaptation to hierarchy, there is resistance. This means that
modern society (capitalism), like any hierarchical society, faces a direct
contradiction. On the one hand, such systems divide society into a narrow
stratum of order givers and the vast majority of the population who are
(officially) excluded from decision making, who are reduced to carrying out
(executing) the decisions made by the few. As a result, most people suffer
feelings of alienation and unhappiness. However, in practice, people try and
overcome this position of powerlessness and so hierarchy produces a struggle
against itself by those subjected to it. This process goes on all the time, to
a greater or lesser degree, and is an essential aspect in creating the
possibility of political consciousness, social change and revolution. People
refuse to be treated like objects (as required by hierarchical society) and by
so doing hierarchy creates the possibility for its own destruction.

For the inequality in wealth and power produced by hierarchies, between the
powerful and the powerless, between the rich and the poor, has not been
ordained by god, nature or some other superhuman force. It has been created by
a specific social system, its institutions and workings -- a system based upon
authoritarian social relationships which effect us both physically and
mentally. So there is hope. Just as authoritarian traits are learned, so can
they be **unlearned.** As Carole Pateman summarises, the evidence supports the
argument _"that we do learn to participate by participating"_ and that a
participatory environment _"might also be effective in diminishing tendencies
toward non-democratic attitudes in the individual."_ [**Participaton and
Democratic Theory**, p. 105] So oppression reproduces resistance and the seeds
of its own destruction.

It is for this reason anarchists stress the importance of self-liberation (see
[section A.2.7](secA2.md#seca27)) and _"support all struggles for partial
freedom, because we are convinced that one learns through struggle, and that
once one begins to enjoy a little freedom one ends by wanting it all."_
[Malatesta, **Errico Malatesta: His Life and Ideas**, p. 195] By means of
direct action (see [section J.2](secJ2.md)), people exert themselves and
stand up for themselves. This breaks the conditioning of hierarchy, breaks the
submissiveness which hierarchical social relationships both need and produce.
Thus the daily struggles against oppression _"serve as a training camp to
develop"_ a person's _"understanding of [their] proper role in life, to
cultivate [their] self-reliance and independence, teach him [or her] mutual
help and co-operation, and make him [or her] conscious of [their]
responsibility. [They] will learn to decide and act on [their] own behalf, not
leaving it to leaders or politicians to attend to [their] affairs and look out
for [their] welfare. It will be [them] who will determine, together with
[their] fellows . . . , what they want and what methods will best serve their
aims."_ [Berkman, **Op. Cit.**, p. 206]

In other words, struggle encourages all the traits hierarchy erodes and,
consequently, develop the abilities not only to question and resist authority
but, ultimately, end it once and for all. This means that any struggle
**changes** those who take part in it, politicising them and transforming
their personalities by shaking off the servile traits produced and required by
hierarchy. As an example, after the sit-down strikes in Flint, Michigan, in
1937 one eye-witness saw how _"the auto worker became a different human being.
The women that had participated actively became a different type of women . .
. They carried themselves with a different walk, their heads were high, and
they had confidence in themselves."_ [Genora (Johnson) Dollinger, contained in
**Voices of a People's History of the United States**, Howard Zinn and Anthony
Arnove (eds.), p. 349] Such changes happen in all struggles (also see [section
J.4.2](secJ4.md#secj42)). Anarchists are not surprised for, as discussed in
[section J.1](secJ1.md) and [J.2.1](secJ2.md#secj21), we have long
recognised the liberating aspects of social struggle and the key role it plays
in creating free people and the other preconditions for needed for an
anarchist society (like the initial social structure -- see [section
I.2.3](secI2.md#seci23)).

Needless to say, a hierarchical system like capitalism cannot survive with a
non-submissive working class and the bosses spend a considerable amount of
time, energy and resources trying to break the spirits of the working class so
they will submit to authority (either unwillingly, by fear of being fired, or
willingly, by fooling them into believing that hierarchy is natural or by
rewarding subservient behaviour). Unsurprisingly, this never completely
succeeds and so capitalism is marked by constant struggles between the
oppressed and oppressor. Some of these struggles succeed, some do not. Some
are defensive, some are not. Some, like strikes, are visible, other less so
(such a working slowly and less efficiently than management desires). And
these struggles are waged by both sides of the hierarchical divide. Those
subject to hierarchy fight to limit it and increase their autonomy and those
who exercise authority fight to increase their power over others. Who wins
varies. The 1960s and 1970s saw a marked increase in victories for the
oppressed all throughout capitalism but, unfortunately, since the 1980s, as we
discuss in [section C.8.3](sec83.md#secc83), there has been a relentless
class war conducted by the powerful which has succeeded in inflicting a series
of defeats on working class people. Unsurprisingly, the rich have got richer
and more powerful since.

So anarchists take part in the on-going social struggle in society in an
attempt to end it in the only way possible, the victory of the oppressed. A
key part of this is to fight for partial freedoms, for minor or major reforms,
as this strengthens the spirit of revolt and starts the process towards the
final end of hierarchy. In such struggles we stress the autonomy of those
involved and see them not only as the means of getting more justice and
freedom in the current unfree system but also as a means of ending the
hierarchies they are fighting once and for all. Thus, for example, in the
class struggle we argue for _"[o]rganisation from the bottom up, beginning
with the shop and factory, on the foundation of the joint interests of the
workers everywhere, irrespective of trade, race, or country."_ [Alexander
Berkman, **Op. Cit.**, p. 207] Such an organisation, as we discuss in [section
J.5.2](secJ5.md#secj52), would be run via workplace assemblies and would be
the ideal means of replacing capitalist hierarchy in industry by genuine
economic freedom, i.e. worker's self-management of production (see [section
I.3](secI3.md)). Similarly, in the community we argue for popular assemblies
(see [section J.5.1](secJ5.md#secj51)) as a means of not only combating the
power of the state but also replaced it with by free, self-managed,
communities (see [section I.5](secI5.md)).

Thus the current struggle itself creates the bridge between what is and what
could be:

> _ "Assembly and community must arise from within the revolutionary process
itself; indeed, the revolutionary process must **be** the formation of
assembly and community, and with it, the destruction of power. Assembly and
community must become 'fighting words,' not distant panaceas. They must be
created as **modes of struggle** against the existing society, not as
theoretical or programmatic abstractions."_ [Murray Bookchin, **Post-Scarcity
Anarchism**, p. 104]

This is not all. As well as fighting the state and capitalism, we also need
fight all other forms of oppression. This means that anarchists argue that we
need to combat social hierarchies like racism and sexism as well as workplace
hierarchy and economic class, that we need to oppose homophobia and religious
hatred as well as the political state. Such oppressions and struggles are not
diversions from the struggle against class oppression or capitalism but part
and parcel of the struggle for human freedom and cannot be ignored without
fatally harming it.

As part of that process, anarchists encourage and support all sections of the
population to stand up for their humanity and individuality by resisting
racist, sexist and anti-gay activity and challenging such views in their
everyday lives, everywhere (as Carole Pateman points out, _"sexual domination
structures the workplace as well as the conjugal home"_ [**The Sexual
Contract**, p. 142]). It means a struggle of all working class people against
the internal and external tyrannies we face -- we must fight against own our
prejudices while supporting those in struggle against our common enemies, no
matter their sex, skin colour or sexuality. Lorenzo Kom'boa Ervin words on
fighting racism are applicable to all forms of oppression:

> _ "Racism must be fought vigorously wherever it is found, even if in our own
ranks, and even in ones own breast. Accordingly, we must end the system of
white skin privilege which the bosses use to split the class, and subject
racially oppressed workers to super-exploitation. White workers, especially
those in the Western world, must resist the attempt to use one section of the
working class to help them advance, while holding back the gains of another
segment based on race or nationality. This kind of class opportunism and
capitulationism on the part of white labour must be directly challenged and
defeated. There can be no workers unity until the system of super-exploitation
and world White Supremacy is brought to an end."_ [**Anarchism and the Black
Revolution**, p. 128]

Progress towards equality can and has been made. While it is still true that
(in the words of Emma Goldman) _"[n]owhere is woman treated according to the
merit of her work, but rather as a sex"_ [**Red Emma Speaks**, p. 177] and
that education is still patriarchal, with young women still often steered away
from traditionally "male" courses of study and work (which teaches children
that men and women are assigned different roles in society and sets them up to
accept these limitations as they grow up) it is also true that the position of
women, like that of blacks and gays, **has** improved. This is due to the
various self-organised, self-liberation movements that have continually
developed throughout history and these are **the** key to fighting oppression
in the short term (and creating the potential for the long term solution of
dismantling capitalism and the state).

Emma Goldman argued that emancipation begins _"in [a] woman's soul."_ Only by
a process of internal emancipation, in which the oppressed get to know their
own value, respect themselves and their culture, can they be in a position to
effectively combat (and overcome) external oppression and attitudes. Only when
you respect yourself can you be in a position to get others to respect you.
Those men, whites and heterosexuals who are opposed to bigotry, inequality and
injustice, must support oppressed groups and refuse to condone racist, sexist
or homophobic attitudes and actions by others or themselves. For anarchists,
_"not a single member of the Labour movement may with impunity be
discriminated against, suppressed or ignored. . . Labour [and other]
organisations must be built on the principle of equal liberty of all its
members. This equality means that only if each worker is a free and
independent unit, co-operating with the others from his or her mutual
interests, can the whole labour organisation work successfully and become
powerful."_ [Lorenzo Kom'boa Ervin, **Op. Cit.**, pp. 127-8]

We must all treat people as equals, while at the same time respecting their
differences. Diversity is a strength and a source of joy, and anarchists
reject the idea that equality means conformity. By these methods, of internal
self-liberation and solidarity against external oppression, we can fight
against bigotry. Racism, sexism and homophobia can be reduced, perhaps almost
eliminated, before a social revolution has occurred by those subject to them
organising themselves, fighting back **autonomously** and refusing to be
subjected to racial, sexual or anti-gay abuse or to allowing others to get
away with it (which plays an essential role in making others aware of their
own attitudes and actions, attitudes they may even be blind to!).

The example of the _**Mujeres Libres**_ (Free Women) in Spain during the 1930s
shows what is possible. Women anarchists involved in the C.N.T. and F.A.I.
organised themselves autonomously to raise the issue of sexism in the wider
libertarian movement, to increase women's involvement in libertarian
organisations and help the process of women's self-liberation against male
oppression. Along the way they also had to combat the (all too common) sexist
attitudes of their "revolutionary" male fellow anarchists. Martha A.
Ackelsberg's book **Free Women of Spain** is an excellent account of this
movement and the issues it raises for all people concerned about freedom.
Decades latter, the women's movement of the 1960s and 1970s did much the same
thing, aiming to challenge the traditional sexism and patriarchy of capitalist
society. They, too, formed their own organisations to fight for their own
needs as a group. Individuals worked together and drew strength for their own
personal battles in the home and in wider society.

Another essential part of this process is for such autonomous groups to
actively support others in struggle (including members of the dominant
race/sex/sexuality). Such practical solidarity and communication can, when
combined with the radicalising effects of the struggle itself on those
involved, help break down prejudice and bigotry, undermining the social
hierarchies that oppress us all. For example, gay and lesbian groups
supporting the 1984/5 UK miners' strike resulted in such groups being given
pride of place in many miners' marches. Another example is the great strike by
Jewish immigrant workers in 1912 in London which occurred at the same time as
a big London Dock Strike. _"The common struggle brought Jewish and non-Jewish
workers together. Joint strike meetings were held, and the same speakers spoke
at huge joint demonstrations."_ The Jewish strike was a success, dealing a _
"death-blow to the sweatshop system. The English workers looked at the Jewish
workers with quite different eyes after this victory."_ Yet the London dock
strike continued and many dockers' families were suffering real wants. The
successful Jewish strikers started a campaign _"to take some of the dockers'
children into their homes."_ This practical support _"did a great deal to
strengthen the friendship between Jewish and non-Jewish workers."_ [Rudolf
Rocker, **London Years**, p. 129 and p. 131] This solidarity was repaid in
October 1936, when the dockers were at the forefront in stopping Mosley's
fascist blackshirts marching through Jewish areas (the famous battle of Cable
street).

For whites, males and heterosexuals, the only anarchistic approach is to
support others in struggle, refuse to tolerate bigotry in others and to root
out their own fears and prejudices (while refusing to be uncritical of self-
liberation struggles -- solidarity does not imply switching your brain off!).
This obviously involves taking the issue of social oppression into all working
class organisations and activity, ensuring that no oppressed group is
marginalised within them.

Only in this way can the hold of these social diseases be weakened and a
better, non-hierarchical system be created. An injury to one is an injury to
all.

[‹ B.0 Section B Introduction](secBint.md "Go to previous page" )
[up](secBcon.md "Go to parent page" ) [B.2 Why are anarchists against the
state? ›](secB2.md "Go to next page" )

