# Descrip.mms:  MMS description file for building LibZ on OpenVMS
#
# Modifed:   7-APR-2000 Rick Dyson (rick-dyson@uiowa.edu)
#           28-MAR-2001 RLD Modified for stripped down Analog distribution
#           11-DEC-2002 RLD Modified for Analog v5.30

CFLAGS = $(COMPFLAGS) $(CFLAGS)
LINKFLAGS = $(LFLAGS)

OBJS =  adler32.obj compress.obj crc32.obj deflate.obj gzio.obj infblock.obj \
	infcodes.obj inffast.obj inflate.obj inftrees.obj infutil.obj \
	trees.obj uncompr.obj zutil.obj

lib :	libz.olb
	@ Write Sys$Output "LibZ build complete..."

libz.olb :	libz.olb($(OBJS))
	@ Continue

example.exe :	example.obj libz.olb
	$(LINK) $(LINKFLAGS) example,LibZ.olb/Library

minigzip.exe :	minigzip.obj libz.olb
	$(LINK) $(LINKFLAGS) minigzip,LibZ.olb/Library

clean : 
	- Purge /NoLog /NoConfirm *.mms,*.obj,*.olb

clobber :	clean
	- Delete /NoLog /NoConfirm *.obj;*,LibZ.olb;*
	
# Other dependencies.
adler32.obj : zutil.h zlib.h zconf.h
compress.obj : zlib.h zconf.h
crc32.obj : zutil.h zlib.h zconf.h
deflate.obj : deflate.h zutil.h zlib.h zconf.h
example.obj : zlib.h zconf.h
gzio.obj : zutil.h zlib.h zconf.h
infblock.obj : zutil.h zlib.h zconf.h infblock.h inftrees.h infcodes.h infutil.h
infcodes.obj : zutil.h zlib.h zconf.h inftrees.h infutil.h infcodes.h inffast.h
inffast.obj : zutil.h zlib.h zconf.h inftrees.h infutil.h inffast.h
inflate.obj : zutil.h zlib.h zconf.h infblock.h
inftrees.obj : zutil.h zlib.h zconf.h inftrees.h
infutil.obj : zutil.h zlib.h zconf.h inftrees.h infutil.h
minigzip.obj : zlib.h zconf.h
trees.obj : deflate.h zutil.h zlib.h zconf.h
uncompr.obj : zlib.h zconf.h
zutil.obj : zutil.h zlib.h zconf.h
