/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1997  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#include "pm.h"
#include "damage.h"

#define flaps_IMPORT
#include "flaps.h"

int
flaps_down(craft * c)
{

	c->flapSetting += 10.0 * M_PI / 180.0;
	if (c->flapSetting > c->cinfo->maxFlap)
		c->flapSetting = c->cinfo->maxFlap;
	return 0;
}

int
flaps_up(craft * c)
{

	c->flapSetting -= 10.0 * M_PI / 180.0;
	if (c->flapSetting < 0.0)
		c->flapSetting = 0.0;
	return 0;
}

void
flaps_update(craft * c)
{

	if (damage_isFunctioning(c, SYS_FLAPS)) {

		if (c->flapSetting > c->curFlap) {
			c->curFlap += c->cinfo->flapRate * deltaT;
			if (c->curFlap > c->flapSetting)
				c->curFlap = c->flapSetting;
		}
		else if (c->flapSetting < c->curFlap) {
			c->curFlap -= c->cinfo->flapRate * deltaT;
			if (c->curFlap < c->flapSetting)
				c->curFlap = c->flapSetting;
		}
	}

	if (damage_isFunctioning(c, SYS_SPEEDBRAKE)) {

		if (c->speedBrakeSetting > c->curSpeedBrake) {
			c->curSpeedBrake += c->cinfo->speedBrakeRate * deltaT;
			if (c->curSpeedBrake > c->speedBrakeSetting)
				c->curSpeedBrake = c->speedBrakeSetting;
		}
		else if (c->speedBrakeSetting < c->curSpeedBrake) {
			c->curSpeedBrake -= c->cinfo->speedBrakeRate * deltaT;
			if (c->curSpeedBrake < c->speedBrakeSetting)
				c->curSpeedBrake = c->speedBrakeSetting;
		}
	}

/*
 *  Set some status flags
 */

	if (c->fuel < (c->cinfo->maxFuel * 0.15))
		c->damageBits |= FLAG_LOWFUEL;
	else
		c->damageBits &= ~FLAG_LOWFUEL;

	if (c->speedBrakeSetting > 0.0)
		c->damageBits |= FLAG_SPEEDBRAKE;
	else
		c->damageBits &= ~FLAG_SPEEDBRAKE;
}

int
flaps_speed_brakes_extend(craft * c)
{

	c->speedBrakeSetting += c->cinfo->speedBrakeIncr;
	if (c->speedBrakeSetting > c->cinfo->maxSpeedBrake)
		c->speedBrakeSetting = c->cinfo->maxSpeedBrake;
	return 0;
}

int
flaps_speed_brakes_retract(craft * c)
{

	c->speedBrakeSetting -= c->cinfo->speedBrakeIncr;
	if (c->speedBrakeSetting < 0.0)
		c->speedBrakeSetting = 0.0;
	return 0;
}
