

(** [evm_compute eq blacklist] performs a vm_compute step with the
    following provisos: evars can appear in the goal; terms that are
    equal (modulo eq) to terms in the blacklist are abstracted
    before-hand. *)
val evm_compute : (Term.constr -> Term.constr -> bool) -> Term.constr list -> Proof_type.tactic 


(** [evm_compute eq blacklist h] performs an evm_compute step in the hypothesis h *)
val evm_compute_in : (Term.constr -> Term.constr -> bool) -> Term.constr list -> Names.identifier ->  Proof_type.tactic 
