/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.JhoveBase;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.Rational;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.TextMDMetadata;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class RepTreeRoot
extends DefaultMutableTreeNode {
    private RepInfo _info;
    private Property _repProp;
    private App _app;
    private JhoveBase _base;
    private boolean _rawOutput;
    private DateFormat _dateFmt;
    private double _sampleRate;

    public RepTreeRoot(RepInfo repInfo, App app, JhoveBase jhoveBase) {
        super(repInfo.getUri());
        this._info = repInfo;
        this._app = app;
        this._base = jhoveBase;
        this._rawOutput = this._base.getShowRawFlag();
        this._dateFmt = DateFormat.getDateInstance();
        this.snarfRepInfo();
    }

    private DefaultMutableTreeNode propToNode(Property property) {
        PropertyArity propertyArity = property.getArity();
        PropertyType propertyType = property.getType();
        Object object = property.getValue();
        if (propertyArity == PropertyArity.SCALAR) {
            if (propertyType == PropertyType.NISOIMAGEMETADATA) {
                NisoImageMetadata nisoImageMetadata = (NisoImageMetadata)object;
                return this.nisoToNode(nisoImageMetadata);
            }
            if (propertyType == PropertyType.AESAUDIOMETADATA) {
                AESAudioMetadata aESAudioMetadata = (AESAudioMetadata)object;
                return this.aesToNode(aESAudioMetadata);
            }
            if (propertyType == PropertyType.TEXTMDMETADATA) {
                TextMDMetadata textMDMetadata = (TextMDMetadata)object;
                return this.textMDToNode(textMDMetadata);
            }
            if (propertyType == PropertyType.PROPERTY) {
                if ("TextMDMetadata".equals(property.getName())) {
                    TextMDMetadata textMDMetadata = (TextMDMetadata)object;
                    return this.textMDToNode(textMDMetadata);
                }
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(property.getName());
                defaultMutableTreeNode.add(this.propToNode((Property)object));
                return defaultMutableTreeNode;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(property.getName() + ": " + object.toString());
            return defaultMutableTreeNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(property.getName());
        if (propertyArity == PropertyArity.ARRAY) {
            this.addArrayMembers(defaultMutableTreeNode, property);
        } else if (propertyArity == PropertyArity.LIST) {
            this.addListMembers(defaultMutableTreeNode, property);
        } else if (propertyArity == PropertyArity.MAP) {
            this.addMapMembers(defaultMutableTreeNode, property);
        } else if (propertyArity == PropertyArity.SET) {
            this.addSetMembers(defaultMutableTreeNode, property);
        }
        return defaultMutableTreeNode;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Property property = (Property)object;
        PropertyArity propertyArity = property.getArity();
        Iterator<Object> iterator = null;
        if (propertyArity == PropertyArity.SET || propertyArity == PropertyArity.LIST || propertyArity == PropertyArity.MAP) {
            Object object3;
            if (propertyArity == PropertyArity.SET) {
                object3 = (Set)property.getValue();
                iterator = object3.iterator();
            } else if (propertyArity == PropertyArity.MAP) {
                object3 = (Map)property.getValue();
                iterator = object3.values().iterator();
            } else {
                object3 = (List)property.getValue();
                iterator = object3.iterator();
            }
            int n = 0;
            while (true) {
                if (!iterator.hasNext()) {
                    return 0;
                }
                if (iterator.next() == object2) {
                    return n;
                }
                ++n;
            }
        }
        PropertyType propertyType = property.getType();
        Date[] dateArray = null;
        Property[] propertyArray = null;
        Rational[] rationalArray = null;
        Object[] objectArray = null;
        int n = 0;
        if (PropertyType.DATE == propertyType) {
            dateArray = (Date[])property.getValue();
            n = dateArray.length;
        } else if (PropertyType.OBJECT == propertyType) {
            objectArray = (Object[])property.getValue();
            n = objectArray.length;
        } else if (PropertyType.RATIONAL == propertyType) {
            rationalArray = (Rational[])property.getValue();
            n = rationalArray.length;
        } else if (PropertyType.PROPERTY == propertyType) {
            propertyArray = (Property[])property.getValue();
            n = propertyArray.length;
        } else {
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            Object object4 = null;
            if (PropertyType.DATE == propertyType) {
                object4 = dateArray[i];
            } else if (PropertyType.OBJECT == propertyType) {
                object4 = objectArray[i];
            } else if (PropertyType.RATIONAL == propertyType) {
                object4 = rationalArray[i];
            } else if (PropertyType.PROPERTY == propertyType) {
                object4 = propertyArray[i];
            }
            if (object4 != object2) continue;
            return i;
        }
        return 0;
    }

    private void snarfRepInfo() {
        List list;
        Map map;
        List list2;
        Object object;
        Object object22;
        Object object3;
        String string;
        String string2;
        long l;
        DefaultMutableTreeNode defaultMutableTreeNode;
        Module module = this._info.getModule();
        if (module != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Module");
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(module.getName(), false));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Release: " + module.getRelease(), false));
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Date: " + this._dateFmt.format(module.getDate()), false));
            this.add(defaultMutableTreeNode);
        }
        defaultMutableTreeNode = new DefaultMutableTreeNode("RepInfo");
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("URI: " + this._info.getUri(), false));
        Date date = this._info.getCreated();
        if (date != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Created: " + date.toString(), false));
        }
        if ((date = this._info.getLastModified()) != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("LastModified: " + date.toString(), false));
        }
        if ((l = this._info.getSize()) != -1L) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Size: " + Long.toString(l), false));
        }
        if ((string2 = this._info.getFormat()) != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Format: " + string2, false));
        }
        if ((string2 = this._info.getVersion()) != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Version: " + string2, false));
        }
        switch (this._info.getWellFormed()) {
            case 1: {
                string = "Well-Formed";
                break;
            }
            case 0: {
                string = "Not well-formed";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        if (this._info.getWellFormed() == 1) {
            switch (this._info.getValid()) {
                case 1: {
                    string = string + " and valid";
                    break;
                }
                case 0: {
                    string = string + ", but not valid";
                }
            }
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode("Status: " + string, false));
        List list3 = this._info.getSigMatch();
        if (list3 != null && list3.size() > 0) {
            object3 = new DefaultMutableTreeNode("SignatureMatches");
            defaultMutableTreeNode.add((MutableTreeNode)object3);
            for (int i = 0; i < list3.size(); ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode((String)list3.get(i));
                ((DefaultMutableTreeNode)object3).add(defaultMutableTreeNode2);
            }
        }
        if ((object3 = this._info.getMessage()) != null && object3.size() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Messages");
            defaultMutableTreeNode.add(defaultMutableTreeNode3);
            for (int i = 0; i < object3.size(); ++i) {
                Message message = (Message)object3.get(i);
                object22 = message instanceof InfoMessage ? "InfoMessage: " : (message instanceof ErrorMessage ? "ErrorMessage: " : "Message: ");
                object = new DefaultMutableTreeNode((String)object22 + message.getMessage());
                String string3 = message.getSubMessage();
                if (string3 != null) {
                    ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode("SubMessage: " + string3));
                }
                long l2 = -1L;
                if (message instanceof ErrorMessage) {
                    l2 = ((ErrorMessage)message).getOffset();
                }
                if (l2 >= 0L) {
                    ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode("Offset: " + Long.toString(l2)));
                } else if (string3 == null) {
                    ((DefaultMutableTreeNode)object).setAllowsChildren(false);
                }
                defaultMutableTreeNode3.add((MutableTreeNode)object);
            }
        }
        if ((string2 = this._info.getMimeType()) != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("MimeType: " + string2, false));
        }
        if ((list2 = this._info.getProfile()) != null && list2.size() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("Profiles");
            defaultMutableTreeNode.add(defaultMutableTreeNode4);
            for (int i = 0; i < list2.size(); ++i) {
                defaultMutableTreeNode4.add(new DefaultMutableTreeNode((String)list2.get(i), false));
            }
        }
        if ((map = this._info.getProperty()) != null) {
            for (Object object22 : map.keySet()) {
                object = this._info.getProperty((String)object22);
                defaultMutableTreeNode.add(this.propToNode((Property)object));
            }
        }
        if ((list = this._info.getChecksum()) != null && list.size() > 0) {
            object22 = new DefaultMutableTreeNode("Checksums");
            defaultMutableTreeNode.add((MutableTreeNode)object22);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Checksum checksum = (Checksum)list.get(i);
                String string4 = checksum.getValue();
                DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Checksum");
                ((DefaultMutableTreeNode)object22).add(defaultMutableTreeNode5);
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Type:" + checksum.getType().toString(), false));
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode("Checksum: " + string4, false));
            }
        }
        if ((string2 = this._info.getNote()) != null) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode("Note: " + string2, false));
        }
        this.add(defaultMutableTreeNode);
    }

    private void addArrayMembers(DefaultMutableTreeNode defaultMutableTreeNode, Property property) {
        block14: {
            PropertyType propertyType;
            Object object;
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    block15: {
                                                        block13: {
                                                            object = property.getValue();
                                                            propertyType = property.getType();
                                                            if (propertyType != PropertyType.INTEGER) break block13;
                                                            int[] nArray = (int[])object;
                                                            for (int i = 0; i < nArray.length; ++i) {
                                                                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Integer(nArray[i])));
                                                            }
                                                            break block14;
                                                        }
                                                        if (propertyType != PropertyType.LONG) break block15;
                                                        long[] lArray = (long[])object;
                                                        for (int i = 0; i < lArray.length; ++i) {
                                                            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Long(lArray[i])));
                                                        }
                                                        break block14;
                                                    }
                                                    if (propertyType != PropertyType.BOOLEAN) break block16;
                                                    boolean[] blArray = (boolean[])object;
                                                    for (int i = 0; i < blArray.length; ++i) {
                                                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Boolean(blArray[i])));
                                                    }
                                                    break block14;
                                                }
                                                if (propertyType != PropertyType.CHARACTER) break block17;
                                                char[] cArray = (char[])object;
                                                for (int i = 0; i < cArray.length; ++i) {
                                                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Character(cArray[i])));
                                                }
                                                break block14;
                                            }
                                            if (propertyType != PropertyType.DOUBLE) break block18;
                                            double[] dArray = (double[])object;
                                            for (int i = 0; i < dArray.length; ++i) {
                                                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Double(dArray[i])));
                                            }
                                            break block14;
                                        }
                                        if (propertyType != PropertyType.FLOAT) break block19;
                                        float[] fArray = (float[])object;
                                        for (int i = 0; i < fArray.length; ++i) {
                                            defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Float(fArray[i])));
                                        }
                                        break block14;
                                    }
                                    if (propertyType != PropertyType.SHORT) break block20;
                                    short[] sArray = (short[])object;
                                    for (int i = 0; i < sArray.length; ++i) {
                                        defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Short(sArray[i])));
                                    }
                                    break block14;
                                }
                                if (propertyType != PropertyType.BYTE) break block21;
                                byte[] byArray = (byte[])object;
                                for (int i = 0; i < byArray.length; ++i) {
                                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(new Byte(byArray[i])));
                                }
                                break block14;
                            }
                            if (propertyType != PropertyType.STRING) break block22;
                            String[] stringArray = (String[])object;
                            for (int i = 0; i < stringArray.length; ++i) {
                                defaultMutableTreeNode.add(new DefaultMutableTreeNode(stringArray[i]));
                            }
                            break block14;
                        }
                        if (propertyType != PropertyType.RATIONAL) break block23;
                        Rational[] rationalArray = (Rational[])object;
                        for (int i = 0; i < rationalArray.length; ++i) {
                            defaultMutableTreeNode.add(new DefaultMutableTreeNode(rationalArray[i]));
                        }
                        break block14;
                    }
                    if (propertyType != PropertyType.PROPERTY) break block24;
                    Property[] propertyArray = (Property[])object;
                    for (int i = 0; i < propertyArray.length; ++i) {
                        defaultMutableTreeNode.add(this.propToNode(propertyArray[i]));
                    }
                    break block14;
                }
                if (propertyType != PropertyType.NISOIMAGEMETADATA) break block25;
                NisoImageMetadata[] nisoImageMetadataArray = (NisoImageMetadata[])object;
                for (int i = 0; i < nisoImageMetadataArray.length; ++i) {
                    defaultMutableTreeNode.add(this.nisoToNode(nisoImageMetadataArray[i]));
                }
                break block14;
            }
            if (propertyType != PropertyType.OBJECT) break block14;
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(objectArray[i]));
            }
        }
    }

    private void addListMembers(DefaultMutableTreeNode defaultMutableTreeNode, Property property) {
        List list = (List)property.getValue();
        PropertyType propertyType = property.getType();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (propertyType == PropertyType.PROPERTY) {
                defaultMutableTreeNode.add(this.propToNode((Property)e));
                continue;
            }
            if (propertyType == PropertyType.NISOIMAGEMETADATA) {
                defaultMutableTreeNode.add(this.nisoToNode((NisoImageMetadata)e));
                continue;
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(e, false));
        }
    }

    private void addSetMembers(DefaultMutableTreeNode defaultMutableTreeNode, Property property) {
        Set set = (Set)property.getValue();
        PropertyType propertyType = property.getType();
        for (Object e : set) {
            if (propertyType == PropertyType.PROPERTY) {
                defaultMutableTreeNode.add(this.propToNode((Property)e));
                continue;
            }
            if (propertyType == PropertyType.NISOIMAGEMETADATA) {
                defaultMutableTreeNode.add(this.nisoToNode((NisoImageMetadata)e));
                continue;
            }
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(e, false));
        }
    }

    private void addMapMembers(DefaultMutableTreeNode defaultMutableTreeNode, Property property) {
        Map map = (Map)property.getValue();
        PropertyType propertyType = property.getType();
        for (String string : map.keySet()) {
            Object v = map.get(string);
            DefaultMutableTreeNode defaultMutableTreeNode2 = propertyType == PropertyType.PROPERTY ? this.propToNode((Property)v) : (propertyType == PropertyType.NISOIMAGEMETADATA ? this.nisoToNode((NisoImageMetadata)v) : new DefaultMutableTreeNode(v, true));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNode2.setAllowsChildren(true);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Key: " + string, false));
        }
    }

    private DefaultMutableTreeNode aesToNode(AESAudioMetadata aESAudioMetadata) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        String[] stringArray2;
        long l;
        int n;
        this._sampleRate = aESAudioMetadata.getSampleRate();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("AESAudioMetadata", true);
        String string = aESAudioMetadata.getAnalogDigitalFlag();
        if (string != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("AnalogDigitalFlag: " + string, false));
        }
        if ((string = aESAudioMetadata.getSchemaVersion()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SchemaVersion: " + string, false));
        }
        if ((string = aESAudioMetadata.getFormat()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Format: " + string, true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            String string2 = aESAudioMetadata.getSpecificationVersion();
            if (string2 != null) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode("SpecificationVersion: " + string2, false));
            }
        }
        if ((string = aESAudioMetadata.getAppSpecificData()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("AppSpecificData: " + string, false));
        }
        if ((string = aESAudioMetadata.getAudioDataEncoding()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("AudioDataEncoding: " + string, false));
        }
        if ((n = aESAudioMetadata.getByteOrder()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ByteOrder: " + (n == 0 ? "BIG_ENDIAN" : "LITTLE_ENDIAN")));
        }
        if ((l = aESAudioMetadata.getFirstSampleOffset()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FirstSampleOffset: " + Long.toString(l)));
        }
        if ((stringArray2 = aESAudioMetadata.getUse()) != null) {
            object3 = new DefaultMutableTreeNode("Use", true);
            defaultMutableTreeNode2.add((MutableTreeNode)object3);
            ((DefaultMutableTreeNode)object3).add(new DefaultMutableTreeNode("UseType: " + stringArray2[0], false));
            ((DefaultMutableTreeNode)object3).add(new DefaultMutableTreeNode("OtherType: " + stringArray2[1], false));
        }
        if ((string = aESAudioMetadata.getPrimaryIdentifier()) != null) {
            object3 = aESAudioMetadata.getPrimaryIdentifierType();
            object2 = new DefaultMutableTreeNode("PrimaryIdentifier: " + string, true);
            defaultMutableTreeNode2.add((MutableTreeNode)object2);
            if (object3 != null) {
                ((DefaultMutableTreeNode)object2).add(new DefaultMutableTreeNode("IdentifierType: " + (String)object3));
            }
        }
        if (!(object3 = aESAudioMetadata.getFaceList()).isEmpty()) {
            object2 = (AESAudioMetadata.Face)object3.get(0);
            object = new DefaultMutableTreeNode("Face", true);
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("TimeLine", true);
            AESAudioMetadata.TimeDesc timeDesc = object2.getStartTime();
            if (timeDesc != null) {
                this.addAESTimeRange(defaultMutableTreeNode4, timeDesc, object2.getDuration());
            }
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode4);
            AESAudioMetadata.FaceRegion faceRegion = object2.getFaceRegion(0);
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("Region", true);
            defaultMutableTreeNode4 = new DefaultMutableTreeNode("TimeRange", true);
            this.addAESTimeRange(defaultMutableTreeNode4, faceRegion.getStartTime(), faceRegion.getDuration());
            defaultMutableTreeNode5.add(defaultMutableTreeNode4);
            int n2 = aESAudioMetadata.getNumChannels();
            if (n2 != -1) {
                stringArray = aESAudioMetadata.getMapLocations();
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode("NumChannels: " + Integer.toString(n2), false));
                for (int i = 0; i < n2; ++i) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode("Stream", true);
                    defaultMutableTreeNode5.add(defaultMutableTreeNode);
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("ChannelAssignment: " + stringArray[i], false));
                }
            }
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode5);
            defaultMutableTreeNode2.add((MutableTreeNode)object);
        }
        if (!(object2 = aESAudioMetadata.getFormatList()).isEmpty()) {
            object = (AESAudioMetadata.FormatRegion)object2.get(0);
            int n3 = object.getBitDepth();
            double d = object.getSampleRate();
            int n4 = object.getWordSize();
            String[] stringArray3 = object.getBitrateReduction();
            if (n3 != -1 || d != -1.0 || n4 != -1) {
                stringArray = new DefaultMutableTreeNode("FormatList", true);
                DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("FormatRegion", true);
                if (n3 != -1) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("BitDepth: " + Integer.toString(n3), false));
                }
                if (d != -1.0) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("SampleRate: " + Double.toString(d), false));
                }
                if (n4 != -1) {
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode("WordSize: " + Integer.toString(n3), false));
                }
                if (stringArray3 != null) {
                    defaultMutableTreeNode = new DefaultMutableTreeNode("BitrateReduction", true);
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("codecName: " + stringArray3[0], false));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("codecNameVersion: " + stringArray3[1], false));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("codecCreatorApplication: " + stringArray3[2], false));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("codecCreatorApplicationVersion: " + stringArray3[3], false));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("codecQuality: " + stringArray3[4], false));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("dataRate: " + stringArray3[5], false));
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode("dataRateMode: " + stringArray3[6], false));
                    defaultMutableTreeNode6.add(defaultMutableTreeNode);
                }
                stringArray.add(defaultMutableTreeNode6);
                defaultMutableTreeNode2.add((MutableTreeNode)stringArray);
            }
        }
        return defaultMutableTreeNode2;
    }

    private void addAESTimeRange(DefaultMutableTreeNode defaultMutableTreeNode, AESAudioMetadata.TimeDesc timeDesc, AESAudioMetadata.TimeDesc timeDesc2) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Start", true);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FrameCount: 30", false));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TimeBase: 1000"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("VideoField: FIELD_1"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("CountingMode: NTSC_NON_DROP_FRAME", false));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Hours: " + timeDesc.getHours(), false));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Minutes: " + timeDesc.getMinutes(), false));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Seconds: " + timeDesc.getSeconds(), false));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Frames: " + timeDesc.getFrames(), false));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Samples", true);
        double d = timeDesc.getSampleRate();
        if (d == 1.0) {
            d = this._sampleRate;
        }
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("SampleRate: S" + Integer.toString((int)d), false));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("NumberOfSamples: " + timeDesc.getSamples(), false));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode3 = new DefaultMutableTreeNode("FilmFraming", true);
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Framing: NOT_APPLICABLE", false));
        defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Type: ntscFilmFramingType", false));
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        if (timeDesc2 != null) {
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("Duration", true);
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FrameCount: 30", false));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TimeBase: 1000"));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("VideoField: FIELD_1"));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("CountingMode: NTSC_NON_DROP_FRAME", false));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Hours: " + timeDesc2.getHours(), false));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Minutes: " + timeDesc2.getMinutes(), false));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Seconds: " + timeDesc2.getSeconds(), false));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Frames: " + timeDesc2.getFrames(), false));
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("Samples", true);
            d = timeDesc2.getSampleRate();
            if (d == 1.0) {
                d = this._sampleRate;
            }
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("SamplesRate S" + Integer.toString((int)d), false));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("NumberOfSamples: " + timeDesc2.getSamples(), false));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode3 = new DefaultMutableTreeNode("FilmFraming", true);
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Framing: NOT_APPLICABLE", false));
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Type: ntscFilmFramingType", false));
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private DefaultMutableTreeNode textMDToNode(TextMDMetadata textMDMetadata) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("TextMDMetadata", true);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Character_info", true);
        defaultMutableTreeNode2.add(defaultMutableTreeNode3);
        String string = textMDMetadata.getCharset();
        if (string != null) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Charset: " + string, false));
        }
        if ((string = textMDMetadata.getByte_orderString()) != null) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Byte_order: " + string, false));
        }
        if ((string = textMDMetadata.getByte_size()) != null) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Byte_size: " + string, false));
        }
        if ((string = textMDMetadata.getCharacter_size()) != null) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Character_size: " + string, false));
        }
        if ((string = textMDMetadata.getLinebreakString()) != null) {
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode("Linebreak: " + string, false));
        }
        if ((string = textMDMetadata.getLanguage()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Language: " + string, false));
        }
        if ((string = textMDMetadata.getMarkup_basis()) != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Markup_basis: " + string, true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            string = textMDMetadata.getMarkup_basis_version();
            if (string != null) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode("Version: " + string, false));
            }
        }
        if ((string = textMDMetadata.getMarkup_language()) != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("Markup_language: " + string, true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            string = textMDMetadata.getMarkup_language_version();
            if (string != null) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode("Version: " + string, false));
            }
        }
        return defaultMutableTreeNode2;
    }

    private DefaultMutableTreeNode nisoToNode(NisoImageMetadata nisoImageMetadata) {
        String[] stringArray;
        Rational rational;
        int n;
        Object object;
        double[] dArray;
        double d;
        int n2;
        DefaultMutableTreeNode defaultMutableTreeNode;
        long l;
        long[] lArray;
        int n3;
        Rational[] rationalArray;
        int[] nArray;
        int n4;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("NisoImageMetadata", true);
        String string = nisoImageMetadata.getMimeType();
        if (string != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("MIMEType: " + string, false));
        }
        if ((string = nisoImageMetadata.getByteOrder()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ByteOrder: " + string, false));
        }
        if ((n4 = nisoImageMetadata.getCompressionScheme()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("CompressionScheme: " + this.integerRepresentation(n4, NisoImageMetadata.COMPRESSION_SCHEME, NisoImageMetadata.COMPRESSION_SCHEME_INDEX), false));
        }
        if ((n4 = nisoImageMetadata.getCompressionLevel()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("CompressionLevel: " + Integer.toString(n4), false));
        }
        if ((n4 = nisoImageMetadata.getColorSpace()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ColorSpace: " + this.integerRepresentation(n4, NisoImageMetadata.COLORSPACE, NisoImageMetadata.COLORSPACE_INDEX), false));
        }
        if ((string = nisoImageMetadata.getProfileName()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ProfileName: " + string, false));
        }
        if ((string = nisoImageMetadata.getProfileURL()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ProfileURL: " + string, false));
        }
        if ((nArray = nisoImageMetadata.getYCbCrSubSampling()) != null) {
            rationalArray = new DefaultMutableTreeNode("YCbCrSubSampling");
            defaultMutableTreeNode2.add((MutableTreeNode)rationalArray);
            for (int i = 0; i < nArray.length; ++i) {
                rationalArray.add(new DefaultMutableTreeNode(Integer.toString(nArray[i]), false));
            }
        }
        if ((n4 = nisoImageMetadata.getYCbCrPositioning()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("YCbCrPositioning: " + this.integerRepresentation(n4, NisoImageMetadata.YCBCR_POSITIONING), false));
        }
        if ((rationalArray = nisoImageMetadata.getYCbCrCoefficients()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("YCbCrCoefficients", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            for (n3 = 0; n3 < rationalArray.length; ++n3) {
                defaultMutableTreeNode3.add(new DefaultMutableTreeNode(rationalArray[n3].toString(), false));
            }
        }
        if ((rationalArray = nisoImageMetadata.getReferenceBlackWhite()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode("ReferenceBlackWhite", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode4);
            for (n3 = 0; n3 < rationalArray.length; ++n3) {
                defaultMutableTreeNode4.add(new DefaultMutableTreeNode(rationalArray[n3].toString(), false));
            }
        }
        if ((n4 = nisoImageMetadata.getSegmentType()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("YSegmentType: " + this.integerRepresentation(n4, NisoImageMetadata.SEGMENT_TYPE), false));
        }
        if ((lArray = nisoImageMetadata.getStripOffsets()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode("StripOffsets", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode5);
            for (int i = 0; i < lArray.length; ++i) {
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode(Long.toString(lArray[i]), false));
            }
        }
        if ((l = nisoImageMetadata.getRowsPerStrip()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("RowsPerStrip: " + Long.toString(l), false));
        }
        if ((lArray = nisoImageMetadata.getStripByteCounts()) != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("StripByteCounts", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            for (n2 = 0; n2 < lArray.length; ++n2) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(Long.toString(lArray[n2]), false));
            }
        }
        if ((l = nisoImageMetadata.getTileWidth()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TileWidth: " + Long.toString(l)));
        }
        if ((l = nisoImageMetadata.getTileLength()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TileLength: " + Long.toString(l)));
        }
        if ((lArray = nisoImageMetadata.getTileOffsets()) != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("TileOffsets", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            for (n2 = 0; n2 < lArray.length; ++n2) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(Long.toString(lArray[n2]), false));
            }
        }
        if ((lArray = nisoImageMetadata.getTileByteCounts()) != null) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("TileByteCounts", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
            for (n2 = 0; n2 < lArray.length; ++n2) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(Long.toString(lArray[n2]), false));
            }
        }
        if ((n4 = nisoImageMetadata.getPlanarConfiguration()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PlanarConfiguration: " + this.integerRepresentation(n4, NisoImageMetadata.PLANAR_CONFIGURATION), false));
        }
        if ((string = nisoImageMetadata.getImageIdentifier()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ImageIdentifier: " + string, false));
        }
        if ((string = nisoImageMetadata.getImageIdentifierLocation()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ImageIdentifierLocation: " + string, false));
        }
        if ((l = nisoImageMetadata.getFileSize()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FileSize: " + Long.toString(l), false));
        }
        if ((n4 = nisoImageMetadata.getChecksumMethod()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ChecksumMethod: " + this.integerRepresentation(n4, NisoImageMetadata.CHECKSUM_METHOD), false));
        }
        if ((string = nisoImageMetadata.getChecksumValue()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ChecksumValue: " + string, false));
        }
        if ((n4 = nisoImageMetadata.getOrientation()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Orientation: " + this.integerRepresentation(n4, NisoImageMetadata.ORIENTATION), false));
        }
        if ((n4 = nisoImageMetadata.getDisplayOrientation()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("DisplayOrientation: " + this.integerRepresentation(n4, NisoImageMetadata.DISPLAY_ORIENTATION), false));
        }
        if ((l = nisoImageMetadata.getXTargetedDisplayAR()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("XTargetedDisplayAR: " + Long.toString(l), false));
        }
        if ((l = nisoImageMetadata.getYTargetedDisplayAR()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("YTargetedDisplayAR: " + Long.toString(l), false));
        }
        if ((string = nisoImageMetadata.getPreferredPresentation()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PreferredPresentation: " + string, false));
        }
        if ((string = nisoImageMetadata.getSourceType()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SourceType: " + string, false));
        }
        if ((string = nisoImageMetadata.getImageProducer()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ImageProducer: " + string, false));
        }
        if ((string = nisoImageMetadata.getHostComputer()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("HostComputer: " + string, false));
        }
        if ((string = nisoImageMetadata.getOS()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("OperatingSystem: " + string, false));
        }
        if ((string = nisoImageMetadata.getOSVersion()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("OSVersion: " + string, false));
        }
        if ((string = nisoImageMetadata.getDeviceSource()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("DeviceSource: " + string, false));
        }
        if ((string = nisoImageMetadata.getScannerManufacturer()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ScannerManufacturer: " + string, false));
        }
        if ((string = nisoImageMetadata.getScannerModelName()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ScannerModelName: " + string, false));
        }
        if ((string = nisoImageMetadata.getScannerModelNumber()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ScannerModelNumber: " + string, false));
        }
        if ((string = nisoImageMetadata.getScannerModelSerialNo()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ScannerModelSerialNo: " + string, false));
        }
        if ((string = nisoImageMetadata.getScanningSoftware()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ScanningSoftware: " + string, false));
        }
        if ((string = nisoImageMetadata.getScanningSoftwareVersionNo()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ScanningSoftwareVersionNo: " + string, false));
        }
        if ((d = nisoImageMetadata.getPixelSize()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PixelSize: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getXPhysScanResolution()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("XPhysScanResolution: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getYPhysScanResolution()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("YPhysScanResolution: " + Double.toString(d), false));
        }
        if ((string = nisoImageMetadata.getDigitalCameraManufacturer()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("DigitalCameraManufacturer: " + string, false));
        }
        if ((string = nisoImageMetadata.getDigitalCameraModel()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("DigitalCameraModel: " + string, false));
        }
        if ((d = nisoImageMetadata.getFNumber()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FNumber: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getExposureTime()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ExposureTime: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getBrightness()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Brightness: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getExposureBias()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ExposureBias: " + Double.toString(d), false));
        }
        if ((dArray = nisoImageMetadata.getSubjectDistance()) != null) {
            object = new DefaultMutableTreeNode("SubjectDistance", true);
            defaultMutableTreeNode2.add((MutableTreeNode)object);
            for (int i = 0; i < dArray.length; ++i) {
                ((DefaultMutableTreeNode)object).add(new DefaultMutableTreeNode(Double.toString(dArray[i]), false));
            }
        }
        if ((n4 = nisoImageMetadata.getMeteringMode()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("MeteringMode: " + Integer.toString(n4), false));
        }
        if ((n4 = nisoImageMetadata.getSceneIlluminant()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SceneIlluminant: " + Integer.toString(n4), false));
        }
        if ((d = nisoImageMetadata.getColorTemp()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ColorTemp: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getFocalLength()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FocalLength: " + Double.toString(d), false));
        }
        if ((n4 = nisoImageMetadata.getFlash()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Flash: " + this.integerRepresentation(n4, NisoImageMetadata.FLASH), false));
        }
        if ((d = nisoImageMetadata.getFlashEnergy()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FlashEnergy: " + Double.toString(d), false));
        }
        if ((n4 = nisoImageMetadata.getFlashReturn()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("FlashReturn: " + this.integerRepresentation(n4, NisoImageMetadata.FLASH_RETURN), false));
        }
        if ((n4 = nisoImageMetadata.getBackLight()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("BackLight: " + this.integerRepresentation(n4, NisoImageMetadata.BACKLIGHT), false));
        }
        if ((d = nisoImageMetadata.getExposureIndex()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ExposureIndex: " + Double.toString(d), false));
        }
        if ((n4 = nisoImageMetadata.getAutoFocus()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("AutoFocus: " + Integer.toString(n4), false));
        }
        if ((d = nisoImageMetadata.getXPrintAspectRatio()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("XPrintAspectRatio: " + Double.toString(d), false));
        }
        if ((d = nisoImageMetadata.getYPrintAspectRatio()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("YPrintAspectRatio: " + Double.toString(d), false));
        }
        if ((n4 = nisoImageMetadata.getSensor()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Sensor: " + this.integerRepresentation(n4, NisoImageMetadata.SENSOR), false));
        }
        if ((string = nisoImageMetadata.getDateTimeCreated()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("DateTimeCreated: " + string, false));
        }
        if ((string = nisoImageMetadata.getMethodology()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Methodology: " + string, false));
        }
        if ((n4 = nisoImageMetadata.getSamplingFrequencyPlane()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SamplingFrequencyPlane: " + this.integerRepresentation(n4, NisoImageMetadata.SAMPLING_FREQUENCY_PLANE), false));
        }
        if ((n4 = nisoImageMetadata.getSamplingFrequencyUnit()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SamplingFrequencyUnit: " + this.integerRepresentation(n4, NisoImageMetadata.SAMPLING_FREQUENCY_UNIT), false));
        }
        if ((object = nisoImageMetadata.getXSamplingFrequency()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("XSamplingFrequency: " + ((Rational)object).toString(), false));
        }
        if ((object = nisoImageMetadata.getYSamplingFrequency()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("YSamplingFrequency: " + ((Rational)object).toString(), false));
        }
        if ((l = nisoImageMetadata.getImageWidth()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ImageWidth: " + Long.toString(l), false));
        }
        if ((l = nisoImageMetadata.getImageLength()) != -1L) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ImageLength: " + Long.toString(l), false));
        }
        if ((d = nisoImageMetadata.getSourceXDimension()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SourceXDimension: " + Double.toString(d), false));
        }
        if ((n4 = nisoImageMetadata.getSourceXDimensionUnit()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SourceXDimensionUnit: " + this.integerRepresentation(n4, NisoImageMetadata.SOURCE_DIMENSION_UNIT), false));
        }
        if ((d = nisoImageMetadata.getSourceYDimension()) != -1.0) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SourceYDimension: " + Double.toString(d), false));
        }
        if ((n4 = nisoImageMetadata.getSourceYDimensionUnit()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SourceYDimensionUnit: " + this.integerRepresentation(n4, NisoImageMetadata.SOURCE_DIMENSION_UNIT), false));
        }
        if ((nArray = nisoImageMetadata.getBitsPerSample()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode("BitsPerSample");
            defaultMutableTreeNode2.add(defaultMutableTreeNode6);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode6.add(new DefaultMutableTreeNode(Integer.toString(nArray[n]), false));
            }
        }
        if ((n4 = nisoImageMetadata.getSamplesPerPixel()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SamplesPerPixel: " + Integer.toString(n4), false));
        }
        if ((nArray = nisoImageMetadata.getExtraSamples()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode("ExtraSamples");
            defaultMutableTreeNode2.add(defaultMutableTreeNode7);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode7.add(new DefaultMutableTreeNode(this.integerRepresentation(nArray[n], NisoImageMetadata.EXTRA_SAMPLES), false));
            }
        }
        if ((string = nisoImageMetadata.getColormapReference()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ColormapReference: " + string));
        }
        if ((nArray = nisoImageMetadata.getColormapBitCodeValue()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode("ColormapBitCodeValue");
            defaultMutableTreeNode2.add(defaultMutableTreeNode8);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode8.add(new DefaultMutableTreeNode(Integer.toString(nArray[n]), false));
            }
        }
        if ((nArray = nisoImageMetadata.getColormapRedValue()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode("ColormapRedValue");
            defaultMutableTreeNode2.add(defaultMutableTreeNode9);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode9.add(new DefaultMutableTreeNode(Integer.toString(nArray[n]), false));
            }
        }
        if ((nArray = nisoImageMetadata.getColormapGreenValue()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode("ColormapGreenValue");
            defaultMutableTreeNode2.add(defaultMutableTreeNode10);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode10.add(new DefaultMutableTreeNode(Integer.toString(nArray[n]), false));
            }
        }
        if ((nArray = nisoImageMetadata.getColormapBlueValue()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode("ColormapBlueValue");
            defaultMutableTreeNode2.add(defaultMutableTreeNode11);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode11.add(new DefaultMutableTreeNode(Integer.toString(nArray[n]), false));
            }
        }
        if ((nArray = nisoImageMetadata.getGrayResponseCurve()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode("GrayResponseCurve");
            defaultMutableTreeNode2.add(defaultMutableTreeNode12);
            for (n = 0; n < nArray.length; ++n) {
                defaultMutableTreeNode12.add(new DefaultMutableTreeNode(Integer.toString(nArray[n]), false));
            }
        }
        if ((n4 = nisoImageMetadata.getGrayResponseUnit()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("GrayResponseUnit: " + Integer.toString(n4), false));
        }
        if ((rational = nisoImageMetadata.getWhitePointXValue()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("WhitePointXValue: " + rational.toString(), false));
        }
        if ((rational = nisoImageMetadata.getWhitePointYValue()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("WhitePointYValue: " + rational.toString(), false));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedX()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PrimaryChromaticitiesRedX: " + rational.toString(), false));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesRedY()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PrimaryChromaticitiesRedY: " + rational.toString(), false));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenX()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PrimaryChromaticitiesGreenX: " + rational.toString(), false));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesGreenY()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PrimaryChromaticitiesGreenY: " + rational.toString(), false));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueX()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PrimaryChromaticitiesBlueX: " + rational.toString()));
        }
        if ((rational = nisoImageMetadata.getPrimaryChromaticitiesBlueY()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PrimaryChromaticitiesBlueY: " + rational.toString()));
        }
        if ((n4 = nisoImageMetadata.getTargetType()) != -1) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TargetType: " + this.integerRepresentation(n4, NisoImageMetadata.TARGET_TYPE), false));
        }
        if ((string = nisoImageMetadata.getTargetIDManufacturer()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TargetIDManufacturer: " + string, false));
        }
        if ((string = nisoImageMetadata.getTargetIDName()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TargetIDName: " + string, false));
        }
        if ((string = nisoImageMetadata.getTargetIDNo()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TargetIDNo: " + string, false));
        }
        if ((string = nisoImageMetadata.getTargetIDMedia()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("TargetIDMedia: " + string, false));
        }
        if ((string = nisoImageMetadata.getImageData()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ImageData: " + string, false));
        }
        if ((string = nisoImageMetadata.getPerformanceData()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("PerformanceData: " + string, false));
        }
        if ((string = nisoImageMetadata.getProfiles()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("Profiles: " + string, false));
        }
        if ((string = nisoImageMetadata.getDateTimeProcessed()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("DateTimeProcessed: " + string, false));
        }
        if ((string = nisoImageMetadata.getSourceData()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("SourceData: " + string, false));
        }
        if ((string = nisoImageMetadata.getProcessingAgency()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ProcessingAgency: " + string, false));
        }
        if ((string = nisoImageMetadata.getProcessingSoftwareName()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ProcessingSoftwareName: " + string, false));
        }
        if ((string = nisoImageMetadata.getProcessingSoftwareVersion()) != null) {
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ProcessingSoftwareVersion: " + string, false));
        }
        if ((stringArray = nisoImageMetadata.getProcessingActions()) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode("ProcessingActions", true);
            defaultMutableTreeNode2.add(defaultMutableTreeNode13);
            for (int i = 1; i < stringArray.length; ++i) {
                defaultMutableTreeNode13.add(new DefaultMutableTreeNode(stringArray[i], false));
            }
        }
        return defaultMutableTreeNode2;
    }

    private String integerRepresentation(int n, String[] stringArray) {
        if (this._rawOutput) {
            return Integer.toString(n);
        }
        try {
            return stringArray[n];
        }
        catch (Exception exception) {
            return Integer.toString(n);
        }
    }

    private String integerRepresentation(int n, String[] stringArray, int[] nArray) {
        if (this._rawOutput) {
            return Integer.toString(n);
        }
        try {
            int n2 = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                n2 = i;
                break;
            }
            if (n2 > -1) {
                return stringArray[n2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.toString(n);
    }
}

